/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.evidently.model.LaunchGroup;

final class LaunchGroupListCopier {
    LaunchGroupListCopier() {
    }

    static List<LaunchGroup> copy(Collection<? extends LaunchGroup> launchGroupListParam) {
        Object list;
        if (launchGroupListParam == null || launchGroupListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            launchGroupListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<LaunchGroup> copyFromBuilder(Collection<? extends LaunchGroup.Builder> launchGroupListParam) {
        Object list;
        if (launchGroupListParam == null || launchGroupListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            launchGroupListParam.forEach(entry -> {
                LaunchGroup member = entry == null ? null : (LaunchGroup)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<LaunchGroup.Builder> copyToBuilder(Collection<? extends LaunchGroup> launchGroupListParam) {
        Object list;
        if (launchGroupListParam == null || launchGroupListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            launchGroupListParam.forEach(entry -> {
                LaunchGroup.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

