/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.evidently.model.EvaluationResult;
import software.amazon.awssdk.services.evidently.model.EvaluationResultsListCopier;
import software.amazon.awssdk.services.evidently.model.EvidentlyResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchEvaluateFeatureResponse
extends EvidentlyResponse
implements ToCopyableBuilder<Builder, BatchEvaluateFeatureResponse> {
    private static final SdkField<List<EvaluationResult>> RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("results").getter(BatchEvaluateFeatureResponse.getter(BatchEvaluateFeatureResponse::results)).setter(BatchEvaluateFeatureResponse.setter(Builder::results)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("results").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD));
    private final List<EvaluationResult> results;

    private BatchEvaluateFeatureResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
    }

    public final boolean hasResults() {
        return this.results != null && !(this.results instanceof SdkAutoConstructList);
    }

    public final List<EvaluationResult> results() {
        return this.results;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResults() ? this.results() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchEvaluateFeatureResponse)) {
            return false;
        }
        BatchEvaluateFeatureResponse other = (BatchEvaluateFeatureResponse)((Object)obj);
        return this.hasResults() == other.hasResults() && Objects.equals(this.results(), other.results());
    }

    public final String toString() {
        return ToString.builder((String)"BatchEvaluateFeatureResponse").add("Results", this.hasResults() ? this.results() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "results": {
                return Optional.ofNullable(clazz.cast(this.results()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchEvaluateFeatureResponse, T> g) {
        return obj -> g.apply((BatchEvaluateFeatureResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EvidentlyResponse.BuilderImpl
    implements Builder {
        private List<EvaluationResult> results = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchEvaluateFeatureResponse model) {
            super(model);
            this.results(model.results);
        }

        public final List<EvaluationResult.Builder> getResults() {
            List<EvaluationResult.Builder> result = EvaluationResultsListCopier.copyToBuilder(this.results);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResults(Collection<EvaluationResult.BuilderImpl> results) {
            this.results = EvaluationResultsListCopier.copyFromBuilder(results);
        }

        @Override
        public final Builder results(Collection<EvaluationResult> results) {
            this.results = EvaluationResultsListCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(EvaluationResult ... results) {
            this.results(Arrays.asList(results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Consumer<EvaluationResult.Builder> ... results) {
            this.results(Stream.of(results).map(c -> (EvaluationResult)((EvaluationResult.Builder)EvaluationResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchEvaluateFeatureResponse build() {
            return new BatchEvaluateFeatureResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EvidentlyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchEvaluateFeatureResponse> {
        public Builder results(Collection<EvaluationResult> var1);

        public Builder results(EvaluationResult ... var1);

        public Builder results(Consumer<EvaluationResult.Builder> ... var1);
    }
}

