/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.endpoints.internal;

import java.util.concurrent.CompletionException;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.services.evidently.endpoints.EvidentlyEndpointParams;
import software.amazon.awssdk.services.evidently.endpoints.EvidentlyEndpointProvider;
import software.amazon.awssdk.services.evidently.endpoints.internal.AwsEndpointProviderUtils;

@SdkInternalApi
public final class EvidentlyResolveEndpointInterceptor
implements ExecutionInterceptor {
    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        if (AwsEndpointProviderUtils.endpointIsDiscovered(executionAttributes)) {
            return context.request();
        }
        EvidentlyEndpointProvider provider = (EvidentlyEndpointProvider)executionAttributes.getAttribute(SdkInternalExecutionAttribute.ENDPOINT_PROVIDER);
        try {
            Endpoint result = provider.resolveEndpoint(EvidentlyResolveEndpointInterceptor.ruleParams(context, executionAttributes)).join();
            executionAttributes.putAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT, (Object)result);
            return context.request();
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SdkClientException) {
                throw (SdkClientException)cause;
            }
            throw SdkClientException.create((String)"Endpoint resolution failed", (Throwable)cause);
        }
    }

    private static EvidentlyEndpointParams ruleParams(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        EvidentlyEndpointParams.Builder builder = EvidentlyEndpointParams.builder();
        EvidentlyResolveEndpointInterceptor.setStaticContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME));
        EvidentlyResolveEndpointInterceptor.setContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME), context.request());
        builder.region(AwsEndpointProviderUtils.regionBuiltIn(executionAttributes));
        builder.useDualStack(AwsEndpointProviderUtils.dualStackEnabledBuiltIn(executionAttributes));
        builder.useFips(AwsEndpointProviderUtils.fipsEnabledBuiltIn(executionAttributes));
        builder.endpoint(AwsEndpointProviderUtils.endpointBuiltIn(executionAttributes));
        return builder.build();
    }

    private static void setContextParams(EvidentlyEndpointParams.Builder params, String operationName, SdkRequest request) {
        switch (operationName) {
            default: 
        }
    }

    private static void setStaticContextParams(EvidentlyEndpointParams.Builder params, String operationName) {
        switch (operationName) {
            default: 
        }
    }
}

