/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.evidently.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.evidently.model.DoubleValueListCopier;
import software.amazon.awssdk.services.evidently.model.ExperimentResultResponseType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExperimentResultsData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExperimentResultsData> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricName").getter(ExperimentResultsData.getter(ExperimentResultsData::metricName)).setter(ExperimentResultsData.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()}).build();
    private static final SdkField<String> RESULT_STAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resultStat").getter(ExperimentResultsData.getter(ExperimentResultsData::resultStatAsString)).setter(ExperimentResultsData.setter(Builder::resultStat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultStat").build()}).build();
    private static final SdkField<String> TREATMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("treatmentName").getter(ExperimentResultsData.getter(ExperimentResultsData::treatmentName)).setter(ExperimentResultsData.setter(Builder::treatmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treatmentName").build()}).build();
    private static final SdkField<List<Double>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("values").getter(ExperimentResultsData.getter(ExperimentResultsData::values)).setter(ExperimentResultsData.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD, RESULT_STAT_FIELD, TREATMENT_NAME_FIELD, VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String metricName;
    private final String resultStat;
    private final String treatmentName;
    private final List<Double> values;

    private ExperimentResultsData(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.resultStat = builder.resultStat;
        this.treatmentName = builder.treatmentName;
        this.values = builder.values;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final ExperimentResultResponseType resultStat() {
        return ExperimentResultResponseType.fromValue(this.resultStat);
    }

    public final String resultStatAsString() {
        return this.resultStat;
    }

    public final String treatmentName() {
        return this.treatmentName;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<Double> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultStatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.treatmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExperimentResultsData)) {
            return false;
        }
        ExperimentResultsData other = (ExperimentResultsData)obj;
        return Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.resultStatAsString(), other.resultStatAsString()) && Objects.equals(this.treatmentName(), other.treatmentName()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values());
    }

    public final String toString() {
        return ToString.builder((String)"ExperimentResultsData").add("MetricName", (Object)this.metricName()).add("ResultStat", (Object)this.resultStatAsString()).add("TreatmentName", (Object)this.treatmentName()).add("Values", this.hasValues() ? this.values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "resultStat": {
                return Optional.ofNullable(clazz.cast(this.resultStatAsString()));
            }
            case "treatmentName": {
                return Optional.ofNullable(clazz.cast(this.treatmentName()));
            }
            case "values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExperimentResultsData, T> g) {
        return obj -> g.apply((ExperimentResultsData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metricName;
        private String resultStat;
        private String treatmentName;
        private List<Double> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExperimentResultsData model) {
            this.metricName(model.metricName);
            this.resultStat(model.resultStat);
            this.treatmentName(model.treatmentName);
            this.values(model.values);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        @Transient
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getResultStat() {
            return this.resultStat;
        }

        public final void setResultStat(String resultStat) {
            this.resultStat = resultStat;
        }

        @Override
        @Transient
        public final Builder resultStat(String resultStat) {
            this.resultStat = resultStat;
            return this;
        }

        @Override
        @Transient
        public final Builder resultStat(ExperimentResultResponseType resultStat) {
            this.resultStat(resultStat == null ? null : resultStat.toString());
            return this;
        }

        public final String getTreatmentName() {
            return this.treatmentName;
        }

        public final void setTreatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
        }

        @Override
        @Transient
        public final Builder treatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
            return this;
        }

        public final Collection<Double> getValues() {
            if (this.values instanceof SdkAutoConstructList) {
                return null;
            }
            return this.values;
        }

        public final void setValues(Collection<Double> values) {
            this.values = DoubleValueListCopier.copy(values);
        }

        @Override
        @Transient
        public final Builder values(Collection<Double> values) {
            this.values = DoubleValueListCopier.copy(values);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder values(Double ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public ExperimentResultsData build() {
            return new ExperimentResultsData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExperimentResultsData> {
        public Builder metricName(String var1);

        public Builder resultStat(String var1);

        public Builder resultStat(ExperimentResultResponseType var1);

        public Builder treatmentName(String var1);

        public Builder values(Collection<Double> var1);

        public Builder values(Double ... var1);
    }
}

