/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomerProfilesIntegrationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomerProfilesIntegrationConfig> {
    private static final SdkField<String> DOMAIN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainArn").getter(CustomerProfilesIntegrationConfig.getter(CustomerProfilesIntegrationConfig::domainArn)).setter(CustomerProfilesIntegrationConfig.setter(Builder::domainArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainArn").build()}).build();
    private static final SdkField<String> OBJECT_TYPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("objectTypeArn").getter(CustomerProfilesIntegrationConfig.getter(CustomerProfilesIntegrationConfig::objectTypeArn)).setter(CustomerProfilesIntegrationConfig.setter(Builder::objectTypeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectTypeArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ARN_FIELD, OBJECT_TYPE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomerProfilesIntegrationConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String domainArn;
    private final String objectTypeArn;

    private CustomerProfilesIntegrationConfig(BuilderImpl builder) {
        this.domainArn = builder.domainArn;
        this.objectTypeArn = builder.objectTypeArn;
    }

    public final String domainArn() {
        return this.domainArn;
    }

    public final String objectTypeArn() {
        return this.objectTypeArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectTypeArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerProfilesIntegrationConfig)) {
            return false;
        }
        CustomerProfilesIntegrationConfig other = (CustomerProfilesIntegrationConfig)obj;
        return Objects.equals(this.domainArn(), other.domainArn()) && Objects.equals(this.objectTypeArn(), other.objectTypeArn());
    }

    public final String toString() {
        return ToString.builder((String)"CustomerProfilesIntegrationConfig").add("DomainArn", (Object)this.domainArn()).add("ObjectTypeArn", (Object)this.objectTypeArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainArn": {
                return Optional.ofNullable(clazz.cast(this.domainArn()));
            }
            case "objectTypeArn": {
                return Optional.ofNullable(clazz.cast(this.objectTypeArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("domainArn", DOMAIN_ARN_FIELD);
        map.put("objectTypeArn", OBJECT_TYPE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomerProfilesIntegrationConfig, T> g) {
        return obj -> g.apply((CustomerProfilesIntegrationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainArn;
        private String objectTypeArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerProfilesIntegrationConfig model) {
            this.domainArn(model.domainArn);
            this.objectTypeArn(model.objectTypeArn);
        }

        public final String getDomainArn() {
            return this.domainArn;
        }

        public final void setDomainArn(String domainArn) {
            this.domainArn = domainArn;
        }

        @Override
        public final Builder domainArn(String domainArn) {
            this.domainArn = domainArn;
            return this;
        }

        public final String getObjectTypeArn() {
            return this.objectTypeArn;
        }

        public final void setObjectTypeArn(String objectTypeArn) {
            this.objectTypeArn = objectTypeArn;
        }

        @Override
        public final Builder objectTypeArn(String objectTypeArn) {
            this.objectTypeArn = objectTypeArn;
            return this;
        }

        public CustomerProfilesIntegrationConfig build() {
            return new CustomerProfilesIntegrationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomerProfilesIntegrationConfig> {
        public Builder domainArn(String var1);

        public Builder objectTypeArn(String var1);
    }
}

