/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The rule-based properties of an ID namespace. These properties define how the ID namespace can be used in an ID
 * mapping workflow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NamespaceRuleBasedProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<NamespaceRuleBasedProperties.Builder, NamespaceRuleBasedProperties> {
    private static final SdkField<List<Rule>> RULES_FIELD = SdkField
            .<List<Rule>> builder(MarshallingType.LIST)
            .memberName("rules")
            .getter(getter(NamespaceRuleBasedProperties::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Rule> builder(MarshallingType.SDK_POJO)
                                            .constructor(Rule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RULE_DEFINITION_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ruleDefinitionTypes")
            .getter(getter(NamespaceRuleBasedProperties::ruleDefinitionTypesAsStrings))
            .setter(setter(Builder::ruleDefinitionTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleDefinitionTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ATTRIBUTE_MATCHING_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attributeMatchingModel").getter(getter(NamespaceRuleBasedProperties::attributeMatchingModelAsString))
            .setter(setter(Builder::attributeMatchingModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeMatchingModel").build())
            .build();

    private static final SdkField<List<String>> RECORD_MATCHING_MODELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("recordMatchingModels")
            .getter(getter(NamespaceRuleBasedProperties::recordMatchingModelsAsStrings))
            .setter(setter(Builder::recordMatchingModelsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordMatchingModels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULES_FIELD,
            RULE_DEFINITION_TYPES_FIELD, ATTRIBUTE_MATCHING_MODEL_FIELD, RECORD_MATCHING_MODELS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Rule> rules;

    private final List<String> ruleDefinitionTypes;

    private final String attributeMatchingModel;

    private final List<String> recordMatchingModels;

    private NamespaceRuleBasedProperties(BuilderImpl builder) {
        this.rules = builder.rules;
        this.ruleDefinitionTypes = builder.ruleDefinitionTypes;
        this.attributeMatchingModel = builder.attributeMatchingModel;
        this.recordMatchingModels = builder.recordMatchingModels;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rules for the ID namespace.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return The rules for the ID namespace.
     */
    public final List<Rule> rules() {
        return rules;
    }

    /**
     * <p>
     * The sets of rules you can use in an ID mapping workflow. The limitations specified for the source and target must
     * be compatible.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleDefinitionTypes} method.
     * </p>
     * 
     * @return The sets of rules you can use in an ID mapping workflow. The limitations specified for the source and
     *         target must be compatible.
     */
    public final List<IdMappingWorkflowRuleDefinitionType> ruleDefinitionTypes() {
        return IdMappingWorkflowRuleDefinitionTypeListCopier.copyStringToEnum(ruleDefinitionTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the RuleDefinitionTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRuleDefinitionTypes() {
        return ruleDefinitionTypes != null && !(ruleDefinitionTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sets of rules you can use in an ID mapping workflow. The limitations specified for the source and target must
     * be compatible.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRuleDefinitionTypes} method.
     * </p>
     * 
     * @return The sets of rules you can use in an ID mapping workflow. The limitations specified for the source and
     *         target must be compatible.
     */
    public final List<String> ruleDefinitionTypesAsStrings() {
        return ruleDefinitionTypes;
    }

    /**
     * <p>
     * The comparison type. You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the
     * <code>attributeMatchingModel</code>.
     * </p>
     * <p>
     * If you choose <code>ONE_TO_ONE</code>, the system can only match attributes if the sub-types are an exact match.
     * For example, for the <code>Email</code> attribute type, the system will only consider it a match if the value of
     * the <code>Email</code> field of Profile A matches the value of the <code>Email</code> field of Profile B.
     * </p>
     * <p>
     * If you choose <code>MANY_TO_MANY</code>, the system can match attributes across the sub-types of an attribute
     * type. For example, if the value of the <code>Email</code> field of Profile A matches the value of
     * <code>BusinessEmail</code> field of Profile B, the two profiles are matched on the <code>Email</code> attribute
     * type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #attributeMatchingModel} will return {@link AttributeMatchingModel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #attributeMatchingModelAsString}.
     * </p>
     * 
     * @return The comparison type. You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the
     *         <code>attributeMatchingModel</code>. </p>
     *         <p>
     *         If you choose <code>ONE_TO_ONE</code>, the system can only match attributes if the sub-types are an exact
     *         match. For example, for the <code>Email</code> attribute type, the system will only consider it a match
     *         if the value of the <code>Email</code> field of Profile A matches the value of the <code>Email</code>
     *         field of Profile B.
     *         </p>
     *         <p>
     *         If you choose <code>MANY_TO_MANY</code>, the system can match attributes across the sub-types of an
     *         attribute type. For example, if the value of the <code>Email</code> field of Profile A matches the value
     *         of <code>BusinessEmail</code> field of Profile B, the two profiles are matched on the <code>Email</code>
     *         attribute type.
     * @see AttributeMatchingModel
     */
    public final AttributeMatchingModel attributeMatchingModel() {
        return AttributeMatchingModel.fromValue(attributeMatchingModel);
    }

    /**
     * <p>
     * The comparison type. You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the
     * <code>attributeMatchingModel</code>.
     * </p>
     * <p>
     * If you choose <code>ONE_TO_ONE</code>, the system can only match attributes if the sub-types are an exact match.
     * For example, for the <code>Email</code> attribute type, the system will only consider it a match if the value of
     * the <code>Email</code> field of Profile A matches the value of the <code>Email</code> field of Profile B.
     * </p>
     * <p>
     * If you choose <code>MANY_TO_MANY</code>, the system can match attributes across the sub-types of an attribute
     * type. For example, if the value of the <code>Email</code> field of Profile A matches the value of
     * <code>BusinessEmail</code> field of Profile B, the two profiles are matched on the <code>Email</code> attribute
     * type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #attributeMatchingModel} will return {@link AttributeMatchingModel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #attributeMatchingModelAsString}.
     * </p>
     * 
     * @return The comparison type. You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the
     *         <code>attributeMatchingModel</code>. </p>
     *         <p>
     *         If you choose <code>ONE_TO_ONE</code>, the system can only match attributes if the sub-types are an exact
     *         match. For example, for the <code>Email</code> attribute type, the system will only consider it a match
     *         if the value of the <code>Email</code> field of Profile A matches the value of the <code>Email</code>
     *         field of Profile B.
     *         </p>
     *         <p>
     *         If you choose <code>MANY_TO_MANY</code>, the system can match attributes across the sub-types of an
     *         attribute type. For example, if the value of the <code>Email</code> field of Profile A matches the value
     *         of <code>BusinessEmail</code> field of Profile B, the two profiles are matched on the <code>Email</code>
     *         attribute type.
     * @see AttributeMatchingModel
     */
    public final String attributeMatchingModelAsString() {
        return attributeMatchingModel;
    }

    /**
     * <p>
     * The type of matching record that is allowed to be used in an ID mapping workflow.
     * </p>
     * <p>
     * If the value is set to <code>ONE_SOURCE_TO_ONE_TARGET</code>, only one record in the source is matched to one
     * record in the target.
     * </p>
     * <p>
     * If the value is set to <code>MANY_SOURCE_TO_ONE_TARGET</code>, all matching records in the source are matched to
     * one record in the target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecordMatchingModels} method.
     * </p>
     * 
     * @return The type of matching record that is allowed to be used in an ID mapping workflow. </p>
     *         <p>
     *         If the value is set to <code>ONE_SOURCE_TO_ONE_TARGET</code>, only one record in the source is matched to
     *         one record in the target.
     *         </p>
     *         <p>
     *         If the value is set to <code>MANY_SOURCE_TO_ONE_TARGET</code>, all matching records in the source are
     *         matched to one record in the target.
     */
    public final List<RecordMatchingModel> recordMatchingModels() {
        return RecordMatchingModelListCopier.copyStringToEnum(recordMatchingModels);
    }

    /**
     * For responses, this returns true if the service returned a value for the RecordMatchingModels property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRecordMatchingModels() {
        return recordMatchingModels != null && !(recordMatchingModels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type of matching record that is allowed to be used in an ID mapping workflow.
     * </p>
     * <p>
     * If the value is set to <code>ONE_SOURCE_TO_ONE_TARGET</code>, only one record in the source is matched to one
     * record in the target.
     * </p>
     * <p>
     * If the value is set to <code>MANY_SOURCE_TO_ONE_TARGET</code>, all matching records in the source are matched to
     * one record in the target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecordMatchingModels} method.
     * </p>
     * 
     * @return The type of matching record that is allowed to be used in an ID mapping workflow. </p>
     *         <p>
     *         If the value is set to <code>ONE_SOURCE_TO_ONE_TARGET</code>, only one record in the source is matched to
     *         one record in the target.
     *         </p>
     *         <p>
     *         If the value is set to <code>MANY_SOURCE_TO_ONE_TARGET</code>, all matching records in the source are
     *         matched to one record in the target.
     */
    public final List<String> recordMatchingModelsAsStrings() {
        return recordMatchingModels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRuleDefinitionTypes() ? ruleDefinitionTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(attributeMatchingModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecordMatchingModels() ? recordMatchingModelsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NamespaceRuleBasedProperties)) {
            return false;
        }
        NamespaceRuleBasedProperties other = (NamespaceRuleBasedProperties) obj;
        return hasRules() == other.hasRules() && Objects.equals(rules(), other.rules())
                && hasRuleDefinitionTypes() == other.hasRuleDefinitionTypes()
                && Objects.equals(ruleDefinitionTypesAsStrings(), other.ruleDefinitionTypesAsStrings())
                && Objects.equals(attributeMatchingModelAsString(), other.attributeMatchingModelAsString())
                && hasRecordMatchingModels() == other.hasRecordMatchingModels()
                && Objects.equals(recordMatchingModelsAsStrings(), other.recordMatchingModelsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NamespaceRuleBasedProperties").add("Rules", hasRules() ? rules() : null)
                .add("RuleDefinitionTypes", hasRuleDefinitionTypes() ? ruleDefinitionTypesAsStrings() : null)
                .add("AttributeMatchingModel", attributeMatchingModelAsString())
                .add("RecordMatchingModels", hasRecordMatchingModels() ? recordMatchingModelsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rules":
            return Optional.ofNullable(clazz.cast(rules()));
        case "ruleDefinitionTypes":
            return Optional.ofNullable(clazz.cast(ruleDefinitionTypesAsStrings()));
        case "attributeMatchingModel":
            return Optional.ofNullable(clazz.cast(attributeMatchingModelAsString()));
        case "recordMatchingModels":
            return Optional.ofNullable(clazz.cast(recordMatchingModelsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("rules", RULES_FIELD);
        map.put("ruleDefinitionTypes", RULE_DEFINITION_TYPES_FIELD);
        map.put("attributeMatchingModel", ATTRIBUTE_MATCHING_MODEL_FIELD);
        map.put("recordMatchingModels", RECORD_MATCHING_MODELS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NamespaceRuleBasedProperties, T> g) {
        return obj -> g.apply((NamespaceRuleBasedProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NamespaceRuleBasedProperties> {
        /**
         * <p>
         * The rules for the ID namespace.
         * </p>
         * 
         * @param rules
         *        The rules for the ID namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<Rule> rules);

        /**
         * <p>
         * The rules for the ID namespace.
         * </p>
         * 
         * @param rules
         *        The rules for the ID namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Rule... rules);

        /**
         * <p>
         * The rules for the ID namespace.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.entityresolution.model.Rule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.entityresolution.model.Rule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.entityresolution.model.Rule.Builder#build()} is called immediately and
         * its result is passed to {@link #rules(List<Rule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.entityresolution.model.Rule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(java.util.Collection<Rule>)
         */
        Builder rules(Consumer<Rule.Builder>... rules);

        /**
         * <p>
         * The sets of rules you can use in an ID mapping workflow. The limitations specified for the source and target
         * must be compatible.
         * </p>
         * 
         * @param ruleDefinitionTypes
         *        The sets of rules you can use in an ID mapping workflow. The limitations specified for the source and
         *        target must be compatible.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleDefinitionTypesWithStrings(Collection<String> ruleDefinitionTypes);

        /**
         * <p>
         * The sets of rules you can use in an ID mapping workflow. The limitations specified for the source and target
         * must be compatible.
         * </p>
         * 
         * @param ruleDefinitionTypes
         *        The sets of rules you can use in an ID mapping workflow. The limitations specified for the source and
         *        target must be compatible.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleDefinitionTypesWithStrings(String... ruleDefinitionTypes);

        /**
         * <p>
         * The sets of rules you can use in an ID mapping workflow. The limitations specified for the source and target
         * must be compatible.
         * </p>
         * 
         * @param ruleDefinitionTypes
         *        The sets of rules you can use in an ID mapping workflow. The limitations specified for the source and
         *        target must be compatible.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleDefinitionTypes(Collection<IdMappingWorkflowRuleDefinitionType> ruleDefinitionTypes);

        /**
         * <p>
         * The sets of rules you can use in an ID mapping workflow. The limitations specified for the source and target
         * must be compatible.
         * </p>
         * 
         * @param ruleDefinitionTypes
         *        The sets of rules you can use in an ID mapping workflow. The limitations specified for the source and
         *        target must be compatible.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleDefinitionTypes(IdMappingWorkflowRuleDefinitionType... ruleDefinitionTypes);

        /**
         * <p>
         * The comparison type. You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the
         * <code>attributeMatchingModel</code>.
         * </p>
         * <p>
         * If you choose <code>ONE_TO_ONE</code>, the system can only match attributes if the sub-types are an exact
         * match. For example, for the <code>Email</code> attribute type, the system will only consider it a match if
         * the value of the <code>Email</code> field of Profile A matches the value of the <code>Email</code> field of
         * Profile B.
         * </p>
         * <p>
         * If you choose <code>MANY_TO_MANY</code>, the system can match attributes across the sub-types of an attribute
         * type. For example, if the value of the <code>Email</code> field of Profile A matches the value of
         * <code>BusinessEmail</code> field of Profile B, the two profiles are matched on the <code>Email</code>
         * attribute type.
         * </p>
         * 
         * @param attributeMatchingModel
         *        The comparison type. You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the
         *        <code>attributeMatchingModel</code>. </p>
         *        <p>
         *        If you choose <code>ONE_TO_ONE</code>, the system can only match attributes if the sub-types are an
         *        exact match. For example, for the <code>Email</code> attribute type, the system will only consider it
         *        a match if the value of the <code>Email</code> field of Profile A matches the value of the
         *        <code>Email</code> field of Profile B.
         *        </p>
         *        <p>
         *        If you choose <code>MANY_TO_MANY</code>, the system can match attributes across the sub-types of an
         *        attribute type. For example, if the value of the <code>Email</code> field of Profile A matches the
         *        value of <code>BusinessEmail</code> field of Profile B, the two profiles are matched on the
         *        <code>Email</code> attribute type.
         * @see AttributeMatchingModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttributeMatchingModel
         */
        Builder attributeMatchingModel(String attributeMatchingModel);

        /**
         * <p>
         * The comparison type. You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the
         * <code>attributeMatchingModel</code>.
         * </p>
         * <p>
         * If you choose <code>ONE_TO_ONE</code>, the system can only match attributes if the sub-types are an exact
         * match. For example, for the <code>Email</code> attribute type, the system will only consider it a match if
         * the value of the <code>Email</code> field of Profile A matches the value of the <code>Email</code> field of
         * Profile B.
         * </p>
         * <p>
         * If you choose <code>MANY_TO_MANY</code>, the system can match attributes across the sub-types of an attribute
         * type. For example, if the value of the <code>Email</code> field of Profile A matches the value of
         * <code>BusinessEmail</code> field of Profile B, the two profiles are matched on the <code>Email</code>
         * attribute type.
         * </p>
         * 
         * @param attributeMatchingModel
         *        The comparison type. You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the
         *        <code>attributeMatchingModel</code>. </p>
         *        <p>
         *        If you choose <code>ONE_TO_ONE</code>, the system can only match attributes if the sub-types are an
         *        exact match. For example, for the <code>Email</code> attribute type, the system will only consider it
         *        a match if the value of the <code>Email</code> field of Profile A matches the value of the
         *        <code>Email</code> field of Profile B.
         *        </p>
         *        <p>
         *        If you choose <code>MANY_TO_MANY</code>, the system can match attributes across the sub-types of an
         *        attribute type. For example, if the value of the <code>Email</code> field of Profile A matches the
         *        value of <code>BusinessEmail</code> field of Profile B, the two profiles are matched on the
         *        <code>Email</code> attribute type.
         * @see AttributeMatchingModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttributeMatchingModel
         */
        Builder attributeMatchingModel(AttributeMatchingModel attributeMatchingModel);

        /**
         * <p>
         * The type of matching record that is allowed to be used in an ID mapping workflow.
         * </p>
         * <p>
         * If the value is set to <code>ONE_SOURCE_TO_ONE_TARGET</code>, only one record in the source is matched to one
         * record in the target.
         * </p>
         * <p>
         * If the value is set to <code>MANY_SOURCE_TO_ONE_TARGET</code>, all matching records in the source are matched
         * to one record in the target.
         * </p>
         * 
         * @param recordMatchingModels
         *        The type of matching record that is allowed to be used in an ID mapping workflow. </p>
         *        <p>
         *        If the value is set to <code>ONE_SOURCE_TO_ONE_TARGET</code>, only one record in the source is matched
         *        to one record in the target.
         *        </p>
         *        <p>
         *        If the value is set to <code>MANY_SOURCE_TO_ONE_TARGET</code>, all matching records in the source are
         *        matched to one record in the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordMatchingModelsWithStrings(Collection<String> recordMatchingModels);

        /**
         * <p>
         * The type of matching record that is allowed to be used in an ID mapping workflow.
         * </p>
         * <p>
         * If the value is set to <code>ONE_SOURCE_TO_ONE_TARGET</code>, only one record in the source is matched to one
         * record in the target.
         * </p>
         * <p>
         * If the value is set to <code>MANY_SOURCE_TO_ONE_TARGET</code>, all matching records in the source are matched
         * to one record in the target.
         * </p>
         * 
         * @param recordMatchingModels
         *        The type of matching record that is allowed to be used in an ID mapping workflow. </p>
         *        <p>
         *        If the value is set to <code>ONE_SOURCE_TO_ONE_TARGET</code>, only one record in the source is matched
         *        to one record in the target.
         *        </p>
         *        <p>
         *        If the value is set to <code>MANY_SOURCE_TO_ONE_TARGET</code>, all matching records in the source are
         *        matched to one record in the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordMatchingModelsWithStrings(String... recordMatchingModels);

        /**
         * <p>
         * The type of matching record that is allowed to be used in an ID mapping workflow.
         * </p>
         * <p>
         * If the value is set to <code>ONE_SOURCE_TO_ONE_TARGET</code>, only one record in the source is matched to one
         * record in the target.
         * </p>
         * <p>
         * If the value is set to <code>MANY_SOURCE_TO_ONE_TARGET</code>, all matching records in the source are matched
         * to one record in the target.
         * </p>
         * 
         * @param recordMatchingModels
         *        The type of matching record that is allowed to be used in an ID mapping workflow. </p>
         *        <p>
         *        If the value is set to <code>ONE_SOURCE_TO_ONE_TARGET</code>, only one record in the source is matched
         *        to one record in the target.
         *        </p>
         *        <p>
         *        If the value is set to <code>MANY_SOURCE_TO_ONE_TARGET</code>, all matching records in the source are
         *        matched to one record in the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordMatchingModels(Collection<RecordMatchingModel> recordMatchingModels);

        /**
         * <p>
         * The type of matching record that is allowed to be used in an ID mapping workflow.
         * </p>
         * <p>
         * If the value is set to <code>ONE_SOURCE_TO_ONE_TARGET</code>, only one record in the source is matched to one
         * record in the target.
         * </p>
         * <p>
         * If the value is set to <code>MANY_SOURCE_TO_ONE_TARGET</code>, all matching records in the source are matched
         * to one record in the target.
         * </p>
         * 
         * @param recordMatchingModels
         *        The type of matching record that is allowed to be used in an ID mapping workflow. </p>
         *        <p>
         *        If the value is set to <code>ONE_SOURCE_TO_ONE_TARGET</code>, only one record in the source is matched
         *        to one record in the target.
         *        </p>
         *        <p>
         *        If the value is set to <code>MANY_SOURCE_TO_ONE_TARGET</code>, all matching records in the source are
         *        matched to one record in the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordMatchingModels(RecordMatchingModel... recordMatchingModels);
    }

    static final class BuilderImpl implements Builder {
        private List<Rule> rules = DefaultSdkAutoConstructList.getInstance();

        private List<String> ruleDefinitionTypes = DefaultSdkAutoConstructList.getInstance();

        private String attributeMatchingModel;

        private List<String> recordMatchingModels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NamespaceRuleBasedProperties model) {
            rules(model.rules);
            ruleDefinitionTypesWithStrings(model.ruleDefinitionTypes);
            attributeMatchingModel(model.attributeMatchingModel);
            recordMatchingModelsWithStrings(model.recordMatchingModels);
        }

        public final List<Rule.Builder> getRules() {
            List<Rule.Builder> result = NamespaceRuleBasedPropertiesRulesListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = NamespaceRuleBasedPropertiesRulesListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = NamespaceRuleBasedPropertiesRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<Rule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> Rule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getRuleDefinitionTypes() {
            if (ruleDefinitionTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return ruleDefinitionTypes;
        }

        public final void setRuleDefinitionTypes(Collection<String> ruleDefinitionTypes) {
            this.ruleDefinitionTypes = IdMappingWorkflowRuleDefinitionTypeListCopier.copy(ruleDefinitionTypes);
        }

        @Override
        public final Builder ruleDefinitionTypesWithStrings(Collection<String> ruleDefinitionTypes) {
            this.ruleDefinitionTypes = IdMappingWorkflowRuleDefinitionTypeListCopier.copy(ruleDefinitionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleDefinitionTypesWithStrings(String... ruleDefinitionTypes) {
            ruleDefinitionTypesWithStrings(Arrays.asList(ruleDefinitionTypes));
            return this;
        }

        @Override
        public final Builder ruleDefinitionTypes(Collection<IdMappingWorkflowRuleDefinitionType> ruleDefinitionTypes) {
            this.ruleDefinitionTypes = IdMappingWorkflowRuleDefinitionTypeListCopier.copyEnumToString(ruleDefinitionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleDefinitionTypes(IdMappingWorkflowRuleDefinitionType... ruleDefinitionTypes) {
            ruleDefinitionTypes(Arrays.asList(ruleDefinitionTypes));
            return this;
        }

        public final String getAttributeMatchingModel() {
            return attributeMatchingModel;
        }

        public final void setAttributeMatchingModel(String attributeMatchingModel) {
            this.attributeMatchingModel = attributeMatchingModel;
        }

        @Override
        public final Builder attributeMatchingModel(String attributeMatchingModel) {
            this.attributeMatchingModel = attributeMatchingModel;
            return this;
        }

        @Override
        public final Builder attributeMatchingModel(AttributeMatchingModel attributeMatchingModel) {
            this.attributeMatchingModel(attributeMatchingModel == null ? null : attributeMatchingModel.toString());
            return this;
        }

        public final Collection<String> getRecordMatchingModels() {
            if (recordMatchingModels instanceof SdkAutoConstructList) {
                return null;
            }
            return recordMatchingModels;
        }

        public final void setRecordMatchingModels(Collection<String> recordMatchingModels) {
            this.recordMatchingModels = RecordMatchingModelListCopier.copy(recordMatchingModels);
        }

        @Override
        public final Builder recordMatchingModelsWithStrings(Collection<String> recordMatchingModels) {
            this.recordMatchingModels = RecordMatchingModelListCopier.copy(recordMatchingModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordMatchingModelsWithStrings(String... recordMatchingModels) {
            recordMatchingModelsWithStrings(Arrays.asList(recordMatchingModels));
            return this;
        }

        @Override
        public final Builder recordMatchingModels(Collection<RecordMatchingModel> recordMatchingModels) {
            this.recordMatchingModels = RecordMatchingModelListCopier.copyEnumToString(recordMatchingModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordMatchingModels(RecordMatchingModel... recordMatchingModels) {
            recordMatchingModels(Arrays.asList(recordMatchingModels));
            return this;
        }

        @Override
        public NamespaceRuleBasedProperties build() {
            return new NamespaceRuleBasedProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
