/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object which defines the ID mapping technique and any additional configurations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdMappingTechniques implements SdkPojo, Serializable,
        ToCopyableBuilder<IdMappingTechniques.Builder, IdMappingTechniques> {
    private static final SdkField<String> ID_MAPPING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("idMappingType").getter(getter(IdMappingTechniques::idMappingTypeAsString))
            .setter(setter(Builder::idMappingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idMappingType").build()).build();

    private static final SdkField<IdMappingRuleBasedProperties> RULE_BASED_PROPERTIES_FIELD = SdkField
            .<IdMappingRuleBasedProperties> builder(MarshallingType.SDK_POJO).memberName("ruleBasedProperties")
            .getter(getter(IdMappingTechniques::ruleBasedProperties)).setter(setter(Builder::ruleBasedProperties))
            .constructor(IdMappingRuleBasedProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleBasedProperties").build())
            .build();

    private static final SdkField<ProviderProperties> PROVIDER_PROPERTIES_FIELD = SdkField
            .<ProviderProperties> builder(MarshallingType.SDK_POJO).memberName("providerProperties")
            .getter(getter(IdMappingTechniques::providerProperties)).setter(setter(Builder::providerProperties))
            .constructor(ProviderProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_MAPPING_TYPE_FIELD,
            RULE_BASED_PROPERTIES_FIELD, PROVIDER_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String idMappingType;

    private final IdMappingRuleBasedProperties ruleBasedProperties;

    private final ProviderProperties providerProperties;

    private IdMappingTechniques(BuilderImpl builder) {
        this.idMappingType = builder.idMappingType;
        this.ruleBasedProperties = builder.ruleBasedProperties;
        this.providerProperties = builder.providerProperties;
    }

    /**
     * <p>
     * The type of ID mapping.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #idMappingType}
     * will return {@link IdMappingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #idMappingTypeAsString}.
     * </p>
     * 
     * @return The type of ID mapping.
     * @see IdMappingType
     */
    public final IdMappingType idMappingType() {
        return IdMappingType.fromValue(idMappingType);
    }

    /**
     * <p>
     * The type of ID mapping.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #idMappingType}
     * will return {@link IdMappingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #idMappingTypeAsString}.
     * </p>
     * 
     * @return The type of ID mapping.
     * @see IdMappingType
     */
    public final String idMappingTypeAsString() {
        return idMappingType;
    }

    /**
     * <p>
     * An object which defines any additional configurations required by rule-based matching.
     * </p>
     * 
     * @return An object which defines any additional configurations required by rule-based matching.
     */
    public final IdMappingRuleBasedProperties ruleBasedProperties() {
        return ruleBasedProperties;
    }

    /**
     * <p>
     * An object which defines any additional configurations required by the provider service.
     * </p>
     * 
     * @return An object which defines any additional configurations required by the provider service.
     */
    public final ProviderProperties providerProperties() {
        return providerProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(idMappingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ruleBasedProperties());
        hashCode = 31 * hashCode + Objects.hashCode(providerProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdMappingTechniques)) {
            return false;
        }
        IdMappingTechniques other = (IdMappingTechniques) obj;
        return Objects.equals(idMappingTypeAsString(), other.idMappingTypeAsString())
                && Objects.equals(ruleBasedProperties(), other.ruleBasedProperties())
                && Objects.equals(providerProperties(), other.providerProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdMappingTechniques").add("IdMappingType", idMappingTypeAsString())
                .add("RuleBasedProperties", ruleBasedProperties()).add("ProviderProperties", providerProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "idMappingType":
            return Optional.ofNullable(clazz.cast(idMappingTypeAsString()));
        case "ruleBasedProperties":
            return Optional.ofNullable(clazz.cast(ruleBasedProperties()));
        case "providerProperties":
            return Optional.ofNullable(clazz.cast(providerProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("idMappingType", ID_MAPPING_TYPE_FIELD);
        map.put("ruleBasedProperties", RULE_BASED_PROPERTIES_FIELD);
        map.put("providerProperties", PROVIDER_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdMappingTechniques, T> g) {
        return obj -> g.apply((IdMappingTechniques) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdMappingTechniques> {
        /**
         * <p>
         * The type of ID mapping.
         * </p>
         * 
         * @param idMappingType
         *        The type of ID mapping.
         * @see IdMappingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdMappingType
         */
        Builder idMappingType(String idMappingType);

        /**
         * <p>
         * The type of ID mapping.
         * </p>
         * 
         * @param idMappingType
         *        The type of ID mapping.
         * @see IdMappingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdMappingType
         */
        Builder idMappingType(IdMappingType idMappingType);

        /**
         * <p>
         * An object which defines any additional configurations required by rule-based matching.
         * </p>
         * 
         * @param ruleBasedProperties
         *        An object which defines any additional configurations required by rule-based matching.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleBasedProperties(IdMappingRuleBasedProperties ruleBasedProperties);

        /**
         * <p>
         * An object which defines any additional configurations required by rule-based matching.
         * </p>
         * This is a convenience method that creates an instance of the {@link IdMappingRuleBasedProperties.Builder}
         * avoiding the need to create one manually via {@link IdMappingRuleBasedProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IdMappingRuleBasedProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #ruleBasedProperties(IdMappingRuleBasedProperties)}.
         * 
         * @param ruleBasedProperties
         *        a consumer that will call methods on {@link IdMappingRuleBasedProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleBasedProperties(IdMappingRuleBasedProperties)
         */
        default Builder ruleBasedProperties(Consumer<IdMappingRuleBasedProperties.Builder> ruleBasedProperties) {
            return ruleBasedProperties(IdMappingRuleBasedProperties.builder().applyMutation(ruleBasedProperties).build());
        }

        /**
         * <p>
         * An object which defines any additional configurations required by the provider service.
         * </p>
         * 
         * @param providerProperties
         *        An object which defines any additional configurations required by the provider service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerProperties(ProviderProperties providerProperties);

        /**
         * <p>
         * An object which defines any additional configurations required by the provider service.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProviderProperties.Builder} avoiding the
         * need to create one manually via {@link ProviderProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProviderProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #providerProperties(ProviderProperties)}.
         * 
         * @param providerProperties
         *        a consumer that will call methods on {@link ProviderProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #providerProperties(ProviderProperties)
         */
        default Builder providerProperties(Consumer<ProviderProperties.Builder> providerProperties) {
            return providerProperties(ProviderProperties.builder().applyMutation(providerProperties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String idMappingType;

        private IdMappingRuleBasedProperties ruleBasedProperties;

        private ProviderProperties providerProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(IdMappingTechniques model) {
            idMappingType(model.idMappingType);
            ruleBasedProperties(model.ruleBasedProperties);
            providerProperties(model.providerProperties);
        }

        public final String getIdMappingType() {
            return idMappingType;
        }

        public final void setIdMappingType(String idMappingType) {
            this.idMappingType = idMappingType;
        }

        @Override
        public final Builder idMappingType(String idMappingType) {
            this.idMappingType = idMappingType;
            return this;
        }

        @Override
        public final Builder idMappingType(IdMappingType idMappingType) {
            this.idMappingType(idMappingType == null ? null : idMappingType.toString());
            return this;
        }

        public final IdMappingRuleBasedProperties.Builder getRuleBasedProperties() {
            return ruleBasedProperties != null ? ruleBasedProperties.toBuilder() : null;
        }

        public final void setRuleBasedProperties(IdMappingRuleBasedProperties.BuilderImpl ruleBasedProperties) {
            this.ruleBasedProperties = ruleBasedProperties != null ? ruleBasedProperties.build() : null;
        }

        @Override
        public final Builder ruleBasedProperties(IdMappingRuleBasedProperties ruleBasedProperties) {
            this.ruleBasedProperties = ruleBasedProperties;
            return this;
        }

        public final ProviderProperties.Builder getProviderProperties() {
            return providerProperties != null ? providerProperties.toBuilder() : null;
        }

        public final void setProviderProperties(ProviderProperties.BuilderImpl providerProperties) {
            this.providerProperties = providerProperties != null ? providerProperties.build() : null;
        }

        @Override
        public final Builder providerProperties(ProviderProperties providerProperties) {
            this.providerProperties = providerProperties;
            return this;
        }

        @Override
        public IdMappingTechniques build() {
            return new IdMappingTechniques(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
