/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenerateMatchIdResponse extends EntityResolutionResponse implements
        ToCopyableBuilder<GenerateMatchIdResponse.Builder, GenerateMatchIdResponse> {
    private static final SdkField<List<MatchGroup>> MATCH_GROUPS_FIELD = SdkField
            .<List<MatchGroup>> builder(MarshallingType.LIST)
            .memberName("matchGroups")
            .getter(getter(GenerateMatchIdResponse::matchGroups))
            .setter(setter(Builder::matchGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MatchGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(MatchGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FailedRecord>> FAILED_RECORDS_FIELD = SdkField
            .<List<FailedRecord>> builder(MarshallingType.LIST)
            .memberName("failedRecords")
            .getter(getter(GenerateMatchIdResponse::failedRecords))
            .setter(setter(Builder::failedRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedRecords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FailedRecord> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedRecord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCH_GROUPS_FIELD,
            FAILED_RECORDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<MatchGroup> matchGroups;

    private final List<FailedRecord> failedRecords;

    private GenerateMatchIdResponse(BuilderImpl builder) {
        super(builder);
        this.matchGroups = builder.matchGroups;
        this.failedRecords = builder.failedRecords;
    }

    /**
     * For responses, this returns true if the service returned a value for the MatchGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMatchGroups() {
        return matchGroups != null && !(matchGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The match groups from the generated match ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMatchGroups} method.
     * </p>
     * 
     * @return The match groups from the generated match ID.
     */
    public final List<MatchGroup> matchGroups() {
        return matchGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedRecords property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailedRecords() {
        return failedRecords != null && !(failedRecords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The records that didn't receive a generated Match ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedRecords} method.
     * </p>
     * 
     * @return The records that didn't receive a generated Match ID.
     */
    public final List<FailedRecord> failedRecords() {
        return failedRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMatchGroups() ? matchGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedRecords() ? failedRecords() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateMatchIdResponse)) {
            return false;
        }
        GenerateMatchIdResponse other = (GenerateMatchIdResponse) obj;
        return hasMatchGroups() == other.hasMatchGroups() && Objects.equals(matchGroups(), other.matchGroups())
                && hasFailedRecords() == other.hasFailedRecords() && Objects.equals(failedRecords(), other.failedRecords());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GenerateMatchIdResponse").add("MatchGroups", hasMatchGroups() ? matchGroups() : null)
                .add("FailedRecords", hasFailedRecords() ? failedRecords() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "matchGroups":
            return Optional.ofNullable(clazz.cast(matchGroups()));
        case "failedRecords":
            return Optional.ofNullable(clazz.cast(failedRecords()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("matchGroups", MATCH_GROUPS_FIELD);
        map.put("failedRecords", FAILED_RECORDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerateMatchIdResponse, T> g) {
        return obj -> g.apply((GenerateMatchIdResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EntityResolutionResponse.Builder, SdkPojo, CopyableBuilder<Builder, GenerateMatchIdResponse> {
        /**
         * <p>
         * The match groups from the generated match ID.
         * </p>
         * 
         * @param matchGroups
         *        The match groups from the generated match ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchGroups(Collection<MatchGroup> matchGroups);

        /**
         * <p>
         * The match groups from the generated match ID.
         * </p>
         * 
         * @param matchGroups
         *        The match groups from the generated match ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchGroups(MatchGroup... matchGroups);

        /**
         * <p>
         * The match groups from the generated match ID.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.entityresolution.model.MatchGroup.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.entityresolution.model.MatchGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.entityresolution.model.MatchGroup.Builder#build()} is called
         * immediately and its result is passed to {@link #matchGroups(List<MatchGroup>)}.
         * 
         * @param matchGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.entityresolution.model.MatchGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #matchGroups(java.util.Collection<MatchGroup>)
         */
        Builder matchGroups(Consumer<MatchGroup.Builder>... matchGroups);

        /**
         * <p>
         * The records that didn't receive a generated Match ID.
         * </p>
         * 
         * @param failedRecords
         *        The records that didn't receive a generated Match ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedRecords(Collection<FailedRecord> failedRecords);

        /**
         * <p>
         * The records that didn't receive a generated Match ID.
         * </p>
         * 
         * @param failedRecords
         *        The records that didn't receive a generated Match ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedRecords(FailedRecord... failedRecords);

        /**
         * <p>
         * The records that didn't receive a generated Match ID.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.entityresolution.model.FailedRecord.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.entityresolution.model.FailedRecord#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.entityresolution.model.FailedRecord.Builder#build()} is called
         * immediately and its result is passed to {@link #failedRecords(List<FailedRecord>)}.
         * 
         * @param failedRecords
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.entityresolution.model.FailedRecord.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedRecords(java.util.Collection<FailedRecord>)
         */
        Builder failedRecords(Consumer<FailedRecord.Builder>... failedRecords);
    }

    static final class BuilderImpl extends EntityResolutionResponse.BuilderImpl implements Builder {
        private List<MatchGroup> matchGroups = DefaultSdkAutoConstructList.getInstance();

        private List<FailedRecord> failedRecords = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateMatchIdResponse model) {
            super(model);
            matchGroups(model.matchGroups);
            failedRecords(model.failedRecords);
        }

        public final List<MatchGroup.Builder> getMatchGroups() {
            List<MatchGroup.Builder> result = MatchGroupsListCopier.copyToBuilder(this.matchGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMatchGroups(Collection<MatchGroup.BuilderImpl> matchGroups) {
            this.matchGroups = MatchGroupsListCopier.copyFromBuilder(matchGroups);
        }

        @Override
        public final Builder matchGroups(Collection<MatchGroup> matchGroups) {
            this.matchGroups = MatchGroupsListCopier.copy(matchGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchGroups(MatchGroup... matchGroups) {
            matchGroups(Arrays.asList(matchGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchGroups(Consumer<MatchGroup.Builder>... matchGroups) {
            matchGroups(Stream.of(matchGroups).map(c -> MatchGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<FailedRecord.Builder> getFailedRecords() {
            List<FailedRecord.Builder> result = FailedRecordsListCopier.copyToBuilder(this.failedRecords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedRecords(Collection<FailedRecord.BuilderImpl> failedRecords) {
            this.failedRecords = FailedRecordsListCopier.copyFromBuilder(failedRecords);
        }

        @Override
        public final Builder failedRecords(Collection<FailedRecord> failedRecords) {
            this.failedRecords = FailedRecordsListCopier.copy(failedRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedRecords(FailedRecord... failedRecords) {
            failedRecords(Arrays.asList(failedRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedRecords(Consumer<FailedRecord.Builder>... failedRecords) {
            failedRecords(Stream.of(failedRecords).map(c -> FailedRecord.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GenerateMatchIdResponse build() {
            return new GenerateMatchIdResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
