/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.entityresolution.model.MatchedRecord;
import software.amazon.awssdk.services.entityresolution.model.MatchedRecordsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MatchGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MatchGroup> {
    private static final SdkField<List<MatchedRecord>> RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("records").getter(MatchGroup.getter(MatchGroup::records)).setter(MatchGroup.setter(Builder::records)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("records").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MatchedRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MATCH_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("matchId").getter(MatchGroup.getter(MatchGroup::matchId)).setter(MatchGroup.setter(Builder::matchId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchId").build()}).build();
    private static final SdkField<String> MATCH_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("matchRule").getter(MatchGroup.getter(MatchGroup::matchRule)).setter(MatchGroup.setter(Builder::matchRule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchRule").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDS_FIELD, MATCH_ID_FIELD, MATCH_RULE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MatchGroup.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<MatchedRecord> records;
    private final String matchId;
    private final String matchRule;

    private MatchGroup(BuilderImpl builder) {
        this.records = builder.records;
        this.matchId = builder.matchId;
        this.matchRule = builder.matchRule;
    }

    public final boolean hasRecords() {
        return this.records != null && !(this.records instanceof SdkAutoConstructList);
    }

    public final List<MatchedRecord> records() {
        return this.records;
    }

    public final String matchId() {
        return this.matchId;
    }

    public final String matchRule() {
        return this.matchRule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecords() ? this.records() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.matchId());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchRule());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchGroup)) {
            return false;
        }
        MatchGroup other = (MatchGroup)obj;
        return this.hasRecords() == other.hasRecords() && Objects.equals(this.records(), other.records()) && Objects.equals(this.matchId(), other.matchId()) && Objects.equals(this.matchRule(), other.matchRule());
    }

    public final String toString() {
        return ToString.builder((String)"MatchGroup").add("Records", this.hasRecords() ? this.records() : null).add("MatchId", (Object)this.matchId()).add("MatchRule", (Object)this.matchRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "records": {
                return Optional.ofNullable(clazz.cast(this.records()));
            }
            case "matchId": {
                return Optional.ofNullable(clazz.cast(this.matchId()));
            }
            case "matchRule": {
                return Optional.ofNullable(clazz.cast(this.matchRule()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("records", RECORDS_FIELD);
        map.put("matchId", MATCH_ID_FIELD);
        map.put("matchRule", MATCH_RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MatchGroup, T> g) {
        return obj -> g.apply((MatchGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<MatchedRecord> records = DefaultSdkAutoConstructList.getInstance();
        private String matchId;
        private String matchRule;

        private BuilderImpl() {
        }

        private BuilderImpl(MatchGroup model) {
            this.records(model.records);
            this.matchId(model.matchId);
            this.matchRule(model.matchRule);
        }

        public final List<MatchedRecord.Builder> getRecords() {
            List<MatchedRecord.Builder> result = MatchedRecordsListCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<MatchedRecord.BuilderImpl> records) {
            this.records = MatchedRecordsListCopier.copyFromBuilder(records);
        }

        @Override
        public final Builder records(Collection<MatchedRecord> records) {
            this.records = MatchedRecordsListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(MatchedRecord ... records) {
            this.records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<MatchedRecord.Builder> ... records) {
            this.records(Stream.of(records).map(c -> (MatchedRecord)((MatchedRecord.Builder)MatchedRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMatchId() {
            return this.matchId;
        }

        public final void setMatchId(String matchId) {
            this.matchId = matchId;
        }

        @Override
        public final Builder matchId(String matchId) {
            this.matchId = matchId;
            return this;
        }

        public final String getMatchRule() {
            return this.matchRule;
        }

        public final void setMatchRule(String matchRule) {
            this.matchRule = matchRule;
        }

        @Override
        public final Builder matchRule(String matchRule) {
            this.matchRule = matchRule;
            return this;
        }

        public MatchGroup build() {
            return new MatchGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MatchGroup> {
        public Builder records(Collection<MatchedRecord> var1);

        public Builder records(MatchedRecord ... var1);

        public Builder records(Consumer<MatchedRecord.Builder> ... var1);

        public Builder matchId(String var1);

        public Builder matchRule(String var1);
    }
}

