/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.entityresolution.model.OutputAttribute;
import software.amazon.awssdk.services.entityresolution.model.OutputSourceOutputListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutputSource> {
    private static final SdkField<String> OUTPUT_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputS3Path").getter(OutputSource.getter(OutputSource::outputS3Path)).setter(OutputSource.setter(Builder::outputS3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputS3Path").build()}).build();
    private static final SdkField<String> KMS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSArn").getter(OutputSource.getter(OutputSource::kmsArn)).setter(OutputSource.setter(Builder::kmsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSArn").build()}).build();
    private static final SdkField<List<OutputAttribute>> OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("output").getter(OutputSource.getter(OutputSource::output)).setter(OutputSource.setter(Builder::output)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("output").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> APPLY_NORMALIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("applyNormalization").getter(OutputSource.getter(OutputSource::applyNormalization)).setter(OutputSource.setter(Builder::applyNormalization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applyNormalization").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_S3_PATH_FIELD, KMS_ARN_FIELD, OUTPUT_FIELD, APPLY_NORMALIZATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OutputSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String outputS3Path;
    private final String kmsArn;
    private final List<OutputAttribute> output;
    private final Boolean applyNormalization;

    private OutputSource(BuilderImpl builder) {
        this.outputS3Path = builder.outputS3Path;
        this.kmsArn = builder.kmsArn;
        this.output = builder.output;
        this.applyNormalization = builder.applyNormalization;
    }

    public final String outputS3Path() {
        return this.outputS3Path;
    }

    public final String kmsArn() {
        return this.kmsArn;
    }

    public final boolean hasOutput() {
        return this.output != null && !(this.output instanceof SdkAutoConstructList);
    }

    public final List<OutputAttribute> output() {
        return this.output;
    }

    public final Boolean applyNormalization() {
        return this.applyNormalization;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3Path());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutput() ? this.output() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.applyNormalization());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputSource)) {
            return false;
        }
        OutputSource other = (OutputSource)obj;
        return Objects.equals(this.outputS3Path(), other.outputS3Path()) && Objects.equals(this.kmsArn(), other.kmsArn()) && this.hasOutput() == other.hasOutput() && Objects.equals(this.output(), other.output()) && Objects.equals(this.applyNormalization(), other.applyNormalization());
    }

    public final String toString() {
        return ToString.builder((String)"OutputSource").add("OutputS3Path", (Object)this.outputS3Path()).add("KMSArn", (Object)this.kmsArn()).add("Output", this.hasOutput() ? this.output() : null).add("ApplyNormalization", (Object)this.applyNormalization()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "outputS3Path": {
                return Optional.ofNullable(clazz.cast(this.outputS3Path()));
            }
            case "KMSArn": {
                return Optional.ofNullable(clazz.cast(this.kmsArn()));
            }
            case "output": {
                return Optional.ofNullable(clazz.cast(this.output()));
            }
            case "applyNormalization": {
                return Optional.ofNullable(clazz.cast(this.applyNormalization()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("outputS3Path", OUTPUT_S3_PATH_FIELD);
        map.put("KMSArn", KMS_ARN_FIELD);
        map.put("output", OUTPUT_FIELD);
        map.put("applyNormalization", APPLY_NORMALIZATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutputSource, T> g) {
        return obj -> g.apply((OutputSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String outputS3Path;
        private String kmsArn;
        private List<OutputAttribute> output = DefaultSdkAutoConstructList.getInstance();
        private Boolean applyNormalization;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputSource model) {
            this.outputS3Path(model.outputS3Path);
            this.kmsArn(model.kmsArn);
            this.output(model.output);
            this.applyNormalization(model.applyNormalization);
        }

        public final String getOutputS3Path() {
            return this.outputS3Path;
        }

        public final void setOutputS3Path(String outputS3Path) {
            this.outputS3Path = outputS3Path;
        }

        @Override
        public final Builder outputS3Path(String outputS3Path) {
            this.outputS3Path = outputS3Path;
            return this;
        }

        public final String getKmsArn() {
            return this.kmsArn;
        }

        public final void setKmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
        }

        @Override
        public final Builder kmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
            return this;
        }

        public final List<OutputAttribute.Builder> getOutput() {
            List<OutputAttribute.Builder> result = OutputSourceOutputListCopier.copyToBuilder(this.output);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutput(Collection<OutputAttribute.BuilderImpl> output) {
            this.output = OutputSourceOutputListCopier.copyFromBuilder(output);
        }

        @Override
        public final Builder output(Collection<OutputAttribute> output) {
            this.output = OutputSourceOutputListCopier.copy(output);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder output(OutputAttribute ... output) {
            this.output(Arrays.asList(output));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder output(Consumer<OutputAttribute.Builder> ... output) {
            this.output(Stream.of(output).map(c -> (OutputAttribute)((OutputAttribute.Builder)OutputAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getApplyNormalization() {
            return this.applyNormalization;
        }

        public final void setApplyNormalization(Boolean applyNormalization) {
            this.applyNormalization = applyNormalization;
        }

        @Override
        public final Builder applyNormalization(Boolean applyNormalization) {
            this.applyNormalization = applyNormalization;
            return this;
        }

        public OutputSource build() {
            return new OutputSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutputSource> {
        public Builder outputS3Path(String var1);

        public Builder kmsArn(String var1);

        public Builder output(Collection<OutputAttribute> var1);

        public Builder output(OutputAttribute ... var1);

        public Builder output(Consumer<OutputAttribute.Builder> ... var1);

        public Builder applyNormalization(Boolean var1);
    }
}

