/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.entityresolution.model.AttributeMatchingModel;
import software.amazon.awssdk.services.entityresolution.model.IdMappingRuleBasedPropertiesRulesListCopier;
import software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowRuleDefinitionType;
import software.amazon.awssdk.services.entityresolution.model.RecordMatchingModel;
import software.amazon.awssdk.services.entityresolution.model.Rule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdMappingRuleBasedProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IdMappingRuleBasedProperties> {
    private static final SdkField<List<Rule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rules").getter(IdMappingRuleBasedProperties.getter(IdMappingRuleBasedProperties::rules)).setter(IdMappingRuleBasedProperties.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Rule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RULE_DEFINITION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleDefinitionType").getter(IdMappingRuleBasedProperties.getter(IdMappingRuleBasedProperties::ruleDefinitionTypeAsString)).setter(IdMappingRuleBasedProperties.setter(Builder::ruleDefinitionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleDefinitionType").build()}).build();
    private static final SdkField<String> ATTRIBUTE_MATCHING_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("attributeMatchingModel").getter(IdMappingRuleBasedProperties.getter(IdMappingRuleBasedProperties::attributeMatchingModelAsString)).setter(IdMappingRuleBasedProperties.setter(Builder::attributeMatchingModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeMatchingModel").build()}).build();
    private static final SdkField<String> RECORD_MATCHING_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recordMatchingModel").getter(IdMappingRuleBasedProperties.getter(IdMappingRuleBasedProperties::recordMatchingModelAsString)).setter(IdMappingRuleBasedProperties.setter(Builder::recordMatchingModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordMatchingModel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULES_FIELD, RULE_DEFINITION_TYPE_FIELD, ATTRIBUTE_MATCHING_MODEL_FIELD, RECORD_MATCHING_MODEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IdMappingRuleBasedProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Rule> rules;
    private final String ruleDefinitionType;
    private final String attributeMatchingModel;
    private final String recordMatchingModel;

    private IdMappingRuleBasedProperties(BuilderImpl builder) {
        this.rules = builder.rules;
        this.ruleDefinitionType = builder.ruleDefinitionType;
        this.attributeMatchingModel = builder.attributeMatchingModel;
        this.recordMatchingModel = builder.recordMatchingModel;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<Rule> rules() {
        return this.rules;
    }

    public final IdMappingWorkflowRuleDefinitionType ruleDefinitionType() {
        return IdMappingWorkflowRuleDefinitionType.fromValue(this.ruleDefinitionType);
    }

    public final String ruleDefinitionTypeAsString() {
        return this.ruleDefinitionType;
    }

    public final AttributeMatchingModel attributeMatchingModel() {
        return AttributeMatchingModel.fromValue(this.attributeMatchingModel);
    }

    public final String attributeMatchingModelAsString() {
        return this.attributeMatchingModel;
    }

    public final RecordMatchingModel recordMatchingModel() {
        return RecordMatchingModel.fromValue(this.recordMatchingModel);
    }

    public final String recordMatchingModelAsString() {
        return this.recordMatchingModel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleDefinitionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeMatchingModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordMatchingModelAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdMappingRuleBasedProperties)) {
            return false;
        }
        IdMappingRuleBasedProperties other = (IdMappingRuleBasedProperties)obj;
        return this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules()) && Objects.equals(this.ruleDefinitionTypeAsString(), other.ruleDefinitionTypeAsString()) && Objects.equals(this.attributeMatchingModelAsString(), other.attributeMatchingModelAsString()) && Objects.equals(this.recordMatchingModelAsString(), other.recordMatchingModelAsString());
    }

    public final String toString() {
        return ToString.builder((String)"IdMappingRuleBasedProperties").add("Rules", this.hasRules() ? this.rules() : null).add("RuleDefinitionType", (Object)this.ruleDefinitionTypeAsString()).add("AttributeMatchingModel", (Object)this.attributeMatchingModelAsString()).add("RecordMatchingModel", (Object)this.recordMatchingModelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "ruleDefinitionType": {
                return Optional.ofNullable(clazz.cast(this.ruleDefinitionTypeAsString()));
            }
            case "attributeMatchingModel": {
                return Optional.ofNullable(clazz.cast(this.attributeMatchingModelAsString()));
            }
            case "recordMatchingModel": {
                return Optional.ofNullable(clazz.cast(this.recordMatchingModelAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rules", RULES_FIELD);
        map.put("ruleDefinitionType", RULE_DEFINITION_TYPE_FIELD);
        map.put("attributeMatchingModel", ATTRIBUTE_MATCHING_MODEL_FIELD);
        map.put("recordMatchingModel", RECORD_MATCHING_MODEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdMappingRuleBasedProperties, T> g) {
        return obj -> g.apply((IdMappingRuleBasedProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Rule> rules = DefaultSdkAutoConstructList.getInstance();
        private String ruleDefinitionType;
        private String attributeMatchingModel;
        private String recordMatchingModel;

        private BuilderImpl() {
        }

        private BuilderImpl(IdMappingRuleBasedProperties model) {
            this.rules(model.rules);
            this.ruleDefinitionType(model.ruleDefinitionType);
            this.attributeMatchingModel(model.attributeMatchingModel);
            this.recordMatchingModel(model.recordMatchingModel);
        }

        public final List<Rule.Builder> getRules() {
            List<Rule.Builder> result = IdMappingRuleBasedPropertiesRulesListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = IdMappingRuleBasedPropertiesRulesListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = IdMappingRuleBasedPropertiesRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<Rule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (Rule)((Rule.Builder)Rule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRuleDefinitionType() {
            return this.ruleDefinitionType;
        }

        public final void setRuleDefinitionType(String ruleDefinitionType) {
            this.ruleDefinitionType = ruleDefinitionType;
        }

        @Override
        public final Builder ruleDefinitionType(String ruleDefinitionType) {
            this.ruleDefinitionType = ruleDefinitionType;
            return this;
        }

        @Override
        public final Builder ruleDefinitionType(IdMappingWorkflowRuleDefinitionType ruleDefinitionType) {
            this.ruleDefinitionType(ruleDefinitionType == null ? null : ruleDefinitionType.toString());
            return this;
        }

        public final String getAttributeMatchingModel() {
            return this.attributeMatchingModel;
        }

        public final void setAttributeMatchingModel(String attributeMatchingModel) {
            this.attributeMatchingModel = attributeMatchingModel;
        }

        @Override
        public final Builder attributeMatchingModel(String attributeMatchingModel) {
            this.attributeMatchingModel = attributeMatchingModel;
            return this;
        }

        @Override
        public final Builder attributeMatchingModel(AttributeMatchingModel attributeMatchingModel) {
            this.attributeMatchingModel(attributeMatchingModel == null ? null : attributeMatchingModel.toString());
            return this;
        }

        public final String getRecordMatchingModel() {
            return this.recordMatchingModel;
        }

        public final void setRecordMatchingModel(String recordMatchingModel) {
            this.recordMatchingModel = recordMatchingModel;
        }

        @Override
        public final Builder recordMatchingModel(String recordMatchingModel) {
            this.recordMatchingModel = recordMatchingModel;
            return this;
        }

        @Override
        public final Builder recordMatchingModel(RecordMatchingModel recordMatchingModel) {
            this.recordMatchingModel(recordMatchingModel == null ? null : recordMatchingModel.toString());
            return this;
        }

        public IdMappingRuleBasedProperties build() {
            return new IdMappingRuleBasedProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IdMappingRuleBasedProperties> {
        public Builder rules(Collection<Rule> var1);

        public Builder rules(Rule ... var1);

        public Builder rules(Consumer<Rule.Builder> ... var1);

        public Builder ruleDefinitionType(String var1);

        public Builder ruleDefinitionType(IdMappingWorkflowRuleDefinitionType var1);

        public Builder attributeMatchingModel(String var1);

        public Builder attributeMatchingModel(AttributeMatchingModel var1);

        public Builder recordMatchingModel(String var1);

        public Builder recordMatchingModel(RecordMatchingModel var1);
    }
}

