/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.entityresolution.model.EntityResolutionRequest;
import software.amazon.awssdk.services.entityresolution.model.IdNamespaceIdMappingWorkflowProperties;
import software.amazon.awssdk.services.entityresolution.model.IdNamespaceIdMappingWorkflowPropertiesListCopier;
import software.amazon.awssdk.services.entityresolution.model.IdNamespaceInputSource;
import software.amazon.awssdk.services.entityresolution.model.IdNamespaceInputSourceConfigCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateIdNamespaceRequest
extends EntityResolutionRequest
implements ToCopyableBuilder<Builder, UpdateIdNamespaceRequest> {
    private static final SdkField<String> ID_NAMESPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("idNamespaceName").getter(UpdateIdNamespaceRequest.getter(UpdateIdNamespaceRequest::idNamespaceName)).setter(UpdateIdNamespaceRequest.setter(Builder::idNamespaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("idNamespaceName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateIdNamespaceRequest.getter(UpdateIdNamespaceRequest::description)).setter(UpdateIdNamespaceRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<IdNamespaceInputSource>> INPUT_SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputSourceConfig").getter(UpdateIdNamespaceRequest.getter(UpdateIdNamespaceRequest::inputSourceConfig)).setter(UpdateIdNamespaceRequest.setter(Builder::inputSourceConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSourceConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IdNamespaceInputSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<IdNamespaceIdMappingWorkflowProperties>> ID_MAPPING_WORKFLOW_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("idMappingWorkflowProperties").getter(UpdateIdNamespaceRequest.getter(UpdateIdNamespaceRequest::idMappingWorkflowProperties)).setter(UpdateIdNamespaceRequest.setter(Builder::idMappingWorkflowProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idMappingWorkflowProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IdNamespaceIdMappingWorkflowProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(UpdateIdNamespaceRequest.getter(UpdateIdNamespaceRequest::roleArn)).setter(UpdateIdNamespaceRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_NAMESPACE_NAME_FIELD, DESCRIPTION_FIELD, INPUT_SOURCE_CONFIG_FIELD, ID_MAPPING_WORKFLOW_PROPERTIES_FIELD, ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateIdNamespaceRequest.memberNameToFieldInitializer();
    private final String idNamespaceName;
    private final String description;
    private final List<IdNamespaceInputSource> inputSourceConfig;
    private final List<IdNamespaceIdMappingWorkflowProperties> idMappingWorkflowProperties;
    private final String roleArn;

    private UpdateIdNamespaceRequest(BuilderImpl builder) {
        super(builder);
        this.idNamespaceName = builder.idNamespaceName;
        this.description = builder.description;
        this.inputSourceConfig = builder.inputSourceConfig;
        this.idMappingWorkflowProperties = builder.idMappingWorkflowProperties;
        this.roleArn = builder.roleArn;
    }

    public final String idNamespaceName() {
        return this.idNamespaceName;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasInputSourceConfig() {
        return this.inputSourceConfig != null && !(this.inputSourceConfig instanceof SdkAutoConstructList);
    }

    public final List<IdNamespaceInputSource> inputSourceConfig() {
        return this.inputSourceConfig;
    }

    public final boolean hasIdMappingWorkflowProperties() {
        return this.idMappingWorkflowProperties != null && !(this.idMappingWorkflowProperties instanceof SdkAutoConstructList);
    }

    public final List<IdNamespaceIdMappingWorkflowProperties> idMappingWorkflowProperties() {
        return this.idMappingWorkflowProperties;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.idNamespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputSourceConfig() ? this.inputSourceConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdMappingWorkflowProperties() ? this.idMappingWorkflowProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIdNamespaceRequest)) {
            return false;
        }
        UpdateIdNamespaceRequest other = (UpdateIdNamespaceRequest)((Object)obj);
        return Objects.equals(this.idNamespaceName(), other.idNamespaceName()) && Objects.equals(this.description(), other.description()) && this.hasInputSourceConfig() == other.hasInputSourceConfig() && Objects.equals(this.inputSourceConfig(), other.inputSourceConfig()) && this.hasIdMappingWorkflowProperties() == other.hasIdMappingWorkflowProperties() && Objects.equals(this.idMappingWorkflowProperties(), other.idMappingWorkflowProperties()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateIdNamespaceRequest").add("IdNamespaceName", (Object)this.idNamespaceName()).add("Description", (Object)this.description()).add("InputSourceConfig", this.hasInputSourceConfig() ? this.inputSourceConfig() : null).add("IdMappingWorkflowProperties", this.hasIdMappingWorkflowProperties() ? this.idMappingWorkflowProperties() : null).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "idNamespaceName": {
                return Optional.ofNullable(clazz.cast(this.idNamespaceName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "inputSourceConfig": {
                return Optional.ofNullable(clazz.cast(this.inputSourceConfig()));
            }
            case "idMappingWorkflowProperties": {
                return Optional.ofNullable(clazz.cast(this.idMappingWorkflowProperties()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("idNamespaceName", ID_NAMESPACE_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("inputSourceConfig", INPUT_SOURCE_CONFIG_FIELD);
        map.put("idMappingWorkflowProperties", ID_MAPPING_WORKFLOW_PROPERTIES_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateIdNamespaceRequest, T> g) {
        return obj -> g.apply((UpdateIdNamespaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EntityResolutionRequest.BuilderImpl
    implements Builder {
        private String idNamespaceName;
        private String description;
        private List<IdNamespaceInputSource> inputSourceConfig = DefaultSdkAutoConstructList.getInstance();
        private List<IdNamespaceIdMappingWorkflowProperties> idMappingWorkflowProperties = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIdNamespaceRequest model) {
            super(model);
            this.idNamespaceName(model.idNamespaceName);
            this.description(model.description);
            this.inputSourceConfig(model.inputSourceConfig);
            this.idMappingWorkflowProperties(model.idMappingWorkflowProperties);
            this.roleArn(model.roleArn);
        }

        public final String getIdNamespaceName() {
            return this.idNamespaceName;
        }

        public final void setIdNamespaceName(String idNamespaceName) {
            this.idNamespaceName = idNamespaceName;
        }

        @Override
        public final Builder idNamespaceName(String idNamespaceName) {
            this.idNamespaceName = idNamespaceName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<IdNamespaceInputSource.Builder> getInputSourceConfig() {
            List<IdNamespaceInputSource.Builder> result = IdNamespaceInputSourceConfigCopier.copyToBuilder(this.inputSourceConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputSourceConfig(Collection<IdNamespaceInputSource.BuilderImpl> inputSourceConfig) {
            this.inputSourceConfig = IdNamespaceInputSourceConfigCopier.copyFromBuilder(inputSourceConfig);
        }

        @Override
        public final Builder inputSourceConfig(Collection<IdNamespaceInputSource> inputSourceConfig) {
            this.inputSourceConfig = IdNamespaceInputSourceConfigCopier.copy(inputSourceConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSourceConfig(IdNamespaceInputSource ... inputSourceConfig) {
            this.inputSourceConfig(Arrays.asList(inputSourceConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSourceConfig(Consumer<IdNamespaceInputSource.Builder> ... inputSourceConfig) {
            this.inputSourceConfig(Stream.of(inputSourceConfig).map(c -> (IdNamespaceInputSource)((IdNamespaceInputSource.Builder)IdNamespaceInputSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<IdNamespaceIdMappingWorkflowProperties.Builder> getIdMappingWorkflowProperties() {
            List<IdNamespaceIdMappingWorkflowProperties.Builder> result = IdNamespaceIdMappingWorkflowPropertiesListCopier.copyToBuilder(this.idMappingWorkflowProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdMappingWorkflowProperties(Collection<IdNamespaceIdMappingWorkflowProperties.BuilderImpl> idMappingWorkflowProperties) {
            this.idMappingWorkflowProperties = IdNamespaceIdMappingWorkflowPropertiesListCopier.copyFromBuilder(idMappingWorkflowProperties);
        }

        @Override
        public final Builder idMappingWorkflowProperties(Collection<IdNamespaceIdMappingWorkflowProperties> idMappingWorkflowProperties) {
            this.idMappingWorkflowProperties = IdNamespaceIdMappingWorkflowPropertiesListCopier.copy(idMappingWorkflowProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder idMappingWorkflowProperties(IdNamespaceIdMappingWorkflowProperties ... idMappingWorkflowProperties) {
            this.idMappingWorkflowProperties(Arrays.asList(idMappingWorkflowProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder idMappingWorkflowProperties(Consumer<IdNamespaceIdMappingWorkflowProperties.Builder> ... idMappingWorkflowProperties) {
            this.idMappingWorkflowProperties(Stream.of(idMappingWorkflowProperties).map(c -> (IdNamespaceIdMappingWorkflowProperties)((IdNamespaceIdMappingWorkflowProperties.Builder)IdNamespaceIdMappingWorkflowProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateIdNamespaceRequest build() {
            return new UpdateIdNamespaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EntityResolutionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateIdNamespaceRequest> {
        public Builder idNamespaceName(String var1);

        public Builder description(String var1);

        public Builder inputSourceConfig(Collection<IdNamespaceInputSource> var1);

        public Builder inputSourceConfig(IdNamespaceInputSource ... var1);

        public Builder inputSourceConfig(Consumer<IdNamespaceInputSource.Builder> ... var1);

        public Builder idMappingWorkflowProperties(Collection<IdNamespaceIdMappingWorkflowProperties> var1);

        public Builder idMappingWorkflowProperties(IdNamespaceIdMappingWorkflowProperties ... var1);

        public Builder idMappingWorkflowProperties(Consumer<IdNamespaceIdMappingWorkflowProperties.Builder> ... var1);

        public Builder roleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

