/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.entityresolution.model.EntityResolutionResponse;
import software.amazon.awssdk.services.entityresolution.model.SchemaInputAttribute;
import software.amazon.awssdk.services.entityresolution.model.SchemaInputAttributesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSchemaMappingResponse
extends EntityResolutionResponse
implements ToCopyableBuilder<Builder, UpdateSchemaMappingResponse> {
    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("schemaName").getter(UpdateSchemaMappingResponse.getter(UpdateSchemaMappingResponse::schemaName)).setter(UpdateSchemaMappingResponse.setter(Builder::schemaName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaName").build()}).build();
    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("schemaArn").getter(UpdateSchemaMappingResponse.getter(UpdateSchemaMappingResponse::schemaArn)).setter(UpdateSchemaMappingResponse.setter(Builder::schemaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateSchemaMappingResponse.getter(UpdateSchemaMappingResponse::description)).setter(UpdateSchemaMappingResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<SchemaInputAttribute>> MAPPED_INPUT_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("mappedInputFields").getter(UpdateSchemaMappingResponse.getter(UpdateSchemaMappingResponse::mappedInputFields)).setter(UpdateSchemaMappingResponse.setter(Builder::mappedInputFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mappedInputFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SchemaInputAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_NAME_FIELD, SCHEMA_ARN_FIELD, DESCRIPTION_FIELD, MAPPED_INPUT_FIELDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateSchemaMappingResponse.memberNameToFieldInitializer();
    private final String schemaName;
    private final String schemaArn;
    private final String description;
    private final List<SchemaInputAttribute> mappedInputFields;

    private UpdateSchemaMappingResponse(BuilderImpl builder) {
        super(builder);
        this.schemaName = builder.schemaName;
        this.schemaArn = builder.schemaArn;
        this.description = builder.description;
        this.mappedInputFields = builder.mappedInputFields;
    }

    public final String schemaName() {
        return this.schemaName;
    }

    public final String schemaArn() {
        return this.schemaArn;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasMappedInputFields() {
        return this.mappedInputFields != null && !(this.mappedInputFields instanceof SdkAutoConstructList);
    }

    public final List<SchemaInputAttribute> mappedInputFields() {
        return this.mappedInputFields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaName());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMappedInputFields() ? this.mappedInputFields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSchemaMappingResponse)) {
            return false;
        }
        UpdateSchemaMappingResponse other = (UpdateSchemaMappingResponse)((Object)obj);
        return Objects.equals(this.schemaName(), other.schemaName()) && Objects.equals(this.schemaArn(), other.schemaArn()) && Objects.equals(this.description(), other.description()) && this.hasMappedInputFields() == other.hasMappedInputFields() && Objects.equals(this.mappedInputFields(), other.mappedInputFields());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSchemaMappingResponse").add("SchemaName", (Object)this.schemaName()).add("SchemaArn", (Object)this.schemaArn()).add("Description", (Object)this.description()).add("MappedInputFields", this.hasMappedInputFields() ? this.mappedInputFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "schemaName": {
                return Optional.ofNullable(clazz.cast(this.schemaName()));
            }
            case "schemaArn": {
                return Optional.ofNullable(clazz.cast(this.schemaArn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "mappedInputFields": {
                return Optional.ofNullable(clazz.cast(this.mappedInputFields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("schemaName", SCHEMA_NAME_FIELD);
        map.put("schemaArn", SCHEMA_ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("mappedInputFields", MAPPED_INPUT_FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSchemaMappingResponse, T> g) {
        return obj -> g.apply((UpdateSchemaMappingResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EntityResolutionResponse.BuilderImpl
    implements Builder {
        private String schemaName;
        private String schemaArn;
        private String description;
        private List<SchemaInputAttribute> mappedInputFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSchemaMappingResponse model) {
            super(model);
            this.schemaName(model.schemaName);
            this.schemaArn(model.schemaArn);
            this.description(model.description);
            this.mappedInputFields(model.mappedInputFields);
        }

        public final String getSchemaName() {
            return this.schemaName;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public final String getSchemaArn() {
            return this.schemaArn;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<SchemaInputAttribute.Builder> getMappedInputFields() {
            List<SchemaInputAttribute.Builder> result = SchemaInputAttributesCopier.copyToBuilder(this.mappedInputFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMappedInputFields(Collection<SchemaInputAttribute.BuilderImpl> mappedInputFields) {
            this.mappedInputFields = SchemaInputAttributesCopier.copyFromBuilder(mappedInputFields);
        }

        @Override
        public final Builder mappedInputFields(Collection<SchemaInputAttribute> mappedInputFields) {
            this.mappedInputFields = SchemaInputAttributesCopier.copy(mappedInputFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappedInputFields(SchemaInputAttribute ... mappedInputFields) {
            this.mappedInputFields(Arrays.asList(mappedInputFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappedInputFields(Consumer<SchemaInputAttribute.Builder> ... mappedInputFields) {
            this.mappedInputFields(Stream.of(mappedInputFields).map(c -> (SchemaInputAttribute)((SchemaInputAttribute.Builder)SchemaInputAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public UpdateSchemaMappingResponse build() {
            return new UpdateSchemaMappingResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EntityResolutionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSchemaMappingResponse> {
        public Builder schemaName(String var1);

        public Builder schemaArn(String var1);

        public Builder description(String var1);

        public Builder mappedInputFields(Collection<SchemaInputAttribute> var1);

        public Builder mappedInputFields(SchemaInputAttribute ... var1);

        public Builder mappedInputFields(Consumer<SchemaInputAttribute.Builder> ... var1);
    }
}

