/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.entityresolution.model.ServiceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProviderServiceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProviderServiceSummary> {
    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerName").getter(ProviderServiceSummary.getter(ProviderServiceSummary::providerName)).setter(ProviderServiceSummary.setter(Builder::providerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerName").build()}).build();
    private static final SdkField<String> PROVIDER_SERVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerServiceArn").getter(ProviderServiceSummary.getter(ProviderServiceSummary::providerServiceArn)).setter(ProviderServiceSummary.setter(Builder::providerServiceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerServiceArn").build()}).build();
    private static final SdkField<String> PROVIDER_SERVICE_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerServiceDisplayName").getter(ProviderServiceSummary.getter(ProviderServiceSummary::providerServiceDisplayName)).setter(ProviderServiceSummary.setter(Builder::providerServiceDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerServiceDisplayName").build()}).build();
    private static final SdkField<String> PROVIDER_SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerServiceName").getter(ProviderServiceSummary.getter(ProviderServiceSummary::providerServiceName)).setter(ProviderServiceSummary.setter(Builder::providerServiceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerServiceName").build()}).build();
    private static final SdkField<String> PROVIDER_SERVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerServiceType").getter(ProviderServiceSummary.getter(ProviderServiceSummary::providerServiceTypeAsString)).setter(ProviderServiceSummary.setter(Builder::providerServiceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerServiceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_NAME_FIELD, PROVIDER_SERVICE_ARN_FIELD, PROVIDER_SERVICE_DISPLAY_NAME_FIELD, PROVIDER_SERVICE_NAME_FIELD, PROVIDER_SERVICE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String providerName;
    private final String providerServiceArn;
    private final String providerServiceDisplayName;
    private final String providerServiceName;
    private final String providerServiceType;

    private ProviderServiceSummary(BuilderImpl builder) {
        this.providerName = builder.providerName;
        this.providerServiceArn = builder.providerServiceArn;
        this.providerServiceDisplayName = builder.providerServiceDisplayName;
        this.providerServiceName = builder.providerServiceName;
        this.providerServiceType = builder.providerServiceType;
    }

    public final String providerName() {
        return this.providerName;
    }

    public final String providerServiceArn() {
        return this.providerServiceArn;
    }

    public final String providerServiceDisplayName() {
        return this.providerServiceDisplayName;
    }

    public final String providerServiceName() {
        return this.providerServiceName;
    }

    public final ServiceType providerServiceType() {
        return ServiceType.fromValue(this.providerServiceType);
    }

    public final String providerServiceTypeAsString() {
        return this.providerServiceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.providerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerServiceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerServiceDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerServiceTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProviderServiceSummary)) {
            return false;
        }
        ProviderServiceSummary other = (ProviderServiceSummary)obj;
        return Objects.equals(this.providerName(), other.providerName()) && Objects.equals(this.providerServiceArn(), other.providerServiceArn()) && Objects.equals(this.providerServiceDisplayName(), other.providerServiceDisplayName()) && Objects.equals(this.providerServiceName(), other.providerServiceName()) && Objects.equals(this.providerServiceTypeAsString(), other.providerServiceTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ProviderServiceSummary").add("ProviderName", (Object)this.providerName()).add("ProviderServiceArn", (Object)this.providerServiceArn()).add("ProviderServiceDisplayName", (Object)this.providerServiceDisplayName()).add("ProviderServiceName", (Object)this.providerServiceName()).add("ProviderServiceType", (Object)this.providerServiceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "providerName": {
                return Optional.ofNullable(clazz.cast(this.providerName()));
            }
            case "providerServiceArn": {
                return Optional.ofNullable(clazz.cast(this.providerServiceArn()));
            }
            case "providerServiceDisplayName": {
                return Optional.ofNullable(clazz.cast(this.providerServiceDisplayName()));
            }
            case "providerServiceName": {
                return Optional.ofNullable(clazz.cast(this.providerServiceName()));
            }
            case "providerServiceType": {
                return Optional.ofNullable(clazz.cast(this.providerServiceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProviderServiceSummary, T> g) {
        return obj -> g.apply((ProviderServiceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String providerName;
        private String providerServiceArn;
        private String providerServiceDisplayName;
        private String providerServiceName;
        private String providerServiceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ProviderServiceSummary model) {
            this.providerName(model.providerName);
            this.providerServiceArn(model.providerServiceArn);
            this.providerServiceDisplayName(model.providerServiceDisplayName);
            this.providerServiceName(model.providerServiceName);
            this.providerServiceType(model.providerServiceType);
        }

        public final String getProviderName() {
            return this.providerName;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final String getProviderServiceArn() {
            return this.providerServiceArn;
        }

        public final void setProviderServiceArn(String providerServiceArn) {
            this.providerServiceArn = providerServiceArn;
        }

        @Override
        public final Builder providerServiceArn(String providerServiceArn) {
            this.providerServiceArn = providerServiceArn;
            return this;
        }

        public final String getProviderServiceDisplayName() {
            return this.providerServiceDisplayName;
        }

        public final void setProviderServiceDisplayName(String providerServiceDisplayName) {
            this.providerServiceDisplayName = providerServiceDisplayName;
        }

        @Override
        public final Builder providerServiceDisplayName(String providerServiceDisplayName) {
            this.providerServiceDisplayName = providerServiceDisplayName;
            return this;
        }

        public final String getProviderServiceName() {
            return this.providerServiceName;
        }

        public final void setProviderServiceName(String providerServiceName) {
            this.providerServiceName = providerServiceName;
        }

        @Override
        public final Builder providerServiceName(String providerServiceName) {
            this.providerServiceName = providerServiceName;
            return this;
        }

        public final String getProviderServiceType() {
            return this.providerServiceType;
        }

        public final void setProviderServiceType(String providerServiceType) {
            this.providerServiceType = providerServiceType;
        }

        @Override
        public final Builder providerServiceType(String providerServiceType) {
            this.providerServiceType = providerServiceType;
            return this;
        }

        @Override
        public final Builder providerServiceType(ServiceType providerServiceType) {
            this.providerServiceType(providerServiceType == null ? null : providerServiceType.toString());
            return this;
        }

        public ProviderServiceSummary build() {
            return new ProviderServiceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProviderServiceSummary> {
        public Builder providerName(String var1);

        public Builder providerServiceArn(String var1);

        public Builder providerServiceDisplayName(String var1);

        public Builder providerServiceName(String var1);

        public Builder providerServiceType(String var1);

        public Builder providerServiceType(ServiceType var1);
    }
}

