/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.entityresolution.model.SchemaAttributeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SchemaInputAttribute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SchemaInputAttribute> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fieldName").getter(SchemaInputAttribute.getter(SchemaInputAttribute::fieldName)).setter(SchemaInputAttribute.setter(Builder::fieldName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldName").build()}).build();
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupName").getter(SchemaInputAttribute.getter(SchemaInputAttribute::groupName)).setter(SchemaInputAttribute.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupName").build()}).build();
    private static final SdkField<String> MATCH_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("matchKey").getter(SchemaInputAttribute.getter(SchemaInputAttribute::matchKey)).setter(SchemaInputAttribute.setter(Builder::matchKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchKey").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(SchemaInputAttribute.getter(SchemaInputAttribute::typeAsString)).setter(SchemaInputAttribute.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAME_FIELD, GROUP_NAME_FIELD, MATCH_KEY_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fieldName;
    private final String groupName;
    private final String matchKey;
    private final String type;

    private SchemaInputAttribute(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.groupName = builder.groupName;
        this.matchKey = builder.matchKey;
        this.type = builder.type;
    }

    public final String fieldName() {
        return this.fieldName;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final String matchKey() {
        return this.matchKey;
    }

    public final SchemaAttributeType type() {
        return SchemaAttributeType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaInputAttribute)) {
            return false;
        }
        SchemaInputAttribute other = (SchemaInputAttribute)obj;
        return Objects.equals(this.fieldName(), other.fieldName()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.matchKey(), other.matchKey()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SchemaInputAttribute").add("FieldName", (Object)this.fieldName()).add("GroupName", (Object)this.groupName()).add("MatchKey", (Object)this.matchKey()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fieldName": {
                return Optional.ofNullable(clazz.cast(this.fieldName()));
            }
            case "groupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "matchKey": {
                return Optional.ofNullable(clazz.cast(this.matchKey()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SchemaInputAttribute, T> g) {
        return obj -> g.apply((SchemaInputAttribute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldName;
        private String groupName;
        private String matchKey;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaInputAttribute model) {
            this.fieldName(model.fieldName);
            this.groupName(model.groupName);
            this.matchKey(model.matchKey);
            this.type(model.type);
        }

        public final String getFieldName() {
            return this.fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getMatchKey() {
            return this.matchKey;
        }

        public final void setMatchKey(String matchKey) {
            this.matchKey = matchKey;
        }

        @Override
        public final Builder matchKey(String matchKey) {
            this.matchKey = matchKey;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SchemaAttributeType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public SchemaInputAttribute build() {
            return new SchemaInputAttribute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SchemaInputAttribute> {
        public Builder fieldName(String var1);

        public Builder groupName(String var1);

        public Builder matchKey(String var1);

        public Builder type(String var1);

        public Builder type(SchemaAttributeType var1);
    }
}

