/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emrserverless.model.Configuration;
import software.amazon.awssdk.services.emrserverless.model.ConfigurationListCopier;
import software.amazon.awssdk.services.emrserverless.model.MonitoringConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationOverrides
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationOverrides> {
    private static final SdkField<List<Configuration>> APPLICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("applicationConfiguration").getter(ConfigurationOverrides.getter(ConfigurationOverrides::applicationConfiguration)).setter(ConfigurationOverrides.setter(Builder::applicationConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationConfiguration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Configuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MonitoringConfiguration> MONITORING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("monitoringConfiguration").getter(ConfigurationOverrides.getter(ConfigurationOverrides::monitoringConfiguration)).setter(ConfigurationOverrides.setter(Builder::monitoringConfiguration)).constructor(MonitoringConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitoringConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_CONFIGURATION_FIELD, MONITORING_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfigurationOverrides.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Configuration> applicationConfiguration;
    private final MonitoringConfiguration monitoringConfiguration;

    private ConfigurationOverrides(BuilderImpl builder) {
        this.applicationConfiguration = builder.applicationConfiguration;
        this.monitoringConfiguration = builder.monitoringConfiguration;
    }

    public final boolean hasApplicationConfiguration() {
        return this.applicationConfiguration != null && !(this.applicationConfiguration instanceof SdkAutoConstructList);
    }

    public final List<Configuration> applicationConfiguration() {
        return this.applicationConfiguration;
    }

    public final MonitoringConfiguration monitoringConfiguration() {
        return this.monitoringConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationConfiguration() ? this.applicationConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationOverrides)) {
            return false;
        }
        ConfigurationOverrides other = (ConfigurationOverrides)obj;
        return this.hasApplicationConfiguration() == other.hasApplicationConfiguration() && Objects.equals(this.applicationConfiguration(), other.applicationConfiguration()) && Objects.equals(this.monitoringConfiguration(), other.monitoringConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigurationOverrides").add("ApplicationConfiguration", this.hasApplicationConfiguration() ? this.applicationConfiguration() : null).add("MonitoringConfiguration", (Object)this.monitoringConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.applicationConfiguration()));
            }
            case "monitoringConfiguration": {
                return Optional.ofNullable(clazz.cast(this.monitoringConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applicationConfiguration", APPLICATION_CONFIGURATION_FIELD);
        map.put("monitoringConfiguration", MONITORING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationOverrides, T> g) {
        return obj -> g.apply((ConfigurationOverrides)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Configuration> applicationConfiguration = DefaultSdkAutoConstructList.getInstance();
        private MonitoringConfiguration monitoringConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationOverrides model) {
            this.applicationConfiguration(model.applicationConfiguration);
            this.monitoringConfiguration(model.monitoringConfiguration);
        }

        public final List<Configuration.Builder> getApplicationConfiguration() {
            List<Configuration.Builder> result = ConfigurationListCopier.copyToBuilder(this.applicationConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicationConfiguration(Collection<Configuration.BuilderImpl> applicationConfiguration) {
            this.applicationConfiguration = ConfigurationListCopier.copyFromBuilder(applicationConfiguration);
        }

        @Override
        public final Builder applicationConfiguration(Collection<Configuration> applicationConfiguration) {
            this.applicationConfiguration = ConfigurationListCopier.copy(applicationConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationConfiguration(Configuration ... applicationConfiguration) {
            this.applicationConfiguration(Arrays.asList(applicationConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationConfiguration(Consumer<Configuration.Builder> ... applicationConfiguration) {
            this.applicationConfiguration(Stream.of(applicationConfiguration).map(c -> (Configuration)((Configuration.Builder)Configuration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final MonitoringConfiguration.Builder getMonitoringConfiguration() {
            return this.monitoringConfiguration != null ? this.monitoringConfiguration.toBuilder() : null;
        }

        public final void setMonitoringConfiguration(MonitoringConfiguration.BuilderImpl monitoringConfiguration) {
            this.monitoringConfiguration = monitoringConfiguration != null ? monitoringConfiguration.build() : null;
        }

        @Override
        public final Builder monitoringConfiguration(MonitoringConfiguration monitoringConfiguration) {
            this.monitoringConfiguration = monitoringConfiguration;
            return this;
        }

        public ConfigurationOverrides build() {
            return new ConfigurationOverrides(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationOverrides> {
        public Builder applicationConfiguration(Collection<Configuration> var1);

        public Builder applicationConfiguration(Configuration ... var1);

        public Builder applicationConfiguration(Consumer<Configuration.Builder> ... var1);

        public Builder monitoringConfiguration(MonitoringConfiguration var1);

        default public Builder monitoringConfiguration(Consumer<MonitoringConfiguration.Builder> monitoringConfiguration) {
            return this.monitoringConfiguration((MonitoringConfiguration)((MonitoringConfiguration.Builder)MonitoringConfiguration.builder().applyMutation(monitoringConfiguration)).build());
        }
    }
}

