/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for an application to automatically stop after a certain amount of time being idle.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoStopConfig implements SdkPojo, Serializable, ToCopyableBuilder<AutoStopConfig.Builder, AutoStopConfig> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(AutoStopConfig::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<Integer> IDLE_TIMEOUT_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("idleTimeoutMinutes").getter(getter(AutoStopConfig::idleTimeoutMinutes))
            .setter(setter(Builder::idleTimeoutMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleTimeoutMinutes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            IDLE_TIMEOUT_MINUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final Integer idleTimeoutMinutes;

    private AutoStopConfig(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.idleTimeoutMinutes = builder.idleTimeoutMinutes;
    }

    /**
     * <p>
     * Enables the application to automatically stop after a certain amount of time being idle. Defaults to true.
     * </p>
     * 
     * @return Enables the application to automatically stop after a certain amount of time being idle. Defaults to
     *         true.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The amount of idle time in minutes after which your application will automatically stop. Defaults to 15 minutes.
     * </p>
     * 
     * @return The amount of idle time in minutes after which your application will automatically stop. Defaults to 15
     *         minutes.
     */
    public final Integer idleTimeoutMinutes() {
        return idleTimeoutMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(idleTimeoutMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoStopConfig)) {
            return false;
        }
        AutoStopConfig other = (AutoStopConfig) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(idleTimeoutMinutes(), other.idleTimeoutMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoStopConfig").add("Enabled", enabled()).add("IdleTimeoutMinutes", idleTimeoutMinutes())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "idleTimeoutMinutes":
            return Optional.ofNullable(clazz.cast(idleTimeoutMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enabled", ENABLED_FIELD);
        map.put("idleTimeoutMinutes", IDLE_TIMEOUT_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoStopConfig, T> g) {
        return obj -> g.apply((AutoStopConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoStopConfig> {
        /**
         * <p>
         * Enables the application to automatically stop after a certain amount of time being idle. Defaults to true.
         * </p>
         * 
         * @param enabled
         *        Enables the application to automatically stop after a certain amount of time being idle. Defaults to
         *        true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The amount of idle time in minutes after which your application will automatically stop. Defaults to 15
         * minutes.
         * </p>
         * 
         * @param idleTimeoutMinutes
         *        The amount of idle time in minutes after which your application will automatically stop. Defaults to
         *        15 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleTimeoutMinutes(Integer idleTimeoutMinutes);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private Integer idleTimeoutMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoStopConfig model) {
            enabled(model.enabled);
            idleTimeoutMinutes(model.idleTimeoutMinutes);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Integer getIdleTimeoutMinutes() {
            return idleTimeoutMinutes;
        }

        public final void setIdleTimeoutMinutes(Integer idleTimeoutMinutes) {
            this.idleTimeoutMinutes = idleTimeoutMinutes;
        }

        @Override
        public final Builder idleTimeoutMinutes(Integer idleTimeoutMinutes) {
            this.idleTimeoutMinutes = idleTimeoutMinutes;
            return this;
        }

        @Override
        public AutoStopConfig build() {
            return new AutoStopConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
