/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.emrserverless.model.Architecture;
import software.amazon.awssdk.services.emrserverless.model.AutoStartConfig;
import software.amazon.awssdk.services.emrserverless.model.AutoStopConfig;
import software.amazon.awssdk.services.emrserverless.model.Configuration;
import software.amazon.awssdk.services.emrserverless.model.ConfigurationListCopier;
import software.amazon.awssdk.services.emrserverless.model.EmrServerlessRequest;
import software.amazon.awssdk.services.emrserverless.model.ImageConfigurationInput;
import software.amazon.awssdk.services.emrserverless.model.InitialCapacityConfig;
import software.amazon.awssdk.services.emrserverless.model.InitialCapacityConfigMapCopier;
import software.amazon.awssdk.services.emrserverless.model.InteractiveConfiguration;
import software.amazon.awssdk.services.emrserverless.model.MaximumAllowedResources;
import software.amazon.awssdk.services.emrserverless.model.MonitoringConfiguration;
import software.amazon.awssdk.services.emrserverless.model.NetworkConfiguration;
import software.amazon.awssdk.services.emrserverless.model.SchedulerConfiguration;
import software.amazon.awssdk.services.emrserverless.model.TagMapCopier;
import software.amazon.awssdk.services.emrserverless.model.WorkerTypeSpecificationInput;
import software.amazon.awssdk.services.emrserverless.model.WorkerTypeSpecificationInputMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApplicationRequest
extends EmrServerlessRequest
implements ToCopyableBuilder<Builder, CreateApplicationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateApplicationRequest.getter(CreateApplicationRequest::name)).setter(CreateApplicationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> RELEASE_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("releaseLabel").getter(CreateApplicationRequest.getter(CreateApplicationRequest::releaseLabel)).setter(CreateApplicationRequest.setter(Builder::releaseLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseLabel").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(CreateApplicationRequest.getter(CreateApplicationRequest::type)).setter(CreateApplicationRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateApplicationRequest.getter(CreateApplicationRequest::clientToken)).setter(CreateApplicationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, InitialCapacityConfig>> INITIAL_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("initialCapacity").getter(CreateApplicationRequest.getter(CreateApplicationRequest::initialCapacity)).setter(CreateApplicationRequest.setter(Builder::initialCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialCapacity").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InitialCapacityConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<MaximumAllowedResources> MAXIMUM_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("maximumCapacity").getter(CreateApplicationRequest.getter(CreateApplicationRequest::maximumCapacity)).setter(CreateApplicationRequest.setter(Builder::maximumCapacity)).constructor(MaximumAllowedResources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumCapacity").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateApplicationRequest.getter(CreateApplicationRequest::tags)).setter(CreateApplicationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<AutoStartConfig> AUTO_START_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("autoStartConfiguration").getter(CreateApplicationRequest.getter(CreateApplicationRequest::autoStartConfiguration)).setter(CreateApplicationRequest.setter(Builder::autoStartConfiguration)).constructor(AutoStartConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoStartConfiguration").build()}).build();
    private static final SdkField<AutoStopConfig> AUTO_STOP_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("autoStopConfiguration").getter(CreateApplicationRequest.getter(CreateApplicationRequest::autoStopConfiguration)).setter(CreateApplicationRequest.setter(Builder::autoStopConfiguration)).constructor(AutoStopConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoStopConfiguration").build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkConfiguration").getter(CreateApplicationRequest.getter(CreateApplicationRequest::networkConfiguration)).setter(CreateApplicationRequest.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build()}).build();
    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("architecture").getter(CreateApplicationRequest.getter(CreateApplicationRequest::architectureAsString)).setter(CreateApplicationRequest.setter(Builder::architecture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architecture").build()}).build();
    private static final SdkField<ImageConfigurationInput> IMAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("imageConfiguration").getter(CreateApplicationRequest.getter(CreateApplicationRequest::imageConfiguration)).setter(CreateApplicationRequest.setter(Builder::imageConfiguration)).constructor(ImageConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageConfiguration").build()}).build();
    private static final SdkField<Map<String, WorkerTypeSpecificationInput>> WORKER_TYPE_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("workerTypeSpecifications").getter(CreateApplicationRequest.getter(CreateApplicationRequest::workerTypeSpecifications)).setter(CreateApplicationRequest.setter(Builder::workerTypeSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerTypeSpecifications").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkerTypeSpecificationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<Configuration>> RUNTIME_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("runtimeConfiguration").getter(CreateApplicationRequest.getter(CreateApplicationRequest::runtimeConfiguration)).setter(CreateApplicationRequest.setter(Builder::runtimeConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeConfiguration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Configuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MonitoringConfiguration> MONITORING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("monitoringConfiguration").getter(CreateApplicationRequest.getter(CreateApplicationRequest::monitoringConfiguration)).setter(CreateApplicationRequest.setter(Builder::monitoringConfiguration)).constructor(MonitoringConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monitoringConfiguration").build()}).build();
    private static final SdkField<InteractiveConfiguration> INTERACTIVE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("interactiveConfiguration").getter(CreateApplicationRequest.getter(CreateApplicationRequest::interactiveConfiguration)).setter(CreateApplicationRequest.setter(Builder::interactiveConfiguration)).constructor(InteractiveConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interactiveConfiguration").build()}).build();
    private static final SdkField<SchedulerConfiguration> SCHEDULER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("schedulerConfiguration").getter(CreateApplicationRequest.getter(CreateApplicationRequest::schedulerConfiguration)).setter(CreateApplicationRequest.setter(Builder::schedulerConfiguration)).constructor(SchedulerConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedulerConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, RELEASE_LABEL_FIELD, TYPE_FIELD, CLIENT_TOKEN_FIELD, INITIAL_CAPACITY_FIELD, MAXIMUM_CAPACITY_FIELD, TAGS_FIELD, AUTO_START_CONFIGURATION_FIELD, AUTO_STOP_CONFIGURATION_FIELD, NETWORK_CONFIGURATION_FIELD, ARCHITECTURE_FIELD, IMAGE_CONFIGURATION_FIELD, WORKER_TYPE_SPECIFICATIONS_FIELD, RUNTIME_CONFIGURATION_FIELD, MONITORING_CONFIGURATION_FIELD, INTERACTIVE_CONFIGURATION_FIELD, SCHEDULER_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateApplicationRequest.memberNameToFieldInitializer();
    private final String name;
    private final String releaseLabel;
    private final String type;
    private final String clientToken;
    private final Map<String, InitialCapacityConfig> initialCapacity;
    private final MaximumAllowedResources maximumCapacity;
    private final Map<String, String> tags;
    private final AutoStartConfig autoStartConfiguration;
    private final AutoStopConfig autoStopConfiguration;
    private final NetworkConfiguration networkConfiguration;
    private final String architecture;
    private final ImageConfigurationInput imageConfiguration;
    private final Map<String, WorkerTypeSpecificationInput> workerTypeSpecifications;
    private final List<Configuration> runtimeConfiguration;
    private final MonitoringConfiguration monitoringConfiguration;
    private final InteractiveConfiguration interactiveConfiguration;
    private final SchedulerConfiguration schedulerConfiguration;

    private CreateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.releaseLabel = builder.releaseLabel;
        this.type = builder.type;
        this.clientToken = builder.clientToken;
        this.initialCapacity = builder.initialCapacity;
        this.maximumCapacity = builder.maximumCapacity;
        this.tags = builder.tags;
        this.autoStartConfiguration = builder.autoStartConfiguration;
        this.autoStopConfiguration = builder.autoStopConfiguration;
        this.networkConfiguration = builder.networkConfiguration;
        this.architecture = builder.architecture;
        this.imageConfiguration = builder.imageConfiguration;
        this.workerTypeSpecifications = builder.workerTypeSpecifications;
        this.runtimeConfiguration = builder.runtimeConfiguration;
        this.monitoringConfiguration = builder.monitoringConfiguration;
        this.interactiveConfiguration = builder.interactiveConfiguration;
        this.schedulerConfiguration = builder.schedulerConfiguration;
    }

    public final String name() {
        return this.name;
    }

    public final String releaseLabel() {
        return this.releaseLabel;
    }

    public final String type() {
        return this.type;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasInitialCapacity() {
        return this.initialCapacity != null && !(this.initialCapacity instanceof SdkAutoConstructMap);
    }

    public final Map<String, InitialCapacityConfig> initialCapacity() {
        return this.initialCapacity;
    }

    public final MaximumAllowedResources maximumCapacity() {
        return this.maximumCapacity;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final AutoStartConfig autoStartConfiguration() {
        return this.autoStartConfiguration;
    }

    public final AutoStopConfig autoStopConfiguration() {
        return this.autoStopConfiguration;
    }

    public final NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public final Architecture architecture() {
        return Architecture.fromValue(this.architecture);
    }

    public final String architectureAsString() {
        return this.architecture;
    }

    public final ImageConfigurationInput imageConfiguration() {
        return this.imageConfiguration;
    }

    public final boolean hasWorkerTypeSpecifications() {
        return this.workerTypeSpecifications != null && !(this.workerTypeSpecifications instanceof SdkAutoConstructMap);
    }

    public final Map<String, WorkerTypeSpecificationInput> workerTypeSpecifications() {
        return this.workerTypeSpecifications;
    }

    public final boolean hasRuntimeConfiguration() {
        return this.runtimeConfiguration != null && !(this.runtimeConfiguration instanceof SdkAutoConstructList);
    }

    public final List<Configuration> runtimeConfiguration() {
        return this.runtimeConfiguration;
    }

    public final MonitoringConfiguration monitoringConfiguration() {
        return this.monitoringConfiguration;
    }

    public final InteractiveConfiguration interactiveConfiguration() {
        return this.interactiveConfiguration;
    }

    public final SchedulerConfiguration schedulerConfiguration() {
        return this.schedulerConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInitialCapacity() ? this.initialCapacity() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoStartConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoStopConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.architectureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkerTypeSpecifications() ? this.workerTypeSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuntimeConfiguration() ? this.runtimeConfiguration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.interactiveConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedulerConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.releaseLabel(), other.releaseLabel()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasInitialCapacity() == other.hasInitialCapacity() && Objects.equals(this.initialCapacity(), other.initialCapacity()) && Objects.equals(this.maximumCapacity(), other.maximumCapacity()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.autoStartConfiguration(), other.autoStartConfiguration()) && Objects.equals(this.autoStopConfiguration(), other.autoStopConfiguration()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.architectureAsString(), other.architectureAsString()) && Objects.equals(this.imageConfiguration(), other.imageConfiguration()) && this.hasWorkerTypeSpecifications() == other.hasWorkerTypeSpecifications() && Objects.equals(this.workerTypeSpecifications(), other.workerTypeSpecifications()) && this.hasRuntimeConfiguration() == other.hasRuntimeConfiguration() && Objects.equals(this.runtimeConfiguration(), other.runtimeConfiguration()) && Objects.equals(this.monitoringConfiguration(), other.monitoringConfiguration()) && Objects.equals(this.interactiveConfiguration(), other.interactiveConfiguration()) && Objects.equals(this.schedulerConfiguration(), other.schedulerConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateApplicationRequest").add("Name", (Object)this.name()).add("ReleaseLabel", (Object)this.releaseLabel()).add("Type", (Object)this.type()).add("ClientToken", (Object)this.clientToken()).add("InitialCapacity", this.hasInitialCapacity() ? this.initialCapacity() : null).add("MaximumCapacity", (Object)this.maximumCapacity()).add("Tags", this.hasTags() ? this.tags() : null).add("AutoStartConfiguration", (Object)this.autoStartConfiguration()).add("AutoStopConfiguration", (Object)this.autoStopConfiguration()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("Architecture", (Object)this.architectureAsString()).add("ImageConfiguration", (Object)this.imageConfiguration()).add("WorkerTypeSpecifications", this.hasWorkerTypeSpecifications() ? this.workerTypeSpecifications() : null).add("RuntimeConfiguration", this.hasRuntimeConfiguration() ? this.runtimeConfiguration() : null).add("MonitoringConfiguration", (Object)this.monitoringConfiguration()).add("InteractiveConfiguration", (Object)this.interactiveConfiguration()).add("SchedulerConfiguration", (Object)this.schedulerConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "releaseLabel": {
                return Optional.ofNullable(clazz.cast(this.releaseLabel()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "initialCapacity": {
                return Optional.ofNullable(clazz.cast(this.initialCapacity()));
            }
            case "maximumCapacity": {
                return Optional.ofNullable(clazz.cast(this.maximumCapacity()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "autoStartConfiguration": {
                return Optional.ofNullable(clazz.cast(this.autoStartConfiguration()));
            }
            case "autoStopConfiguration": {
                return Optional.ofNullable(clazz.cast(this.autoStopConfiguration()));
            }
            case "networkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "architecture": {
                return Optional.ofNullable(clazz.cast(this.architectureAsString()));
            }
            case "imageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.imageConfiguration()));
            }
            case "workerTypeSpecifications": {
                return Optional.ofNullable(clazz.cast(this.workerTypeSpecifications()));
            }
            case "runtimeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.runtimeConfiguration()));
            }
            case "monitoringConfiguration": {
                return Optional.ofNullable(clazz.cast(this.monitoringConfiguration()));
            }
            case "interactiveConfiguration": {
                return Optional.ofNullable(clazz.cast(this.interactiveConfiguration()));
            }
            case "schedulerConfiguration": {
                return Optional.ofNullable(clazz.cast(this.schedulerConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("releaseLabel", RELEASE_LABEL_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("initialCapacity", INITIAL_CAPACITY_FIELD);
        map.put("maximumCapacity", MAXIMUM_CAPACITY_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("autoStartConfiguration", AUTO_START_CONFIGURATION_FIELD);
        map.put("autoStopConfiguration", AUTO_STOP_CONFIGURATION_FIELD);
        map.put("networkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("architecture", ARCHITECTURE_FIELD);
        map.put("imageConfiguration", IMAGE_CONFIGURATION_FIELD);
        map.put("workerTypeSpecifications", WORKER_TYPE_SPECIFICATIONS_FIELD);
        map.put("runtimeConfiguration", RUNTIME_CONFIGURATION_FIELD);
        map.put("monitoringConfiguration", MONITORING_CONFIGURATION_FIELD);
        map.put("interactiveConfiguration", INTERACTIVE_CONFIGURATION_FIELD);
        map.put("schedulerConfiguration", SCHEDULER_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationRequest, T> g) {
        return obj -> g.apply((CreateApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrServerlessRequest.BuilderImpl
    implements Builder {
        private String name;
        private String releaseLabel;
        private String type;
        private String clientToken;
        private Map<String, InitialCapacityConfig> initialCapacity = DefaultSdkAutoConstructMap.getInstance();
        private MaximumAllowedResources maximumCapacity;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private AutoStartConfig autoStartConfiguration;
        private AutoStopConfig autoStopConfiguration;
        private NetworkConfiguration networkConfiguration;
        private String architecture;
        private ImageConfigurationInput imageConfiguration;
        private Map<String, WorkerTypeSpecificationInput> workerTypeSpecifications = DefaultSdkAutoConstructMap.getInstance();
        private List<Configuration> runtimeConfiguration = DefaultSdkAutoConstructList.getInstance();
        private MonitoringConfiguration monitoringConfiguration;
        private InteractiveConfiguration interactiveConfiguration;
        private SchedulerConfiguration schedulerConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationRequest model) {
            super(model);
            this.name(model.name);
            this.releaseLabel(model.releaseLabel);
            this.type(model.type);
            this.clientToken(model.clientToken);
            this.initialCapacity(model.initialCapacity);
            this.maximumCapacity(model.maximumCapacity);
            this.tags(model.tags);
            this.autoStartConfiguration(model.autoStartConfiguration);
            this.autoStopConfiguration(model.autoStopConfiguration);
            this.networkConfiguration(model.networkConfiguration);
            this.architecture(model.architecture);
            this.imageConfiguration(model.imageConfiguration);
            this.workerTypeSpecifications(model.workerTypeSpecifications);
            this.runtimeConfiguration(model.runtimeConfiguration);
            this.monitoringConfiguration(model.monitoringConfiguration);
            this.interactiveConfiguration(model.interactiveConfiguration);
            this.schedulerConfiguration(model.schedulerConfiguration);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getReleaseLabel() {
            return this.releaseLabel;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, InitialCapacityConfig.Builder> getInitialCapacity() {
            Map<String, InitialCapacityConfig.Builder> result = InitialCapacityConfigMapCopier.copyToBuilder(this.initialCapacity);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setInitialCapacity(Map<String, InitialCapacityConfig.BuilderImpl> initialCapacity) {
            this.initialCapacity = InitialCapacityConfigMapCopier.copyFromBuilder(initialCapacity);
        }

        @Override
        public final Builder initialCapacity(Map<String, InitialCapacityConfig> initialCapacity) {
            this.initialCapacity = InitialCapacityConfigMapCopier.copy(initialCapacity);
            return this;
        }

        public final MaximumAllowedResources.Builder getMaximumCapacity() {
            return this.maximumCapacity != null ? this.maximumCapacity.toBuilder() : null;
        }

        public final void setMaximumCapacity(MaximumAllowedResources.BuilderImpl maximumCapacity) {
            this.maximumCapacity = maximumCapacity != null ? maximumCapacity.build() : null;
        }

        @Override
        public final Builder maximumCapacity(MaximumAllowedResources maximumCapacity) {
            this.maximumCapacity = maximumCapacity;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final AutoStartConfig.Builder getAutoStartConfiguration() {
            return this.autoStartConfiguration != null ? this.autoStartConfiguration.toBuilder() : null;
        }

        public final void setAutoStartConfiguration(AutoStartConfig.BuilderImpl autoStartConfiguration) {
            this.autoStartConfiguration = autoStartConfiguration != null ? autoStartConfiguration.build() : null;
        }

        @Override
        public final Builder autoStartConfiguration(AutoStartConfig autoStartConfiguration) {
            this.autoStartConfiguration = autoStartConfiguration;
            return this;
        }

        public final AutoStopConfig.Builder getAutoStopConfiguration() {
            return this.autoStopConfiguration != null ? this.autoStopConfiguration.toBuilder() : null;
        }

        public final void setAutoStopConfiguration(AutoStopConfig.BuilderImpl autoStopConfiguration) {
            this.autoStopConfiguration = autoStopConfiguration != null ? autoStopConfiguration.build() : null;
        }

        @Override
        public final Builder autoStopConfiguration(AutoStopConfig autoStopConfiguration) {
            this.autoStopConfiguration = autoStopConfiguration;
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(Architecture architecture) {
            this.architecture(architecture == null ? null : architecture.toString());
            return this;
        }

        public final ImageConfigurationInput.Builder getImageConfiguration() {
            return this.imageConfiguration != null ? this.imageConfiguration.toBuilder() : null;
        }

        public final void setImageConfiguration(ImageConfigurationInput.BuilderImpl imageConfiguration) {
            this.imageConfiguration = imageConfiguration != null ? imageConfiguration.build() : null;
        }

        @Override
        public final Builder imageConfiguration(ImageConfigurationInput imageConfiguration) {
            this.imageConfiguration = imageConfiguration;
            return this;
        }

        public final Map<String, WorkerTypeSpecificationInput.Builder> getWorkerTypeSpecifications() {
            Map<String, WorkerTypeSpecificationInput.Builder> result = WorkerTypeSpecificationInputMapCopier.copyToBuilder(this.workerTypeSpecifications);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setWorkerTypeSpecifications(Map<String, WorkerTypeSpecificationInput.BuilderImpl> workerTypeSpecifications) {
            this.workerTypeSpecifications = WorkerTypeSpecificationInputMapCopier.copyFromBuilder(workerTypeSpecifications);
        }

        @Override
        public final Builder workerTypeSpecifications(Map<String, WorkerTypeSpecificationInput> workerTypeSpecifications) {
            this.workerTypeSpecifications = WorkerTypeSpecificationInputMapCopier.copy(workerTypeSpecifications);
            return this;
        }

        public final List<Configuration.Builder> getRuntimeConfiguration() {
            List<Configuration.Builder> result = ConfigurationListCopier.copyToBuilder(this.runtimeConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuntimeConfiguration(Collection<Configuration.BuilderImpl> runtimeConfiguration) {
            this.runtimeConfiguration = ConfigurationListCopier.copyFromBuilder(runtimeConfiguration);
        }

        @Override
        public final Builder runtimeConfiguration(Collection<Configuration> runtimeConfiguration) {
            this.runtimeConfiguration = ConfigurationListCopier.copy(runtimeConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runtimeConfiguration(Configuration ... runtimeConfiguration) {
            this.runtimeConfiguration(Arrays.asList(runtimeConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runtimeConfiguration(Consumer<Configuration.Builder> ... runtimeConfiguration) {
            this.runtimeConfiguration(Stream.of(runtimeConfiguration).map(c -> (Configuration)((Configuration.Builder)Configuration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final MonitoringConfiguration.Builder getMonitoringConfiguration() {
            return this.monitoringConfiguration != null ? this.monitoringConfiguration.toBuilder() : null;
        }

        public final void setMonitoringConfiguration(MonitoringConfiguration.BuilderImpl monitoringConfiguration) {
            this.monitoringConfiguration = monitoringConfiguration != null ? monitoringConfiguration.build() : null;
        }

        @Override
        public final Builder monitoringConfiguration(MonitoringConfiguration monitoringConfiguration) {
            this.monitoringConfiguration = monitoringConfiguration;
            return this;
        }

        public final InteractiveConfiguration.Builder getInteractiveConfiguration() {
            return this.interactiveConfiguration != null ? this.interactiveConfiguration.toBuilder() : null;
        }

        public final void setInteractiveConfiguration(InteractiveConfiguration.BuilderImpl interactiveConfiguration) {
            this.interactiveConfiguration = interactiveConfiguration != null ? interactiveConfiguration.build() : null;
        }

        @Override
        public final Builder interactiveConfiguration(InteractiveConfiguration interactiveConfiguration) {
            this.interactiveConfiguration = interactiveConfiguration;
            return this;
        }

        public final SchedulerConfiguration.Builder getSchedulerConfiguration() {
            return this.schedulerConfiguration != null ? this.schedulerConfiguration.toBuilder() : null;
        }

        public final void setSchedulerConfiguration(SchedulerConfiguration.BuilderImpl schedulerConfiguration) {
            this.schedulerConfiguration = schedulerConfiguration != null ? schedulerConfiguration.build() : null;
        }

        @Override
        public final Builder schedulerConfiguration(SchedulerConfiguration schedulerConfiguration) {
            this.schedulerConfiguration = schedulerConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EmrServerlessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApplicationRequest> {
        public Builder name(String var1);

        public Builder releaseLabel(String var1);

        public Builder type(String var1);

        public Builder clientToken(String var1);

        public Builder initialCapacity(Map<String, InitialCapacityConfig> var1);

        public Builder maximumCapacity(MaximumAllowedResources var1);

        default public Builder maximumCapacity(Consumer<MaximumAllowedResources.Builder> maximumCapacity) {
            return this.maximumCapacity((MaximumAllowedResources)((MaximumAllowedResources.Builder)MaximumAllowedResources.builder().applyMutation(maximumCapacity)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder autoStartConfiguration(AutoStartConfig var1);

        default public Builder autoStartConfiguration(Consumer<AutoStartConfig.Builder> autoStartConfiguration) {
            return this.autoStartConfiguration((AutoStartConfig)((AutoStartConfig.Builder)AutoStartConfig.builder().applyMutation(autoStartConfiguration)).build());
        }

        public Builder autoStopConfiguration(AutoStopConfig var1);

        default public Builder autoStopConfiguration(Consumer<AutoStopConfig.Builder> autoStopConfiguration) {
            return this.autoStopConfiguration((AutoStopConfig)((AutoStopConfig.Builder)AutoStopConfig.builder().applyMutation(autoStopConfiguration)).build());
        }

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder architecture(String var1);

        public Builder architecture(Architecture var1);

        public Builder imageConfiguration(ImageConfigurationInput var1);

        default public Builder imageConfiguration(Consumer<ImageConfigurationInput.Builder> imageConfiguration) {
            return this.imageConfiguration((ImageConfigurationInput)((ImageConfigurationInput.Builder)ImageConfigurationInput.builder().applyMutation(imageConfiguration)).build());
        }

        public Builder workerTypeSpecifications(Map<String, WorkerTypeSpecificationInput> var1);

        public Builder runtimeConfiguration(Collection<Configuration> var1);

        public Builder runtimeConfiguration(Configuration ... var1);

        public Builder runtimeConfiguration(Consumer<Configuration.Builder> ... var1);

        public Builder monitoringConfiguration(MonitoringConfiguration var1);

        default public Builder monitoringConfiguration(Consumer<MonitoringConfiguration.Builder> monitoringConfiguration) {
            return this.monitoringConfiguration((MonitoringConfiguration)((MonitoringConfiguration.Builder)MonitoringConfiguration.builder().applyMutation(monitoringConfiguration)).build());
        }

        public Builder interactiveConfiguration(InteractiveConfiguration var1);

        default public Builder interactiveConfiguration(Consumer<InteractiveConfiguration.Builder> interactiveConfiguration) {
            return this.interactiveConfiguration((InteractiveConfiguration)((InteractiveConfiguration.Builder)InteractiveConfiguration.builder().applyMutation(interactiveConfiguration)).build());
        }

        public Builder schedulerConfiguration(SchedulerConfiguration var1);

        default public Builder schedulerConfiguration(Consumer<SchedulerConfiguration.Builder> schedulerConfiguration) {
            return this.schedulerConfiguration((SchedulerConfiguration)((SchedulerConfiguration.Builder)SchedulerConfiguration.builder().applyMutation(schedulerConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

