/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The specifications for a worker type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkerTypeSpecificationInput implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkerTypeSpecificationInput.Builder, WorkerTypeSpecificationInput> {
    private static final SdkField<ImageConfigurationInput> IMAGE_CONFIGURATION_FIELD = SdkField
            .<ImageConfigurationInput> builder(MarshallingType.SDK_POJO).memberName("imageConfiguration")
            .getter(getter(WorkerTypeSpecificationInput::imageConfiguration)).setter(setter(Builder::imageConfiguration))
            .constructor(ImageConfigurationInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final ImageConfigurationInput imageConfiguration;

    private WorkerTypeSpecificationInput(BuilderImpl builder) {
        this.imageConfiguration = builder.imageConfiguration;
    }

    /**
     * <p>
     * The image configuration for a worker type.
     * </p>
     * 
     * @return The image configuration for a worker type.
     */
    public final ImageConfigurationInput imageConfiguration() {
        return imageConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkerTypeSpecificationInput)) {
            return false;
        }
        WorkerTypeSpecificationInput other = (WorkerTypeSpecificationInput) obj;
        return Objects.equals(imageConfiguration(), other.imageConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkerTypeSpecificationInput").add("ImageConfiguration", imageConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "imageConfiguration":
            return Optional.ofNullable(clazz.cast(imageConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkerTypeSpecificationInput, T> g) {
        return obj -> g.apply((WorkerTypeSpecificationInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkerTypeSpecificationInput> {
        /**
         * <p>
         * The image configuration for a worker type.
         * </p>
         * 
         * @param imageConfiguration
         *        The image configuration for a worker type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageConfiguration(ImageConfigurationInput imageConfiguration);

        /**
         * <p>
         * The image configuration for a worker type.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageConfigurationInput.Builder} avoiding
         * the need to create one manually via {@link ImageConfigurationInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageConfigurationInput.Builder#build()} is called immediately
         * and its result is passed to {@link #imageConfiguration(ImageConfigurationInput)}.
         * 
         * @param imageConfiguration
         *        a consumer that will call methods on {@link ImageConfigurationInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageConfiguration(ImageConfigurationInput)
         */
        default Builder imageConfiguration(Consumer<ImageConfigurationInput.Builder> imageConfiguration) {
            return imageConfiguration(ImageConfigurationInput.builder().applyMutation(imageConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ImageConfigurationInput imageConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkerTypeSpecificationInput model) {
            imageConfiguration(model.imageConfiguration);
        }

        public final ImageConfigurationInput.Builder getImageConfiguration() {
            return imageConfiguration != null ? imageConfiguration.toBuilder() : null;
        }

        public final void setImageConfiguration(ImageConfigurationInput.BuilderImpl imageConfiguration) {
            this.imageConfiguration = imageConfiguration != null ? imageConfiguration.build() : null;
        }

        @Override
        public final Builder imageConfiguration(ImageConfigurationInput imageConfiguration) {
            this.imageConfiguration = imageConfiguration;
            return this;
        }

        @Override
        public WorkerTypeSpecificationInput build() {
            return new WorkerTypeSpecificationInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
