/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of attributes associated with a job run attempt.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobRunAttemptSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<JobRunAttemptSummary.Builder, JobRunAttemptSummary> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(JobRunAttemptSummary::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(JobRunAttemptSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(JobRunAttemptSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("mode")
            .getter(getter(JobRunAttemptSummary::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(JobRunAttemptSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(JobRunAttemptSummary::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<Instant> JOB_CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("jobCreatedAt").getter(getter(JobRunAttemptSummary::jobCreatedAt)).setter(setter(Builder::jobCreatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobCreatedAt").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(JobRunAttemptSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(JobRunAttemptSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRole").getter(getter(JobRunAttemptSummary::executionRole))
            .setter(setter(Builder::executionRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(JobRunAttemptSummary::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> STATE_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stateDetails").getter(getter(JobRunAttemptSummary::stateDetails)).setter(setter(Builder::stateDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateDetails").build()).build();

    private static final SdkField<String> RELEASE_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("releaseLabel").getter(getter(JobRunAttemptSummary::releaseLabel)).setter(setter(Builder::releaseLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseLabel").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(JobRunAttemptSummary::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Integer> ATTEMPT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("attempt").getter(getter(JobRunAttemptSummary::attempt)).setter(setter(Builder::attempt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attempt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            ID_FIELD, NAME_FIELD, MODE_FIELD, ARN_FIELD, CREATED_BY_FIELD, JOB_CREATED_AT_FIELD, CREATED_AT_FIELD,
            UPDATED_AT_FIELD, EXECUTION_ROLE_FIELD, STATE_FIELD, STATE_DETAILS_FIELD, RELEASE_LABEL_FIELD, TYPE_FIELD,
            ATTEMPT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final String id;

    private final String name;

    private final String mode;

    private final String arn;

    private final String createdBy;

    private final Instant jobCreatedAt;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String executionRole;

    private final String state;

    private final String stateDetails;

    private final String releaseLabel;

    private final String type;

    private final Integer attempt;

    private JobRunAttemptSummary(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.id = builder.id;
        this.name = builder.name;
        this.mode = builder.mode;
        this.arn = builder.arn;
        this.createdBy = builder.createdBy;
        this.jobCreatedAt = builder.jobCreatedAt;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.executionRole = builder.executionRole;
        this.state = builder.state;
        this.stateDetails = builder.stateDetails;
        this.releaseLabel = builder.releaseLabel;
        this.type = builder.type;
        this.attempt = builder.attempt;
    }

    /**
     * <p>
     * The ID of the application the job is running on.
     * </p>
     * 
     * @return The ID of the application the job is running on.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The ID of the job run attempt.
     * </p>
     * 
     * @return The ID of the job run attempt.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the job run attempt.
     * </p>
     * 
     * @return The name of the job run attempt.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The mode of the job run attempt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link JobRunMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The mode of the job run attempt.
     * @see JobRunMode
     */
    public final JobRunMode mode() {
        return JobRunMode.fromValue(mode);
    }

    /**
     * <p>
     * The mode of the job run attempt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link JobRunMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The mode of the job run attempt.
     * @see JobRunMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the job run.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the job run.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The user who created the job run.
     * </p>
     * 
     * @return The user who created the job run.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The date and time of when the job run was created.
     * </p>
     * 
     * @return The date and time of when the job run was created.
     */
    public final Instant jobCreatedAt() {
        return jobCreatedAt;
    }

    /**
     * <p>
     * The date and time when the job run attempt was created.
     * </p>
     * 
     * @return The date and time when the job run attempt was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time of when the job run attempt was last updated.
     * </p>
     * 
     * @return The date and time of when the job run attempt was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the execution role of the job run..
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the execution role of the job run..
     */
    public final String executionRole() {
        return executionRole;
    }

    /**
     * <p>
     * The state of the job run attempt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link JobRunState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the job run attempt.
     * @see JobRunState
     */
    public final JobRunState state() {
        return JobRunState.fromValue(state);
    }

    /**
     * <p>
     * The state of the job run attempt.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link JobRunState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the job run attempt.
     * @see JobRunState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The state details of the job run attempt.
     * </p>
     * 
     * @return The state details of the job run attempt.
     */
    public final String stateDetails() {
        return stateDetails;
    }

    /**
     * <p>
     * The Amazon EMR release label of the job run attempt.
     * </p>
     * 
     * @return The Amazon EMR release label of the job run attempt.
     */
    public final String releaseLabel() {
        return releaseLabel;
    }

    /**
     * <p>
     * The type of the job run, such as Spark or Hive.
     * </p>
     * 
     * @return The type of the job run, such as Spark or Hive.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The attempt number of the job run execution.
     * </p>
     * 
     * @return The attempt number of the job run execution.
     */
    public final Integer attempt() {
        return attempt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(jobCreatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateDetails());
        hashCode = 31 * hashCode + Objects.hashCode(releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(attempt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobRunAttemptSummary)) {
            return false;
        }
        JobRunAttemptSummary other = (JobRunAttemptSummary) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(modeAsString(), other.modeAsString())
                && Objects.equals(arn(), other.arn()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(jobCreatedAt(), other.jobCreatedAt()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(executionRole(), other.executionRole())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(stateDetails(), other.stateDetails())
                && Objects.equals(releaseLabel(), other.releaseLabel()) && Objects.equals(type(), other.type())
                && Objects.equals(attempt(), other.attempt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobRunAttemptSummary").add("ApplicationId", applicationId()).add("Id", id()).add("Name", name())
                .add("Mode", modeAsString()).add("Arn", arn()).add("CreatedBy", createdBy()).add("JobCreatedAt", jobCreatedAt())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).add("ExecutionRole", executionRole())
                .add("State", stateAsString()).add("StateDetails", stateDetails()).add("ReleaseLabel", releaseLabel())
                .add("Type", type()).add("Attempt", attempt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "jobCreatedAt":
            return Optional.ofNullable(clazz.cast(jobCreatedAt()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "executionRole":
            return Optional.ofNullable(clazz.cast(executionRole()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "stateDetails":
            return Optional.ofNullable(clazz.cast(stateDetails()));
        case "releaseLabel":
            return Optional.ofNullable(clazz.cast(releaseLabel()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "attempt":
            return Optional.ofNullable(clazz.cast(attempt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobRunAttemptSummary, T> g) {
        return obj -> g.apply((JobRunAttemptSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobRunAttemptSummary> {
        /**
         * <p>
         * The ID of the application the job is running on.
         * </p>
         * 
         * @param applicationId
         *        The ID of the application the job is running on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The ID of the job run attempt.
         * </p>
         * 
         * @param id
         *        The ID of the job run attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the job run attempt.
         * </p>
         * 
         * @param name
         *        The name of the job run attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The mode of the job run attempt.
         * </p>
         * 
         * @param mode
         *        The mode of the job run attempt.
         * @see JobRunMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobRunMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The mode of the job run attempt.
         * </p>
         * 
         * @param mode
         *        The mode of the job run attempt.
         * @see JobRunMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobRunMode
         */
        Builder mode(JobRunMode mode);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the job run.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The user who created the job run.
         * </p>
         * 
         * @param createdBy
         *        The user who created the job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The date and time of when the job run was created.
         * </p>
         * 
         * @param jobCreatedAt
         *        The date and time of when the job run was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobCreatedAt(Instant jobCreatedAt);

        /**
         * <p>
         * The date and time when the job run attempt was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time when the job run attempt was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time of when the job run attempt was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time of when the job run attempt was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the execution role of the job run..
         * </p>
         * 
         * @param executionRole
         *        The Amazon Resource Name (ARN) of the execution role of the job run..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRole(String executionRole);

        /**
         * <p>
         * The state of the job run attempt.
         * </p>
         * 
         * @param state
         *        The state of the job run attempt.
         * @see JobRunState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobRunState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the job run attempt.
         * </p>
         * 
         * @param state
         *        The state of the job run attempt.
         * @see JobRunState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobRunState
         */
        Builder state(JobRunState state);

        /**
         * <p>
         * The state details of the job run attempt.
         * </p>
         * 
         * @param stateDetails
         *        The state details of the job run attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateDetails(String stateDetails);

        /**
         * <p>
         * The Amazon EMR release label of the job run attempt.
         * </p>
         * 
         * @param releaseLabel
         *        The Amazon EMR release label of the job run attempt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releaseLabel(String releaseLabel);

        /**
         * <p>
         * The type of the job run, such as Spark or Hive.
         * </p>
         * 
         * @param type
         *        The type of the job run, such as Spark or Hive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The attempt number of the job run execution.
         * </p>
         * 
         * @param attempt
         *        The attempt number of the job run execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attempt(Integer attempt);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String id;

        private String name;

        private String mode;

        private String arn;

        private String createdBy;

        private Instant jobCreatedAt;

        private Instant createdAt;

        private Instant updatedAt;

        private String executionRole;

        private String state;

        private String stateDetails;

        private String releaseLabel;

        private String type;

        private Integer attempt;

        private BuilderImpl() {
        }

        private BuilderImpl(JobRunAttemptSummary model) {
            applicationId(model.applicationId);
            id(model.id);
            name(model.name);
            mode(model.mode);
            arn(model.arn);
            createdBy(model.createdBy);
            jobCreatedAt(model.jobCreatedAt);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            executionRole(model.executionRole);
            state(model.state);
            stateDetails(model.stateDetails);
            releaseLabel(model.releaseLabel);
            type(model.type);
            attempt(model.attempt);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(JobRunMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getJobCreatedAt() {
            return jobCreatedAt;
        }

        public final void setJobCreatedAt(Instant jobCreatedAt) {
            this.jobCreatedAt = jobCreatedAt;
        }

        @Override
        public final Builder jobCreatedAt(Instant jobCreatedAt) {
            this.jobCreatedAt = jobCreatedAt;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getExecutionRole() {
            return executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(JobRunState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateDetails() {
            return stateDetails;
        }

        public final void setStateDetails(String stateDetails) {
            this.stateDetails = stateDetails;
        }

        @Override
        public final Builder stateDetails(String stateDetails) {
            this.stateDetails = stateDetails;
            return this;
        }

        public final String getReleaseLabel() {
            return releaseLabel;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Integer getAttempt() {
            return attempt;
        }

        public final void setAttempt(Integer attempt) {
            this.attempt = attempt;
        }

        @Override
        public final Builder attempt(Integer attempt) {
            this.attempt = attempt;
            return this;
        }

        @Override
        public JobRunAttemptSummary build() {
            return new JobRunAttemptSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
