/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Hive
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Hive> {
    private static final SdkField<String> QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("query").getter(Hive.getter(Hive::query)).setter(Hive.setter(Builder::query)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("query").build()}).build();
    private static final SdkField<String> INIT_QUERY_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("initQueryFile").getter(Hive.getter(Hive::initQueryFile)).setter(Hive.setter(Builder::initQueryFile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initQueryFile").build()}).build();
    private static final SdkField<String> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parameters").getter(Hive.getter(Hive::parameters)).setter(Hive.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_FIELD, INIT_QUERY_FILE_FIELD, PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String query;
    private final String initQueryFile;
    private final String parameters;

    private Hive(BuilderImpl builder) {
        this.query = builder.query;
        this.initQueryFile = builder.initQueryFile;
        this.parameters = builder.parameters;
    }

    public final String query() {
        return this.query;
    }

    public final String initQueryFile() {
        return this.initQueryFile;
    }

    public final String parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.query());
        hashCode = 31 * hashCode + Objects.hashCode(this.initQueryFile());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Hive)) {
            return false;
        }
        Hive other = (Hive)obj;
        return Objects.equals(this.query(), other.query()) && Objects.equals(this.initQueryFile(), other.initQueryFile()) && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"Hive").add("Query", (Object)(this.query() == null ? null : "*** Sensitive Data Redacted ***")).add("InitQueryFile", (Object)(this.initQueryFile() == null ? null : "*** Sensitive Data Redacted ***")).add("Parameters", (Object)(this.parameters() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "query": {
                return Optional.ofNullable(clazz.cast(this.query()));
            }
            case "initQueryFile": {
                return Optional.ofNullable(clazz.cast(this.initQueryFile()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Hive, T> g) {
        return obj -> g.apply((Hive)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String query;
        private String initQueryFile;
        private String parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(Hive model) {
            this.query(model.query);
            this.initQueryFile(model.initQueryFile);
            this.parameters(model.parameters);
        }

        public final String getQuery() {
            return this.query;
        }

        public final void setQuery(String query) {
            this.query = query;
        }

        @Override
        public final Builder query(String query) {
            this.query = query;
            return this;
        }

        public final String getInitQueryFile() {
            return this.initQueryFile;
        }

        public final void setInitQueryFile(String initQueryFile) {
            this.initQueryFile = initQueryFile;
        }

        @Override
        public final Builder initQueryFile(String initQueryFile) {
            this.initQueryFile = initQueryFile;
            return this;
        }

        public final String getParameters() {
            return this.parameters;
        }

        public final void setParameters(String parameters) {
            this.parameters = parameters;
        }

        @Override
        public final Builder parameters(String parameters) {
            this.parameters = parameters;
            return this;
        }

        public Hive build() {
            return new Hive(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Hive> {
        public Builder query(String var1);

        public Builder initQueryFile(String var1);

        public Builder parameters(String var1);
    }
}

