/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emrserverless.model.ApplicationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ApplicationSummary.getter(ApplicationSummary::id)).setter(ApplicationSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ApplicationSummary.getter(ApplicationSummary::name)).setter(ApplicationSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ApplicationSummary.getter(ApplicationSummary::arn)).setter(ApplicationSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> RELEASE_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("releaseLabel").getter(ApplicationSummary.getter(ApplicationSummary::releaseLabel)).setter(ApplicationSummary.setter(Builder::releaseLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseLabel").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ApplicationSummary.getter(ApplicationSummary::type)).setter(ApplicationSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(ApplicationSummary.getter(ApplicationSummary::stateAsString)).setter(ApplicationSummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> STATE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateDetails").getter(ApplicationSummary.getter(ApplicationSummary::stateDetails)).setter(ApplicationSummary.setter(Builder::stateDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateDetails").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ApplicationSummary.getter(ApplicationSummary::createdAt)).setter(ApplicationSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(ApplicationSummary.getter(ApplicationSummary::updatedAt)).setter(ApplicationSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, ARN_FIELD, RELEASE_LABEL_FIELD, TYPE_FIELD, STATE_FIELD, STATE_DETAILS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String arn;
    private final String releaseLabel;
    private final String type;
    private final String state;
    private final String stateDetails;
    private final Instant createdAt;
    private final Instant updatedAt;

    private ApplicationSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.arn = builder.arn;
        this.releaseLabel = builder.releaseLabel;
        this.type = builder.type;
        this.state = builder.state;
        this.stateDetails = builder.stateDetails;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String releaseLabel() {
        return this.releaseLabel;
    }

    public final String type() {
        return this.type;
    }

    public final ApplicationState state() {
        return ApplicationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String stateDetails() {
        return this.stateDetails;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSummary)) {
            return false;
        }
        ApplicationSummary other = (ApplicationSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.releaseLabel(), other.releaseLabel()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateDetails(), other.stateDetails()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationSummary").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("ReleaseLabel", (Object)this.releaseLabel()).add("Type", (Object)this.type()).add("State", (Object)this.stateAsString()).add("StateDetails", (Object)this.stateDetails()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "releaseLabel": {
                return Optional.ofNullable(clazz.cast(this.releaseLabel()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "stateDetails": {
                return Optional.ofNullable(clazz.cast(this.stateDetails()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationSummary, T> g) {
        return obj -> g.apply((ApplicationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String arn;
        private String releaseLabel;
        private String type;
        private String state;
        private String stateDetails;
        private Instant createdAt;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSummary model) {
            this.id(model.id);
            this.name(model.name);
            this.arn(model.arn);
            this.releaseLabel(model.releaseLabel);
            this.type(model.type);
            this.state(model.state);
            this.stateDetails(model.stateDetails);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getReleaseLabel() {
            return this.releaseLabel;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ApplicationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateDetails() {
            return this.stateDetails;
        }

        public final void setStateDetails(String stateDetails) {
            this.stateDetails = stateDetails;
        }

        @Override
        public final Builder stateDetails(String stateDetails) {
            this.stateDetails = stateDetails;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public ApplicationSummary build() {
            return new ApplicationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationSummary> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder releaseLabel(String var1);

        public Builder type(String var1);

        public Builder state(String var1);

        public Builder state(ApplicationState var1);

        public Builder stateDetails(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);
    }
}

