/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elastictranscoder.model.ElasticTranscoderRequest;
import software.amazon.awssdk.services.elastictranscoder.model.Notifications;
import software.amazon.awssdk.services.elastictranscoder.model.PipelineOutputConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePipelineRequest
extends ElasticTranscoderRequest
implements ToCopyableBuilder<Builder, CreatePipelineRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreatePipelineRequest.getter(CreatePipelineRequest::name)).setter(CreatePipelineRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> INPUT_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputBucket").getter(CreatePipelineRequest.getter(CreatePipelineRequest::inputBucket)).setter(CreatePipelineRequest.setter(Builder::inputBucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputBucket").build()}).build();
    private static final SdkField<String> OUTPUT_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputBucket").getter(CreatePipelineRequest.getter(CreatePipelineRequest::outputBucket)).setter(CreatePipelineRequest.setter(Builder::outputBucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputBucket").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(CreatePipelineRequest.getter(CreatePipelineRequest::role)).setter(CreatePipelineRequest.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> AWS_KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsKmsKeyArn").getter(CreatePipelineRequest.getter(CreatePipelineRequest::awsKmsKeyArn)).setter(CreatePipelineRequest.setter(Builder::awsKmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsKmsKeyArn").build()}).build();
    private static final SdkField<Notifications> NOTIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Notifications").getter(CreatePipelineRequest.getter(CreatePipelineRequest::notifications)).setter(CreatePipelineRequest.setter(Builder::notifications)).constructor(Notifications::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notifications").build()}).build();
    private static final SdkField<PipelineOutputConfig> CONTENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContentConfig").getter(CreatePipelineRequest.getter(CreatePipelineRequest::contentConfig)).setter(CreatePipelineRequest.setter(Builder::contentConfig)).constructor(PipelineOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentConfig").build()}).build();
    private static final SdkField<PipelineOutputConfig> THUMBNAIL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ThumbnailConfig").getter(CreatePipelineRequest.getter(CreatePipelineRequest::thumbnailConfig)).setter(CreatePipelineRequest.setter(Builder::thumbnailConfig)).constructor(PipelineOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThumbnailConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUT_BUCKET_FIELD, OUTPUT_BUCKET_FIELD, ROLE_FIELD, AWS_KMS_KEY_ARN_FIELD, NOTIFICATIONS_FIELD, CONTENT_CONFIG_FIELD, THUMBNAIL_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("InputBucket", INPUT_BUCKET_FIELD);
            this.put("OutputBucket", OUTPUT_BUCKET_FIELD);
            this.put("Role", ROLE_FIELD);
            this.put("AwsKmsKeyArn", AWS_KMS_KEY_ARN_FIELD);
            this.put("Notifications", NOTIFICATIONS_FIELD);
            this.put("ContentConfig", CONTENT_CONFIG_FIELD);
            this.put("ThumbnailConfig", THUMBNAIL_CONFIG_FIELD);
        }
    });
    private final String name;
    private final String inputBucket;
    private final String outputBucket;
    private final String role;
    private final String awsKmsKeyArn;
    private final Notifications notifications;
    private final PipelineOutputConfig contentConfig;
    private final PipelineOutputConfig thumbnailConfig;

    private CreatePipelineRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.inputBucket = builder.inputBucket;
        this.outputBucket = builder.outputBucket;
        this.role = builder.role;
        this.awsKmsKeyArn = builder.awsKmsKeyArn;
        this.notifications = builder.notifications;
        this.contentConfig = builder.contentConfig;
        this.thumbnailConfig = builder.thumbnailConfig;
    }

    public final String name() {
        return this.name;
    }

    public final String inputBucket() {
        return this.inputBucket;
    }

    public final String outputBucket() {
        return this.outputBucket;
    }

    public final String role() {
        return this.role;
    }

    public final String awsKmsKeyArn() {
        return this.awsKmsKeyArn;
    }

    public final Notifications notifications() {
        return this.notifications;
    }

    public final PipelineOutputConfig contentConfig() {
        return this.contentConfig;
    }

    public final PipelineOutputConfig thumbnailConfig() {
        return this.thumbnailConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputBucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputBucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsKmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.notifications());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.thumbnailConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePipelineRequest)) {
            return false;
        }
        CreatePipelineRequest other = (CreatePipelineRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.inputBucket(), other.inputBucket()) && Objects.equals(this.outputBucket(), other.outputBucket()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.awsKmsKeyArn(), other.awsKmsKeyArn()) && Objects.equals(this.notifications(), other.notifications()) && Objects.equals(this.contentConfig(), other.contentConfig()) && Objects.equals(this.thumbnailConfig(), other.thumbnailConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePipelineRequest").add("Name", (Object)this.name()).add("InputBucket", (Object)this.inputBucket()).add("OutputBucket", (Object)this.outputBucket()).add("Role", (Object)this.role()).add("AwsKmsKeyArn", (Object)this.awsKmsKeyArn()).add("Notifications", (Object)this.notifications()).add("ContentConfig", (Object)this.contentConfig()).add("ThumbnailConfig", (Object)this.thumbnailConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "InputBucket": {
                return Optional.ofNullable(clazz.cast(this.inputBucket()));
            }
            case "OutputBucket": {
                return Optional.ofNullable(clazz.cast(this.outputBucket()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "AwsKmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.awsKmsKeyArn()));
            }
            case "Notifications": {
                return Optional.ofNullable(clazz.cast(this.notifications()));
            }
            case "ContentConfig": {
                return Optional.ofNullable(clazz.cast(this.contentConfig()));
            }
            case "ThumbnailConfig": {
                return Optional.ofNullable(clazz.cast(this.thumbnailConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreatePipelineRequest, T> g) {
        return obj -> g.apply((CreatePipelineRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticTranscoderRequest.BuilderImpl
    implements Builder {
        private String name;
        private String inputBucket;
        private String outputBucket;
        private String role;
        private String awsKmsKeyArn;
        private Notifications notifications;
        private PipelineOutputConfig contentConfig;
        private PipelineOutputConfig thumbnailConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePipelineRequest model) {
            super(model);
            this.name(model.name);
            this.inputBucket(model.inputBucket);
            this.outputBucket(model.outputBucket);
            this.role(model.role);
            this.awsKmsKeyArn(model.awsKmsKeyArn);
            this.notifications(model.notifications);
            this.contentConfig(model.contentConfig);
            this.thumbnailConfig(model.thumbnailConfig);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getInputBucket() {
            return this.inputBucket;
        }

        public final void setInputBucket(String inputBucket) {
            this.inputBucket = inputBucket;
        }

        @Override
        public final Builder inputBucket(String inputBucket) {
            this.inputBucket = inputBucket;
            return this;
        }

        public final String getOutputBucket() {
            return this.outputBucket;
        }

        public final void setOutputBucket(String outputBucket) {
            this.outputBucket = outputBucket;
        }

        @Override
        public final Builder outputBucket(String outputBucket) {
            this.outputBucket = outputBucket;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final String getAwsKmsKeyArn() {
            return this.awsKmsKeyArn;
        }

        public final void setAwsKmsKeyArn(String awsKmsKeyArn) {
            this.awsKmsKeyArn = awsKmsKeyArn;
        }

        @Override
        public final Builder awsKmsKeyArn(String awsKmsKeyArn) {
            this.awsKmsKeyArn = awsKmsKeyArn;
            return this;
        }

        public final Notifications.Builder getNotifications() {
            return this.notifications != null ? this.notifications.toBuilder() : null;
        }

        public final void setNotifications(Notifications.BuilderImpl notifications) {
            this.notifications = notifications != null ? notifications.build() : null;
        }

        @Override
        public final Builder notifications(Notifications notifications) {
            this.notifications = notifications;
            return this;
        }

        public final PipelineOutputConfig.Builder getContentConfig() {
            return this.contentConfig != null ? this.contentConfig.toBuilder() : null;
        }

        public final void setContentConfig(PipelineOutputConfig.BuilderImpl contentConfig) {
            this.contentConfig = contentConfig != null ? contentConfig.build() : null;
        }

        @Override
        public final Builder contentConfig(PipelineOutputConfig contentConfig) {
            this.contentConfig = contentConfig;
            return this;
        }

        public final PipelineOutputConfig.Builder getThumbnailConfig() {
            return this.thumbnailConfig != null ? this.thumbnailConfig.toBuilder() : null;
        }

        public final void setThumbnailConfig(PipelineOutputConfig.BuilderImpl thumbnailConfig) {
            this.thumbnailConfig = thumbnailConfig != null ? thumbnailConfig.build() : null;
        }

        @Override
        public final Builder thumbnailConfig(PipelineOutputConfig thumbnailConfig) {
            this.thumbnailConfig = thumbnailConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePipelineRequest build() {
            return new CreatePipelineRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElasticTranscoderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePipelineRequest> {
        public Builder name(String var1);

        public Builder inputBucket(String var1);

        public Builder outputBucket(String var1);

        public Builder role(String var1);

        public Builder awsKmsKeyArn(String var1);

        public Builder notifications(Notifications var1);

        default public Builder notifications(Consumer<Notifications.Builder> notifications) {
            return this.notifications((Notifications)((Notifications.Builder)Notifications.builder().applyMutation(notifications)).build());
        }

        public Builder contentConfig(PipelineOutputConfig var1);

        default public Builder contentConfig(Consumer<PipelineOutputConfig.Builder> contentConfig) {
            return this.contentConfig((PipelineOutputConfig)((PipelineOutputConfig.Builder)PipelineOutputConfig.builder().applyMutation(contentConfig)).build());
        }

        public Builder thumbnailConfig(PipelineOutputConfig var1);

        default public Builder thumbnailConfig(Consumer<PipelineOutputConfig.Builder> thumbnailConfig) {
            return this.thumbnailConfig((PipelineOutputConfig)((PipelineOutputConfig.Builder)PipelineOutputConfig.builder().applyMutation(thumbnailConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

