/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elastictranscoder.model.Artwork;
import software.amazon.awssdk.services.elastictranscoder.model.ArtworksCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobAlbumArt
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobAlbumArt> {
    private static final SdkField<String> MERGE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MergePolicy").getter(JobAlbumArt.getter(JobAlbumArt::mergePolicy)).setter(JobAlbumArt.setter(Builder::mergePolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MergePolicy").build()}).build();
    private static final SdkField<List<Artwork>> ARTWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Artwork").getter(JobAlbumArt.getter(JobAlbumArt::artwork)).setter(JobAlbumArt.setter(Builder::artwork)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Artwork").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Artwork::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MERGE_POLICY_FIELD, ARTWORK_FIELD));
    private static final long serialVersionUID = 1L;
    private final String mergePolicy;
    private final List<Artwork> artwork;

    private JobAlbumArt(BuilderImpl builder) {
        this.mergePolicy = builder.mergePolicy;
        this.artwork = builder.artwork;
    }

    public final String mergePolicy() {
        return this.mergePolicy;
    }

    public final boolean hasArtwork() {
        return this.artwork != null && !(this.artwork instanceof SdkAutoConstructList);
    }

    public final List<Artwork> artwork() {
        return this.artwork;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mergePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArtwork() ? this.artwork() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobAlbumArt)) {
            return false;
        }
        JobAlbumArt other = (JobAlbumArt)obj;
        return Objects.equals(this.mergePolicy(), other.mergePolicy()) && this.hasArtwork() == other.hasArtwork() && Objects.equals(this.artwork(), other.artwork());
    }

    public final String toString() {
        return ToString.builder((String)"JobAlbumArt").add("MergePolicy", (Object)this.mergePolicy()).add("Artwork", this.hasArtwork() ? this.artwork() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MergePolicy": {
                return Optional.ofNullable(clazz.cast(this.mergePolicy()));
            }
            case "Artwork": {
                return Optional.ofNullable(clazz.cast(this.artwork()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobAlbumArt, T> g) {
        return obj -> g.apply((JobAlbumArt)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mergePolicy;
        private List<Artwork> artwork = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobAlbumArt model) {
            this.mergePolicy(model.mergePolicy);
            this.artwork(model.artwork);
        }

        public final String getMergePolicy() {
            return this.mergePolicy;
        }

        public final void setMergePolicy(String mergePolicy) {
            this.mergePolicy = mergePolicy;
        }

        @Override
        public final Builder mergePolicy(String mergePolicy) {
            this.mergePolicy = mergePolicy;
            return this;
        }

        public final List<Artwork.Builder> getArtwork() {
            List<Artwork.Builder> result = ArtworksCopier.copyToBuilder(this.artwork);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setArtwork(Collection<Artwork.BuilderImpl> artwork) {
            this.artwork = ArtworksCopier.copyFromBuilder(artwork);
        }

        @Override
        public final Builder artwork(Collection<Artwork> artwork) {
            this.artwork = ArtworksCopier.copy(artwork);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder artwork(Artwork ... artwork) {
            this.artwork(Arrays.asList(artwork));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder artwork(Consumer<Artwork.Builder> ... artwork) {
            this.artwork(Stream.of(artwork).map(c -> (Artwork)((Artwork.Builder)Artwork.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public JobAlbumArt build() {
            return new JobAlbumArt(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobAlbumArt> {
        public Builder mergePolicy(String var1);

        public Builder artwork(Collection<Artwork> var1);

        public Builder artwork(Artwork ... var1);

        public Builder artwork(Consumer<Artwork.Builder> ... var1);
    }
}

