/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.elastictranscoder.DefaultElasticTranscoderAsyncClient;
import software.amazon.awssdk.services.elastictranscoder.DefaultElasticTranscoderBaseClientBuilder;
import software.amazon.awssdk.services.elastictranscoder.ElasticTranscoderAsyncClient;
import software.amazon.awssdk.services.elastictranscoder.ElasticTranscoderAsyncClientBuilder;
import software.amazon.awssdk.services.elastictranscoder.ElasticTranscoderServiceClientConfiguration;
import software.amazon.awssdk.services.elastictranscoder.endpoints.ElasticTranscoderEndpointProvider;

@SdkInternalApi
final class DefaultElasticTranscoderAsyncClientBuilder
extends DefaultElasticTranscoderBaseClientBuilder<ElasticTranscoderAsyncClientBuilder, ElasticTranscoderAsyncClient>
implements ElasticTranscoderAsyncClientBuilder {
    DefaultElasticTranscoderAsyncClientBuilder() {
    }

    @Override
    public DefaultElasticTranscoderAsyncClientBuilder endpointProvider(ElasticTranscoderEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ElasticTranscoderAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultElasticTranscoderAsyncClientBuilder.validateClientOptions(clientConfiguration);
        ElasticTranscoderServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultElasticTranscoderAsyncClient client = new DefaultElasticTranscoderAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ElasticTranscoderServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ElasticTranscoderServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

