/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elastictranscoder.ElasticTranscoderAsyncClient;
import software.amazon.awssdk.services.elastictranscoder.model.Job;
import software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ListJobsByPipelineResponse;

public class ListJobsByPipelinePublisher
implements SdkPublisher<ListJobsByPipelineResponse> {
    private final ElasticTranscoderAsyncClient client;
    private final ListJobsByPipelineRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListJobsByPipelinePublisher(ElasticTranscoderAsyncClient client, ListJobsByPipelineRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListJobsByPipelinePublisher(ElasticTranscoderAsyncClient client, ListJobsByPipelineRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListJobsByPipelineResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListJobsByPipelineResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Job> jobs() {
        Function<ListJobsByPipelineResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobs() != null) {
                return response.jobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListJobsByPipelineResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListJobsByPipelineResponseFetcher
    implements AsyncPageFetcher<ListJobsByPipelineResponse> {
        private ListJobsByPipelineResponseFetcher() {
        }

        public boolean hasNextPage(ListJobsByPipelineResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<ListJobsByPipelineResponse> nextPage(ListJobsByPipelineResponse previousPage) {
            if (previousPage == null) {
                return ListJobsByPipelinePublisher.this.client.listJobsByPipeline(ListJobsByPipelinePublisher.this.firstRequest);
            }
            return ListJobsByPipelinePublisher.this.client.listJobsByPipeline((ListJobsByPipelineRequest)((Object)ListJobsByPipelinePublisher.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

