/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elastictranscoder.ElasticTranscoderClient;
import software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesRequest;
import software.amazon.awssdk.services.elastictranscoder.model.ListPipelinesResponse;
import software.amazon.awssdk.services.elastictranscoder.model.Pipeline;

public class ListPipelinesIterable
implements SdkIterable<ListPipelinesResponse> {
    private final ElasticTranscoderClient client;
    private final ListPipelinesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPipelinesIterable(ElasticTranscoderClient client, ListPipelinesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPipelinesResponseFetcher();
    }

    public Iterator<ListPipelinesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Pipeline> pipelines() {
        Function<ListPipelinesResponse, Iterator> getIterator = response -> {
            if (response != null && response.pipelines() != null) {
                return response.pipelines().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPipelinesResponseFetcher
    implements SyncPageFetcher<ListPipelinesResponse> {
        private ListPipelinesResponseFetcher() {
        }

        public boolean hasNextPage(ListPipelinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public ListPipelinesResponse nextPage(ListPipelinesResponse previousPage) {
            if (previousPage == null) {
                return ListPipelinesIterable.this.client.listPipelines(ListPipelinesIterable.this.firstRequest);
            }
            return ListPipelinesIterable.this.client.listPipelines((ListPipelinesRequest)((Object)ListPipelinesIterable.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

