/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>VideoParameters</code> structure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoParameters implements SdkPojo, Serializable, ToCopyableBuilder<VideoParameters.Builder, VideoParameters> {
    private static final SdkField<String> CODEC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Codec")
            .getter(getter(VideoParameters::codec)).setter(setter(Builder::codec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Codec").build()).build();

    private static final SdkField<Map<String, String>> CODEC_OPTIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("CodecOptions")
            .getter(getter(VideoParameters::codecOptions))
            .setter(setter(Builder::codecOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodecOptions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> KEYFRAMES_MAX_DIST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyframesMaxDist").getter(getter(VideoParameters::keyframesMaxDist))
            .setter(setter(Builder::keyframesMaxDist))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyframesMaxDist").build()).build();

    private static final SdkField<String> FIXED_GOP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FixedGOP").getter(getter(VideoParameters::fixedGOP)).setter(setter(Builder::fixedGOP))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedGOP").build()).build();

    private static final SdkField<String> BIT_RATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BitRate").getter(getter(VideoParameters::bitRate)).setter(setter(Builder::bitRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BitRate").build()).build();

    private static final SdkField<String> FRAME_RATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FrameRate").getter(getter(VideoParameters::frameRate)).setter(setter(Builder::frameRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameRate").build()).build();

    private static final SdkField<String> MAX_FRAME_RATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxFrameRate").getter(getter(VideoParameters::maxFrameRate)).setter(setter(Builder::maxFrameRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxFrameRate").build()).build();

    private static final SdkField<String> RESOLUTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Resolution").getter(getter(VideoParameters::resolution)).setter(setter(Builder::resolution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resolution").build()).build();

    private static final SdkField<String> ASPECT_RATIO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AspectRatio").getter(getter(VideoParameters::aspectRatio)).setter(setter(Builder::aspectRatio))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AspectRatio").build()).build();

    private static final SdkField<String> MAX_WIDTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxWidth").getter(getter(VideoParameters::maxWidth)).setter(setter(Builder::maxWidth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxWidth").build()).build();

    private static final SdkField<String> MAX_HEIGHT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxHeight").getter(getter(VideoParameters::maxHeight)).setter(setter(Builder::maxHeight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxHeight").build()).build();

    private static final SdkField<String> DISPLAY_ASPECT_RATIO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayAspectRatio").getter(getter(VideoParameters::displayAspectRatio))
            .setter(setter(Builder::displayAspectRatio))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayAspectRatio").build())
            .build();

    private static final SdkField<String> SIZING_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SizingPolicy").getter(getter(VideoParameters::sizingPolicy)).setter(setter(Builder::sizingPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizingPolicy").build()).build();

    private static final SdkField<String> PADDING_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PaddingPolicy").getter(getter(VideoParameters::paddingPolicy)).setter(setter(Builder::paddingPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaddingPolicy").build()).build();

    private static final SdkField<List<PresetWatermark>> WATERMARKS_FIELD = SdkField
            .<List<PresetWatermark>> builder(MarshallingType.LIST)
            .memberName("Watermarks")
            .getter(getter(VideoParameters::watermarks))
            .setter(setter(Builder::watermarks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Watermarks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PresetWatermark> builder(MarshallingType.SDK_POJO)
                                            .constructor(PresetWatermark::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODEC_FIELD,
            CODEC_OPTIONS_FIELD, KEYFRAMES_MAX_DIST_FIELD, FIXED_GOP_FIELD, BIT_RATE_FIELD, FRAME_RATE_FIELD,
            MAX_FRAME_RATE_FIELD, RESOLUTION_FIELD, ASPECT_RATIO_FIELD, MAX_WIDTH_FIELD, MAX_HEIGHT_FIELD,
            DISPLAY_ASPECT_RATIO_FIELD, SIZING_POLICY_FIELD, PADDING_POLICY_FIELD, WATERMARKS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String codec;

    private final Map<String, String> codecOptions;

    private final String keyframesMaxDist;

    private final String fixedGOP;

    private final String bitRate;

    private final String frameRate;

    private final String maxFrameRate;

    private final String resolution;

    private final String aspectRatio;

    private final String maxWidth;

    private final String maxHeight;

    private final String displayAspectRatio;

    private final String sizingPolicy;

    private final String paddingPolicy;

    private final List<PresetWatermark> watermarks;

    private VideoParameters(BuilderImpl builder) {
        this.codec = builder.codec;
        this.codecOptions = builder.codecOptions;
        this.keyframesMaxDist = builder.keyframesMaxDist;
        this.fixedGOP = builder.fixedGOP;
        this.bitRate = builder.bitRate;
        this.frameRate = builder.frameRate;
        this.maxFrameRate = builder.maxFrameRate;
        this.resolution = builder.resolution;
        this.aspectRatio = builder.aspectRatio;
        this.maxWidth = builder.maxWidth;
        this.maxHeight = builder.maxHeight;
        this.displayAspectRatio = builder.displayAspectRatio;
        this.sizingPolicy = builder.sizingPolicy;
        this.paddingPolicy = builder.paddingPolicy;
        this.watermarks = builder.watermarks;
    }

    /**
     * <p>
     * The video codec for the output file. Valid values include <code>gif</code>, <code>H.264</code>,
     * <code>mpeg2</code>, <code>vp8</code>, and <code>vp9</code>. You can only specify <code>vp8</code> and
     * <code>vp9</code> when the container type is <code>webm</code>, <code>gif</code> when the container type is
     * <code>gif</code>, and <code>mpeg2</code> when the container type is <code>mpg</code>.
     * </p>
     * 
     * @return The video codec for the output file. Valid values include <code>gif</code>, <code>H.264</code>,
     *         <code>mpeg2</code>, <code>vp8</code>, and <code>vp9</code>. You can only specify <code>vp8</code> and
     *         <code>vp9</code> when the container type is <code>webm</code>, <code>gif</code> when the container type
     *         is <code>gif</code>, and <code>mpeg2</code> when the container type is <code>mpg</code>.
     */
    public final String codec() {
        return codec;
    }

    /**
     * Returns true if the CodecOptions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCodecOptions() {
        return codecOptions != null && !(codecOptions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * <b>Profile (H.264/VP8/VP9 Only)</b>
     * </p>
     * <p>
     * The H.264 profile that you want to use for the output file. Elastic Transcoder supports the following profiles:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>baseline</code>: The profile most commonly used for videoconferencing and for mobile applications.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>main</code>: The profile used for standard-definition digital TV broadcasts.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>high</code>: The profile used for high-definition digital TV broadcasts and for Blu-ray discs.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Level (H.264 Only)</b>
     * </p>
     * <p>
     * The H.264 level that you want to use for the output file. Elastic Transcoder supports the following levels:
     * </p>
     * <p>
     * <code>1</code>, <code>1b</code>, <code>1.1</code>, <code>1.2</code>, <code>1.3</code>, <code>2</code>,
     * <code>2.1</code>, <code>2.2</code>, <code>3</code>, <code>3.1</code>, <code>3.2</code>, <code>4</code>,
     * <code>4.1</code>
     * </p>
     * <p>
     * <b>MaxReferenceFrames (H.264 Only)</b>
     * </p>
     * <p>
     * Applicable only when the value of Video:Codec is H.264. The maximum number of previously decoded frames to use as
     * a reference for decoding future frames. Valid values are integers 0 through 16, but we recommend that you not use
     * a value greater than the following:
     * </p>
     * <p>
     * <code>Min(Floor(Maximum decoded picture buffer in macroblocks * 256 / (Width in pixels * Height in pixels)), 16)</code>
     * </p>
     * <p>
     * where <i>Width in pixels</i> and <i>Height in pixels</i> represent either MaxWidth and MaxHeight, or Resolution.
     * <i>Maximum decoded picture buffer in macroblocks</i> depends on the value of the <code>Level</code> object. See
     * the list below. (A macroblock is a block of pixels measuring 16x16.)
     * </p>
     * <ul>
     * <li>
     * <p>
     * 1 - 396
     * </p>
     * </li>
     * <li>
     * <p>
     * 1b - 396
     * </p>
     * </li>
     * <li>
     * <p>
     * 1.1 - 900
     * </p>
     * </li>
     * <li>
     * <p>
     * 1.2 - 2376
     * </p>
     * </li>
     * <li>
     * <p>
     * 1.3 - 2376
     * </p>
     * </li>
     * <li>
     * <p>
     * 2 - 2376
     * </p>
     * </li>
     * <li>
     * <p>
     * 2.1 - 4752
     * </p>
     * </li>
     * <li>
     * <p>
     * 2.2 - 8100
     * </p>
     * </li>
     * <li>
     * <p>
     * 3 - 8100
     * </p>
     * </li>
     * <li>
     * <p>
     * 3.1 - 18000
     * </p>
     * </li>
     * <li>
     * <p>
     * 3.2 - 20480
     * </p>
     * </li>
     * <li>
     * <p>
     * 4 - 32768
     * </p>
     * </li>
     * <li>
     * <p>
     * 4.1 - 32768
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>MaxBitRate (Optional, H.264/MPEG2/VP8/VP9 only)</b>
     * </p>
     * <p>
     * The maximum number of bits per second in a video buffer; the size of the buffer is specified by
     * <code>BufferSize</code>. Specify a value between 16 and 62,500. You can reduce the bandwidth required to stream a
     * video by reducing the maximum bit rate, but this also reduces the quality of the video.
     * </p>
     * <p>
     * <b>BufferSize (Optional, H.264/MPEG2/VP8/VP9 only)</b>
     * </p>
     * <p>
     * The maximum number of bits in any x seconds of the output video. This window is commonly 10 seconds, the standard
     * segment duration when you're using FMP4 or MPEG-TS for the container type of the output video. Specify an integer
     * greater than 0. If you specify <code>MaxBitRate</code> and omit <code>BufferSize</code>, Elastic Transcoder sets
     * <code>BufferSize</code> to 10 times the value of <code>MaxBitRate</code>.
     * </p>
     * <p>
     * <b>InterlacedMode (Optional, H.264/MPEG2 Only)</b>
     * </p>
     * <p>
     * The interlace mode for the output video.
     * </p>
     * <p>
     * Interlaced video is used to double the perceived frame rate for a video by interlacing two fields (one field on
     * every other line, the other field on the other lines) so that the human eye registers multiple pictures per
     * frame. Interlacing reduces the bandwidth required for transmitting a video, but can result in blurred images and
     * flickering.
     * </p>
     * <p>
     * Valid values include <code>Progressive</code> (no interlacing, top to bottom), <code>TopFirst</code> (top field
     * first), <code>BottomFirst</code> (bottom field first), and <code>Auto</code>.
     * </p>
     * <p>
     * If <code>InterlaceMode</code> is not specified, Elastic Transcoder uses <code>Progressive</code> for the output.
     * If <code>Auto</code> is specified, Elastic Transcoder interlaces the output.
     * </p>
     * <p>
     * <b>ColorSpaceConversionMode (Optional, H.264/MPEG2 Only)</b>
     * </p>
     * <p>
     * The color space conversion Elastic Transcoder applies to the output video. Color spaces are the algorithms used
     * by the computer to store information about how to render color. <code>Bt.601</code> is the standard for standard
     * definition video, while <code>Bt.709</code> is the standard for high definition video.
     * </p>
     * <p>
     * Valid values include <code>None</code>, <code>Bt709toBt601</code>, <code>Bt601toBt709</code>, and
     * <code>Auto</code>.
     * </p>
     * <p>
     * If you chose <code>Auto</code> for <code>ColorSpaceConversionMode</code> and your output is interlaced, your
     * frame rate is one of <code>23.97</code>, <code>24</code>, <code>25</code>, <code>29.97</code>, <code>50</code>,
     * or <code>60</code>, your <code>SegmentDuration</code> is null, and you are using one of the resolution changes
     * from the list below, Elastic Transcoder applies the following color space conversions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Standard to HD, 720x480 to 1920x1080</i> - Elastic Transcoder applies <code>Bt601ToBt709</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Standard to HD, 720x576 to 1920x1080</i> - Elastic Transcoder applies <code>Bt601ToBt709</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>HD to Standard, 1920x1080 to 720x480</i> - Elastic Transcoder applies <code>Bt709ToBt601</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>HD to Standard, 1920x1080 to 720x576</i> - Elastic Transcoder applies <code>Bt709ToBt601</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Elastic Transcoder may change the behavior of the <code>ColorspaceConversionMode</code> <code>Auto</code> mode in
     * the future. All outputs in a playlist must use the same <code>ColorSpaceConversionMode</code>.
     * </p>
     * </note>
     * <p>
     * If you do not specify a <code>ColorSpaceConversionMode</code>, Elastic Transcoder does not change the color space
     * of a file. If you are unsure what <code>ColorSpaceConversionMode</code> was applied to your output file, you can
     * check the <code>AppliedColorSpaceConversion</code> parameter included in your job response. If your job does not
     * have an <code>AppliedColorSpaceConversion</code> in its response, no <code>ColorSpaceConversionMode</code> was
     * applied.
     * </p>
     * <p>
     * <b>ChromaSubsampling</b>
     * </p>
     * <p>
     * The sampling pattern for the chroma (color) channels of the output video. Valid values include
     * <code>yuv420p</code> and <code>yuv422p</code>.
     * </p>
     * <p>
     * <code>yuv420p</code> samples the chroma information of every other horizontal and every other vertical line,
     * <code>yuv422p</code> samples the color information of every horizontal line and every other vertical line.
     * </p>
     * <p>
     * <b>LoopCount (Gif Only)</b>
     * </p>
     * <p>
     * The number of times you want the output gif to loop. Valid values include <code>Infinite</code> and integers
     * between <code>0</code> and <code>100</code>, inclusive.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCodecOptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return <b>Profile (H.264/VP8/VP9 Only)</b> </p>
     *         <p>
     *         The H.264 profile that you want to use for the output file. Elastic Transcoder supports the following
     *         profiles:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>baseline</code>: The profile most commonly used for videoconferencing and for mobile applications.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>main</code>: The profile used for standard-definition digital TV broadcasts.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>high</code>: The profile used for high-definition digital TV broadcasts and for Blu-ray discs.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>Level (H.264 Only)</b>
     *         </p>
     *         <p>
     *         The H.264 level that you want to use for the output file. Elastic Transcoder supports the following
     *         levels:
     *         </p>
     *         <p>
     *         <code>1</code>, <code>1b</code>, <code>1.1</code>, <code>1.2</code>, <code>1.3</code>, <code>2</code>,
     *         <code>2.1</code>, <code>2.2</code>, <code>3</code>, <code>3.1</code>, <code>3.2</code>, <code>4</code>,
     *         <code>4.1</code>
     *         </p>
     *         <p>
     *         <b>MaxReferenceFrames (H.264 Only)</b>
     *         </p>
     *         <p>
     *         Applicable only when the value of Video:Codec is H.264. The maximum number of previously decoded frames
     *         to use as a reference for decoding future frames. Valid values are integers 0 through 16, but we
     *         recommend that you not use a value greater than the following:
     *         </p>
     *         <p>
     *         <code>Min(Floor(Maximum decoded picture buffer in macroblocks * 256 / (Width in pixels * Height in pixels)), 16)</code>
     *         </p>
     *         <p>
     *         where <i>Width in pixels</i> and <i>Height in pixels</i> represent either MaxWidth and MaxHeight, or
     *         Resolution. <i>Maximum decoded picture buffer in macroblocks</i> depends on the value of the
     *         <code>Level</code> object. See the list below. (A macroblock is a block of pixels measuring 16x16.)
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         1 - 396
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1b - 396
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1.1 - 900
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1.2 - 2376
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1.3 - 2376
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         2 - 2376
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         2.1 - 4752
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         2.2 - 8100
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         3 - 8100
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         3.1 - 18000
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         3.2 - 20480
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         4 - 32768
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         4.1 - 32768
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <b>MaxBitRate (Optional, H.264/MPEG2/VP8/VP9 only)</b>
     *         </p>
     *         <p>
     *         The maximum number of bits per second in a video buffer; the size of the buffer is specified by
     *         <code>BufferSize</code>. Specify a value between 16 and 62,500. You can reduce the bandwidth required to
     *         stream a video by reducing the maximum bit rate, but this also reduces the quality of the video.
     *         </p>
     *         <p>
     *         <b>BufferSize (Optional, H.264/MPEG2/VP8/VP9 only)</b>
     *         </p>
     *         <p>
     *         The maximum number of bits in any x seconds of the output video. This window is commonly 10 seconds, the
     *         standard segment duration when you're using FMP4 or MPEG-TS for the container type of the output video.
     *         Specify an integer greater than 0. If you specify <code>MaxBitRate</code> and omit
     *         <code>BufferSize</code>, Elastic Transcoder sets <code>BufferSize</code> to 10 times the value of
     *         <code>MaxBitRate</code>.
     *         </p>
     *         <p>
     *         <b>InterlacedMode (Optional, H.264/MPEG2 Only)</b>
     *         </p>
     *         <p>
     *         The interlace mode for the output video.
     *         </p>
     *         <p>
     *         Interlaced video is used to double the perceived frame rate for a video by interlacing two fields (one
     *         field on every other line, the other field on the other lines) so that the human eye registers multiple
     *         pictures per frame. Interlacing reduces the bandwidth required for transmitting a video, but can result
     *         in blurred images and flickering.
     *         </p>
     *         <p>
     *         Valid values include <code>Progressive</code> (no interlacing, top to bottom), <code>TopFirst</code> (top
     *         field first), <code>BottomFirst</code> (bottom field first), and <code>Auto</code>.
     *         </p>
     *         <p>
     *         If <code>InterlaceMode</code> is not specified, Elastic Transcoder uses <code>Progressive</code> for the
     *         output. If <code>Auto</code> is specified, Elastic Transcoder interlaces the output.
     *         </p>
     *         <p>
     *         <b>ColorSpaceConversionMode (Optional, H.264/MPEG2 Only)</b>
     *         </p>
     *         <p>
     *         The color space conversion Elastic Transcoder applies to the output video. Color spaces are the
     *         algorithms used by the computer to store information about how to render color. <code>Bt.601</code> is
     *         the standard for standard definition video, while <code>Bt.709</code> is the standard for high definition
     *         video.
     *         </p>
     *         <p>
     *         Valid values include <code>None</code>, <code>Bt709toBt601</code>, <code>Bt601toBt709</code>, and
     *         <code>Auto</code>.
     *         </p>
     *         <p>
     *         If you chose <code>Auto</code> for <code>ColorSpaceConversionMode</code> and your output is interlaced,
     *         your frame rate is one of <code>23.97</code>, <code>24</code>, <code>25</code>, <code>29.97</code>,
     *         <code>50</code>, or <code>60</code>, your <code>SegmentDuration</code> is null, and you are using one of
     *         the resolution changes from the list below, Elastic Transcoder applies the following color space
     *         conversions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>Standard to HD, 720x480 to 1920x1080</i> - Elastic Transcoder applies <code>Bt601ToBt709</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Standard to HD, 720x576 to 1920x1080</i> - Elastic Transcoder applies <code>Bt601ToBt709</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>HD to Standard, 1920x1080 to 720x480</i> - Elastic Transcoder applies <code>Bt709ToBt601</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>HD to Standard, 1920x1080 to 720x576</i> - Elastic Transcoder applies <code>Bt709ToBt601</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         Elastic Transcoder may change the behavior of the <code>ColorspaceConversionMode</code> <code>Auto</code>
     *         mode in the future. All outputs in a playlist must use the same <code>ColorSpaceConversionMode</code>.
     *         </p>
     *         </note>
     *         <p>
     *         If you do not specify a <code>ColorSpaceConversionMode</code>, Elastic Transcoder does not change the
     *         color space of a file. If you are unsure what <code>ColorSpaceConversionMode</code> was applied to your
     *         output file, you can check the <code>AppliedColorSpaceConversion</code> parameter included in your job
     *         response. If your job does not have an <code>AppliedColorSpaceConversion</code> in its response, no
     *         <code>ColorSpaceConversionMode</code> was applied.
     *         </p>
     *         <p>
     *         <b>ChromaSubsampling</b>
     *         </p>
     *         <p>
     *         The sampling pattern for the chroma (color) channels of the output video. Valid values include
     *         <code>yuv420p</code> and <code>yuv422p</code>.
     *         </p>
     *         <p>
     *         <code>yuv420p</code> samples the chroma information of every other horizontal and every other vertical
     *         line, <code>yuv422p</code> samples the color information of every horizontal line and every other
     *         vertical line.
     *         </p>
     *         <p>
     *         <b>LoopCount (Gif Only)</b>
     *         </p>
     *         <p>
     *         The number of times you want the output gif to loop. Valid values include <code>Infinite</code> and
     *         integers between <code>0</code> and <code>100</code>, inclusive.
     */
    public final Map<String, String> codecOptions() {
        return codecOptions;
    }

    /**
     * <p>
     * Applicable only when the value of Video:Codec is one of <code>H.264</code>, <code>MPEG2</code>, or
     * <code>VP8</code>.
     * </p>
     * <p>
     * The maximum number of frames between key frames. Key frames are fully encoded frames; the frames between key
     * frames are encoded based, in part, on the content of the key frames. The value is an integer formatted as a
     * string; valid values are between 1 (every frame is a key frame) and 100000, inclusive. A higher value results in
     * higher compression but may also discernibly decrease video quality.
     * </p>
     * <p>
     * For <code>Smooth</code> outputs, the <code>FrameRate</code> must have a constant ratio to the
     * <code>KeyframesMaxDist</code>. This allows <code>Smooth</code> playlists to switch between different quality
     * levels while the file is being played.
     * </p>
     * <p>
     * For example, an input file can have a <code>FrameRate</code> of 30 with a <code>KeyframesMaxDist</code> of 90.
     * The output file then needs to have a ratio of 1:3. Valid outputs would have <code>FrameRate</code> of 30, 25, and
     * 10, and <code>KeyframesMaxDist</code> of 90, 75, and 30, respectively.
     * </p>
     * <p>
     * Alternately, this can be achieved by setting <code>FrameRate</code> to auto and having the same values for
     * <code>MaxFrameRate</code> and <code>KeyframesMaxDist</code>.
     * </p>
     * 
     * @return Applicable only when the value of Video:Codec is one of <code>H.264</code>, <code>MPEG2</code>, or
     *         <code>VP8</code>.</p>
     *         <p>
     *         The maximum number of frames between key frames. Key frames are fully encoded frames; the frames between
     *         key frames are encoded based, in part, on the content of the key frames. The value is an integer
     *         formatted as a string; valid values are between 1 (every frame is a key frame) and 100000, inclusive. A
     *         higher value results in higher compression but may also discernibly decrease video quality.
     *         </p>
     *         <p>
     *         For <code>Smooth</code> outputs, the <code>FrameRate</code> must have a constant ratio to the
     *         <code>KeyframesMaxDist</code>. This allows <code>Smooth</code> playlists to switch between different
     *         quality levels while the file is being played.
     *         </p>
     *         <p>
     *         For example, an input file can have a <code>FrameRate</code> of 30 with a <code>KeyframesMaxDist</code>
     *         of 90. The output file then needs to have a ratio of 1:3. Valid outputs would have <code>FrameRate</code>
     *         of 30, 25, and 10, and <code>KeyframesMaxDist</code> of 90, 75, and 30, respectively.
     *         </p>
     *         <p>
     *         Alternately, this can be achieved by setting <code>FrameRate</code> to auto and having the same values
     *         for <code>MaxFrameRate</code> and <code>KeyframesMaxDist</code>.
     */
    public final String keyframesMaxDist() {
        return keyframesMaxDist;
    }

    /**
     * <p>
     * Applicable only when the value of Video:Codec is one of <code>H.264</code>, <code>MPEG2</code>, or
     * <code>VP8</code>.
     * </p>
     * <p>
     * Whether to use a fixed value for <code>FixedGOP</code>. Valid values are <code>true</code> and <code>false</code>
     * :
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>true</code>: Elastic Transcoder uses the value of <code>KeyframesMaxDist</code> for the distance between
     * key frames (the number of frames in a group of pictures, or GOP).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>false</code>: The distance between key frames can vary.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * <code>FixedGOP</code> must be set to <code>true</code> for <code>fmp4</code> containers.
     * </p>
     * </important>
     * 
     * @return Applicable only when the value of Video:Codec is one of <code>H.264</code>, <code>MPEG2</code>, or
     *         <code>VP8</code>.</p>
     *         <p>
     *         Whether to use a fixed value for <code>FixedGOP</code>. Valid values are <code>true</code> and
     *         <code>false</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>true</code>: Elastic Transcoder uses the value of <code>KeyframesMaxDist</code> for the distance
     *         between key frames (the number of frames in a group of pictures, or GOP).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>false</code>: The distance between key frames can vary.
     *         </p>
     *         </li>
     *         </ul>
     *         <important>
     *         <p>
     *         <code>FixedGOP</code> must be set to <code>true</code> for <code>fmp4</code> containers.
     *         </p>
     */
    public final String fixedGOP() {
        return fixedGOP;
    }

    /**
     * <p>
     * The bit rate of the video stream in the output file, in kilobits/second. Valid values depend on the values of
     * <code>Level</code> and <code>Profile</code>. If you specify <code>auto</code>, Elastic Transcoder uses the
     * detected bit rate of the input source. If you specify a value other than <code>auto</code>, we recommend that you
     * specify a value less than or equal to the maximum H.264-compliant value listed for your level and profile:
     * </p>
     * <p>
     * <i>Level - Maximum video bit rate in kilobits/second (baseline and main Profile) : maximum video bit rate in
     * kilobits/second (high Profile)</i>
     * </p>
     * <ul>
     * <li>
     * <p>
     * 1 - 64 : 80
     * </p>
     * </li>
     * <li>
     * <p>
     * 1b - 128 : 160
     * </p>
     * </li>
     * <li>
     * <p>
     * 1.1 - 192 : 240
     * </p>
     * </li>
     * <li>
     * <p>
     * 1.2 - 384 : 480
     * </p>
     * </li>
     * <li>
     * <p>
     * 1.3 - 768 : 960
     * </p>
     * </li>
     * <li>
     * <p>
     * 2 - 2000 : 2500
     * </p>
     * </li>
     * <li>
     * <p>
     * 3 - 10000 : 12500
     * </p>
     * </li>
     * <li>
     * <p>
     * 3.1 - 14000 : 17500
     * </p>
     * </li>
     * <li>
     * <p>
     * 3.2 - 20000 : 25000
     * </p>
     * </li>
     * <li>
     * <p>
     * 4 - 20000 : 25000
     * </p>
     * </li>
     * <li>
     * <p>
     * 4.1 - 50000 : 62500
     * </p>
     * </li>
     * </ul>
     * 
     * @return The bit rate of the video stream in the output file, in kilobits/second. Valid values depend on the
     *         values of <code>Level</code> and <code>Profile</code>. If you specify <code>auto</code>, Elastic
     *         Transcoder uses the detected bit rate of the input source. If you specify a value other than
     *         <code>auto</code>, we recommend that you specify a value less than or equal to the maximum
     *         H.264-compliant value listed for your level and profile:</p>
     *         <p>
     *         <i>Level - Maximum video bit rate in kilobits/second (baseline and main Profile) : maximum video bit rate
     *         in kilobits/second (high Profile)</i>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         1 - 64 : 80
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1b - 128 : 160
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1.1 - 192 : 240
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1.2 - 384 : 480
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1.3 - 768 : 960
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         2 - 2000 : 2500
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         3 - 10000 : 12500
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         3.1 - 14000 : 17500
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         3.2 - 20000 : 25000
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         4 - 20000 : 25000
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         4.1 - 50000 : 62500
     *         </p>
     *         </li>
     */
    public final String bitRate() {
        return bitRate;
    }

    /**
     * <p>
     * The frames per second for the video stream in the output file. Valid values include:
     * </p>
     * <p>
     * <code>auto</code>, <code>10</code>, <code>15</code>, <code>23.97</code>, <code>24</code>, <code>25</code>,
     * <code>29.97</code>, <code>30</code>, <code>60</code>
     * </p>
     * <p>
     * If you specify <code>auto</code>, Elastic Transcoder uses the detected frame rate of the input source. If you
     * specify a frame rate, we recommend that you perform the following calculation:
     * </p>
     * <p>
     * <code>Frame rate = maximum recommended decoding speed in luma samples/second / (width in pixels * height in pixels)</code>
     * </p>
     * <p>
     * where:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>width in pixels</i> and <i>height in pixels</i> represent the Resolution of the output video.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>maximum recommended decoding speed in Luma samples/second</i> is less than or equal to the maximum value
     * listed in the following table, based on the value that you specified for Level.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The maximum recommended decoding speed in Luma samples/second for each level is described in the following list
     * (<i>Level - Decoding speed</i>):
     * </p>
     * <ul>
     * <li>
     * <p>
     * 1 - 380160
     * </p>
     * </li>
     * <li>
     * <p>
     * 1b - 380160
     * </p>
     * </li>
     * <li>
     * <p>
     * 1.1 - 76800
     * </p>
     * </li>
     * <li>
     * <p>
     * 1.2 - 1536000
     * </p>
     * </li>
     * <li>
     * <p>
     * 1.3 - 3041280
     * </p>
     * </li>
     * <li>
     * <p>
     * 2 - 3041280
     * </p>
     * </li>
     * <li>
     * <p>
     * 2.1 - 5068800
     * </p>
     * </li>
     * <li>
     * <p>
     * 2.2 - 5184000
     * </p>
     * </li>
     * <li>
     * <p>
     * 3 - 10368000
     * </p>
     * </li>
     * <li>
     * <p>
     * 3.1 - 27648000
     * </p>
     * </li>
     * <li>
     * <p>
     * 3.2 - 55296000
     * </p>
     * </li>
     * <li>
     * <p>
     * 4 - 62914560
     * </p>
     * </li>
     * <li>
     * <p>
     * 4.1 - 62914560
     * </p>
     * </li>
     * </ul>
     * 
     * @return The frames per second for the video stream in the output file. Valid values include:</p>
     *         <p>
     *         <code>auto</code>, <code>10</code>, <code>15</code>, <code>23.97</code>, <code>24</code>, <code>25</code>, <code>29.97</code>, <code>30</code>, <code>60</code>
     *         </p>
     *         <p>
     *         If you specify <code>auto</code>, Elastic Transcoder uses the detected frame rate of the input source. If
     *         you specify a frame rate, we recommend that you perform the following calculation:
     *         </p>
     *         <p>
     *         <code>Frame rate = maximum recommended decoding speed in luma samples/second / (width in pixels * height in pixels)</code>
     *         </p>
     *         <p>
     *         where:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>width in pixels</i> and <i>height in pixels</i> represent the Resolution of the output video.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>maximum recommended decoding speed in Luma samples/second</i> is less than or equal to the maximum
     *         value listed in the following table, based on the value that you specified for Level.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The maximum recommended decoding speed in Luma samples/second for each level is described in the
     *         following list (<i>Level - Decoding speed</i>):
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         1 - 380160
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1b - 380160
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1.1 - 76800
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1.2 - 1536000
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1.3 - 3041280
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         2 - 3041280
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         2.1 - 5068800
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         2.2 - 5184000
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         3 - 10368000
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         3.1 - 27648000
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         3.2 - 55296000
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         4 - 62914560
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         4.1 - 62914560
     *         </p>
     *         </li>
     */
    public final String frameRate() {
        return frameRate;
    }

    /**
     * <p>
     * If you specify <code>auto</code> for <code>FrameRate</code>, Elastic Transcoder uses the frame rate of the input
     * video for the frame rate of the output video. Specify the maximum frame rate that you want Elastic Transcoder to
     * use when the frame rate of the input video is greater than the desired maximum frame rate of the output video.
     * Valid values include: <code>10</code>, <code>15</code>, <code>23.97</code>, <code>24</code>, <code>25</code>,
     * <code>29.97</code>, <code>30</code>, <code>60</code>.
     * </p>
     * 
     * @return If you specify <code>auto</code> for <code>FrameRate</code>, Elastic Transcoder uses the frame rate of
     *         the input video for the frame rate of the output video. Specify the maximum frame rate that you want
     *         Elastic Transcoder to use when the frame rate of the input video is greater than the desired maximum
     *         frame rate of the output video. Valid values include: <code>10</code>, <code>15</code>,
     *         <code>23.97</code>, <code>24</code>, <code>25</code>, <code>29.97</code>, <code>30</code>,
     *         <code>60</code>.
     */
    public final String maxFrameRate() {
        return maxFrameRate;
    }

    /**
     * <important>
     * <p>
     * To better control resolution and aspect ratio of output videos, we recommend that you use the values
     * <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, <code>PaddingPolicy</code>, and
     * <code>DisplayAspectRatio</code> instead of <code>Resolution</code> and <code>AspectRatio</code>. The two groups
     * of settings are mutually exclusive. Do not use them together.
     * </p>
     * </important>
     * <p>
     * The width and height of the video in the output file, in pixels. Valid values are <code>auto</code> and
     * <i>width</i> x <i>height</i>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>auto</code>: Elastic Transcoder attempts to preserve the width and height of the input file, subject to the
     * following rules.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code> <i>width</i> x <i>height</i> </code>: The width and height of the output video in pixels.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note the following about specifying the width and height:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The width must be an even integer between 128 and 4096, inclusive.
     * </p>
     * </li>
     * <li>
     * <p>
     * The height must be an even integer between 96 and 3072, inclusive.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify a resolution that is less than the resolution of the input file, Elastic Transcoder rescales the
     * output file to the lower resolution.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify a resolution that is greater than the resolution of the input file, Elastic Transcoder rescales
     * the output to the higher resolution.
     * </p>
     * </li>
     * <li>
     * <p>
     * We recommend that you specify a resolution for which the product of width and height is less than or equal to the
     * applicable value in the following list (<i>List - Max width x height value</i>):
     * </p>
     * <ul>
     * <li>
     * <p>
     * 1 - 25344
     * </p>
     * </li>
     * <li>
     * <p>
     * 1b - 25344
     * </p>
     * </li>
     * <li>
     * <p>
     * 1.1 - 101376
     * </p>
     * </li>
     * <li>
     * <p>
     * 1.2 - 101376
     * </p>
     * </li>
     * <li>
     * <p>
     * 1.3 - 101376
     * </p>
     * </li>
     * <li>
     * <p>
     * 2 - 101376
     * </p>
     * </li>
     * <li>
     * <p>
     * 2.1 - 202752
     * </p>
     * </li>
     * <li>
     * <p>
     * 2.2 - 404720
     * </p>
     * </li>
     * <li>
     * <p>
     * 3 - 404720
     * </p>
     * </li>
     * <li>
     * <p>
     * 3.1 - 921600
     * </p>
     * </li>
     * <li>
     * <p>
     * 3.2 - 1310720
     * </p>
     * </li>
     * <li>
     * <p>
     * 4 - 2097152
     * </p>
     * </li>
     * <li>
     * <p>
     * 4.1 - 2097152
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @return <p>
     *         To better control resolution and aspect ratio of output videos, we recommend that you use the values
     *         <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, <code>PaddingPolicy</code>, and
     *         <code>DisplayAspectRatio</code> instead of <code>Resolution</code> and <code>AspectRatio</code>. The two
     *         groups of settings are mutually exclusive. Do not use them together.
     *         </p>
     *         </important>
     *         <p>
     *         The width and height of the video in the output file, in pixels. Valid values are <code>auto</code> and
     *         <i>width</i> x <i>height</i>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>auto</code>: Elastic Transcoder attempts to preserve the width and height of the input file,
     *         subject to the following rules.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code> <i>width</i> x <i>height</i> </code>: The width and height of the output video in pixels.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Note the following about specifying the width and height:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The width must be an even integer between 128 and 4096, inclusive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The height must be an even integer between 96 and 3072, inclusive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify a resolution that is less than the resolution of the input file, Elastic Transcoder
     *         rescales the output file to the lower resolution.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you specify a resolution that is greater than the resolution of the input file, Elastic Transcoder
     *         rescales the output to the higher resolution.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         We recommend that you specify a resolution for which the product of width and height is less than or
     *         equal to the applicable value in the following list (<i>List - Max width x height value</i>):
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         1 - 25344
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1b - 25344
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1.1 - 101376
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1.2 - 101376
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1.3 - 101376
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         2 - 101376
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         2.1 - 202752
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         2.2 - 404720
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         3 - 404720
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         3.1 - 921600
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         3.2 - 1310720
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         4 - 2097152
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         4.1 - 2097152
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final String resolution() {
        return resolution;
    }

    /**
     * <important>
     * <p>
     * To better control resolution and aspect ratio of output videos, we recommend that you use the values
     * <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, <code>PaddingPolicy</code>, and
     * <code>DisplayAspectRatio</code> instead of <code>Resolution</code> and <code>AspectRatio</code>. The two groups
     * of settings are mutually exclusive. Do not use them together.
     * </p>
     * </important>
     * <p>
     * The display aspect ratio of the video in the output file. Valid values include:
     * </p>
     * <p>
     * <code>auto</code>, <code>1:1</code>, <code>4:3</code>, <code>3:2</code>, <code>16:9</code>
     * </p>
     * <p>
     * If you specify <code>auto</code>, Elastic Transcoder tries to preserve the aspect ratio of the input file.
     * </p>
     * <p>
     * If you specify an aspect ratio for the output file that differs from aspect ratio of the input file, Elastic
     * Transcoder adds pillarboxing (black bars on the sides) or letterboxing (black bars on the top and bottom) to
     * maintain the aspect ratio of the active region of the video.
     * </p>
     * 
     * @return <p>
     *         To better control resolution and aspect ratio of output videos, we recommend that you use the values
     *         <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, <code>PaddingPolicy</code>, and
     *         <code>DisplayAspectRatio</code> instead of <code>Resolution</code> and <code>AspectRatio</code>. The two
     *         groups of settings are mutually exclusive. Do not use them together.
     *         </p>
     *         </important>
     *         <p>
     *         The display aspect ratio of the video in the output file. Valid values include:
     *         </p>
     *         <p>
     *         <code>auto</code>, <code>1:1</code>, <code>4:3</code>, <code>3:2</code>, <code>16:9</code>
     *         </p>
     *         <p>
     *         If you specify <code>auto</code>, Elastic Transcoder tries to preserve the aspect ratio of the input
     *         file.
     *         </p>
     *         <p>
     *         If you specify an aspect ratio for the output file that differs from aspect ratio of the input file,
     *         Elastic Transcoder adds pillarboxing (black bars on the sides) or letterboxing (black bars on the top and
     *         bottom) to maintain the aspect ratio of the active region of the video.
     */
    public final String aspectRatio() {
        return aspectRatio;
    }

    /**
     * <p>
     * The maximum width of the output video in pixels. If you specify <code>auto</code>, Elastic Transcoder uses 1920
     * (Full HD) as the default value. If you specify a numeric value, enter an even integer between 128 and 4096.
     * </p>
     * 
     * @return The maximum width of the output video in pixels. If you specify <code>auto</code>, Elastic Transcoder
     *         uses 1920 (Full HD) as the default value. If you specify a numeric value, enter an even integer between
     *         128 and 4096.
     */
    public final String maxWidth() {
        return maxWidth;
    }

    /**
     * <p>
     * The maximum height of the output video in pixels. If you specify <code>auto</code>, Elastic Transcoder uses 1080
     * (Full HD) as the default value. If you specify a numeric value, enter an even integer between 96 and 3072.
     * </p>
     * 
     * @return The maximum height of the output video in pixels. If you specify <code>auto</code>, Elastic Transcoder
     *         uses 1080 (Full HD) as the default value. If you specify a numeric value, enter an even integer between
     *         96 and 3072.
     */
    public final String maxHeight() {
        return maxHeight;
    }

    /**
     * <p>
     * The value that Elastic Transcoder adds to the metadata in the output file.
     * </p>
     * 
     * @return The value that Elastic Transcoder adds to the metadata in the output file.
     */
    public final String displayAspectRatio() {
        return displayAspectRatio;
    }

    /**
     * <p>
     * Specify one of the following values to control scaling of the output video:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Fit</code>: Elastic Transcoder scales the output video so it matches the value that you specified in either
     * <code>MaxWidth</code> or <code>MaxHeight</code> without exceeding the other value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Fill</code>: Elastic Transcoder scales the output video so it matches the value that you specified in
     * either <code>MaxWidth</code> or <code>MaxHeight</code> and matches or exceeds the other value. Elastic Transcoder
     * centers the output video and then crops it in the dimension (if any) that exceeds the maximum value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Stretch</code>: Elastic Transcoder stretches the output video to match the values that you specified for
     * <code>MaxWidth</code> and <code>MaxHeight</code>. If the relative proportions of the input video and the output
     * video are different, the output video will be distorted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Keep</code>: Elastic Transcoder does not scale the output video. If either dimension of the input video
     * exceeds the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>, Elastic Transcoder
     * crops the output video.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ShrinkToFit</code>: Elastic Transcoder scales the output video down so that its dimensions match the values
     * that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without exceeding either
     * value. If you specify this option, Elastic Transcoder does not scale the video up.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ShrinkToFill</code>: Elastic Transcoder scales the output video down so that its dimensions match the
     * values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without dropping
     * below either value. If you specify this option, Elastic Transcoder does not scale the video up.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specify one of the following values to control scaling of the output video:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Fit</code>: Elastic Transcoder scales the output video so it matches the value that you specified
     *         in either <code>MaxWidth</code> or <code>MaxHeight</code> without exceeding the other value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Fill</code>: Elastic Transcoder scales the output video so it matches the value that you specified
     *         in either <code>MaxWidth</code> or <code>MaxHeight</code> and matches or exceeds the other value. Elastic
     *         Transcoder centers the output video and then crops it in the dimension (if any) that exceeds the maximum
     *         value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Stretch</code>: Elastic Transcoder stretches the output video to match the values that you
     *         specified for <code>MaxWidth</code> and <code>MaxHeight</code>. If the relative proportions of the input
     *         video and the output video are different, the output video will be distorted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Keep</code>: Elastic Transcoder does not scale the output video. If either dimension of the input
     *         video exceeds the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>, Elastic
     *         Transcoder crops the output video.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ShrinkToFit</code>: Elastic Transcoder scales the output video down so that its dimensions match
     *         the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code>
     *         without exceeding either value. If you specify this option, Elastic Transcoder does not scale the video
     *         up.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ShrinkToFill</code>: Elastic Transcoder scales the output video down so that its dimensions match
     *         the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code>
     *         without dropping below either value. If you specify this option, Elastic Transcoder does not scale the
     *         video up.
     *         </p>
     *         </li>
     */
    public final String sizingPolicy() {
        return sizingPolicy;
    }

    /**
     * <p>
     * When you set <code>PaddingPolicy</code> to <code>Pad</code>, Elastic Transcoder may add black bars to the top and
     * bottom and/or left and right sides of the output video to make the total size of the output video match the
     * values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>.
     * </p>
     * 
     * @return When you set <code>PaddingPolicy</code> to <code>Pad</code>, Elastic Transcoder may add black bars to the
     *         top and bottom and/or left and right sides of the output video to make the total size of the output video
     *         match the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>.
     */
    public final String paddingPolicy() {
        return paddingPolicy;
    }

    /**
     * Returns true if the Watermarks property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasWatermarks() {
        return watermarks != null && !(watermarks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Settings for the size, location, and opacity of graphics that you want Elastic Transcoder to overlay over videos
     * that are transcoded using this preset. You can specify settings for up to four watermarks. Watermarks appear in
     * the specified size and location, and with the specified opacity for the duration of the transcoded video.
     * </p>
     * <p>
     * Watermarks can be in .png or .jpg format. If you want to display a watermark that is not rectangular, use the
     * .png format, which supports transparency.
     * </p>
     * <p>
     * When you create a job that uses this preset, you specify the .png or .jpg graphics that you want Elastic
     * Transcoder to include in the transcoded videos. You can specify fewer graphics in the job than you specify
     * watermark settings in the preset, which allows you to use the same preset for up to four watermarks that have
     * different dimensions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWatermarks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Settings for the size, location, and opacity of graphics that you want Elastic Transcoder to overlay over
     *         videos that are transcoded using this preset. You can specify settings for up to four watermarks.
     *         Watermarks appear in the specified size and location, and with the specified opacity for the duration of
     *         the transcoded video.</p>
     *         <p>
     *         Watermarks can be in .png or .jpg format. If you want to display a watermark that is not rectangular, use
     *         the .png format, which supports transparency.
     *         </p>
     *         <p>
     *         When you create a job that uses this preset, you specify the .png or .jpg graphics that you want Elastic
     *         Transcoder to include in the transcoded videos. You can specify fewer graphics in the job than you
     *         specify watermark settings in the preset, which allows you to use the same preset for up to four
     *         watermarks that have different dimensions.
     */
    public final List<PresetWatermark> watermarks() {
        return watermarks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codec());
        hashCode = 31 * hashCode + Objects.hashCode(hasCodecOptions() ? codecOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(keyframesMaxDist());
        hashCode = 31 * hashCode + Objects.hashCode(fixedGOP());
        hashCode = 31 * hashCode + Objects.hashCode(bitRate());
        hashCode = 31 * hashCode + Objects.hashCode(frameRate());
        hashCode = 31 * hashCode + Objects.hashCode(maxFrameRate());
        hashCode = 31 * hashCode + Objects.hashCode(resolution());
        hashCode = 31 * hashCode + Objects.hashCode(aspectRatio());
        hashCode = 31 * hashCode + Objects.hashCode(maxWidth());
        hashCode = 31 * hashCode + Objects.hashCode(maxHeight());
        hashCode = 31 * hashCode + Objects.hashCode(displayAspectRatio());
        hashCode = 31 * hashCode + Objects.hashCode(sizingPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(paddingPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(hasWatermarks() ? watermarks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoParameters)) {
            return false;
        }
        VideoParameters other = (VideoParameters) obj;
        return Objects.equals(codec(), other.codec()) && hasCodecOptions() == other.hasCodecOptions()
                && Objects.equals(codecOptions(), other.codecOptions())
                && Objects.equals(keyframesMaxDist(), other.keyframesMaxDist()) && Objects.equals(fixedGOP(), other.fixedGOP())
                && Objects.equals(bitRate(), other.bitRate()) && Objects.equals(frameRate(), other.frameRate())
                && Objects.equals(maxFrameRate(), other.maxFrameRate()) && Objects.equals(resolution(), other.resolution())
                && Objects.equals(aspectRatio(), other.aspectRatio()) && Objects.equals(maxWidth(), other.maxWidth())
                && Objects.equals(maxHeight(), other.maxHeight())
                && Objects.equals(displayAspectRatio(), other.displayAspectRatio())
                && Objects.equals(sizingPolicy(), other.sizingPolicy()) && Objects.equals(paddingPolicy(), other.paddingPolicy())
                && hasWatermarks() == other.hasWatermarks() && Objects.equals(watermarks(), other.watermarks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VideoParameters").add("Codec", codec())
                .add("CodecOptions", hasCodecOptions() ? codecOptions() : null).add("KeyframesMaxDist", keyframesMaxDist())
                .add("FixedGOP", fixedGOP()).add("BitRate", bitRate()).add("FrameRate", frameRate())
                .add("MaxFrameRate", maxFrameRate()).add("Resolution", resolution()).add("AspectRatio", aspectRatio())
                .add("MaxWidth", maxWidth()).add("MaxHeight", maxHeight()).add("DisplayAspectRatio", displayAspectRatio())
                .add("SizingPolicy", sizingPolicy()).add("PaddingPolicy", paddingPolicy())
                .add("Watermarks", hasWatermarks() ? watermarks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Codec":
            return Optional.ofNullable(clazz.cast(codec()));
        case "CodecOptions":
            return Optional.ofNullable(clazz.cast(codecOptions()));
        case "KeyframesMaxDist":
            return Optional.ofNullable(clazz.cast(keyframesMaxDist()));
        case "FixedGOP":
            return Optional.ofNullable(clazz.cast(fixedGOP()));
        case "BitRate":
            return Optional.ofNullable(clazz.cast(bitRate()));
        case "FrameRate":
            return Optional.ofNullable(clazz.cast(frameRate()));
        case "MaxFrameRate":
            return Optional.ofNullable(clazz.cast(maxFrameRate()));
        case "Resolution":
            return Optional.ofNullable(clazz.cast(resolution()));
        case "AspectRatio":
            return Optional.ofNullable(clazz.cast(aspectRatio()));
        case "MaxWidth":
            return Optional.ofNullable(clazz.cast(maxWidth()));
        case "MaxHeight":
            return Optional.ofNullable(clazz.cast(maxHeight()));
        case "DisplayAspectRatio":
            return Optional.ofNullable(clazz.cast(displayAspectRatio()));
        case "SizingPolicy":
            return Optional.ofNullable(clazz.cast(sizingPolicy()));
        case "PaddingPolicy":
            return Optional.ofNullable(clazz.cast(paddingPolicy()));
        case "Watermarks":
            return Optional.ofNullable(clazz.cast(watermarks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VideoParameters, T> g) {
        return obj -> g.apply((VideoParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoParameters> {
        /**
         * <p>
         * The video codec for the output file. Valid values include <code>gif</code>, <code>H.264</code>,
         * <code>mpeg2</code>, <code>vp8</code>, and <code>vp9</code>. You can only specify <code>vp8</code> and
         * <code>vp9</code> when the container type is <code>webm</code>, <code>gif</code> when the container type is
         * <code>gif</code>, and <code>mpeg2</code> when the container type is <code>mpg</code>.
         * </p>
         * 
         * @param codec
         *        The video codec for the output file. Valid values include <code>gif</code>, <code>H.264</code>,
         *        <code>mpeg2</code>, <code>vp8</code>, and <code>vp9</code>. You can only specify <code>vp8</code> and
         *        <code>vp9</code> when the container type is <code>webm</code>, <code>gif</code> when the container
         *        type is <code>gif</code>, and <code>mpeg2</code> when the container type is <code>mpg</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codec(String codec);

        /**
         * <p>
         * <b>Profile (H.264/VP8/VP9 Only)</b>
         * </p>
         * <p>
         * The H.264 profile that you want to use for the output file. Elastic Transcoder supports the following
         * profiles:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>baseline</code>: The profile most commonly used for videoconferencing and for mobile applications.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>main</code>: The profile used for standard-definition digital TV broadcasts.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>high</code>: The profile used for high-definition digital TV broadcasts and for Blu-ray discs.
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>Level (H.264 Only)</b>
         * </p>
         * <p>
         * The H.264 level that you want to use for the output file. Elastic Transcoder supports the following levels:
         * </p>
         * <p>
         * <code>1</code>, <code>1b</code>, <code>1.1</code>, <code>1.2</code>, <code>1.3</code>, <code>2</code>,
         * <code>2.1</code>, <code>2.2</code>, <code>3</code>, <code>3.1</code>, <code>3.2</code>, <code>4</code>,
         * <code>4.1</code>
         * </p>
         * <p>
         * <b>MaxReferenceFrames (H.264 Only)</b>
         * </p>
         * <p>
         * Applicable only when the value of Video:Codec is H.264. The maximum number of previously decoded frames to
         * use as a reference for decoding future frames. Valid values are integers 0 through 16, but we recommend that
         * you not use a value greater than the following:
         * </p>
         * <p>
         * <code>Min(Floor(Maximum decoded picture buffer in macroblocks * 256 / (Width in pixels * Height in pixels)), 16)</code>
         * </p>
         * <p>
         * where <i>Width in pixels</i> and <i>Height in pixels</i> represent either MaxWidth and MaxHeight, or
         * Resolution. <i>Maximum decoded picture buffer in macroblocks</i> depends on the value of the
         * <code>Level</code> object. See the list below. (A macroblock is a block of pixels measuring 16x16.)
         * </p>
         * <ul>
         * <li>
         * <p>
         * 1 - 396
         * </p>
         * </li>
         * <li>
         * <p>
         * 1b - 396
         * </p>
         * </li>
         * <li>
         * <p>
         * 1.1 - 900
         * </p>
         * </li>
         * <li>
         * <p>
         * 1.2 - 2376
         * </p>
         * </li>
         * <li>
         * <p>
         * 1.3 - 2376
         * </p>
         * </li>
         * <li>
         * <p>
         * 2 - 2376
         * </p>
         * </li>
         * <li>
         * <p>
         * 2.1 - 4752
         * </p>
         * </li>
         * <li>
         * <p>
         * 2.2 - 8100
         * </p>
         * </li>
         * <li>
         * <p>
         * 3 - 8100
         * </p>
         * </li>
         * <li>
         * <p>
         * 3.1 - 18000
         * </p>
         * </li>
         * <li>
         * <p>
         * 3.2 - 20480
         * </p>
         * </li>
         * <li>
         * <p>
         * 4 - 32768
         * </p>
         * </li>
         * <li>
         * <p>
         * 4.1 - 32768
         * </p>
         * </li>
         * </ul>
         * <p>
         * <b>MaxBitRate (Optional, H.264/MPEG2/VP8/VP9 only)</b>
         * </p>
         * <p>
         * The maximum number of bits per second in a video buffer; the size of the buffer is specified by
         * <code>BufferSize</code>. Specify a value between 16 and 62,500. You can reduce the bandwidth required to
         * stream a video by reducing the maximum bit rate, but this also reduces the quality of the video.
         * </p>
         * <p>
         * <b>BufferSize (Optional, H.264/MPEG2/VP8/VP9 only)</b>
         * </p>
         * <p>
         * The maximum number of bits in any x seconds of the output video. This window is commonly 10 seconds, the
         * standard segment duration when you're using FMP4 or MPEG-TS for the container type of the output video.
         * Specify an integer greater than 0. If you specify <code>MaxBitRate</code> and omit <code>BufferSize</code>,
         * Elastic Transcoder sets <code>BufferSize</code> to 10 times the value of <code>MaxBitRate</code>.
         * </p>
         * <p>
         * <b>InterlacedMode (Optional, H.264/MPEG2 Only)</b>
         * </p>
         * <p>
         * The interlace mode for the output video.
         * </p>
         * <p>
         * Interlaced video is used to double the perceived frame rate for a video by interlacing two fields (one field
         * on every other line, the other field on the other lines) so that the human eye registers multiple pictures
         * per frame. Interlacing reduces the bandwidth required for transmitting a video, but can result in blurred
         * images and flickering.
         * </p>
         * <p>
         * Valid values include <code>Progressive</code> (no interlacing, top to bottom), <code>TopFirst</code> (top
         * field first), <code>BottomFirst</code> (bottom field first), and <code>Auto</code>.
         * </p>
         * <p>
         * If <code>InterlaceMode</code> is not specified, Elastic Transcoder uses <code>Progressive</code> for the
         * output. If <code>Auto</code> is specified, Elastic Transcoder interlaces the output.
         * </p>
         * <p>
         * <b>ColorSpaceConversionMode (Optional, H.264/MPEG2 Only)</b>
         * </p>
         * <p>
         * The color space conversion Elastic Transcoder applies to the output video. Color spaces are the algorithms
         * used by the computer to store information about how to render color. <code>Bt.601</code> is the standard for
         * standard definition video, while <code>Bt.709</code> is the standard for high definition video.
         * </p>
         * <p>
         * Valid values include <code>None</code>, <code>Bt709toBt601</code>, <code>Bt601toBt709</code>, and
         * <code>Auto</code>.
         * </p>
         * <p>
         * If you chose <code>Auto</code> for <code>ColorSpaceConversionMode</code> and your output is interlaced, your
         * frame rate is one of <code>23.97</code>, <code>24</code>, <code>25</code>, <code>29.97</code>,
         * <code>50</code>, or <code>60</code>, your <code>SegmentDuration</code> is null, and you are using one of the
         * resolution changes from the list below, Elastic Transcoder applies the following color space conversions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>Standard to HD, 720x480 to 1920x1080</i> - Elastic Transcoder applies <code>Bt601ToBt709</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>Standard to HD, 720x576 to 1920x1080</i> - Elastic Transcoder applies <code>Bt601ToBt709</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>HD to Standard, 1920x1080 to 720x480</i> - Elastic Transcoder applies <code>Bt709ToBt601</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>HD to Standard, 1920x1080 to 720x576</i> - Elastic Transcoder applies <code>Bt709ToBt601</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * Elastic Transcoder may change the behavior of the <code>ColorspaceConversionMode</code> <code>Auto</code>
         * mode in the future. All outputs in a playlist must use the same <code>ColorSpaceConversionMode</code>.
         * </p>
         * </note>
         * <p>
         * If you do not specify a <code>ColorSpaceConversionMode</code>, Elastic Transcoder does not change the color
         * space of a file. If you are unsure what <code>ColorSpaceConversionMode</code> was applied to your output
         * file, you can check the <code>AppliedColorSpaceConversion</code> parameter included in your job response. If
         * your job does not have an <code>AppliedColorSpaceConversion</code> in its response, no
         * <code>ColorSpaceConversionMode</code> was applied.
         * </p>
         * <p>
         * <b>ChromaSubsampling</b>
         * </p>
         * <p>
         * The sampling pattern for the chroma (color) channels of the output video. Valid values include
         * <code>yuv420p</code> and <code>yuv422p</code>.
         * </p>
         * <p>
         * <code>yuv420p</code> samples the chroma information of every other horizontal and every other vertical line,
         * <code>yuv422p</code> samples the color information of every horizontal line and every other vertical line.
         * </p>
         * <p>
         * <b>LoopCount (Gif Only)</b>
         * </p>
         * <p>
         * The number of times you want the output gif to loop. Valid values include <code>Infinite</code> and integers
         * between <code>0</code> and <code>100</code>, inclusive.
         * </p>
         * 
         * @param codecOptions
         *        <b>Profile (H.264/VP8/VP9 Only)</b> </p>
         *        <p>
         *        The H.264 profile that you want to use for the output file. Elastic Transcoder supports the following
         *        profiles:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>baseline</code>: The profile most commonly used for videoconferencing and for mobile
         *        applications.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>main</code>: The profile used for standard-definition digital TV broadcasts.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>high</code>: The profile used for high-definition digital TV broadcasts and for Blu-ray discs.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>Level (H.264 Only)</b>
         *        </p>
         *        <p>
         *        The H.264 level that you want to use for the output file. Elastic Transcoder supports the following
         *        levels:
         *        </p>
         *        <p>
         *        <code>1</code>, <code>1b</code>, <code>1.1</code>, <code>1.2</code>, <code>1.3</code>, <code>2</code>,
         *        <code>2.1</code>, <code>2.2</code>, <code>3</code>, <code>3.1</code>, <code>3.2</code>, <code>4</code>, <code>4.1</code>
         *        </p>
         *        <p>
         *        <b>MaxReferenceFrames (H.264 Only)</b>
         *        </p>
         *        <p>
         *        Applicable only when the value of Video:Codec is H.264. The maximum number of previously decoded
         *        frames to use as a reference for decoding future frames. Valid values are integers 0 through 16, but
         *        we recommend that you not use a value greater than the following:
         *        </p>
         *        <p>
         *        <code>Min(Floor(Maximum decoded picture buffer in macroblocks * 256 / (Width in pixels * Height in pixels)), 16)</code>
         *        </p>
         *        <p>
         *        where <i>Width in pixels</i> and <i>Height in pixels</i> represent either MaxWidth and MaxHeight, or
         *        Resolution. <i>Maximum decoded picture buffer in macroblocks</i> depends on the value of the
         *        <code>Level</code> object. See the list below. (A macroblock is a block of pixels measuring 16x16.)
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        1 - 396
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        1b - 396
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        1.1 - 900
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        1.2 - 2376
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        1.3 - 2376
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        2 - 2376
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        2.1 - 4752
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        2.2 - 8100
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        3 - 8100
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        3.1 - 18000
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        3.2 - 20480
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        4 - 32768
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        4.1 - 32768
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <b>MaxBitRate (Optional, H.264/MPEG2/VP8/VP9 only)</b>
         *        </p>
         *        <p>
         *        The maximum number of bits per second in a video buffer; the size of the buffer is specified by
         *        <code>BufferSize</code>. Specify a value between 16 and 62,500. You can reduce the bandwidth required
         *        to stream a video by reducing the maximum bit rate, but this also reduces the quality of the video.
         *        </p>
         *        <p>
         *        <b>BufferSize (Optional, H.264/MPEG2/VP8/VP9 only)</b>
         *        </p>
         *        <p>
         *        The maximum number of bits in any x seconds of the output video. This window is commonly 10 seconds,
         *        the standard segment duration when you're using FMP4 or MPEG-TS for the container type of the output
         *        video. Specify an integer greater than 0. If you specify <code>MaxBitRate</code> and omit
         *        <code>BufferSize</code>, Elastic Transcoder sets <code>BufferSize</code> to 10 times the value of
         *        <code>MaxBitRate</code>.
         *        </p>
         *        <p>
         *        <b>InterlacedMode (Optional, H.264/MPEG2 Only)</b>
         *        </p>
         *        <p>
         *        The interlace mode for the output video.
         *        </p>
         *        <p>
         *        Interlaced video is used to double the perceived frame rate for a video by interlacing two fields (one
         *        field on every other line, the other field on the other lines) so that the human eye registers
         *        multiple pictures per frame. Interlacing reduces the bandwidth required for transmitting a video, but
         *        can result in blurred images and flickering.
         *        </p>
         *        <p>
         *        Valid values include <code>Progressive</code> (no interlacing, top to bottom), <code>TopFirst</code>
         *        (top field first), <code>BottomFirst</code> (bottom field first), and <code>Auto</code>.
         *        </p>
         *        <p>
         *        If <code>InterlaceMode</code> is not specified, Elastic Transcoder uses <code>Progressive</code> for
         *        the output. If <code>Auto</code> is specified, Elastic Transcoder interlaces the output.
         *        </p>
         *        <p>
         *        <b>ColorSpaceConversionMode (Optional, H.264/MPEG2 Only)</b>
         *        </p>
         *        <p>
         *        The color space conversion Elastic Transcoder applies to the output video. Color spaces are the
         *        algorithms used by the computer to store information about how to render color. <code>Bt.601</code> is
         *        the standard for standard definition video, while <code>Bt.709</code> is the standard for high
         *        definition video.
         *        </p>
         *        <p>
         *        Valid values include <code>None</code>, <code>Bt709toBt601</code>, <code>Bt601toBt709</code>, and
         *        <code>Auto</code>.
         *        </p>
         *        <p>
         *        If you chose <code>Auto</code> for <code>ColorSpaceConversionMode</code> and your output is
         *        interlaced, your frame rate is one of <code>23.97</code>, <code>24</code>, <code>25</code>,
         *        <code>29.97</code>, <code>50</code>, or <code>60</code>, your <code>SegmentDuration</code> is null,
         *        and you are using one of the resolution changes from the list below, Elastic Transcoder applies the
         *        following color space conversions:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>Standard to HD, 720x480 to 1920x1080</i> - Elastic Transcoder applies <code>Bt601ToBt709</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Standard to HD, 720x576 to 1920x1080</i> - Elastic Transcoder applies <code>Bt601ToBt709</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>HD to Standard, 1920x1080 to 720x480</i> - Elastic Transcoder applies <code>Bt709ToBt601</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>HD to Standard, 1920x1080 to 720x576</i> - Elastic Transcoder applies <code>Bt709ToBt601</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        Elastic Transcoder may change the behavior of the <code>ColorspaceConversionMode</code>
         *        <code>Auto</code> mode in the future. All outputs in a playlist must use the same
         *        <code>ColorSpaceConversionMode</code>.
         *        </p>
         *        </note>
         *        <p>
         *        If you do not specify a <code>ColorSpaceConversionMode</code>, Elastic Transcoder does not change the
         *        color space of a file. If you are unsure what <code>ColorSpaceConversionMode</code> was applied to
         *        your output file, you can check the <code>AppliedColorSpaceConversion</code> parameter included in
         *        your job response. If your job does not have an <code>AppliedColorSpaceConversion</code> in its
         *        response, no <code>ColorSpaceConversionMode</code> was applied.
         *        </p>
         *        <p>
         *        <b>ChromaSubsampling</b>
         *        </p>
         *        <p>
         *        The sampling pattern for the chroma (color) channels of the output video. Valid values include
         *        <code>yuv420p</code> and <code>yuv422p</code>.
         *        </p>
         *        <p>
         *        <code>yuv420p</code> samples the chroma information of every other horizontal and every other vertical
         *        line, <code>yuv422p</code> samples the color information of every horizontal line and every other
         *        vertical line.
         *        </p>
         *        <p>
         *        <b>LoopCount (Gif Only)</b>
         *        </p>
         *        <p>
         *        The number of times you want the output gif to loop. Valid values include <code>Infinite</code> and
         *        integers between <code>0</code> and <code>100</code>, inclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codecOptions(Map<String, String> codecOptions);

        /**
         * <p>
         * Applicable only when the value of Video:Codec is one of <code>H.264</code>, <code>MPEG2</code>, or
         * <code>VP8</code>.
         * </p>
         * <p>
         * The maximum number of frames between key frames. Key frames are fully encoded frames; the frames between key
         * frames are encoded based, in part, on the content of the key frames. The value is an integer formatted as a
         * string; valid values are between 1 (every frame is a key frame) and 100000, inclusive. A higher value results
         * in higher compression but may also discernibly decrease video quality.
         * </p>
         * <p>
         * For <code>Smooth</code> outputs, the <code>FrameRate</code> must have a constant ratio to the
         * <code>KeyframesMaxDist</code>. This allows <code>Smooth</code> playlists to switch between different quality
         * levels while the file is being played.
         * </p>
         * <p>
         * For example, an input file can have a <code>FrameRate</code> of 30 with a <code>KeyframesMaxDist</code> of
         * 90. The output file then needs to have a ratio of 1:3. Valid outputs would have <code>FrameRate</code> of 30,
         * 25, and 10, and <code>KeyframesMaxDist</code> of 90, 75, and 30, respectively.
         * </p>
         * <p>
         * Alternately, this can be achieved by setting <code>FrameRate</code> to auto and having the same values for
         * <code>MaxFrameRate</code> and <code>KeyframesMaxDist</code>.
         * </p>
         * 
         * @param keyframesMaxDist
         *        Applicable only when the value of Video:Codec is one of <code>H.264</code>, <code>MPEG2</code>, or
         *        <code>VP8</code>.</p>
         *        <p>
         *        The maximum number of frames between key frames. Key frames are fully encoded frames; the frames
         *        between key frames are encoded based, in part, on the content of the key frames. The value is an
         *        integer formatted as a string; valid values are between 1 (every frame is a key frame) and 100000,
         *        inclusive. A higher value results in higher compression but may also discernibly decrease video
         *        quality.
         *        </p>
         *        <p>
         *        For <code>Smooth</code> outputs, the <code>FrameRate</code> must have a constant ratio to the
         *        <code>KeyframesMaxDist</code>. This allows <code>Smooth</code> playlists to switch between different
         *        quality levels while the file is being played.
         *        </p>
         *        <p>
         *        For example, an input file can have a <code>FrameRate</code> of 30 with a
         *        <code>KeyframesMaxDist</code> of 90. The output file then needs to have a ratio of 1:3. Valid outputs
         *        would have <code>FrameRate</code> of 30, 25, and 10, and <code>KeyframesMaxDist</code> of 90, 75, and
         *        30, respectively.
         *        </p>
         *        <p>
         *        Alternately, this can be achieved by setting <code>FrameRate</code> to auto and having the same values
         *        for <code>MaxFrameRate</code> and <code>KeyframesMaxDist</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyframesMaxDist(String keyframesMaxDist);

        /**
         * <p>
         * Applicable only when the value of Video:Codec is one of <code>H.264</code>, <code>MPEG2</code>, or
         * <code>VP8</code>.
         * </p>
         * <p>
         * Whether to use a fixed value for <code>FixedGOP</code>. Valid values are <code>true</code> and
         * <code>false</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>true</code>: Elastic Transcoder uses the value of <code>KeyframesMaxDist</code> for the distance
         * between key frames (the number of frames in a group of pictures, or GOP).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>false</code>: The distance between key frames can vary.
         * </p>
         * </li>
         * </ul>
         * <important>
         * <p>
         * <code>FixedGOP</code> must be set to <code>true</code> for <code>fmp4</code> containers.
         * </p>
         * </important>
         * 
         * @param fixedGOP
         *        Applicable only when the value of Video:Codec is one of <code>H.264</code>, <code>MPEG2</code>, or
         *        <code>VP8</code>.</p>
         *        <p>
         *        Whether to use a fixed value for <code>FixedGOP</code>. Valid values are <code>true</code> and
         *        <code>false</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>true</code>: Elastic Transcoder uses the value of <code>KeyframesMaxDist</code> for the distance
         *        between key frames (the number of frames in a group of pictures, or GOP).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>false</code>: The distance between key frames can vary.
         *        </p>
         *        </li>
         *        </ul>
         *        <important>
         *        <p>
         *        <code>FixedGOP</code> must be set to <code>true</code> for <code>fmp4</code> containers.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixedGOP(String fixedGOP);

        /**
         * <p>
         * The bit rate of the video stream in the output file, in kilobits/second. Valid values depend on the values of
         * <code>Level</code> and <code>Profile</code>. If you specify <code>auto</code>, Elastic Transcoder uses the
         * detected bit rate of the input source. If you specify a value other than <code>auto</code>, we recommend that
         * you specify a value less than or equal to the maximum H.264-compliant value listed for your level and
         * profile:
         * </p>
         * <p>
         * <i>Level - Maximum video bit rate in kilobits/second (baseline and main Profile) : maximum video bit rate in
         * kilobits/second (high Profile)</i>
         * </p>
         * <ul>
         * <li>
         * <p>
         * 1 - 64 : 80
         * </p>
         * </li>
         * <li>
         * <p>
         * 1b - 128 : 160
         * </p>
         * </li>
         * <li>
         * <p>
         * 1.1 - 192 : 240
         * </p>
         * </li>
         * <li>
         * <p>
         * 1.2 - 384 : 480
         * </p>
         * </li>
         * <li>
         * <p>
         * 1.3 - 768 : 960
         * </p>
         * </li>
         * <li>
         * <p>
         * 2 - 2000 : 2500
         * </p>
         * </li>
         * <li>
         * <p>
         * 3 - 10000 : 12500
         * </p>
         * </li>
         * <li>
         * <p>
         * 3.1 - 14000 : 17500
         * </p>
         * </li>
         * <li>
         * <p>
         * 3.2 - 20000 : 25000
         * </p>
         * </li>
         * <li>
         * <p>
         * 4 - 20000 : 25000
         * </p>
         * </li>
         * <li>
         * <p>
         * 4.1 - 50000 : 62500
         * </p>
         * </li>
         * </ul>
         * 
         * @param bitRate
         *        The bit rate of the video stream in the output file, in kilobits/second. Valid values depend on the
         *        values of <code>Level</code> and <code>Profile</code>. If you specify <code>auto</code>, Elastic
         *        Transcoder uses the detected bit rate of the input source. If you specify a value other than
         *        <code>auto</code>, we recommend that you specify a value less than or equal to the maximum
         *        H.264-compliant value listed for your level and profile:</p>
         *        <p>
         *        <i>Level - Maximum video bit rate in kilobits/second (baseline and main Profile) : maximum video bit
         *        rate in kilobits/second (high Profile)</i>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        1 - 64 : 80
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        1b - 128 : 160
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        1.1 - 192 : 240
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        1.2 - 384 : 480
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        1.3 - 768 : 960
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        2 - 2000 : 2500
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        3 - 10000 : 12500
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        3.1 - 14000 : 17500
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        3.2 - 20000 : 25000
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        4 - 20000 : 25000
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        4.1 - 50000 : 62500
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitRate(String bitRate);

        /**
         * <p>
         * The frames per second for the video stream in the output file. Valid values include:
         * </p>
         * <p>
         * <code>auto</code>, <code>10</code>, <code>15</code>, <code>23.97</code>, <code>24</code>, <code>25</code>,
         * <code>29.97</code>, <code>30</code>, <code>60</code>
         * </p>
         * <p>
         * If you specify <code>auto</code>, Elastic Transcoder uses the detected frame rate of the input source. If you
         * specify a frame rate, we recommend that you perform the following calculation:
         * </p>
         * <p>
         * <code>Frame rate = maximum recommended decoding speed in luma samples/second / (width in pixels * height in pixels)</code>
         * </p>
         * <p>
         * where:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>width in pixels</i> and <i>height in pixels</i> represent the Resolution of the output video.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>maximum recommended decoding speed in Luma samples/second</i> is less than or equal to the maximum value
         * listed in the following table, based on the value that you specified for Level.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The maximum recommended decoding speed in Luma samples/second for each level is described in the following
         * list (<i>Level - Decoding speed</i>):
         * </p>
         * <ul>
         * <li>
         * <p>
         * 1 - 380160
         * </p>
         * </li>
         * <li>
         * <p>
         * 1b - 380160
         * </p>
         * </li>
         * <li>
         * <p>
         * 1.1 - 76800
         * </p>
         * </li>
         * <li>
         * <p>
         * 1.2 - 1536000
         * </p>
         * </li>
         * <li>
         * <p>
         * 1.3 - 3041280
         * </p>
         * </li>
         * <li>
         * <p>
         * 2 - 3041280
         * </p>
         * </li>
         * <li>
         * <p>
         * 2.1 - 5068800
         * </p>
         * </li>
         * <li>
         * <p>
         * 2.2 - 5184000
         * </p>
         * </li>
         * <li>
         * <p>
         * 3 - 10368000
         * </p>
         * </li>
         * <li>
         * <p>
         * 3.1 - 27648000
         * </p>
         * </li>
         * <li>
         * <p>
         * 3.2 - 55296000
         * </p>
         * </li>
         * <li>
         * <p>
         * 4 - 62914560
         * </p>
         * </li>
         * <li>
         * <p>
         * 4.1 - 62914560
         * </p>
         * </li>
         * </ul>
         * 
         * @param frameRate
         *        The frames per second for the video stream in the output file. Valid values include:</p>
         *        <p>
         *        <code>auto</code>, <code>10</code>, <code>15</code>, <code>23.97</code>, <code>24</code>,
         *        <code>25</code>, <code>29.97</code>, <code>30</code>, <code>60</code>
         *        </p>
         *        <p>
         *        If you specify <code>auto</code>, Elastic Transcoder uses the detected frame rate of the input source.
         *        If you specify a frame rate, we recommend that you perform the following calculation:
         *        </p>
         *        <p>
         *        <code>Frame rate = maximum recommended decoding speed in luma samples/second / (width in pixels * height in pixels)</code>
         *        </p>
         *        <p>
         *        where:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>width in pixels</i> and <i>height in pixels</i> represent the Resolution of the output video.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>maximum recommended decoding speed in Luma samples/second</i> is less than or equal to the maximum
         *        value listed in the following table, based on the value that you specified for Level.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The maximum recommended decoding speed in Luma samples/second for each level is described in the
         *        following list (<i>Level - Decoding speed</i>):
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        1 - 380160
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        1b - 380160
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        1.1 - 76800
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        1.2 - 1536000
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        1.3 - 3041280
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        2 - 3041280
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        2.1 - 5068800
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        2.2 - 5184000
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        3 - 10368000
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        3.1 - 27648000
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        3.2 - 55296000
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        4 - 62914560
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        4.1 - 62914560
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameRate(String frameRate);

        /**
         * <p>
         * If you specify <code>auto</code> for <code>FrameRate</code>, Elastic Transcoder uses the frame rate of the
         * input video for the frame rate of the output video. Specify the maximum frame rate that you want Elastic
         * Transcoder to use when the frame rate of the input video is greater than the desired maximum frame rate of
         * the output video. Valid values include: <code>10</code>, <code>15</code>, <code>23.97</code>, <code>24</code>, <code>25</code>, <code>29.97</code>, <code>30</code>, <code>60</code>.
         * </p>
         * 
         * @param maxFrameRate
         *        If you specify <code>auto</code> for <code>FrameRate</code>, Elastic Transcoder uses the frame rate of
         *        the input video for the frame rate of the output video. Specify the maximum frame rate that you want
         *        Elastic Transcoder to use when the frame rate of the input video is greater than the desired maximum
         *        frame rate of the output video. Valid values include: <code>10</code>, <code>15</code>,
         *        <code>23.97</code>, <code>24</code>, <code>25</code>, <code>29.97</code>, <code>30</code>,
         *        <code>60</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxFrameRate(String maxFrameRate);

        /**
         * <important>
         * <p>
         * To better control resolution and aspect ratio of output videos, we recommend that you use the values
         * <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, <code>PaddingPolicy</code>, and
         * <code>DisplayAspectRatio</code> instead of <code>Resolution</code> and <code>AspectRatio</code>. The two
         * groups of settings are mutually exclusive. Do not use them together.
         * </p>
         * </important>
         * <p>
         * The width and height of the video in the output file, in pixels. Valid values are <code>auto</code> and
         * <i>width</i> x <i>height</i>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>auto</code>: Elastic Transcoder attempts to preserve the width and height of the input file, subject to
         * the following rules.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code> <i>width</i> x <i>height</i> </code>: The width and height of the output video in pixels.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Note the following about specifying the width and height:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The width must be an even integer between 128 and 4096, inclusive.
         * </p>
         * </li>
         * <li>
         * <p>
         * The height must be an even integer between 96 and 3072, inclusive.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify a resolution that is less than the resolution of the input file, Elastic Transcoder rescales
         * the output file to the lower resolution.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you specify a resolution that is greater than the resolution of the input file, Elastic Transcoder
         * rescales the output to the higher resolution.
         * </p>
         * </li>
         * <li>
         * <p>
         * We recommend that you specify a resolution for which the product of width and height is less than or equal to
         * the applicable value in the following list (<i>List - Max width x height value</i>):
         * </p>
         * <ul>
         * <li>
         * <p>
         * 1 - 25344
         * </p>
         * </li>
         * <li>
         * <p>
         * 1b - 25344
         * </p>
         * </li>
         * <li>
         * <p>
         * 1.1 - 101376
         * </p>
         * </li>
         * <li>
         * <p>
         * 1.2 - 101376
         * </p>
         * </li>
         * <li>
         * <p>
         * 1.3 - 101376
         * </p>
         * </li>
         * <li>
         * <p>
         * 2 - 101376
         * </p>
         * </li>
         * <li>
         * <p>
         * 2.1 - 202752
         * </p>
         * </li>
         * <li>
         * <p>
         * 2.2 - 404720
         * </p>
         * </li>
         * <li>
         * <p>
         * 3 - 404720
         * </p>
         * </li>
         * <li>
         * <p>
         * 3.1 - 921600
         * </p>
         * </li>
         * <li>
         * <p>
         * 3.2 - 1310720
         * </p>
         * </li>
         * <li>
         * <p>
         * 4 - 2097152
         * </p>
         * </li>
         * <li>
         * <p>
         * 4.1 - 2097152
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param resolution
         *        <p>
         *        To better control resolution and aspect ratio of output videos, we recommend that you use the values
         *        <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, <code>PaddingPolicy</code>,
         *        and <code>DisplayAspectRatio</code> instead of <code>Resolution</code> and <code>AspectRatio</code>.
         *        The two groups of settings are mutually exclusive. Do not use them together.
         *        </p>
         *        </important>
         *        <p>
         *        The width and height of the video in the output file, in pixels. Valid values are <code>auto</code>
         *        and <i>width</i> x <i>height</i>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>auto</code>: Elastic Transcoder attempts to preserve the width and height of the input file,
         *        subject to the following rules.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code> <i>width</i> x <i>height</i> </code>: The width and height of the output video in pixels.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Note the following about specifying the width and height:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The width must be an even integer between 128 and 4096, inclusive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The height must be an even integer between 96 and 3072, inclusive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify a resolution that is less than the resolution of the input file, Elastic Transcoder
         *        rescales the output file to the lower resolution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you specify a resolution that is greater than the resolution of the input file, Elastic Transcoder
         *        rescales the output to the higher resolution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        We recommend that you specify a resolution for which the product of width and height is less than or
         *        equal to the applicable value in the following list (<i>List - Max width x height value</i>):
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        1 - 25344
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        1b - 25344
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        1.1 - 101376
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        1.2 - 101376
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        1.3 - 101376
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        2 - 101376
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        2.1 - 202752
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        2.2 - 404720
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        3 - 404720
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        3.1 - 921600
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        3.2 - 1310720
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        4 - 2097152
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        4.1 - 2097152
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolution(String resolution);

        /**
         * <important>
         * <p>
         * To better control resolution and aspect ratio of output videos, we recommend that you use the values
         * <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, <code>PaddingPolicy</code>, and
         * <code>DisplayAspectRatio</code> instead of <code>Resolution</code> and <code>AspectRatio</code>. The two
         * groups of settings are mutually exclusive. Do not use them together.
         * </p>
         * </important>
         * <p>
         * The display aspect ratio of the video in the output file. Valid values include:
         * </p>
         * <p>
         * <code>auto</code>, <code>1:1</code>, <code>4:3</code>, <code>3:2</code>, <code>16:9</code>
         * </p>
         * <p>
         * If you specify <code>auto</code>, Elastic Transcoder tries to preserve the aspect ratio of the input file.
         * </p>
         * <p>
         * If you specify an aspect ratio for the output file that differs from aspect ratio of the input file, Elastic
         * Transcoder adds pillarboxing (black bars on the sides) or letterboxing (black bars on the top and bottom) to
         * maintain the aspect ratio of the active region of the video.
         * </p>
         * 
         * @param aspectRatio
         *        <p>
         *        To better control resolution and aspect ratio of output videos, we recommend that you use the values
         *        <code>MaxWidth</code>, <code>MaxHeight</code>, <code>SizingPolicy</code>, <code>PaddingPolicy</code>,
         *        and <code>DisplayAspectRatio</code> instead of <code>Resolution</code> and <code>AspectRatio</code>.
         *        The two groups of settings are mutually exclusive. Do not use them together.
         *        </p>
         *        </important>
         *        <p>
         *        The display aspect ratio of the video in the output file. Valid values include:
         *        </p>
         *        <p>
         *        <code>auto</code>, <code>1:1</code>, <code>4:3</code>, <code>3:2</code>, <code>16:9</code>
         *        </p>
         *        <p>
         *        If you specify <code>auto</code>, Elastic Transcoder tries to preserve the aspect ratio of the input
         *        file.
         *        </p>
         *        <p>
         *        If you specify an aspect ratio for the output file that differs from aspect ratio of the input file,
         *        Elastic Transcoder adds pillarboxing (black bars on the sides) or letterboxing (black bars on the top
         *        and bottom) to maintain the aspect ratio of the active region of the video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aspectRatio(String aspectRatio);

        /**
         * <p>
         * The maximum width of the output video in pixels. If you specify <code>auto</code>, Elastic Transcoder uses
         * 1920 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 128 and
         * 4096.
         * </p>
         * 
         * @param maxWidth
         *        The maximum width of the output video in pixels. If you specify <code>auto</code>, Elastic Transcoder
         *        uses 1920 (Full HD) as the default value. If you specify a numeric value, enter an even integer
         *        between 128 and 4096.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxWidth(String maxWidth);

        /**
         * <p>
         * The maximum height of the output video in pixels. If you specify <code>auto</code>, Elastic Transcoder uses
         * 1080 (Full HD) as the default value. If you specify a numeric value, enter an even integer between 96 and
         * 3072.
         * </p>
         * 
         * @param maxHeight
         *        The maximum height of the output video in pixels. If you specify <code>auto</code>, Elastic Transcoder
         *        uses 1080 (Full HD) as the default value. If you specify a numeric value, enter an even integer
         *        between 96 and 3072.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxHeight(String maxHeight);

        /**
         * <p>
         * The value that Elastic Transcoder adds to the metadata in the output file.
         * </p>
         * 
         * @param displayAspectRatio
         *        The value that Elastic Transcoder adds to the metadata in the output file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayAspectRatio(String displayAspectRatio);

        /**
         * <p>
         * Specify one of the following values to control scaling of the output video:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Fit</code>: Elastic Transcoder scales the output video so it matches the value that you specified in
         * either <code>MaxWidth</code> or <code>MaxHeight</code> without exceeding the other value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Fill</code>: Elastic Transcoder scales the output video so it matches the value that you specified in
         * either <code>MaxWidth</code> or <code>MaxHeight</code> and matches or exceeds the other value. Elastic
         * Transcoder centers the output video and then crops it in the dimension (if any) that exceeds the maximum
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Stretch</code>: Elastic Transcoder stretches the output video to match the values that you specified
         * for <code>MaxWidth</code> and <code>MaxHeight</code>. If the relative proportions of the input video and the
         * output video are different, the output video will be distorted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Keep</code>: Elastic Transcoder does not scale the output video. If either dimension of the input video
         * exceeds the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>, Elastic
         * Transcoder crops the output video.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ShrinkToFit</code>: Elastic Transcoder scales the output video down so that its dimensions match the
         * values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without
         * exceeding either value. If you specify this option, Elastic Transcoder does not scale the video up.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ShrinkToFill</code>: Elastic Transcoder scales the output video down so that its dimensions match the
         * values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code> without
         * dropping below either value. If you specify this option, Elastic Transcoder does not scale the video up.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sizingPolicy
         *        Specify one of the following values to control scaling of the output video:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Fit</code>: Elastic Transcoder scales the output video so it matches the value that you
         *        specified in either <code>MaxWidth</code> or <code>MaxHeight</code> without exceeding the other value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Fill</code>: Elastic Transcoder scales the output video so it matches the value that you
         *        specified in either <code>MaxWidth</code> or <code>MaxHeight</code> and matches or exceeds the other
         *        value. Elastic Transcoder centers the output video and then crops it in the dimension (if any) that
         *        exceeds the maximum value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Stretch</code>: Elastic Transcoder stretches the output video to match the values that you
         *        specified for <code>MaxWidth</code> and <code>MaxHeight</code>. If the relative proportions of the
         *        input video and the output video are different, the output video will be distorted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Keep</code>: Elastic Transcoder does not scale the output video. If either dimension of the
         *        input video exceeds the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>
         *        , Elastic Transcoder crops the output video.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ShrinkToFit</code>: Elastic Transcoder scales the output video down so that its dimensions match
         *        the values that you specified for at least one of <code>MaxWidth</code> and <code>MaxHeight</code>
         *        without exceeding either value. If you specify this option, Elastic Transcoder does not scale the
         *        video up.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ShrinkToFill</code>: Elastic Transcoder scales the output video down so that its dimensions
         *        match the values that you specified for at least one of <code>MaxWidth</code> and
         *        <code>MaxHeight</code> without dropping below either value. If you specify this option, Elastic
         *        Transcoder does not scale the video up.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizingPolicy(String sizingPolicy);

        /**
         * <p>
         * When you set <code>PaddingPolicy</code> to <code>Pad</code>, Elastic Transcoder may add black bars to the top
         * and bottom and/or left and right sides of the output video to make the total size of the output video match
         * the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>.
         * </p>
         * 
         * @param paddingPolicy
         *        When you set <code>PaddingPolicy</code> to <code>Pad</code>, Elastic Transcoder may add black bars to
         *        the top and bottom and/or left and right sides of the output video to make the total size of the
         *        output video match the values that you specified for <code>MaxWidth</code> and <code>MaxHeight</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paddingPolicy(String paddingPolicy);

        /**
         * <p>
         * Settings for the size, location, and opacity of graphics that you want Elastic Transcoder to overlay over
         * videos that are transcoded using this preset. You can specify settings for up to four watermarks. Watermarks
         * appear in the specified size and location, and with the specified opacity for the duration of the transcoded
         * video.
         * </p>
         * <p>
         * Watermarks can be in .png or .jpg format. If you want to display a watermark that is not rectangular, use the
         * .png format, which supports transparency.
         * </p>
         * <p>
         * When you create a job that uses this preset, you specify the .png or .jpg graphics that you want Elastic
         * Transcoder to include in the transcoded videos. You can specify fewer graphics in the job than you specify
         * watermark settings in the preset, which allows you to use the same preset for up to four watermarks that have
         * different dimensions.
         * </p>
         * 
         * @param watermarks
         *        Settings for the size, location, and opacity of graphics that you want Elastic Transcoder to overlay
         *        over videos that are transcoded using this preset. You can specify settings for up to four watermarks.
         *        Watermarks appear in the specified size and location, and with the specified opacity for the duration
         *        of the transcoded video.</p>
         *        <p>
         *        Watermarks can be in .png or .jpg format. If you want to display a watermark that is not rectangular,
         *        use the .png format, which supports transparency.
         *        </p>
         *        <p>
         *        When you create a job that uses this preset, you specify the .png or .jpg graphics that you want
         *        Elastic Transcoder to include in the transcoded videos. You can specify fewer graphics in the job than
         *        you specify watermark settings in the preset, which allows you to use the same preset for up to four
         *        watermarks that have different dimensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder watermarks(Collection<PresetWatermark> watermarks);

        /**
         * <p>
         * Settings for the size, location, and opacity of graphics that you want Elastic Transcoder to overlay over
         * videos that are transcoded using this preset. You can specify settings for up to four watermarks. Watermarks
         * appear in the specified size and location, and with the specified opacity for the duration of the transcoded
         * video.
         * </p>
         * <p>
         * Watermarks can be in .png or .jpg format. If you want to display a watermark that is not rectangular, use the
         * .png format, which supports transparency.
         * </p>
         * <p>
         * When you create a job that uses this preset, you specify the .png or .jpg graphics that you want Elastic
         * Transcoder to include in the transcoded videos. You can specify fewer graphics in the job than you specify
         * watermark settings in the preset, which allows you to use the same preset for up to four watermarks that have
         * different dimensions.
         * </p>
         * 
         * @param watermarks
         *        Settings for the size, location, and opacity of graphics that you want Elastic Transcoder to overlay
         *        over videos that are transcoded using this preset. You can specify settings for up to four watermarks.
         *        Watermarks appear in the specified size and location, and with the specified opacity for the duration
         *        of the transcoded video.</p>
         *        <p>
         *        Watermarks can be in .png or .jpg format. If you want to display a watermark that is not rectangular,
         *        use the .png format, which supports transparency.
         *        </p>
         *        <p>
         *        When you create a job that uses this preset, you specify the .png or .jpg graphics that you want
         *        Elastic Transcoder to include in the transcoded videos. You can specify fewer graphics in the job than
         *        you specify watermark settings in the preset, which allows you to use the same preset for up to four
         *        watermarks that have different dimensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder watermarks(PresetWatermark... watermarks);

        /**
         * <p>
         * Settings for the size, location, and opacity of graphics that you want Elastic Transcoder to overlay over
         * videos that are transcoded using this preset. You can specify settings for up to four watermarks. Watermarks
         * appear in the specified size and location, and with the specified opacity for the duration of the transcoded
         * video.
         * </p>
         * <p>
         * Watermarks can be in .png or .jpg format. If you want to display a watermark that is not rectangular, use the
         * .png format, which supports transparency.
         * </p>
         * <p>
         * When you create a job that uses this preset, you specify the .png or .jpg graphics that you want Elastic
         * Transcoder to include in the transcoded videos. You can specify fewer graphics in the job than you specify
         * watermark settings in the preset, which allows you to use the same preset for up to four watermarks that have
         * different dimensions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PresetWatermark>.Builder} avoiding the need
         * to create one manually via {@link List<PresetWatermark>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PresetWatermark>.Builder#build()} is called immediately and
         * its result is passed to {@link #watermarks(List<PresetWatermark>)}.
         * 
         * @param watermarks
         *        a consumer that will call methods on {@link List<PresetWatermark>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #watermarks(List<PresetWatermark>)
         */
        Builder watermarks(Consumer<PresetWatermark.Builder>... watermarks);
    }

    static final class BuilderImpl implements Builder {
        private String codec;

        private Map<String, String> codecOptions = DefaultSdkAutoConstructMap.getInstance();

        private String keyframesMaxDist;

        private String fixedGOP;

        private String bitRate;

        private String frameRate;

        private String maxFrameRate;

        private String resolution;

        private String aspectRatio;

        private String maxWidth;

        private String maxHeight;

        private String displayAspectRatio;

        private String sizingPolicy;

        private String paddingPolicy;

        private List<PresetWatermark> watermarks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VideoParameters model) {
            codec(model.codec);
            codecOptions(model.codecOptions);
            keyframesMaxDist(model.keyframesMaxDist);
            fixedGOP(model.fixedGOP);
            bitRate(model.bitRate);
            frameRate(model.frameRate);
            maxFrameRate(model.maxFrameRate);
            resolution(model.resolution);
            aspectRatio(model.aspectRatio);
            maxWidth(model.maxWidth);
            maxHeight(model.maxHeight);
            displayAspectRatio(model.displayAspectRatio);
            sizingPolicy(model.sizingPolicy);
            paddingPolicy(model.paddingPolicy);
            watermarks(model.watermarks);
        }

        public final String getCodec() {
            return codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        public final Map<String, String> getCodecOptions() {
            if (codecOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return codecOptions;
        }

        @Override
        public final Builder codecOptions(Map<String, String> codecOptions) {
            this.codecOptions = CodecOptionsCopier.copy(codecOptions);
            return this;
        }

        public final void setCodecOptions(Map<String, String> codecOptions) {
            this.codecOptions = CodecOptionsCopier.copy(codecOptions);
        }

        public final String getKeyframesMaxDist() {
            return keyframesMaxDist;
        }

        @Override
        public final Builder keyframesMaxDist(String keyframesMaxDist) {
            this.keyframesMaxDist = keyframesMaxDist;
            return this;
        }

        public final void setKeyframesMaxDist(String keyframesMaxDist) {
            this.keyframesMaxDist = keyframesMaxDist;
        }

        public final String getFixedGOP() {
            return fixedGOP;
        }

        @Override
        public final Builder fixedGOP(String fixedGOP) {
            this.fixedGOP = fixedGOP;
            return this;
        }

        public final void setFixedGOP(String fixedGOP) {
            this.fixedGOP = fixedGOP;
        }

        public final String getBitRate() {
            return bitRate;
        }

        @Override
        public final Builder bitRate(String bitRate) {
            this.bitRate = bitRate;
            return this;
        }

        public final void setBitRate(String bitRate) {
            this.bitRate = bitRate;
        }

        public final String getFrameRate() {
            return frameRate;
        }

        @Override
        public final Builder frameRate(String frameRate) {
            this.frameRate = frameRate;
            return this;
        }

        public final void setFrameRate(String frameRate) {
            this.frameRate = frameRate;
        }

        public final String getMaxFrameRate() {
            return maxFrameRate;
        }

        @Override
        public final Builder maxFrameRate(String maxFrameRate) {
            this.maxFrameRate = maxFrameRate;
            return this;
        }

        public final void setMaxFrameRate(String maxFrameRate) {
            this.maxFrameRate = maxFrameRate;
        }

        public final String getResolution() {
            return resolution;
        }

        @Override
        public final Builder resolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        public final void setResolution(String resolution) {
            this.resolution = resolution;
        }

        public final String getAspectRatio() {
            return aspectRatio;
        }

        @Override
        public final Builder aspectRatio(String aspectRatio) {
            this.aspectRatio = aspectRatio;
            return this;
        }

        public final void setAspectRatio(String aspectRatio) {
            this.aspectRatio = aspectRatio;
        }

        public final String getMaxWidth() {
            return maxWidth;
        }

        @Override
        public final Builder maxWidth(String maxWidth) {
            this.maxWidth = maxWidth;
            return this;
        }

        public final void setMaxWidth(String maxWidth) {
            this.maxWidth = maxWidth;
        }

        public final String getMaxHeight() {
            return maxHeight;
        }

        @Override
        public final Builder maxHeight(String maxHeight) {
            this.maxHeight = maxHeight;
            return this;
        }

        public final void setMaxHeight(String maxHeight) {
            this.maxHeight = maxHeight;
        }

        public final String getDisplayAspectRatio() {
            return displayAspectRatio;
        }

        @Override
        public final Builder displayAspectRatio(String displayAspectRatio) {
            this.displayAspectRatio = displayAspectRatio;
            return this;
        }

        public final void setDisplayAspectRatio(String displayAspectRatio) {
            this.displayAspectRatio = displayAspectRatio;
        }

        public final String getSizingPolicy() {
            return sizingPolicy;
        }

        @Override
        public final Builder sizingPolicy(String sizingPolicy) {
            this.sizingPolicy = sizingPolicy;
            return this;
        }

        public final void setSizingPolicy(String sizingPolicy) {
            this.sizingPolicy = sizingPolicy;
        }

        public final String getPaddingPolicy() {
            return paddingPolicy;
        }

        @Override
        public final Builder paddingPolicy(String paddingPolicy) {
            this.paddingPolicy = paddingPolicy;
            return this;
        }

        public final void setPaddingPolicy(String paddingPolicy) {
            this.paddingPolicy = paddingPolicy;
        }

        public final Collection<PresetWatermark.Builder> getWatermarks() {
            if (watermarks instanceof SdkAutoConstructList) {
                return null;
            }
            return watermarks != null ? watermarks.stream().map(PresetWatermark::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder watermarks(Collection<PresetWatermark> watermarks) {
            this.watermarks = PresetWatermarksCopier.copy(watermarks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watermarks(PresetWatermark... watermarks) {
            watermarks(Arrays.asList(watermarks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watermarks(Consumer<PresetWatermark.Builder>... watermarks) {
            watermarks(Stream.of(watermarks).map(c -> PresetWatermark.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setWatermarks(Collection<PresetWatermark.BuilderImpl> watermarks) {
            this.watermarks = PresetWatermarksCopier.copyFromBuilder(watermarks);
        }

        @Override
        public VideoParameters build() {
            return new VideoParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
