/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the file that you're transcoding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobInput implements SdkPojo, Serializable, ToCopyableBuilder<JobInput.Builder, JobInput> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(JobInput::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<String> FRAME_RATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FrameRate").getter(getter(JobInput::frameRate)).setter(setter(Builder::frameRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameRate").build()).build();

    private static final SdkField<String> RESOLUTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Resolution").getter(getter(JobInput::resolution)).setter(setter(Builder::resolution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resolution").build()).build();

    private static final SdkField<String> ASPECT_RATIO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AspectRatio").getter(getter(JobInput::aspectRatio)).setter(setter(Builder::aspectRatio))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AspectRatio").build()).build();

    private static final SdkField<String> INTERLACED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Interlaced").getter(getter(JobInput::interlaced)).setter(setter(Builder::interlaced))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interlaced").build()).build();

    private static final SdkField<String> CONTAINER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Container").getter(getter(JobInput::container)).setter(setter(Builder::container))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Container").build()).build();

    private static final SdkField<Encryption> ENCRYPTION_FIELD = SdkField.<Encryption> builder(MarshallingType.SDK_POJO)
            .memberName("Encryption").getter(getter(JobInput::encryption)).setter(setter(Builder::encryption))
            .constructor(Encryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encryption").build()).build();

    private static final SdkField<TimeSpan> TIME_SPAN_FIELD = SdkField.<TimeSpan> builder(MarshallingType.SDK_POJO)
            .memberName("TimeSpan").getter(getter(JobInput::timeSpan)).setter(setter(Builder::timeSpan))
            .constructor(TimeSpan::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSpan").build()).build();

    private static final SdkField<InputCaptions> INPUT_CAPTIONS_FIELD = SdkField
            .<InputCaptions> builder(MarshallingType.SDK_POJO).memberName("InputCaptions")
            .getter(getter(JobInput::inputCaptions)).setter(setter(Builder::inputCaptions)).constructor(InputCaptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputCaptions").build()).build();

    private static final SdkField<DetectedProperties> DETECTED_PROPERTIES_FIELD = SdkField
            .<DetectedProperties> builder(MarshallingType.SDK_POJO).memberName("DetectedProperties")
            .getter(getter(JobInput::detectedProperties)).setter(setter(Builder::detectedProperties))
            .constructor(DetectedProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetectedProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, FRAME_RATE_FIELD,
            RESOLUTION_FIELD, ASPECT_RATIO_FIELD, INTERLACED_FIELD, CONTAINER_FIELD, ENCRYPTION_FIELD, TIME_SPAN_FIELD,
            INPUT_CAPTIONS_FIELD, DETECTED_PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String frameRate;

    private final String resolution;

    private final String aspectRatio;

    private final String interlaced;

    private final String container;

    private final Encryption encryption;

    private final TimeSpan timeSpan;

    private final InputCaptions inputCaptions;

    private final DetectedProperties detectedProperties;

    private JobInput(BuilderImpl builder) {
        this.key = builder.key;
        this.frameRate = builder.frameRate;
        this.resolution = builder.resolution;
        this.aspectRatio = builder.aspectRatio;
        this.interlaced = builder.interlaced;
        this.container = builder.container;
        this.encryption = builder.encryption;
        this.timeSpan = builder.timeSpan;
        this.inputCaptions = builder.inputCaptions;
        this.detectedProperties = builder.detectedProperties;
    }

    /**
     * <p>
     * The name of the file to transcode. Elsewhere in the body of the JSON block is the the ID of the pipeline to use
     * for processing the job. The <code>InputBucket</code> object in that pipeline tells Elastic Transcoder which
     * Amazon S3 bucket to get the file from.
     * </p>
     * <p>
     * If the file name includes a prefix, such as <code>cooking/lasagna.mpg</code>, include the prefix in the key. If
     * the file isn't in the specified bucket, Elastic Transcoder returns an error.
     * </p>
     * 
     * @return The name of the file to transcode. Elsewhere in the body of the JSON block is the the ID of the pipeline
     *         to use for processing the job. The <code>InputBucket</code> object in that pipeline tells Elastic
     *         Transcoder which Amazon S3 bucket to get the file from. </p>
     *         <p>
     *         If the file name includes a prefix, such as <code>cooking/lasagna.mpg</code>, include the prefix in the
     *         key. If the file isn't in the specified bucket, Elastic Transcoder returns an error.
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * The frame rate of the input file. If you want Elastic Transcoder to automatically detect the frame rate of the
     * input file, specify <code>auto</code>. If you want to specify the frame rate for the input file, enter one of the
     * following values:
     * </p>
     * <p>
     * <code>10</code>, <code>15</code>, <code>23.97</code>, <code>24</code>, <code>25</code>, <code>29.97</code>,
     * <code>30</code>, <code>60</code>
     * </p>
     * <p>
     * If you specify a value other than <code>auto</code>, Elastic Transcoder disables automatic detection of the frame
     * rate.
     * </p>
     * 
     * @return The frame rate of the input file. If you want Elastic Transcoder to automatically detect the frame rate
     *         of the input file, specify <code>auto</code>. If you want to specify the frame rate for the input file,
     *         enter one of the following values: </p>
     *         <p>
     *         <code>10</code>, <code>15</code>, <code>23.97</code>, <code>24</code>, <code>25</code>,
     *         <code>29.97</code>, <code>30</code>, <code>60</code>
     *         </p>
     *         <p>
     *         If you specify a value other than <code>auto</code>, Elastic Transcoder disables automatic detection of
     *         the frame rate.
     */
    public final String frameRate() {
        return frameRate;
    }

    /**
     * <p>
     * This value must be <code>auto</code>, which causes Elastic Transcoder to automatically detect the resolution of
     * the input file.
     * </p>
     * 
     * @return This value must be <code>auto</code>, which causes Elastic Transcoder to automatically detect the
     *         resolution of the input file.
     */
    public final String resolution() {
        return resolution;
    }

    /**
     * <p>
     * The aspect ratio of the input file. If you want Elastic Transcoder to automatically detect the aspect ratio of
     * the input file, specify <code>auto</code>. If you want to specify the aspect ratio for the output file, enter one
     * of the following values:
     * </p>
     * <p>
     * <code>1:1</code>, <code>4:3</code>, <code>3:2</code>, <code>16:9</code>
     * </p>
     * <p>
     * If you specify a value other than <code>auto</code>, Elastic Transcoder disables automatic detection of the
     * aspect ratio.
     * </p>
     * 
     * @return The aspect ratio of the input file. If you want Elastic Transcoder to automatically detect the aspect
     *         ratio of the input file, specify <code>auto</code>. If you want to specify the aspect ratio for the
     *         output file, enter one of the following values: </p>
     *         <p>
     *         <code>1:1</code>, <code>4:3</code>, <code>3:2</code>, <code>16:9</code>
     *         </p>
     *         <p>
     *         If you specify a value other than <code>auto</code>, Elastic Transcoder disables automatic detection of
     *         the aspect ratio.
     */
    public final String aspectRatio() {
        return aspectRatio;
    }

    /**
     * <p>
     * Whether the input file is interlaced. If you want Elastic Transcoder to automatically detect whether the input
     * file is interlaced, specify <code>auto</code>. If you want to specify whether the input file is interlaced, enter
     * one of the following values:
     * </p>
     * <p>
     * <code>true</code>, <code>false</code>
     * </p>
     * <p>
     * If you specify a value other than <code>auto</code>, Elastic Transcoder disables automatic detection of
     * interlacing.
     * </p>
     * 
     * @return Whether the input file is interlaced. If you want Elastic Transcoder to automatically detect whether the
     *         input file is interlaced, specify <code>auto</code>. If you want to specify whether the input file is
     *         interlaced, enter one of the following values:</p>
     *         <p>
     *         <code>true</code>, <code>false</code>
     *         </p>
     *         <p>
     *         If you specify a value other than <code>auto</code>, Elastic Transcoder disables automatic detection of
     *         interlacing.
     */
    public final String interlaced() {
        return interlaced;
    }

    /**
     * <p>
     * The container type for the input file. If you want Elastic Transcoder to automatically detect the container type
     * of the input file, specify <code>auto</code>. If you want to specify the container type for the input file, enter
     * one of the following values:
     * </p>
     * <p>
     * <code>3gp</code>, <code>aac</code>, <code>asf</code>, <code>avi</code>, <code>divx</code>, <code>flv</code>,
     * <code>m4a</code>, <code>mkv</code>, <code>mov</code>, <code>mp3</code>, <code>mp4</code>, <code>mpeg</code>,
     * <code>mpeg-ps</code>, <code>mpeg-ts</code>, <code>mxf</code>, <code>ogg</code>, <code>vob</code>,
     * <code>wav</code>, <code>webm</code>
     * </p>
     * 
     * @return The container type for the input file. If you want Elastic Transcoder to automatically detect the
     *         container type of the input file, specify <code>auto</code>. If you want to specify the container type
     *         for the input file, enter one of the following values: </p>
     *         <p>
     *         <code>3gp</code>, <code>aac</code>, <code>asf</code>, <code>avi</code>, <code>divx</code>,
     *         <code>flv</code>, <code>m4a</code>, <code>mkv</code>, <code>mov</code>, <code>mp3</code>,
     *         <code>mp4</code>, <code>mpeg</code>, <code>mpeg-ps</code>, <code>mpeg-ts</code>, <code>mxf</code>,
     *         <code>ogg</code>, <code>vob</code>, <code>wav</code>, <code>webm</code>
     */
    public final String container() {
        return container;
    }

    /**
     * <p>
     * The encryption settings, if any, that are used for decrypting your input files. If your input file is encrypted,
     * you must specify the mode that Elastic Transcoder uses to decrypt your file.
     * </p>
     * 
     * @return The encryption settings, if any, that are used for decrypting your input files. If your input file is
     *         encrypted, you must specify the mode that Elastic Transcoder uses to decrypt your file.
     */
    public final Encryption encryption() {
        return encryption;
    }

    /**
     * <p>
     * Settings for clipping an input. Each input can have different clip settings.
     * </p>
     * 
     * @return Settings for clipping an input. Each input can have different clip settings.
     */
    public final TimeSpan timeSpan() {
        return timeSpan;
    }

    /**
     * <p>
     * You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another. All
     * captions must be in UTF-8. Elastic Transcoder supports two types of captions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Embedded:</b> Embedded captions are included in the same file as the audio and video. Elastic Transcoder
     * supports only one embedded caption per language, to a maximum of 300 embedded captions per file.
     * </p>
     * <p>
     * Valid input values include: <code>CEA-608 (EIA-608</code>, first non-empty channel only),
     * <code>CEA-708 (EIA-708</code>, first non-empty channel only), and <code>mov-text</code>
     * </p>
     * <p>
     * Valid outputs include: <code>mov-text</code>
     * </p>
     * <p>
     * Elastic Transcoder supports a maximum of one embedded format per output.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Sidecar:</b> Sidecar captions are kept in a separate metadata file from the audio and video data. Sidecar
     * captions require a player that is capable of understanding the relationship between the video file and the
     * sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a maximum of 20 sidecar
     * captions per file.
     * </p>
     * <p>
     * Valid input values include: <code>dfxp</code> (first div element only), <code>ebu-tt</code>, <code>scc</code>,
     * <code>smpt</code>, <code>srt</code>, <code>ttml</code> (first div element only), and <code>webvtt</code>
     * </p>
     * <p>
     * Valid outputs include: <code>dfxp</code> (first div element only), <code>scc</code>, <code>srt</code>, and
     * <code>webvtt</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.
     * </p>
     * <p>
     * Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a valid
     * input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not preserve text
     * formatting (for example, italics) during the transcoding process.
     * </p>
     * <p>
     * To remove captions or leave the captions empty, set <code>Captions</code> to null. To pass through existing
     * captions unchanged, set the <code>MergePolicy</code> to <code>MergeRetain</code>, and pass in a null
     * <code>CaptionSources</code> array.
     * </p>
     * <p>
     * For more information on embedded files, see the Subtitles Wikipedia page.
     * </p>
     * <p>
     * For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia pages.
     * </p>
     * 
     * @return You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another. All
     *         captions must be in UTF-8. Elastic Transcoder supports two types of captions:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Embedded:</b> Embedded captions are included in the same file as the audio and video. Elastic
     *         Transcoder supports only one embedded caption per language, to a maximum of 300 embedded captions per
     *         file.
     *         </p>
     *         <p>
     *         Valid input values include: <code>CEA-608 (EIA-608</code>, first non-empty channel only),
     *         <code>CEA-708 (EIA-708</code>, first non-empty channel only), and <code>mov-text</code>
     *         </p>
     *         <p>
     *         Valid outputs include: <code>mov-text</code>
     *         </p>
     *         <p>
     *         Elastic Transcoder supports a maximum of one embedded format per output.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Sidecar:</b> Sidecar captions are kept in a separate metadata file from the audio and video data.
     *         Sidecar captions require a player that is capable of understanding the relationship between the video
     *         file and the sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a
     *         maximum of 20 sidecar captions per file.
     *         </p>
     *         <p>
     *         Valid input values include: <code>dfxp</code> (first div element only), <code>ebu-tt</code>,
     *         <code>scc</code>, <code>smpt</code>, <code>srt</code>, <code>ttml</code> (first div element only), and
     *         <code>webvtt</code>
     *         </p>
     *         <p>
     *         Valid outputs include: <code>dfxp</code> (first div element only), <code>scc</code>, <code>srt</code>,
     *         and <code>webvtt</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.
     *         </p>
     *         <p>
     *         Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a
     *         valid input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not
     *         preserve text formatting (for example, italics) during the transcoding process.
     *         </p>
     *         <p>
     *         To remove captions or leave the captions empty, set <code>Captions</code> to null. To pass through
     *         existing captions unchanged, set the <code>MergePolicy</code> to <code>MergeRetain</code>, and pass in a
     *         null <code>CaptionSources</code> array.
     *         </p>
     *         <p>
     *         For more information on embedded files, see the Subtitles Wikipedia page.
     *         </p>
     *         <p>
     *         For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia
     *         pages.
     */
    public final InputCaptions inputCaptions() {
        return inputCaptions;
    }

    /**
     * <p>
     * The detected properties of the input file.
     * </p>
     * 
     * @return The detected properties of the input file.
     */
    public final DetectedProperties detectedProperties() {
        return detectedProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(frameRate());
        hashCode = 31 * hashCode + Objects.hashCode(resolution());
        hashCode = 31 * hashCode + Objects.hashCode(aspectRatio());
        hashCode = 31 * hashCode + Objects.hashCode(interlaced());
        hashCode = 31 * hashCode + Objects.hashCode(container());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(timeSpan());
        hashCode = 31 * hashCode + Objects.hashCode(inputCaptions());
        hashCode = 31 * hashCode + Objects.hashCode(detectedProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobInput)) {
            return false;
        }
        JobInput other = (JobInput) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(frameRate(), other.frameRate())
                && Objects.equals(resolution(), other.resolution()) && Objects.equals(aspectRatio(), other.aspectRatio())
                && Objects.equals(interlaced(), other.interlaced()) && Objects.equals(container(), other.container())
                && Objects.equals(encryption(), other.encryption()) && Objects.equals(timeSpan(), other.timeSpan())
                && Objects.equals(inputCaptions(), other.inputCaptions())
                && Objects.equals(detectedProperties(), other.detectedProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobInput").add("Key", key()).add("FrameRate", frameRate()).add("Resolution", resolution())
                .add("AspectRatio", aspectRatio()).add("Interlaced", interlaced()).add("Container", container())
                .add("Encryption", encryption()).add("TimeSpan", timeSpan()).add("InputCaptions", inputCaptions())
                .add("DetectedProperties", detectedProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "FrameRate":
            return Optional.ofNullable(clazz.cast(frameRate()));
        case "Resolution":
            return Optional.ofNullable(clazz.cast(resolution()));
        case "AspectRatio":
            return Optional.ofNullable(clazz.cast(aspectRatio()));
        case "Interlaced":
            return Optional.ofNullable(clazz.cast(interlaced()));
        case "Container":
            return Optional.ofNullable(clazz.cast(container()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        case "TimeSpan":
            return Optional.ofNullable(clazz.cast(timeSpan()));
        case "InputCaptions":
            return Optional.ofNullable(clazz.cast(inputCaptions()));
        case "DetectedProperties":
            return Optional.ofNullable(clazz.cast(detectedProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobInput, T> g) {
        return obj -> g.apply((JobInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobInput> {
        /**
         * <p>
         * The name of the file to transcode. Elsewhere in the body of the JSON block is the the ID of the pipeline to
         * use for processing the job. The <code>InputBucket</code> object in that pipeline tells Elastic Transcoder
         * which Amazon S3 bucket to get the file from.
         * </p>
         * <p>
         * If the file name includes a prefix, such as <code>cooking/lasagna.mpg</code>, include the prefix in the key.
         * If the file isn't in the specified bucket, Elastic Transcoder returns an error.
         * </p>
         * 
         * @param key
         *        The name of the file to transcode. Elsewhere in the body of the JSON block is the the ID of the
         *        pipeline to use for processing the job. The <code>InputBucket</code> object in that pipeline tells
         *        Elastic Transcoder which Amazon S3 bucket to get the file from. </p>
         *        <p>
         *        If the file name includes a prefix, such as <code>cooking/lasagna.mpg</code>, include the prefix in
         *        the key. If the file isn't in the specified bucket, Elastic Transcoder returns an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The frame rate of the input file. If you want Elastic Transcoder to automatically detect the frame rate of
         * the input file, specify <code>auto</code>. If you want to specify the frame rate for the input file, enter
         * one of the following values:
         * </p>
         * <p>
         * <code>10</code>, <code>15</code>, <code>23.97</code>, <code>24</code>, <code>25</code>, <code>29.97</code>,
         * <code>30</code>, <code>60</code>
         * </p>
         * <p>
         * If you specify a value other than <code>auto</code>, Elastic Transcoder disables automatic detection of the
         * frame rate.
         * </p>
         * 
         * @param frameRate
         *        The frame rate of the input file. If you want Elastic Transcoder to automatically detect the frame
         *        rate of the input file, specify <code>auto</code>. If you want to specify the frame rate for the input
         *        file, enter one of the following values: </p>
         *        <p>
         *        <code>10</code>, <code>15</code>, <code>23.97</code>, <code>24</code>, <code>25</code>,
         *        <code>29.97</code>, <code>30</code>, <code>60</code>
         *        </p>
         *        <p>
         *        If you specify a value other than <code>auto</code>, Elastic Transcoder disables automatic detection
         *        of the frame rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameRate(String frameRate);

        /**
         * <p>
         * This value must be <code>auto</code>, which causes Elastic Transcoder to automatically detect the resolution
         * of the input file.
         * </p>
         * 
         * @param resolution
         *        This value must be <code>auto</code>, which causes Elastic Transcoder to automatically detect the
         *        resolution of the input file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolution(String resolution);

        /**
         * <p>
         * The aspect ratio of the input file. If you want Elastic Transcoder to automatically detect the aspect ratio
         * of the input file, specify <code>auto</code>. If you want to specify the aspect ratio for the output file,
         * enter one of the following values:
         * </p>
         * <p>
         * <code>1:1</code>, <code>4:3</code>, <code>3:2</code>, <code>16:9</code>
         * </p>
         * <p>
         * If you specify a value other than <code>auto</code>, Elastic Transcoder disables automatic detection of the
         * aspect ratio.
         * </p>
         * 
         * @param aspectRatio
         *        The aspect ratio of the input file. If you want Elastic Transcoder to automatically detect the aspect
         *        ratio of the input file, specify <code>auto</code>. If you want to specify the aspect ratio for the
         *        output file, enter one of the following values: </p>
         *        <p>
         *        <code>1:1</code>, <code>4:3</code>, <code>3:2</code>, <code>16:9</code>
         *        </p>
         *        <p>
         *        If you specify a value other than <code>auto</code>, Elastic Transcoder disables automatic detection
         *        of the aspect ratio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aspectRatio(String aspectRatio);

        /**
         * <p>
         * Whether the input file is interlaced. If you want Elastic Transcoder to automatically detect whether the
         * input file is interlaced, specify <code>auto</code>. If you want to specify whether the input file is
         * interlaced, enter one of the following values:
         * </p>
         * <p>
         * <code>true</code>, <code>false</code>
         * </p>
         * <p>
         * If you specify a value other than <code>auto</code>, Elastic Transcoder disables automatic detection of
         * interlacing.
         * </p>
         * 
         * @param interlaced
         *        Whether the input file is interlaced. If you want Elastic Transcoder to automatically detect whether
         *        the input file is interlaced, specify <code>auto</code>. If you want to specify whether the input file
         *        is interlaced, enter one of the following values:</p>
         *        <p>
         *        <code>true</code>, <code>false</code>
         *        </p>
         *        <p>
         *        If you specify a value other than <code>auto</code>, Elastic Transcoder disables automatic detection
         *        of interlacing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interlaced(String interlaced);

        /**
         * <p>
         * The container type for the input file. If you want Elastic Transcoder to automatically detect the container
         * type of the input file, specify <code>auto</code>. If you want to specify the container type for the input
         * file, enter one of the following values:
         * </p>
         * <p>
         * <code>3gp</code>, <code>aac</code>, <code>asf</code>, <code>avi</code>, <code>divx</code>, <code>flv</code>,
         * <code>m4a</code>, <code>mkv</code>, <code>mov</code>, <code>mp3</code>, <code>mp4</code>, <code>mpeg</code>,
         * <code>mpeg-ps</code>, <code>mpeg-ts</code>, <code>mxf</code>, <code>ogg</code>, <code>vob</code>,
         * <code>wav</code>, <code>webm</code>
         * </p>
         * 
         * @param container
         *        The container type for the input file. If you want Elastic Transcoder to automatically detect the
         *        container type of the input file, specify <code>auto</code>. If you want to specify the container type
         *        for the input file, enter one of the following values: </p>
         *        <p>
         *        <code>3gp</code>, <code>aac</code>, <code>asf</code>, <code>avi</code>, <code>divx</code>,
         *        <code>flv</code>, <code>m4a</code>, <code>mkv</code>, <code>mov</code>, <code>mp3</code>,
         *        <code>mp4</code>, <code>mpeg</code>, <code>mpeg-ps</code>, <code>mpeg-ts</code>, <code>mxf</code>,
         *        <code>ogg</code>, <code>vob</code>, <code>wav</code>, <code>webm</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder container(String container);

        /**
         * <p>
         * The encryption settings, if any, that are used for decrypting your input files. If your input file is
         * encrypted, you must specify the mode that Elastic Transcoder uses to decrypt your file.
         * </p>
         * 
         * @param encryption
         *        The encryption settings, if any, that are used for decrypting your input files. If your input file is
         *        encrypted, you must specify the mode that Elastic Transcoder uses to decrypt your file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(Encryption encryption);

        /**
         * <p>
         * The encryption settings, if any, that are used for decrypting your input files. If your input file is
         * encrypted, you must specify the mode that Elastic Transcoder uses to decrypt your file.
         * </p>
         * This is a convenience that creates an instance of the {@link Encryption.Builder} avoiding the need to create
         * one manually via {@link Encryption#builder()}.
         *
         * When the {@link Consumer} completes, {@link Encryption.Builder#build()} is called immediately and its result
         * is passed to {@link #encryption(Encryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link Encryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(Encryption)
         */
        default Builder encryption(Consumer<Encryption.Builder> encryption) {
            return encryption(Encryption.builder().applyMutation(encryption).build());
        }

        /**
         * <p>
         * Settings for clipping an input. Each input can have different clip settings.
         * </p>
         * 
         * @param timeSpan
         *        Settings for clipping an input. Each input can have different clip settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSpan(TimeSpan timeSpan);

        /**
         * <p>
         * Settings for clipping an input. Each input can have different clip settings.
         * </p>
         * This is a convenience that creates an instance of the {@link TimeSpan.Builder} avoiding the need to create
         * one manually via {@link TimeSpan#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimeSpan.Builder#build()} is called immediately and its result is
         * passed to {@link #timeSpan(TimeSpan)}.
         * 
         * @param timeSpan
         *        a consumer that will call methods on {@link TimeSpan.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeSpan(TimeSpan)
         */
        default Builder timeSpan(Consumer<TimeSpan.Builder> timeSpan) {
            return timeSpan(TimeSpan.builder().applyMutation(timeSpan).build());
        }

        /**
         * <p>
         * You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another. All
         * captions must be in UTF-8. Elastic Transcoder supports two types of captions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Embedded:</b> Embedded captions are included in the same file as the audio and video. Elastic Transcoder
         * supports only one embedded caption per language, to a maximum of 300 embedded captions per file.
         * </p>
         * <p>
         * Valid input values include: <code>CEA-608 (EIA-608</code>, first non-empty channel only),
         * <code>CEA-708 (EIA-708</code>, first non-empty channel only), and <code>mov-text</code>
         * </p>
         * <p>
         * Valid outputs include: <code>mov-text</code>
         * </p>
         * <p>
         * Elastic Transcoder supports a maximum of one embedded format per output.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Sidecar:</b> Sidecar captions are kept in a separate metadata file from the audio and video data. Sidecar
         * captions require a player that is capable of understanding the relationship between the video file and the
         * sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a maximum of 20 sidecar
         * captions per file.
         * </p>
         * <p>
         * Valid input values include: <code>dfxp</code> (first div element only), <code>ebu-tt</code>, <code>scc</code>, <code>smpt</code>, <code>srt</code>, <code>ttml</code> (first div element only), and <code>webvtt</code>
         * </p>
         * <p>
         * Valid outputs include: <code>dfxp</code> (first div element only), <code>scc</code>, <code>srt</code>, and
         * <code>webvtt</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.
         * </p>
         * <p>
         * Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a valid
         * input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not preserve
         * text formatting (for example, italics) during the transcoding process.
         * </p>
         * <p>
         * To remove captions or leave the captions empty, set <code>Captions</code> to null. To pass through existing
         * captions unchanged, set the <code>MergePolicy</code> to <code>MergeRetain</code>, and pass in a null
         * <code>CaptionSources</code> array.
         * </p>
         * <p>
         * For more information on embedded files, see the Subtitles Wikipedia page.
         * </p>
         * <p>
         * For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia pages.
         * </p>
         * 
         * @param inputCaptions
         *        You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another.
         *        All captions must be in UTF-8. Elastic Transcoder supports two types of captions:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Embedded:</b> Embedded captions are included in the same file as the audio and video. Elastic
         *        Transcoder supports only one embedded caption per language, to a maximum of 300 embedded captions per
         *        file.
         *        </p>
         *        <p>
         *        Valid input values include: <code>CEA-608 (EIA-608</code>, first non-empty channel only),
         *        <code>CEA-708 (EIA-708</code>, first non-empty channel only), and <code>mov-text</code>
         *        </p>
         *        <p>
         *        Valid outputs include: <code>mov-text</code>
         *        </p>
         *        <p>
         *        Elastic Transcoder supports a maximum of one embedded format per output.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Sidecar:</b> Sidecar captions are kept in a separate metadata file from the audio and video data.
         *        Sidecar captions require a player that is capable of understanding the relationship between the video
         *        file and the sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a
         *        maximum of 20 sidecar captions per file.
         *        </p>
         *        <p>
         *        Valid input values include: <code>dfxp</code> (first div element only), <code>ebu-tt</code>,
         *        <code>scc</code>, <code>smpt</code>, <code>srt</code>, <code>ttml</code> (first div element only), and
         *        <code>webvtt</code>
         *        </p>
         *        <p>
         *        Valid outputs include: <code>dfxp</code> (first div element only), <code>scc</code>, <code>srt</code>,
         *        and <code>webvtt</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.
         *        </p>
         *        <p>
         *        Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a
         *        valid input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not
         *        preserve text formatting (for example, italics) during the transcoding process.
         *        </p>
         *        <p>
         *        To remove captions or leave the captions empty, set <code>Captions</code> to null. To pass through
         *        existing captions unchanged, set the <code>MergePolicy</code> to <code>MergeRetain</code>, and pass in
         *        a null <code>CaptionSources</code> array.
         *        </p>
         *        <p>
         *        For more information on embedded files, see the Subtitles Wikipedia page.
         *        </p>
         *        <p>
         *        For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia
         *        pages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputCaptions(InputCaptions inputCaptions);

        /**
         * <p>
         * You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another. All
         * captions must be in UTF-8. Elastic Transcoder supports two types of captions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Embedded:</b> Embedded captions are included in the same file as the audio and video. Elastic Transcoder
         * supports only one embedded caption per language, to a maximum of 300 embedded captions per file.
         * </p>
         * <p>
         * Valid input values include: <code>CEA-608 (EIA-608</code>, first non-empty channel only),
         * <code>CEA-708 (EIA-708</code>, first non-empty channel only), and <code>mov-text</code>
         * </p>
         * <p>
         * Valid outputs include: <code>mov-text</code>
         * </p>
         * <p>
         * Elastic Transcoder supports a maximum of one embedded format per output.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Sidecar:</b> Sidecar captions are kept in a separate metadata file from the audio and video data. Sidecar
         * captions require a player that is capable of understanding the relationship between the video file and the
         * sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a maximum of 20 sidecar
         * captions per file.
         * </p>
         * <p>
         * Valid input values include: <code>dfxp</code> (first div element only), <code>ebu-tt</code>, <code>scc</code>, <code>smpt</code>, <code>srt</code>, <code>ttml</code> (first div element only), and <code>webvtt</code>
         * </p>
         * <p>
         * Valid outputs include: <code>dfxp</code> (first div element only), <code>scc</code>, <code>srt</code>, and
         * <code>webvtt</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.
         * </p>
         * <p>
         * Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a valid
         * input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not preserve
         * text formatting (for example, italics) during the transcoding process.
         * </p>
         * <p>
         * To remove captions or leave the captions empty, set <code>Captions</code> to null. To pass through existing
         * captions unchanged, set the <code>MergePolicy</code> to <code>MergeRetain</code>, and pass in a null
         * <code>CaptionSources</code> array.
         * </p>
         * <p>
         * For more information on embedded files, see the Subtitles Wikipedia page.
         * </p>
         * <p>
         * For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia pages.
         * </p>
         * This is a convenience that creates an instance of the {@link InputCaptions.Builder} avoiding the need to
         * create one manually via {@link InputCaptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputCaptions.Builder#build()} is called immediately and its
         * result is passed to {@link #inputCaptions(InputCaptions)}.
         * 
         * @param inputCaptions
         *        a consumer that will call methods on {@link InputCaptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputCaptions(InputCaptions)
         */
        default Builder inputCaptions(Consumer<InputCaptions.Builder> inputCaptions) {
            return inputCaptions(InputCaptions.builder().applyMutation(inputCaptions).build());
        }

        /**
         * <p>
         * The detected properties of the input file.
         * </p>
         * 
         * @param detectedProperties
         *        The detected properties of the input file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectedProperties(DetectedProperties detectedProperties);

        /**
         * <p>
         * The detected properties of the input file.
         * </p>
         * This is a convenience that creates an instance of the {@link DetectedProperties.Builder} avoiding the need to
         * create one manually via {@link DetectedProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link DetectedProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #detectedProperties(DetectedProperties)}.
         * 
         * @param detectedProperties
         *        a consumer that will call methods on {@link DetectedProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detectedProperties(DetectedProperties)
         */
        default Builder detectedProperties(Consumer<DetectedProperties.Builder> detectedProperties) {
            return detectedProperties(DetectedProperties.builder().applyMutation(detectedProperties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String frameRate;

        private String resolution;

        private String aspectRatio;

        private String interlaced;

        private String container;

        private Encryption encryption;

        private TimeSpan timeSpan;

        private InputCaptions inputCaptions;

        private DetectedProperties detectedProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(JobInput model) {
            key(model.key);
            frameRate(model.frameRate);
            resolution(model.resolution);
            aspectRatio(model.aspectRatio);
            interlaced(model.interlaced);
            container(model.container);
            encryption(model.encryption);
            timeSpan(model.timeSpan);
            inputCaptions(model.inputCaptions);
            detectedProperties(model.detectedProperties);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getFrameRate() {
            return frameRate;
        }

        @Override
        public final Builder frameRate(String frameRate) {
            this.frameRate = frameRate;
            return this;
        }

        public final void setFrameRate(String frameRate) {
            this.frameRate = frameRate;
        }

        public final String getResolution() {
            return resolution;
        }

        @Override
        public final Builder resolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        public final void setResolution(String resolution) {
            this.resolution = resolution;
        }

        public final String getAspectRatio() {
            return aspectRatio;
        }

        @Override
        public final Builder aspectRatio(String aspectRatio) {
            this.aspectRatio = aspectRatio;
            return this;
        }

        public final void setAspectRatio(String aspectRatio) {
            this.aspectRatio = aspectRatio;
        }

        public final String getInterlaced() {
            return interlaced;
        }

        @Override
        public final Builder interlaced(String interlaced) {
            this.interlaced = interlaced;
            return this;
        }

        public final void setInterlaced(String interlaced) {
            this.interlaced = interlaced;
        }

        public final String getContainer() {
            return container;
        }

        @Override
        public final Builder container(String container) {
            this.container = container;
            return this;
        }

        public final void setContainer(String container) {
            this.container = container;
        }

        public final Encryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(Encryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(Encryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final TimeSpan.Builder getTimeSpan() {
            return timeSpan != null ? timeSpan.toBuilder() : null;
        }

        @Override
        public final Builder timeSpan(TimeSpan timeSpan) {
            this.timeSpan = timeSpan;
            return this;
        }

        public final void setTimeSpan(TimeSpan.BuilderImpl timeSpan) {
            this.timeSpan = timeSpan != null ? timeSpan.build() : null;
        }

        public final InputCaptions.Builder getInputCaptions() {
            return inputCaptions != null ? inputCaptions.toBuilder() : null;
        }

        @Override
        public final Builder inputCaptions(InputCaptions inputCaptions) {
            this.inputCaptions = inputCaptions;
            return this;
        }

        public final void setInputCaptions(InputCaptions.BuilderImpl inputCaptions) {
            this.inputCaptions = inputCaptions != null ? inputCaptions.build() : null;
        }

        public final DetectedProperties.Builder getDetectedProperties() {
            return detectedProperties != null ? detectedProperties.toBuilder() : null;
        }

        @Override
        public final Builder detectedProperties(DetectedProperties detectedProperties) {
            this.detectedProperties = detectedProperties;
            return this;
        }

        public final void setDetectedProperties(DetectedProperties.BuilderImpl detectedProperties) {
            this.detectedProperties = detectedProperties != null ? detectedProperties.build() : null;
        }

        @Override
        public JobInput build() {
            return new JobInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
