/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elastictranscoder.model.HlsContentProtection;
import software.amazon.awssdk.services.elastictranscoder.model.OutputKeysCopier;
import software.amazon.awssdk.services.elastictranscoder.model.PlayReadyDrm;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Playlist
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Playlist> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Playlist.getter(Playlist::name)).setter(Playlist.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Playlist.getter(Playlist::format)).setter(Playlist.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()}).build();
    private static final SdkField<List<String>> OUTPUT_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Playlist.getter(Playlist::outputKeys)).setter(Playlist.setter(Builder::outputKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<HlsContentProtection> HLS_CONTENT_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Playlist.getter(Playlist::hlsContentProtection)).setter(Playlist.setter(Builder::hlsContentProtection)).constructor(HlsContentProtection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HlsContentProtection").build()}).build();
    private static final SdkField<PlayReadyDrm> PLAY_READY_DRM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Playlist.getter(Playlist::playReadyDrm)).setter(Playlist.setter(Builder::playReadyDrm)).constructor(PlayReadyDrm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayReadyDrm").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Playlist.getter(Playlist::status)).setter(Playlist.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Playlist.getter(Playlist::statusDetail)).setter(Playlist.setter(Builder::statusDetail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FORMAT_FIELD, OUTPUT_KEYS_FIELD, HLS_CONTENT_PROTECTION_FIELD, PLAY_READY_DRM_FIELD, STATUS_FIELD, STATUS_DETAIL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String format;
    private final List<String> outputKeys;
    private final HlsContentProtection hlsContentProtection;
    private final PlayReadyDrm playReadyDrm;
    private final String status;
    private final String statusDetail;

    private Playlist(BuilderImpl builder) {
        this.name = builder.name;
        this.format = builder.format;
        this.outputKeys = builder.outputKeys;
        this.hlsContentProtection = builder.hlsContentProtection;
        this.playReadyDrm = builder.playReadyDrm;
        this.status = builder.status;
        this.statusDetail = builder.statusDetail;
    }

    public String name() {
        return this.name;
    }

    public String format() {
        return this.format;
    }

    public boolean hasOutputKeys() {
        return this.outputKeys != null && !(this.outputKeys instanceof SdkAutoConstructList);
    }

    public List<String> outputKeys() {
        return this.outputKeys;
    }

    public HlsContentProtection hlsContentProtection() {
        return this.hlsContentProtection;
    }

    public PlayReadyDrm playReadyDrm() {
        return this.playReadyDrm;
    }

    public String status() {
        return this.status;
    }

    public String statusDetail() {
        return this.statusDetail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.format());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputKeys());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsContentProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.playReadyDrm());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetail());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Playlist)) {
            return false;
        }
        Playlist other = (Playlist)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.format(), other.format()) && Objects.equals(this.outputKeys(), other.outputKeys()) && Objects.equals(this.hlsContentProtection(), other.hlsContentProtection()) && Objects.equals(this.playReadyDrm(), other.playReadyDrm()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.statusDetail(), other.statusDetail());
    }

    public String toString() {
        return ToString.builder((String)"Playlist").add("Name", (Object)this.name()).add("Format", (Object)this.format()).add("OutputKeys", this.outputKeys()).add("HlsContentProtection", (Object)this.hlsContentProtection()).add("PlayReadyDrm", (Object)this.playReadyDrm()).add("Status", (Object)this.status()).add("StatusDetail", (Object)this.statusDetail()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.format()));
            }
            case "OutputKeys": {
                return Optional.ofNullable(clazz.cast(this.outputKeys()));
            }
            case "HlsContentProtection": {
                return Optional.ofNullable(clazz.cast(this.hlsContentProtection()));
            }
            case "PlayReadyDrm": {
                return Optional.ofNullable(clazz.cast(this.playReadyDrm()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "StatusDetail": {
                return Optional.ofNullable(clazz.cast(this.statusDetail()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Playlist, T> g) {
        return obj -> g.apply((Playlist)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String format;
        private List<String> outputKeys = DefaultSdkAutoConstructList.getInstance();
        private HlsContentProtection hlsContentProtection;
        private PlayReadyDrm playReadyDrm;
        private String status;
        private String statusDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(Playlist model) {
            this.name(model.name);
            this.format(model.format);
            this.outputKeys(model.outputKeys);
            this.hlsContentProtection(model.hlsContentProtection);
            this.playReadyDrm(model.playReadyDrm);
            this.status(model.status);
            this.statusDetail(model.statusDetail);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final Collection<String> getOutputKeys() {
            return this.outputKeys;
        }

        @Override
        public final Builder outputKeys(Collection<String> outputKeys) {
            this.outputKeys = OutputKeysCopier.copy(outputKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputKeys(String ... outputKeys) {
            this.outputKeys(Arrays.asList(outputKeys));
            return this;
        }

        public final void setOutputKeys(Collection<String> outputKeys) {
            this.outputKeys = OutputKeysCopier.copy(outputKeys);
        }

        public final HlsContentProtection.Builder getHlsContentProtection() {
            return this.hlsContentProtection != null ? this.hlsContentProtection.toBuilder() : null;
        }

        @Override
        public final Builder hlsContentProtection(HlsContentProtection hlsContentProtection) {
            this.hlsContentProtection = hlsContentProtection;
            return this;
        }

        public final void setHlsContentProtection(HlsContentProtection.BuilderImpl hlsContentProtection) {
            this.hlsContentProtection = hlsContentProtection != null ? hlsContentProtection.build() : null;
        }

        public final PlayReadyDrm.Builder getPlayReadyDrm() {
            return this.playReadyDrm != null ? this.playReadyDrm.toBuilder() : null;
        }

        @Override
        public final Builder playReadyDrm(PlayReadyDrm playReadyDrm) {
            this.playReadyDrm = playReadyDrm;
            return this;
        }

        public final void setPlayReadyDrm(PlayReadyDrm.BuilderImpl playReadyDrm) {
            this.playReadyDrm = playReadyDrm != null ? playReadyDrm.build() : null;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDetail() {
            return this.statusDetail;
        }

        @Override
        public final Builder statusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
            return this;
        }

        public final void setStatusDetail(String statusDetail) {
            this.statusDetail = statusDetail;
        }

        public Playlist build() {
            return new Playlist(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Playlist> {
        public Builder name(String var1);

        public Builder format(String var1);

        public Builder outputKeys(Collection<String> var1);

        public Builder outputKeys(String ... var1);

        public Builder hlsContentProtection(HlsContentProtection var1);

        default public Builder hlsContentProtection(Consumer<HlsContentProtection.Builder> hlsContentProtection) {
            return this.hlsContentProtection((HlsContentProtection)((HlsContentProtection.Builder)HlsContentProtection.builder().applyMutation(hlsContentProtection)).build());
        }

        public Builder playReadyDrm(PlayReadyDrm var1);

        default public Builder playReadyDrm(Consumer<PlayReadyDrm.Builder> playReadyDrm) {
            return this.playReadyDrm((PlayReadyDrm)((PlayReadyDrm.Builder)PlayReadyDrm.builder().applyMutation(playReadyDrm)).build());
        }

        public Builder status(String var1);

        public Builder statusDetail(String var1);
    }
}

