/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A source file for the input sidecar captions used during the transcoding process.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CaptionSource implements SdkPojo, Serializable, ToCopyableBuilder<CaptionSource.Builder, CaptionSource> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CaptionSource::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CaptionSource::language)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()).build();

    private static final SdkField<String> TIME_OFFSET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CaptionSource::timeOffset)).setter(setter(Builder::timeOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeOffset").build()).build();

    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CaptionSource::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()).build();

    private static final SdkField<Encryption> ENCRYPTION_FIELD = SdkField.<Encryption> builder(MarshallingType.SDK_POJO)
            .getter(getter(CaptionSource::encryption)).setter(setter(Builder::encryption)).constructor(Encryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encryption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, LANGUAGE_FIELD,
            TIME_OFFSET_FIELD, LABEL_FIELD, ENCRYPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String language;

    private final String timeOffset;

    private final String label;

    private final Encryption encryption;

    private CaptionSource(BuilderImpl builder) {
        this.key = builder.key;
        this.language = builder.language;
        this.timeOffset = builder.timeOffset;
        this.label = builder.label;
        this.encryption = builder.encryption;
    }

    /**
     * <p>
     * The name of the sidecar caption file that you want Elastic Transcoder to include in the output file.
     * </p>
     * 
     * @return The name of the sidecar caption file that you want Elastic Transcoder to include in the output file.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * A string that specifies the language of the caption. If you specified multiple inputs with captions, the caption
     * language must match in order to be included in the output. Specify this as one of:
     * </p>
     * <ul>
     * <li>
     * <p>
     * 2-character ISO 639-1 code
     * </p>
     * </li>
     * <li>
     * <p>
     * 3-character ISO 639-2 code
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information on ISO language codes and language names, see the List of ISO 639-1 codes.
     * </p>
     * 
     * @return A string that specifies the language of the caption. If you specified multiple inputs with captions, the
     *         caption language must match in order to be included in the output. Specify this as one of:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         2-character ISO 639-1 code
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         3-character ISO 639-2 code
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information on ISO language codes and language names, see the List of ISO 639-1 codes.
     */
    public String language() {
        return language;
    }

    /**
     * <p>
     * For clip generation or captions that do not start at the same time as the associated video file, the
     * <code>TimeOffset</code> tells Elastic Transcoder how much of the video to encode before including captions.
     * </p>
     * <p>
     * Specify the TimeOffset in the form [+-]SS.sss or [+-]HH:mm:SS.ss.
     * </p>
     * 
     * @return For clip generation or captions that do not start at the same time as the associated video file, the
     *         <code>TimeOffset</code> tells Elastic Transcoder how much of the video to encode before including
     *         captions.</p>
     *         <p>
     *         Specify the TimeOffset in the form [+-]SS.sss or [+-]HH:mm:SS.ss.
     */
    public String timeOffset() {
        return timeOffset;
    }

    /**
     * <p>
     * The label of the caption shown in the player when choosing a language. We recommend that you put the caption
     * language name here, in the language of the captions.
     * </p>
     * 
     * @return The label of the caption shown in the player when choosing a language. We recommend that you put the
     *         caption language name here, in the language of the captions.
     */
    public String label() {
        return label;
    }

    /**
     * <p>
     * The encryption settings, if any, that Elastic Transcoder needs to decyrpt your caption sources, or that you want
     * Elastic Transcoder to apply to your caption sources.
     * </p>
     * 
     * @return The encryption settings, if any, that Elastic Transcoder needs to decyrpt your caption sources, or that
     *         you want Elastic Transcoder to apply to your caption sources.
     */
    public Encryption encryption() {
        return encryption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(language());
        hashCode = 31 * hashCode + Objects.hashCode(timeOffset());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptionSource)) {
            return false;
        }
        CaptionSource other = (CaptionSource) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(language(), other.language())
                && Objects.equals(timeOffset(), other.timeOffset()) && Objects.equals(label(), other.label())
                && Objects.equals(encryption(), other.encryption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CaptionSource").add("Key", key()).add("Language", language()).add("TimeOffset", timeOffset())
                .add("Label", label()).add("Encryption", encryption()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Language":
            return Optional.ofNullable(clazz.cast(language()));
        case "TimeOffset":
            return Optional.ofNullable(clazz.cast(timeOffset()));
        case "Label":
            return Optional.ofNullable(clazz.cast(label()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CaptionSource, T> g) {
        return obj -> g.apply((CaptionSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CaptionSource> {
        /**
         * <p>
         * The name of the sidecar caption file that you want Elastic Transcoder to include in the output file.
         * </p>
         * 
         * @param key
         *        The name of the sidecar caption file that you want Elastic Transcoder to include in the output file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * A string that specifies the language of the caption. If you specified multiple inputs with captions, the
         * caption language must match in order to be included in the output. Specify this as one of:
         * </p>
         * <ul>
         * <li>
         * <p>
         * 2-character ISO 639-1 code
         * </p>
         * </li>
         * <li>
         * <p>
         * 3-character ISO 639-2 code
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information on ISO language codes and language names, see the List of ISO 639-1 codes.
         * </p>
         * 
         * @param language
         *        A string that specifies the language of the caption. If you specified multiple inputs with captions,
         *        the caption language must match in order to be included in the output. Specify this as one of:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        2-character ISO 639-1 code
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        3-character ISO 639-2 code
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information on ISO language codes and language names, see the List of ISO 639-1 codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder language(String language);

        /**
         * <p>
         * For clip generation or captions that do not start at the same time as the associated video file, the
         * <code>TimeOffset</code> tells Elastic Transcoder how much of the video to encode before including captions.
         * </p>
         * <p>
         * Specify the TimeOffset in the form [+-]SS.sss or [+-]HH:mm:SS.ss.
         * </p>
         * 
         * @param timeOffset
         *        For clip generation or captions that do not start at the same time as the associated video file, the
         *        <code>TimeOffset</code> tells Elastic Transcoder how much of the video to encode before including
         *        captions.</p>
         *        <p>
         *        Specify the TimeOffset in the form [+-]SS.sss or [+-]HH:mm:SS.ss.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeOffset(String timeOffset);

        /**
         * <p>
         * The label of the caption shown in the player when choosing a language. We recommend that you put the caption
         * language name here, in the language of the captions.
         * </p>
         * 
         * @param label
         *        The label of the caption shown in the player when choosing a language. We recommend that you put the
         *        caption language name here, in the language of the captions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * The encryption settings, if any, that Elastic Transcoder needs to decyrpt your caption sources, or that you
         * want Elastic Transcoder to apply to your caption sources.
         * </p>
         * 
         * @param encryption
         *        The encryption settings, if any, that Elastic Transcoder needs to decyrpt your caption sources, or
         *        that you want Elastic Transcoder to apply to your caption sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(Encryption encryption);

        /**
         * <p>
         * The encryption settings, if any, that Elastic Transcoder needs to decyrpt your caption sources, or that you
         * want Elastic Transcoder to apply to your caption sources.
         * </p>
         * This is a convenience that creates an instance of the {@link Encryption.Builder} avoiding the need to create
         * one manually via {@link Encryption#builder()}.
         *
         * When the {@link Consumer} completes, {@link Encryption.Builder#build()} is called immediately and its result
         * is passed to {@link #encryption(Encryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link Encryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(Encryption)
         */
        default Builder encryption(Consumer<Encryption.Builder> encryption) {
            return encryption(Encryption.builder().applyMutation(encryption).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String language;

        private String timeOffset;

        private String label;

        private Encryption encryption;

        private BuilderImpl() {
        }

        private BuilderImpl(CaptionSource model) {
            key(model.key);
            language(model.language);
            timeOffset(model.timeOffset);
            label(model.label);
            encryption(model.encryption);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getLanguage() {
            return language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        public final String getTimeOffset() {
            return timeOffset;
        }

        @Override
        public final Builder timeOffset(String timeOffset) {
            this.timeOffset = timeOffset;
            return this;
        }

        public final void setTimeOffset(String timeOffset) {
            this.timeOffset = timeOffset;
        }

        public final String getLabel() {
            return label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final Encryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(Encryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(Encryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public CaptionSource build() {
            return new CaptionSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
