/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>CreateJobOutput</code> structure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateJobOutput implements SdkPojo, Serializable, ToCopyableBuilder<CreateJobOutput.Builder, CreateJobOutput> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateJobOutput::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<String> THUMBNAIL_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateJobOutput::thumbnailPattern)).setter(setter(Builder::thumbnailPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThumbnailPattern").build()).build();

    private static final SdkField<Encryption> THUMBNAIL_ENCRYPTION_FIELD = SdkField
            .<Encryption> builder(MarshallingType.SDK_POJO).getter(getter(CreateJobOutput::thumbnailEncryption))
            .setter(setter(Builder::thumbnailEncryption)).constructor(Encryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThumbnailEncryption").build())
            .build();

    private static final SdkField<String> ROTATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateJobOutput::rotate)).setter(setter(Builder::rotate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rotate").build()).build();

    private static final SdkField<String> PRESET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateJobOutput::presetId)).setter(setter(Builder::presetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PresetId").build()).build();

    private static final SdkField<String> SEGMENT_DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateJobOutput::segmentDuration)).setter(setter(Builder::segmentDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentDuration").build()).build();

    private static final SdkField<List<JobWatermark>> WATERMARKS_FIELD = SdkField
            .<List<JobWatermark>> builder(MarshallingType.LIST)
            .getter(getter(CreateJobOutput::watermarks))
            .setter(setter(Builder::watermarks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Watermarks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobWatermark> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobWatermark::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<JobAlbumArt> ALBUM_ART_FIELD = SdkField.<JobAlbumArt> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateJobOutput::albumArt)).setter(setter(Builder::albumArt)).constructor(JobAlbumArt::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlbumArt").build()).build();

    private static final SdkField<List<Clip>> COMPOSITION_FIELD = SdkField
            .<List<Clip>> builder(MarshallingType.LIST)
            .getter(getter(CreateJobOutput::composition))
            .setter(setter(Builder::composition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Composition").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Clip> builder(MarshallingType.SDK_POJO)
                                            .constructor(Clip::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Captions> CAPTIONS_FIELD = SdkField.<Captions> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateJobOutput::captions)).setter(setter(Builder::captions)).constructor(Captions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Captions").build()).build();

    private static final SdkField<Encryption> ENCRYPTION_FIELD = SdkField.<Encryption> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateJobOutput::encryption)).setter(setter(Builder::encryption)).constructor(Encryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encryption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD,
            THUMBNAIL_PATTERN_FIELD, THUMBNAIL_ENCRYPTION_FIELD, ROTATE_FIELD, PRESET_ID_FIELD, SEGMENT_DURATION_FIELD,
            WATERMARKS_FIELD, ALBUM_ART_FIELD, COMPOSITION_FIELD, CAPTIONS_FIELD, ENCRYPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String thumbnailPattern;

    private final Encryption thumbnailEncryption;

    private final String rotate;

    private final String presetId;

    private final String segmentDuration;

    private final List<JobWatermark> watermarks;

    private final JobAlbumArt albumArt;

    private final List<Clip> composition;

    private final Captions captions;

    private final Encryption encryption;

    private CreateJobOutput(BuilderImpl builder) {
        this.key = builder.key;
        this.thumbnailPattern = builder.thumbnailPattern;
        this.thumbnailEncryption = builder.thumbnailEncryption;
        this.rotate = builder.rotate;
        this.presetId = builder.presetId;
        this.segmentDuration = builder.segmentDuration;
        this.watermarks = builder.watermarks;
        this.albumArt = builder.albumArt;
        this.composition = builder.composition;
        this.captions = builder.captions;
        this.encryption = builder.encryption;
    }

    /**
     * <p>
     * The name to assign to the transcoded file. Elastic Transcoder saves the file in the Amazon S3 bucket specified by
     * the <code>OutputBucket</code> object in the pipeline that is specified by the pipeline ID. If a file with the
     * specified name already exists in the output bucket, the job fails.
     * </p>
     * 
     * @return The name to assign to the transcoded file. Elastic Transcoder saves the file in the Amazon S3 bucket
     *         specified by the <code>OutputBucket</code> object in the pipeline that is specified by the pipeline ID.
     *         If a file with the specified name already exists in the output bucket, the job fails.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * Whether you want Elastic Transcoder to create thumbnails for your videos and, if so, how you want Elastic
     * Transcoder to name the files.
     * </p>
     * <p>
     * If you don't want Elastic Transcoder to create thumbnails, specify "".
     * </p>
     * <p>
     * If you do want Elastic Transcoder to create thumbnails, specify the information that you want to include in the
     * file name for each thumbnail. You can specify the following values in any sequence:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>{count}</code> (Required)</b>: If you want to create thumbnails, you must include <code>{count}</code>
     * in the <code>ThumbnailPattern</code> object. Wherever you specify <code>{count}</code>, Elastic Transcoder adds a
     * five-digit sequence number (beginning with <b>00001</b>) to thumbnail file names. The number indicates where a
     * given thumbnail appears in the sequence of thumbnails for a transcoded file.
     * </p>
     * <important>
     * <p>
     * If you specify a literal value and/or <code>{resolution}</code> but you omit <code>{count}</code>, Elastic
     * Transcoder returns a validation error and does not create the job.
     * </p>
     * </important></li>
     * <li>
     * <p>
     * <b>Literal values (Optional)</b>: You can specify literal values anywhere in the <code>ThumbnailPattern</code>
     * object. For example, you can include them as a file name prefix or as a delimiter between
     * <code>{resolution}</code> and <code>{count}</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>{resolution}</code> (Optional)</b>: If you want Elastic Transcoder to include the resolution in the
     * file name, include <code>{resolution}</code> in the <code>ThumbnailPattern</code> object.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When creating thumbnails, Elastic Transcoder automatically saves the files in the format (.jpg or .png) that
     * appears in the preset that you specified in the <code>PresetID</code> value of <code>CreateJobOutput</code>.
     * Elastic Transcoder also appends the applicable file name extension.
     * </p>
     * 
     * @return Whether you want Elastic Transcoder to create thumbnails for your videos and, if so, how you want Elastic
     *         Transcoder to name the files.</p>
     *         <p>
     *         If you don't want Elastic Transcoder to create thumbnails, specify "".
     *         </p>
     *         <p>
     *         If you do want Elastic Transcoder to create thumbnails, specify the information that you want to include
     *         in the file name for each thumbnail. You can specify the following values in any sequence:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>{count}</code> (Required)</b>: If you want to create thumbnails, you must include
     *         <code>{count}</code> in the <code>ThumbnailPattern</code> object. Wherever you specify
     *         <code>{count}</code>, Elastic Transcoder adds a five-digit sequence number (beginning with <b>00001</b>)
     *         to thumbnail file names. The number indicates where a given thumbnail appears in the sequence of
     *         thumbnails for a transcoded file.
     *         </p>
     *         <important>
     *         <p>
     *         If you specify a literal value and/or <code>{resolution}</code> but you omit <code>{count}</code>,
     *         Elastic Transcoder returns a validation error and does not create the job.
     *         </p>
     *         </important></li>
     *         <li>
     *         <p>
     *         <b>Literal values (Optional)</b>: You can specify literal values anywhere in the
     *         <code>ThumbnailPattern</code> object. For example, you can include them as a file name prefix or as a
     *         delimiter between <code>{resolution}</code> and <code>{count}</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>{resolution}</code> (Optional)</b>: If you want Elastic Transcoder to include the resolution in
     *         the file name, include <code>{resolution}</code> in the <code>ThumbnailPattern</code> object.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When creating thumbnails, Elastic Transcoder automatically saves the files in the format (.jpg or .png)
     *         that appears in the preset that you specified in the <code>PresetID</code> value of
     *         <code>CreateJobOutput</code>. Elastic Transcoder also appends the applicable file name extension.
     */
    public String thumbnailPattern() {
        return thumbnailPattern;
    }

    /**
     * <p>
     * The encryption settings, if any, that you want Elastic Transcoder to apply to your thumbnail.
     * </p>
     * 
     * @return The encryption settings, if any, that you want Elastic Transcoder to apply to your thumbnail.
     */
    public Encryption thumbnailEncryption() {
        return thumbnailEncryption;
    }

    /**
     * <p>
     * The number of degrees clockwise by which you want Elastic Transcoder to rotate the output relative to the input.
     * Enter one of the following values: <code>auto</code>, <code>0</code>, <code>90</code>, <code>180</code>,
     * <code>270</code>. The value <code>auto</code> generally works only if the file that you're transcoding contains
     * rotation metadata.
     * </p>
     * 
     * @return The number of degrees clockwise by which you want Elastic Transcoder to rotate the output relative to the
     *         input. Enter one of the following values: <code>auto</code>, <code>0</code>, <code>90</code>,
     *         <code>180</code>, <code>270</code>. The value <code>auto</code> generally works only if the file that
     *         you're transcoding contains rotation metadata.
     */
    public String rotate() {
        return rotate;
    }

    /**
     * <p>
     * The <code>Id</code> of the preset to use for this job. The preset determines the audio, video, and thumbnail
     * settings that Elastic Transcoder uses for transcoding.
     * </p>
     * 
     * @return The <code>Id</code> of the preset to use for this job. The preset determines the audio, video, and
     *         thumbnail settings that Elastic Transcoder uses for transcoding.
     */
    public String presetId() {
        return presetId;
    }

    /**
     * <important>
     * <p>
     * (Outputs in Fragmented MP4 or MPEG-TS format only.
     * </p>
     * </important>
     * <p>
     * If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is
     * <code>fmp4</code> (Fragmented MP4) or <code>ts</code> (MPEG-TS), <code>SegmentDuration</code> is the target
     * maximum duration of each segment in seconds. For <code>HLSv3</code> format playlists, each media segment is
     * stored in a separate <code>.ts</code> file. For <code>HLSv4</code> and <code>Smooth</code> playlists, all media
     * segments for an output are stored in a single file. Each segment is approximately the length of the
     * <code>SegmentDuration</code>, though individual segments might be shorter or longer.
     * </p>
     * <p>
     * The range of valid values is 1 to 60 seconds. If the duration of the video is not evenly divisible by
     * <code>SegmentDuration</code>, the duration of the last segment is the remainder of total length/SegmentDuration.
     * </p>
     * <p>
     * Elastic Transcoder creates an output-specific playlist for each output <code>HLS</code> output that you specify
     * in OutputKeys. To add an output to the master playlist for this job, include it in the <code>OutputKeys</code> of
     * the associated playlist.
     * </p>
     * 
     * @return <p>
     *         (Outputs in Fragmented MP4 or MPEG-TS format only.
     *         </p>
     *         </important>
     *         <p>
     *         If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is
     *         <code>fmp4</code> (Fragmented MP4) or <code>ts</code> (MPEG-TS), <code>SegmentDuration</code> is the
     *         target maximum duration of each segment in seconds. For <code>HLSv3</code> format playlists, each media
     *         segment is stored in a separate <code>.ts</code> file. For <code>HLSv4</code> and <code>Smooth</code>
     *         playlists, all media segments for an output are stored in a single file. Each segment is approximately
     *         the length of the <code>SegmentDuration</code>, though individual segments might be shorter or longer.
     *         </p>
     *         <p>
     *         The range of valid values is 1 to 60 seconds. If the duration of the video is not evenly divisible by
     *         <code>SegmentDuration</code>, the duration of the last segment is the remainder of total
     *         length/SegmentDuration.
     *         </p>
     *         <p>
     *         Elastic Transcoder creates an output-specific playlist for each output <code>HLS</code> output that you
     *         specify in OutputKeys. To add an output to the master playlist for this job, include it in the
     *         <code>OutputKeys</code> of the associated playlist.
     */
    public String segmentDuration() {
        return segmentDuration;
    }

    /**
     * Returns true if the Watermarks property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasWatermarks() {
        return watermarks != null && !(watermarks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the watermarks that you want Elastic Transcoder to add to the video during transcoding. You can
     * specify up to four watermarks for each output. Settings for each watermark must be defined in the preset for the
     * current output.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWatermarks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the watermarks that you want Elastic Transcoder to add to the video during transcoding.
     *         You can specify up to four watermarks for each output. Settings for each watermark must be defined in the
     *         preset for the current output.
     */
    public List<JobWatermark> watermarks() {
        return watermarks;
    }

    /**
     * <p>
     * Information about the album art that you want Elastic Transcoder to add to the file during transcoding. You can
     * specify up to twenty album artworks for each output. Settings for each artwork must be defined in the job for the
     * current output.
     * </p>
     * 
     * @return Information about the album art that you want Elastic Transcoder to add to the file during transcoding.
     *         You can specify up to twenty album artworks for each output. Settings for each artwork must be defined in
     *         the job for the current output.
     */
    public JobAlbumArt albumArt() {
        return albumArt;
    }

    /**
     * Returns true if the Composition property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasComposition() {
        return composition != null && !(composition instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * You can create an output file that contains an excerpt from the input file. This excerpt, called a clip, can come
     * from the beginning, middle, or end of the file. The Composition object contains settings for the clips that make
     * up an output file. For the current release, you can only specify settings for a single clip per output file. The
     * Composition object cannot be null.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasComposition()} to see if a value was sent in this field.
     * </p>
     * 
     * @return You can create an output file that contains an excerpt from the input file. This excerpt, called a clip,
     *         can come from the beginning, middle, or end of the file. The Composition object contains settings for the
     *         clips that make up an output file. For the current release, you can only specify settings for a single
     *         clip per output file. The Composition object cannot be null.
     */
    public List<Clip> composition() {
        return composition;
    }

    /**
     * <p>
     * You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another. All
     * captions must be in UTF-8. Elastic Transcoder supports two types of captions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Embedded:</b> Embedded captions are included in the same file as the audio and video. Elastic Transcoder
     * supports only one embedded caption per language, to a maximum of 300 embedded captions per file.
     * </p>
     * <p>
     * Valid input values include: <code>CEA-608 (EIA-608</code>, first non-empty channel only),
     * <code>CEA-708 (EIA-708</code>, first non-empty channel only), and <code>mov-text</code>
     * </p>
     * <p>
     * Valid outputs include: <code>mov-text</code>
     * </p>
     * <p>
     * Elastic Transcoder supports a maximum of one embedded format per output.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Sidecar:</b> Sidecar captions are kept in a separate metadata file from the audio and video data. Sidecar
     * captions require a player that is capable of understanding the relationship between the video file and the
     * sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a maximum of 20 sidecar
     * captions per file.
     * </p>
     * <p>
     * Valid input values include: <code>dfxp</code> (first div element only), <code>ebu-tt</code>, <code>scc</code>,
     * <code>smpt</code>, <code>srt</code>, <code>ttml</code> (first div element only), and <code>webvtt</code>
     * </p>
     * <p>
     * Valid outputs include: <code>dfxp</code> (first div element only), <code>scc</code>, <code>srt</code>, and
     * <code>webvtt</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.
     * </p>
     * <p>
     * Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a valid
     * input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not preserve text
     * formatting (for example, italics) during the transcoding process.
     * </p>
     * <p>
     * To remove captions or leave the captions empty, set <code>Captions</code> to null. To pass through existing
     * captions unchanged, set the <code>MergePolicy</code> to <code>MergeRetain</code>, and pass in a null
     * <code>CaptionSources</code> array.
     * </p>
     * <p>
     * For more information on embedded files, see the Subtitles Wikipedia page.
     * </p>
     * <p>
     * For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia pages.
     * </p>
     * 
     * @return You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another. All
     *         captions must be in UTF-8. Elastic Transcoder supports two types of captions:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Embedded:</b> Embedded captions are included in the same file as the audio and video. Elastic
     *         Transcoder supports only one embedded caption per language, to a maximum of 300 embedded captions per
     *         file.
     *         </p>
     *         <p>
     *         Valid input values include: <code>CEA-608 (EIA-608</code>, first non-empty channel only),
     *         <code>CEA-708 (EIA-708</code>, first non-empty channel only), and <code>mov-text</code>
     *         </p>
     *         <p>
     *         Valid outputs include: <code>mov-text</code>
     *         </p>
     *         <p>
     *         Elastic Transcoder supports a maximum of one embedded format per output.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Sidecar:</b> Sidecar captions are kept in a separate metadata file from the audio and video data.
     *         Sidecar captions require a player that is capable of understanding the relationship between the video
     *         file and the sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a
     *         maximum of 20 sidecar captions per file.
     *         </p>
     *         <p>
     *         Valid input values include: <code>dfxp</code> (first div element only), <code>ebu-tt</code>,
     *         <code>scc</code>, <code>smpt</code>, <code>srt</code>, <code>ttml</code> (first div element only), and
     *         <code>webvtt</code>
     *         </p>
     *         <p>
     *         Valid outputs include: <code>dfxp</code> (first div element only), <code>scc</code>, <code>srt</code>,
     *         and <code>webvtt</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.
     *         </p>
     *         <p>
     *         Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a
     *         valid input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not
     *         preserve text formatting (for example, italics) during the transcoding process.
     *         </p>
     *         <p>
     *         To remove captions or leave the captions empty, set <code>Captions</code> to null. To pass through
     *         existing captions unchanged, set the <code>MergePolicy</code> to <code>MergeRetain</code>, and pass in a
     *         null <code>CaptionSources</code> array.
     *         </p>
     *         <p>
     *         For more information on embedded files, see the Subtitles Wikipedia page.
     *         </p>
     *         <p>
     *         For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia
     *         pages.
     */
    public Captions captions() {
        return captions;
    }

    /**
     * <p>
     * You can specify encryption settings for any output files that you want to use for a transcoding job. This
     * includes the output file and any watermarks, thumbnails, album art, or captions that you want to use. You must
     * specify encryption settings for each file individually.
     * </p>
     * 
     * @return You can specify encryption settings for any output files that you want to use for a transcoding job. This
     *         includes the output file and any watermarks, thumbnails, album art, or captions that you want to use. You
     *         must specify encryption settings for each file individually.
     */
    public Encryption encryption() {
        return encryption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(thumbnailPattern());
        hashCode = 31 * hashCode + Objects.hashCode(thumbnailEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(rotate());
        hashCode = 31 * hashCode + Objects.hashCode(presetId());
        hashCode = 31 * hashCode + Objects.hashCode(segmentDuration());
        hashCode = 31 * hashCode + Objects.hashCode(watermarks());
        hashCode = 31 * hashCode + Objects.hashCode(albumArt());
        hashCode = 31 * hashCode + Objects.hashCode(composition());
        hashCode = 31 * hashCode + Objects.hashCode(captions());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobOutput)) {
            return false;
        }
        CreateJobOutput other = (CreateJobOutput) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(thumbnailPattern(), other.thumbnailPattern())
                && Objects.equals(thumbnailEncryption(), other.thumbnailEncryption()) && Objects.equals(rotate(), other.rotate())
                && Objects.equals(presetId(), other.presetId()) && Objects.equals(segmentDuration(), other.segmentDuration())
                && Objects.equals(watermarks(), other.watermarks()) && Objects.equals(albumArt(), other.albumArt())
                && Objects.equals(composition(), other.composition()) && Objects.equals(captions(), other.captions())
                && Objects.equals(encryption(), other.encryption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateJobOutput").add("Key", key()).add("ThumbnailPattern", thumbnailPattern())
                .add("ThumbnailEncryption", thumbnailEncryption()).add("Rotate", rotate()).add("PresetId", presetId())
                .add("SegmentDuration", segmentDuration()).add("Watermarks", watermarks()).add("AlbumArt", albumArt())
                .add("Composition", composition()).add("Captions", captions()).add("Encryption", encryption()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "ThumbnailPattern":
            return Optional.ofNullable(clazz.cast(thumbnailPattern()));
        case "ThumbnailEncryption":
            return Optional.ofNullable(clazz.cast(thumbnailEncryption()));
        case "Rotate":
            return Optional.ofNullable(clazz.cast(rotate()));
        case "PresetId":
            return Optional.ofNullable(clazz.cast(presetId()));
        case "SegmentDuration":
            return Optional.ofNullable(clazz.cast(segmentDuration()));
        case "Watermarks":
            return Optional.ofNullable(clazz.cast(watermarks()));
        case "AlbumArt":
            return Optional.ofNullable(clazz.cast(albumArt()));
        case "Composition":
            return Optional.ofNullable(clazz.cast(composition()));
        case "Captions":
            return Optional.ofNullable(clazz.cast(captions()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateJobOutput, T> g) {
        return obj -> g.apply((CreateJobOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateJobOutput> {
        /**
         * <p>
         * The name to assign to the transcoded file. Elastic Transcoder saves the file in the Amazon S3 bucket
         * specified by the <code>OutputBucket</code> object in the pipeline that is specified by the pipeline ID. If a
         * file with the specified name already exists in the output bucket, the job fails.
         * </p>
         * 
         * @param key
         *        The name to assign to the transcoded file. Elastic Transcoder saves the file in the Amazon S3 bucket
         *        specified by the <code>OutputBucket</code> object in the pipeline that is specified by the pipeline
         *        ID. If a file with the specified name already exists in the output bucket, the job fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * Whether you want Elastic Transcoder to create thumbnails for your videos and, if so, how you want Elastic
         * Transcoder to name the files.
         * </p>
         * <p>
         * If you don't want Elastic Transcoder to create thumbnails, specify "".
         * </p>
         * <p>
         * If you do want Elastic Transcoder to create thumbnails, specify the information that you want to include in
         * the file name for each thumbnail. You can specify the following values in any sequence:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>{count}</code> (Required)</b>: If you want to create thumbnails, you must include
         * <code>{count}</code> in the <code>ThumbnailPattern</code> object. Wherever you specify <code>{count}</code>,
         * Elastic Transcoder adds a five-digit sequence number (beginning with <b>00001</b>) to thumbnail file names.
         * The number indicates where a given thumbnail appears in the sequence of thumbnails for a transcoded file.
         * </p>
         * <important>
         * <p>
         * If you specify a literal value and/or <code>{resolution}</code> but you omit <code>{count}</code>, Elastic
         * Transcoder returns a validation error and does not create the job.
         * </p>
         * </important></li>
         * <li>
         * <p>
         * <b>Literal values (Optional)</b>: You can specify literal values anywhere in the
         * <code>ThumbnailPattern</code> object. For example, you can include them as a file name prefix or as a
         * delimiter between <code>{resolution}</code> and <code>{count}</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>{resolution}</code> (Optional)</b>: If you want Elastic Transcoder to include the resolution in the
         * file name, include <code>{resolution}</code> in the <code>ThumbnailPattern</code> object.
         * </p>
         * </li>
         * </ul>
         * <p>
         * When creating thumbnails, Elastic Transcoder automatically saves the files in the format (.jpg or .png) that
         * appears in the preset that you specified in the <code>PresetID</code> value of <code>CreateJobOutput</code>.
         * Elastic Transcoder also appends the applicable file name extension.
         * </p>
         * 
         * @param thumbnailPattern
         *        Whether you want Elastic Transcoder to create thumbnails for your videos and, if so, how you want
         *        Elastic Transcoder to name the files.</p>
         *        <p>
         *        If you don't want Elastic Transcoder to create thumbnails, specify "".
         *        </p>
         *        <p>
         *        If you do want Elastic Transcoder to create thumbnails, specify the information that you want to
         *        include in the file name for each thumbnail. You can specify the following values in any sequence:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>{count}</code> (Required)</b>: If you want to create thumbnails, you must include
         *        <code>{count}</code> in the <code>ThumbnailPattern</code> object. Wherever you specify
         *        <code>{count}</code>, Elastic Transcoder adds a five-digit sequence number (beginning with
         *        <b>00001</b>) to thumbnail file names. The number indicates where a given thumbnail appears in the
         *        sequence of thumbnails for a transcoded file.
         *        </p>
         *        <important>
         *        <p>
         *        If you specify a literal value and/or <code>{resolution}</code> but you omit <code>{count}</code>,
         *        Elastic Transcoder returns a validation error and does not create the job.
         *        </p>
         *        </important></li>
         *        <li>
         *        <p>
         *        <b>Literal values (Optional)</b>: You can specify literal values anywhere in the
         *        <code>ThumbnailPattern</code> object. For example, you can include them as a file name prefix or as a
         *        delimiter between <code>{resolution}</code> and <code>{count}</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>{resolution}</code> (Optional)</b>: If you want Elastic Transcoder to include the resolution
         *        in the file name, include <code>{resolution}</code> in the <code>ThumbnailPattern</code> object.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When creating thumbnails, Elastic Transcoder automatically saves the files in the format (.jpg or
         *        .png) that appears in the preset that you specified in the <code>PresetID</code> value of
         *        <code>CreateJobOutput</code>. Elastic Transcoder also appends the applicable file name extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbnailPattern(String thumbnailPattern);

        /**
         * <p>
         * The encryption settings, if any, that you want Elastic Transcoder to apply to your thumbnail.
         * </p>
         * 
         * @param thumbnailEncryption
         *        The encryption settings, if any, that you want Elastic Transcoder to apply to your thumbnail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbnailEncryption(Encryption thumbnailEncryption);

        /**
         * <p>
         * The encryption settings, if any, that you want Elastic Transcoder to apply to your thumbnail.
         * </p>
         * This is a convenience that creates an instance of the {@link Encryption.Builder} avoiding the need to create
         * one manually via {@link Encryption#builder()}.
         *
         * When the {@link Consumer} completes, {@link Encryption.Builder#build()} is called immediately and its result
         * is passed to {@link #thumbnailEncryption(Encryption)}.
         * 
         * @param thumbnailEncryption
         *        a consumer that will call methods on {@link Encryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thumbnailEncryption(Encryption)
         */
        default Builder thumbnailEncryption(Consumer<Encryption.Builder> thumbnailEncryption) {
            return thumbnailEncryption(Encryption.builder().applyMutation(thumbnailEncryption).build());
        }

        /**
         * <p>
         * The number of degrees clockwise by which you want Elastic Transcoder to rotate the output relative to the
         * input. Enter one of the following values: <code>auto</code>, <code>0</code>, <code>90</code>,
         * <code>180</code>, <code>270</code>. The value <code>auto</code> generally works only if the file that you're
         * transcoding contains rotation metadata.
         * </p>
         * 
         * @param rotate
         *        The number of degrees clockwise by which you want Elastic Transcoder to rotate the output relative to
         *        the input. Enter one of the following values: <code>auto</code>, <code>0</code>, <code>90</code>,
         *        <code>180</code>, <code>270</code>. The value <code>auto</code> generally works only if the file that
         *        you're transcoding contains rotation metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotate(String rotate);

        /**
         * <p>
         * The <code>Id</code> of the preset to use for this job. The preset determines the audio, video, and thumbnail
         * settings that Elastic Transcoder uses for transcoding.
         * </p>
         * 
         * @param presetId
         *        The <code>Id</code> of the preset to use for this job. The preset determines the audio, video, and
         *        thumbnail settings that Elastic Transcoder uses for transcoding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder presetId(String presetId);

        /**
         * <important>
         * <p>
         * (Outputs in Fragmented MP4 or MPEG-TS format only.
         * </p>
         * </important>
         * <p>
         * If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is
         * <code>fmp4</code> (Fragmented MP4) or <code>ts</code> (MPEG-TS), <code>SegmentDuration</code> is the target
         * maximum duration of each segment in seconds. For <code>HLSv3</code> format playlists, each media segment is
         * stored in a separate <code>.ts</code> file. For <code>HLSv4</code> and <code>Smooth</code> playlists, all
         * media segments for an output are stored in a single file. Each segment is approximately the length of the
         * <code>SegmentDuration</code>, though individual segments might be shorter or longer.
         * </p>
         * <p>
         * The range of valid values is 1 to 60 seconds. If the duration of the video is not evenly divisible by
         * <code>SegmentDuration</code>, the duration of the last segment is the remainder of total
         * length/SegmentDuration.
         * </p>
         * <p>
         * Elastic Transcoder creates an output-specific playlist for each output <code>HLS</code> output that you
         * specify in OutputKeys. To add an output to the master playlist for this job, include it in the
         * <code>OutputKeys</code> of the associated playlist.
         * </p>
         * 
         * @param segmentDuration
         *        <p>
         *        (Outputs in Fragmented MP4 or MPEG-TS format only.
         *        </p>
         *        </important>
         *        <p>
         *        If you specify a preset in <code>PresetId</code> for which the value of <code>Container</code> is
         *        <code>fmp4</code> (Fragmented MP4) or <code>ts</code> (MPEG-TS), <code>SegmentDuration</code> is the
         *        target maximum duration of each segment in seconds. For <code>HLSv3</code> format playlists, each
         *        media segment is stored in a separate <code>.ts</code> file. For <code>HLSv4</code> and
         *        <code>Smooth</code> playlists, all media segments for an output are stored in a single file. Each
         *        segment is approximately the length of the <code>SegmentDuration</code>, though individual segments
         *        might be shorter or longer.
         *        </p>
         *        <p>
         *        The range of valid values is 1 to 60 seconds. If the duration of the video is not evenly divisible by
         *        <code>SegmentDuration</code>, the duration of the last segment is the remainder of total
         *        length/SegmentDuration.
         *        </p>
         *        <p>
         *        Elastic Transcoder creates an output-specific playlist for each output <code>HLS</code> output that
         *        you specify in OutputKeys. To add an output to the master playlist for this job, include it in the
         *        <code>OutputKeys</code> of the associated playlist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentDuration(String segmentDuration);

        /**
         * <p>
         * Information about the watermarks that you want Elastic Transcoder to add to the video during transcoding. You
         * can specify up to four watermarks for each output. Settings for each watermark must be defined in the preset
         * for the current output.
         * </p>
         * 
         * @param watermarks
         *        Information about the watermarks that you want Elastic Transcoder to add to the video during
         *        transcoding. You can specify up to four watermarks for each output. Settings for each watermark must
         *        be defined in the preset for the current output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder watermarks(Collection<JobWatermark> watermarks);

        /**
         * <p>
         * Information about the watermarks that you want Elastic Transcoder to add to the video during transcoding. You
         * can specify up to four watermarks for each output. Settings for each watermark must be defined in the preset
         * for the current output.
         * </p>
         * 
         * @param watermarks
         *        Information about the watermarks that you want Elastic Transcoder to add to the video during
         *        transcoding. You can specify up to four watermarks for each output. Settings for each watermark must
         *        be defined in the preset for the current output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder watermarks(JobWatermark... watermarks);

        /**
         * <p>
         * Information about the watermarks that you want Elastic Transcoder to add to the video during transcoding. You
         * can specify up to four watermarks for each output. Settings for each watermark must be defined in the preset
         * for the current output.
         * </p>
         * This is a convenience that creates an instance of the {@link List<JobWatermark>.Builder} avoiding the need to
         * create one manually via {@link List<JobWatermark>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<JobWatermark>.Builder#build()} is called immediately and its
         * result is passed to {@link #watermarks(List<JobWatermark>)}.
         * 
         * @param watermarks
         *        a consumer that will call methods on {@link List<JobWatermark>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #watermarks(List<JobWatermark>)
         */
        Builder watermarks(Consumer<JobWatermark.Builder>... watermarks);

        /**
         * <p>
         * Information about the album art that you want Elastic Transcoder to add to the file during transcoding. You
         * can specify up to twenty album artworks for each output. Settings for each artwork must be defined in the job
         * for the current output.
         * </p>
         * 
         * @param albumArt
         *        Information about the album art that you want Elastic Transcoder to add to the file during
         *        transcoding. You can specify up to twenty album artworks for each output. Settings for each artwork
         *        must be defined in the job for the current output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder albumArt(JobAlbumArt albumArt);

        /**
         * <p>
         * Information about the album art that you want Elastic Transcoder to add to the file during transcoding. You
         * can specify up to twenty album artworks for each output. Settings for each artwork must be defined in the job
         * for the current output.
         * </p>
         * This is a convenience that creates an instance of the {@link JobAlbumArt.Builder} avoiding the need to create
         * one manually via {@link JobAlbumArt#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobAlbumArt.Builder#build()} is called immediately and its result
         * is passed to {@link #albumArt(JobAlbumArt)}.
         * 
         * @param albumArt
         *        a consumer that will call methods on {@link JobAlbumArt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #albumArt(JobAlbumArt)
         */
        default Builder albumArt(Consumer<JobAlbumArt.Builder> albumArt) {
            return albumArt(JobAlbumArt.builder().applyMutation(albumArt).build());
        }

        /**
         * <p>
         * You can create an output file that contains an excerpt from the input file. This excerpt, called a clip, can
         * come from the beginning, middle, or end of the file. The Composition object contains settings for the clips
         * that make up an output file. For the current release, you can only specify settings for a single clip per
         * output file. The Composition object cannot be null.
         * </p>
         * 
         * @param composition
         *        You can create an output file that contains an excerpt from the input file. This excerpt, called a
         *        clip, can come from the beginning, middle, or end of the file. The Composition object contains
         *        settings for the clips that make up an output file. For the current release, you can only specify
         *        settings for a single clip per output file. The Composition object cannot be null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder composition(Collection<Clip> composition);

        /**
         * <p>
         * You can create an output file that contains an excerpt from the input file. This excerpt, called a clip, can
         * come from the beginning, middle, or end of the file. The Composition object contains settings for the clips
         * that make up an output file. For the current release, you can only specify settings for a single clip per
         * output file. The Composition object cannot be null.
         * </p>
         * 
         * @param composition
         *        You can create an output file that contains an excerpt from the input file. This excerpt, called a
         *        clip, can come from the beginning, middle, or end of the file. The Composition object contains
         *        settings for the clips that make up an output file. For the current release, you can only specify
         *        settings for a single clip per output file. The Composition object cannot be null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder composition(Clip... composition);

        /**
         * <p>
         * You can create an output file that contains an excerpt from the input file. This excerpt, called a clip, can
         * come from the beginning, middle, or end of the file. The Composition object contains settings for the clips
         * that make up an output file. For the current release, you can only specify settings for a single clip per
         * output file. The Composition object cannot be null.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Clip>.Builder} avoiding the need to create
         * one manually via {@link List<Clip>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Clip>.Builder#build()} is called immediately and its result
         * is passed to {@link #composition(List<Clip>)}.
         * 
         * @param composition
         *        a consumer that will call methods on {@link List<Clip>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #composition(List<Clip>)
         */
        Builder composition(Consumer<Clip.Builder>... composition);

        /**
         * <p>
         * You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another. All
         * captions must be in UTF-8. Elastic Transcoder supports two types of captions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Embedded:</b> Embedded captions are included in the same file as the audio and video. Elastic Transcoder
         * supports only one embedded caption per language, to a maximum of 300 embedded captions per file.
         * </p>
         * <p>
         * Valid input values include: <code>CEA-608 (EIA-608</code>, first non-empty channel only),
         * <code>CEA-708 (EIA-708</code>, first non-empty channel only), and <code>mov-text</code>
         * </p>
         * <p>
         * Valid outputs include: <code>mov-text</code>
         * </p>
         * <p>
         * Elastic Transcoder supports a maximum of one embedded format per output.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Sidecar:</b> Sidecar captions are kept in a separate metadata file from the audio and video data. Sidecar
         * captions require a player that is capable of understanding the relationship between the video file and the
         * sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a maximum of 20 sidecar
         * captions per file.
         * </p>
         * <p>
         * Valid input values include: <code>dfxp</code> (first div element only), <code>ebu-tt</code>, <code>scc</code>, <code>smpt</code>, <code>srt</code>, <code>ttml</code> (first div element only), and <code>webvtt</code>
         * </p>
         * <p>
         * Valid outputs include: <code>dfxp</code> (first div element only), <code>scc</code>, <code>srt</code>, and
         * <code>webvtt</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.
         * </p>
         * <p>
         * Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a valid
         * input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not preserve
         * text formatting (for example, italics) during the transcoding process.
         * </p>
         * <p>
         * To remove captions or leave the captions empty, set <code>Captions</code> to null. To pass through existing
         * captions unchanged, set the <code>MergePolicy</code> to <code>MergeRetain</code>, and pass in a null
         * <code>CaptionSources</code> array.
         * </p>
         * <p>
         * For more information on embedded files, see the Subtitles Wikipedia page.
         * </p>
         * <p>
         * For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia pages.
         * </p>
         * 
         * @param captions
         *        You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another.
         *        All captions must be in UTF-8. Elastic Transcoder supports two types of captions:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Embedded:</b> Embedded captions are included in the same file as the audio and video. Elastic
         *        Transcoder supports only one embedded caption per language, to a maximum of 300 embedded captions per
         *        file.
         *        </p>
         *        <p>
         *        Valid input values include: <code>CEA-608 (EIA-608</code>, first non-empty channel only),
         *        <code>CEA-708 (EIA-708</code>, first non-empty channel only), and <code>mov-text</code>
         *        </p>
         *        <p>
         *        Valid outputs include: <code>mov-text</code>
         *        </p>
         *        <p>
         *        Elastic Transcoder supports a maximum of one embedded format per output.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Sidecar:</b> Sidecar captions are kept in a separate metadata file from the audio and video data.
         *        Sidecar captions require a player that is capable of understanding the relationship between the video
         *        file and the sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a
         *        maximum of 20 sidecar captions per file.
         *        </p>
         *        <p>
         *        Valid input values include: <code>dfxp</code> (first div element only), <code>ebu-tt</code>,
         *        <code>scc</code>, <code>smpt</code>, <code>srt</code>, <code>ttml</code> (first div element only), and
         *        <code>webvtt</code>
         *        </p>
         *        <p>
         *        Valid outputs include: <code>dfxp</code> (first div element only), <code>scc</code>, <code>srt</code>,
         *        and <code>webvtt</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.
         *        </p>
         *        <p>
         *        Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a
         *        valid input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not
         *        preserve text formatting (for example, italics) during the transcoding process.
         *        </p>
         *        <p>
         *        To remove captions or leave the captions empty, set <code>Captions</code> to null. To pass through
         *        existing captions unchanged, set the <code>MergePolicy</code> to <code>MergeRetain</code>, and pass in
         *        a null <code>CaptionSources</code> array.
         *        </p>
         *        <p>
         *        For more information on embedded files, see the Subtitles Wikipedia page.
         *        </p>
         *        <p>
         *        For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia
         *        pages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captions(Captions captions);

        /**
         * <p>
         * You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another. All
         * captions must be in UTF-8. Elastic Transcoder supports two types of captions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Embedded:</b> Embedded captions are included in the same file as the audio and video. Elastic Transcoder
         * supports only one embedded caption per language, to a maximum of 300 embedded captions per file.
         * </p>
         * <p>
         * Valid input values include: <code>CEA-608 (EIA-608</code>, first non-empty channel only),
         * <code>CEA-708 (EIA-708</code>, first non-empty channel only), and <code>mov-text</code>
         * </p>
         * <p>
         * Valid outputs include: <code>mov-text</code>
         * </p>
         * <p>
         * Elastic Transcoder supports a maximum of one embedded format per output.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Sidecar:</b> Sidecar captions are kept in a separate metadata file from the audio and video data. Sidecar
         * captions require a player that is capable of understanding the relationship between the video file and the
         * sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a maximum of 20 sidecar
         * captions per file.
         * </p>
         * <p>
         * Valid input values include: <code>dfxp</code> (first div element only), <code>ebu-tt</code>, <code>scc</code>, <code>smpt</code>, <code>srt</code>, <code>ttml</code> (first div element only), and <code>webvtt</code>
         * </p>
         * <p>
         * Valid outputs include: <code>dfxp</code> (first div element only), <code>scc</code>, <code>srt</code>, and
         * <code>webvtt</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.
         * </p>
         * <p>
         * Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a valid
         * input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not preserve
         * text formatting (for example, italics) during the transcoding process.
         * </p>
         * <p>
         * To remove captions or leave the captions empty, set <code>Captions</code> to null. To pass through existing
         * captions unchanged, set the <code>MergePolicy</code> to <code>MergeRetain</code>, and pass in a null
         * <code>CaptionSources</code> array.
         * </p>
         * <p>
         * For more information on embedded files, see the Subtitles Wikipedia page.
         * </p>
         * <p>
         * For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia pages.
         * </p>
         * This is a convenience that creates an instance of the {@link Captions.Builder} avoiding the need to create
         * one manually via {@link Captions#builder()}.
         *
         * When the {@link Consumer} completes, {@link Captions.Builder#build()} is called immediately and its result is
         * passed to {@link #captions(Captions)}.
         * 
         * @param captions
         *        a consumer that will call methods on {@link Captions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #captions(Captions)
         */
        default Builder captions(Consumer<Captions.Builder> captions) {
            return captions(Captions.builder().applyMutation(captions).build());
        }

        /**
         * <p>
         * You can specify encryption settings for any output files that you want to use for a transcoding job. This
         * includes the output file and any watermarks, thumbnails, album art, or captions that you want to use. You
         * must specify encryption settings for each file individually.
         * </p>
         * 
         * @param encryption
         *        You can specify encryption settings for any output files that you want to use for a transcoding job.
         *        This includes the output file and any watermarks, thumbnails, album art, or captions that you want to
         *        use. You must specify encryption settings for each file individually.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(Encryption encryption);

        /**
         * <p>
         * You can specify encryption settings for any output files that you want to use for a transcoding job. This
         * includes the output file and any watermarks, thumbnails, album art, or captions that you want to use. You
         * must specify encryption settings for each file individually.
         * </p>
         * This is a convenience that creates an instance of the {@link Encryption.Builder} avoiding the need to create
         * one manually via {@link Encryption#builder()}.
         *
         * When the {@link Consumer} completes, {@link Encryption.Builder#build()} is called immediately and its result
         * is passed to {@link #encryption(Encryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link Encryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(Encryption)
         */
        default Builder encryption(Consumer<Encryption.Builder> encryption) {
            return encryption(Encryption.builder().applyMutation(encryption).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String thumbnailPattern;

        private Encryption thumbnailEncryption;

        private String rotate;

        private String presetId;

        private String segmentDuration;

        private List<JobWatermark> watermarks = DefaultSdkAutoConstructList.getInstance();

        private JobAlbumArt albumArt;

        private List<Clip> composition = DefaultSdkAutoConstructList.getInstance();

        private Captions captions;

        private Encryption encryption;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobOutput model) {
            key(model.key);
            thumbnailPattern(model.thumbnailPattern);
            thumbnailEncryption(model.thumbnailEncryption);
            rotate(model.rotate);
            presetId(model.presetId);
            segmentDuration(model.segmentDuration);
            watermarks(model.watermarks);
            albumArt(model.albumArt);
            composition(model.composition);
            captions(model.captions);
            encryption(model.encryption);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getThumbnailPattern() {
            return thumbnailPattern;
        }

        @Override
        public final Builder thumbnailPattern(String thumbnailPattern) {
            this.thumbnailPattern = thumbnailPattern;
            return this;
        }

        public final void setThumbnailPattern(String thumbnailPattern) {
            this.thumbnailPattern = thumbnailPattern;
        }

        public final Encryption.Builder getThumbnailEncryption() {
            return thumbnailEncryption != null ? thumbnailEncryption.toBuilder() : null;
        }

        @Override
        public final Builder thumbnailEncryption(Encryption thumbnailEncryption) {
            this.thumbnailEncryption = thumbnailEncryption;
            return this;
        }

        public final void setThumbnailEncryption(Encryption.BuilderImpl thumbnailEncryption) {
            this.thumbnailEncryption = thumbnailEncryption != null ? thumbnailEncryption.build() : null;
        }

        public final String getRotate() {
            return rotate;
        }

        @Override
        public final Builder rotate(String rotate) {
            this.rotate = rotate;
            return this;
        }

        public final void setRotate(String rotate) {
            this.rotate = rotate;
        }

        public final String getPresetId() {
            return presetId;
        }

        @Override
        public final Builder presetId(String presetId) {
            this.presetId = presetId;
            return this;
        }

        public final void setPresetId(String presetId) {
            this.presetId = presetId;
        }

        public final String getSegmentDuration() {
            return segmentDuration;
        }

        @Override
        public final Builder segmentDuration(String segmentDuration) {
            this.segmentDuration = segmentDuration;
            return this;
        }

        public final void setSegmentDuration(String segmentDuration) {
            this.segmentDuration = segmentDuration;
        }

        public final Collection<JobWatermark.Builder> getWatermarks() {
            return watermarks != null ? watermarks.stream().map(JobWatermark::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder watermarks(Collection<JobWatermark> watermarks) {
            this.watermarks = JobWatermarksCopier.copy(watermarks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watermarks(JobWatermark... watermarks) {
            watermarks(Arrays.asList(watermarks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watermarks(Consumer<JobWatermark.Builder>... watermarks) {
            watermarks(Stream.of(watermarks).map(c -> JobWatermark.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setWatermarks(Collection<JobWatermark.BuilderImpl> watermarks) {
            this.watermarks = JobWatermarksCopier.copyFromBuilder(watermarks);
        }

        public final JobAlbumArt.Builder getAlbumArt() {
            return albumArt != null ? albumArt.toBuilder() : null;
        }

        @Override
        public final Builder albumArt(JobAlbumArt albumArt) {
            this.albumArt = albumArt;
            return this;
        }

        public final void setAlbumArt(JobAlbumArt.BuilderImpl albumArt) {
            this.albumArt = albumArt != null ? albumArt.build() : null;
        }

        public final Collection<Clip.Builder> getComposition() {
            return composition != null ? composition.stream().map(Clip::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder composition(Collection<Clip> composition) {
            this.composition = CompositionCopier.copy(composition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder composition(Clip... composition) {
            composition(Arrays.asList(composition));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder composition(Consumer<Clip.Builder>... composition) {
            composition(Stream.of(composition).map(c -> Clip.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setComposition(Collection<Clip.BuilderImpl> composition) {
            this.composition = CompositionCopier.copyFromBuilder(composition);
        }

        public final Captions.Builder getCaptions() {
            return captions != null ? captions.toBuilder() : null;
        }

        @Override
        public final Builder captions(Captions captions) {
            this.captions = captions;
            return this;
        }

        public final void setCaptions(Captions.BuilderImpl captions) {
            this.captions = captions != null ? captions.build() : null;
        }

        public final Encryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(Encryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(Encryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public CreateJobOutput build() {
            return new CreateJobOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
