/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerAddress;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerAddressesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AvailabilityZone
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AvailabilityZone> {
    private static final SdkField<String> ZONE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AvailabilityZone.getter(AvailabilityZone::zoneName)).setter(AvailabilityZone.setter(Builder::zoneName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneName").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AvailabilityZone.getter(AvailabilityZone::subnetId)).setter(AvailabilityZone.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()}).build();
    private static final SdkField<List<LoadBalancerAddress>> LOAD_BALANCER_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AvailabilityZone.getter(AvailabilityZone::loadBalancerAddresses)).setter(AvailabilityZone.setter(Builder::loadBalancerAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LoadBalancerAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ZONE_NAME_FIELD, SUBNET_ID_FIELD, LOAD_BALANCER_ADDRESSES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String zoneName;
    private final String subnetId;
    private final List<LoadBalancerAddress> loadBalancerAddresses;

    private AvailabilityZone(BuilderImpl builder) {
        this.zoneName = builder.zoneName;
        this.subnetId = builder.subnetId;
        this.loadBalancerAddresses = builder.loadBalancerAddresses;
    }

    public String zoneName() {
        return this.zoneName;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public List<LoadBalancerAddress> loadBalancerAddresses() {
        return this.loadBalancerAddresses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.zoneName());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerAddresses());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailabilityZone)) {
            return false;
        }
        AvailabilityZone other = (AvailabilityZone)obj;
        return Objects.equals(this.zoneName(), other.zoneName()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.loadBalancerAddresses(), other.loadBalancerAddresses());
    }

    public String toString() {
        return ToString.builder((String)"AvailabilityZone").add("ZoneName", (Object)this.zoneName()).add("SubnetId", (Object)this.subnetId()).add("LoadBalancerAddresses", this.loadBalancerAddresses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ZoneName": {
                return Optional.ofNullable(clazz.cast(this.zoneName()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "LoadBalancerAddresses": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerAddresses()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AvailabilityZone, T> g) {
        return obj -> g.apply((AvailabilityZone)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String zoneName;
        private String subnetId;
        private List<LoadBalancerAddress> loadBalancerAddresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AvailabilityZone model) {
            this.zoneName(model.zoneName);
            this.subnetId(model.subnetId);
            this.loadBalancerAddresses(model.loadBalancerAddresses);
        }

        public final String getZoneName() {
            return this.zoneName;
        }

        @Override
        public final Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public final void setZoneName(String zoneName) {
            this.zoneName = zoneName;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final Collection<LoadBalancerAddress.Builder> getLoadBalancerAddresses() {
            return this.loadBalancerAddresses != null ? (Collection)this.loadBalancerAddresses.stream().map(LoadBalancerAddress::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder loadBalancerAddresses(Collection<LoadBalancerAddress> loadBalancerAddresses) {
            this.loadBalancerAddresses = LoadBalancerAddressesCopier.copy(loadBalancerAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerAddresses(LoadBalancerAddress ... loadBalancerAddresses) {
            this.loadBalancerAddresses(Arrays.asList(loadBalancerAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerAddresses(Consumer<LoadBalancerAddress.Builder> ... loadBalancerAddresses) {
            this.loadBalancerAddresses(Stream.of(loadBalancerAddresses).map(c -> (LoadBalancerAddress)((LoadBalancerAddress.Builder)LoadBalancerAddress.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLoadBalancerAddresses(Collection<LoadBalancerAddress.BuilderImpl> loadBalancerAddresses) {
            this.loadBalancerAddresses = LoadBalancerAddressesCopier.copyFromBuilder(loadBalancerAddresses);
        }

        public AvailabilityZone build() {
            return new AvailabilityZone(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AvailabilityZone> {
        public Builder zoneName(String var1);

        public Builder subnetId(String var1);

        public Builder loadBalancerAddresses(Collection<LoadBalancerAddress> var1);

        public Builder loadBalancerAddresses(LoadBalancerAddress ... var1);

        public Builder loadBalancerAddresses(Consumer<LoadBalancerAddress.Builder> ... var1);
    }
}

