/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RewriteConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RewriteConfigListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UrlRewriteConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UrlRewriteConfig> {
    private static final SdkField<List<RewriteConfig>> REWRITES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rewrites").getter(UrlRewriteConfig.getter(UrlRewriteConfig::rewrites)).setter(UrlRewriteConfig.setter(Builder::rewrites)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rewrites").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RewriteConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REWRITES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UrlRewriteConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<RewriteConfig> rewrites;

    private UrlRewriteConfig(BuilderImpl builder) {
        this.rewrites = builder.rewrites;
    }

    public final boolean hasRewrites() {
        return this.rewrites != null && !(this.rewrites instanceof SdkAutoConstructList);
    }

    public final List<RewriteConfig> rewrites() {
        return this.rewrites;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRewrites() ? this.rewrites() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UrlRewriteConfig)) {
            return false;
        }
        UrlRewriteConfig other = (UrlRewriteConfig)obj;
        return this.hasRewrites() == other.hasRewrites() && Objects.equals(this.rewrites(), other.rewrites());
    }

    public final String toString() {
        return ToString.builder((String)"UrlRewriteConfig").add("Rewrites", this.hasRewrites() ? this.rewrites() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rewrites": {
                return Optional.ofNullable(clazz.cast(this.rewrites()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<RewriteConfig>>> map = new HashMap<String, SdkField<List<RewriteConfig>>>();
        map.put("Rewrites", REWRITES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UrlRewriteConfig, T> g) {
        return obj -> g.apply((UrlRewriteConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<RewriteConfig> rewrites = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UrlRewriteConfig model) {
            this.rewrites(model.rewrites);
        }

        public final List<RewriteConfig.Builder> getRewrites() {
            List<RewriteConfig.Builder> result = RewriteConfigListCopier.copyToBuilder(this.rewrites);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRewrites(Collection<RewriteConfig.BuilderImpl> rewrites) {
            this.rewrites = RewriteConfigListCopier.copyFromBuilder(rewrites);
        }

        @Override
        public final Builder rewrites(Collection<RewriteConfig> rewrites) {
            this.rewrites = RewriteConfigListCopier.copy(rewrites);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rewrites(RewriteConfig ... rewrites) {
            this.rewrites(Arrays.asList(rewrites));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rewrites(Consumer<RewriteConfig.Builder> ... rewrites) {
            this.rewrites(Stream.of(rewrites).map(c -> (RewriteConfig)((RewriteConfig.Builder)RewriteConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public UrlRewriteConfig build() {
            return new UrlRewriteConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UrlRewriteConfig> {
        public Builder rewrites(Collection<RewriteConfig> var1);

        public Builder rewrites(RewriteConfig ... var1);

        public Builder rewrites(Consumer<RewriteConfig.Builder> ... var1);
    }
}

