/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a JSON Web Token (JWT) validation action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JwtValidationActionConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<JwtValidationActionConfig.Builder, JwtValidationActionConfig> {
    private static final SdkField<String> JWKS_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JwksEndpoint").getter(getter(JwtValidationActionConfig::jwksEndpoint))
            .setter(setter(Builder::jwksEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JwksEndpoint").build()).build();

    private static final SdkField<String> ISSUER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Issuer")
            .getter(getter(JwtValidationActionConfig::issuer)).setter(setter(Builder::issuer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issuer").build()).build();

    private static final SdkField<List<JwtValidationActionAdditionalClaim>> ADDITIONAL_CLAIMS_FIELD = SdkField
            .<List<JwtValidationActionAdditionalClaim>> builder(MarshallingType.LIST)
            .memberName("AdditionalClaims")
            .getter(getter(JwtValidationActionConfig::additionalClaims))
            .setter(setter(Builder::additionalClaims))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalClaims").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JwtValidationActionAdditionalClaim> builder(MarshallingType.SDK_POJO)
                                            .constructor(JwtValidationActionAdditionalClaim::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JWKS_ENDPOINT_FIELD,
            ISSUER_FIELD, ADDITIONAL_CLAIMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String jwksEndpoint;

    private final String issuer;

    private final List<JwtValidationActionAdditionalClaim> additionalClaims;

    private JwtValidationActionConfig(BuilderImpl builder) {
        this.jwksEndpoint = builder.jwksEndpoint;
        this.issuer = builder.issuer;
        this.additionalClaims = builder.additionalClaims;
    }

    /**
     * <p>
     * The JSON Web Key Set (JWKS) endpoint. This endpoint contains JSON Web Keys (JWK) that are used to validate
     * signatures from the provider.
     * </p>
     * <p>
     * This must be a full URL, including the HTTPS protocol, the domain, and the path. The maximum length is 256
     * characters.
     * </p>
     * 
     * @return The JSON Web Key Set (JWKS) endpoint. This endpoint contains JSON Web Keys (JWK) that are used to
     *         validate signatures from the provider.</p>
     *         <p>
     *         This must be a full URL, including the HTTPS protocol, the domain, and the path. The maximum length is
     *         256 characters.
     */
    public final String jwksEndpoint() {
        return jwksEndpoint;
    }

    /**
     * <p>
     * The issuer of the JWT. The maximum length is 256 characters.
     * </p>
     * 
     * @return The issuer of the JWT. The maximum length is 256 characters.
     */
    public final String issuer() {
        return issuer;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalClaims property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalClaims() {
        return additionalClaims != null && !(additionalClaims instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional claims to validate. The maximum size of the list is 10. We validate the <code>exp</code>,
     * <code>iss</code>, <code>nbf</code>, and <code>iat</code> claims by default.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalClaims} method.
     * </p>
     * 
     * @return Additional claims to validate. The maximum size of the list is 10. We validate the <code>exp</code>,
     *         <code>iss</code>, <code>nbf</code>, and <code>iat</code> claims by default.
     */
    public final List<JwtValidationActionAdditionalClaim> additionalClaims() {
        return additionalClaims;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jwksEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(issuer());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalClaims() ? additionalClaims() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JwtValidationActionConfig)) {
            return false;
        }
        JwtValidationActionConfig other = (JwtValidationActionConfig) obj;
        return Objects.equals(jwksEndpoint(), other.jwksEndpoint()) && Objects.equals(issuer(), other.issuer())
                && hasAdditionalClaims() == other.hasAdditionalClaims()
                && Objects.equals(additionalClaims(), other.additionalClaims());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JwtValidationActionConfig").add("JwksEndpoint", jwksEndpoint()).add("Issuer", issuer())
                .add("AdditionalClaims", hasAdditionalClaims() ? additionalClaims() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JwksEndpoint":
            return Optional.ofNullable(clazz.cast(jwksEndpoint()));
        case "Issuer":
            return Optional.ofNullable(clazz.cast(issuer()));
        case "AdditionalClaims":
            return Optional.ofNullable(clazz.cast(additionalClaims()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JwksEndpoint", JWKS_ENDPOINT_FIELD);
        map.put("Issuer", ISSUER_FIELD);
        map.put("AdditionalClaims", ADDITIONAL_CLAIMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JwtValidationActionConfig, T> g) {
        return obj -> g.apply((JwtValidationActionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JwtValidationActionConfig> {
        /**
         * <p>
         * The JSON Web Key Set (JWKS) endpoint. This endpoint contains JSON Web Keys (JWK) that are used to validate
         * signatures from the provider.
         * </p>
         * <p>
         * This must be a full URL, including the HTTPS protocol, the domain, and the path. The maximum length is 256
         * characters.
         * </p>
         * 
         * @param jwksEndpoint
         *        The JSON Web Key Set (JWKS) endpoint. This endpoint contains JSON Web Keys (JWK) that are used to
         *        validate signatures from the provider.</p>
         *        <p>
         *        This must be a full URL, including the HTTPS protocol, the domain, and the path. The maximum length is
         *        256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jwksEndpoint(String jwksEndpoint);

        /**
         * <p>
         * The issuer of the JWT. The maximum length is 256 characters.
         * </p>
         * 
         * @param issuer
         *        The issuer of the JWT. The maximum length is 256 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuer(String issuer);

        /**
         * <p>
         * Additional claims to validate. The maximum size of the list is 10. We validate the <code>exp</code>,
         * <code>iss</code>, <code>nbf</code>, and <code>iat</code> claims by default.
         * </p>
         * 
         * @param additionalClaims
         *        Additional claims to validate. The maximum size of the list is 10. We validate the <code>exp</code>,
         *        <code>iss</code>, <code>nbf</code>, and <code>iat</code> claims by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalClaims(Collection<JwtValidationActionAdditionalClaim> additionalClaims);

        /**
         * <p>
         * Additional claims to validate. The maximum size of the list is 10. We validate the <code>exp</code>,
         * <code>iss</code>, <code>nbf</code>, and <code>iat</code> claims by default.
         * </p>
         * 
         * @param additionalClaims
         *        Additional claims to validate. The maximum size of the list is 10. We validate the <code>exp</code>,
         *        <code>iss</code>, <code>nbf</code>, and <code>iat</code> claims by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalClaims(JwtValidationActionAdditionalClaim... additionalClaims);

        /**
         * <p>
         * Additional claims to validate. The maximum size of the list is 10. We validate the <code>exp</code>,
         * <code>iss</code>, <code>nbf</code>, and <code>iat</code> claims by default.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.JwtValidationActionAdditionalClaim.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.JwtValidationActionAdditionalClaim#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.JwtValidationActionAdditionalClaim.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #additionalClaims(List<JwtValidationActionAdditionalClaim>)}.
         * 
         * @param additionalClaims
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.JwtValidationActionAdditionalClaim.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalClaims(java.util.Collection<JwtValidationActionAdditionalClaim>)
         */
        Builder additionalClaims(Consumer<JwtValidationActionAdditionalClaim.Builder>... additionalClaims);
    }

    static final class BuilderImpl implements Builder {
        private String jwksEndpoint;

        private String issuer;

        private List<JwtValidationActionAdditionalClaim> additionalClaims = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JwtValidationActionConfig model) {
            jwksEndpoint(model.jwksEndpoint);
            issuer(model.issuer);
            additionalClaims(model.additionalClaims);
        }

        public final String getJwksEndpoint() {
            return jwksEndpoint;
        }

        public final void setJwksEndpoint(String jwksEndpoint) {
            this.jwksEndpoint = jwksEndpoint;
        }

        @Override
        public final Builder jwksEndpoint(String jwksEndpoint) {
            this.jwksEndpoint = jwksEndpoint;
            return this;
        }

        public final String getIssuer() {
            return issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final List<JwtValidationActionAdditionalClaim.Builder> getAdditionalClaims() {
            List<JwtValidationActionAdditionalClaim.Builder> result = JwtValidationActionAdditionalClaimsCopier
                    .copyToBuilder(this.additionalClaims);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalClaims(Collection<JwtValidationActionAdditionalClaim.BuilderImpl> additionalClaims) {
            this.additionalClaims = JwtValidationActionAdditionalClaimsCopier.copyFromBuilder(additionalClaims);
        }

        @Override
        public final Builder additionalClaims(Collection<JwtValidationActionAdditionalClaim> additionalClaims) {
            this.additionalClaims = JwtValidationActionAdditionalClaimsCopier.copy(additionalClaims);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalClaims(JwtValidationActionAdditionalClaim... additionalClaims) {
            additionalClaims(Arrays.asList(additionalClaims));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalClaims(Consumer<JwtValidationActionAdditionalClaim.Builder>... additionalClaims) {
            additionalClaims(Stream.of(additionalClaims)
                    .map(c -> JwtValidationActionAdditionalClaim.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public JwtValidationActionConfig build() {
            return new JwtValidationActionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
