/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a host header condition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HostHeaderConditionConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<HostHeaderConditionConfig.Builder, HostHeaderConditionConfig> {
    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(HostHeaderConditionConfig::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REGEX_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RegexValues")
            .getter(getter(HostHeaderConditionConfig::regexValues))
            .setter(setter(Builder::regexValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUES_FIELD,
            REGEX_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> values;

    private final List<String> regexValues;

    private HostHeaderConditionConfig(BuilderImpl builder) {
        this.values = builder.values;
        this.regexValues = builder.regexValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The host names. The maximum length of each string is 128 characters. The comparison is case insensitive. The
     * following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1
     * character). You must include at least one "." character. You can include only alphabetical characters after the
     * final "." character.
     * </p>
     * <p>
     * If you specify multiple strings, the condition is satisfied if one of the strings matches the host name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return The host names. The maximum length of each string is 128 characters. The comparison is case insensitive.
     *         The following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly
     *         1 character). You must include at least one "." character. You can include only alphabetical characters
     *         after the final "." character.</p>
     *         <p>
     *         If you specify multiple strings, the condition is satisfied if one of the strings matches the host name.
     */
    public final List<String> values() {
        return values;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegexValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRegexValues() {
        return regexValues != null && !(regexValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The regular expressions to compare against the host header. The maximum length of each string is 128 characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegexValues} method.
     * </p>
     * 
     * @return The regular expressions to compare against the host header. The maximum length of each string is 128
     *         characters.
     */
    public final List<String> regexValues() {
        return regexValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRegexValues() ? regexValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostHeaderConditionConfig)) {
            return false;
        }
        HostHeaderConditionConfig other = (HostHeaderConditionConfig) obj;
        return hasValues() == other.hasValues() && Objects.equals(values(), other.values())
                && hasRegexValues() == other.hasRegexValues() && Objects.equals(regexValues(), other.regexValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HostHeaderConditionConfig").add("Values", hasValues() ? values() : null)
                .add("RegexValues", hasRegexValues() ? regexValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        case "RegexValues":
            return Optional.ofNullable(clazz.cast(regexValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Values", VALUES_FIELD);
        map.put("RegexValues", REGEX_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HostHeaderConditionConfig, T> g) {
        return obj -> g.apply((HostHeaderConditionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HostHeaderConditionConfig> {
        /**
         * <p>
         * The host names. The maximum length of each string is 128 characters. The comparison is case insensitive. The
         * following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1
         * character). You must include at least one "." character. You can include only alphabetical characters after
         * the final "." character.
         * </p>
         * <p>
         * If you specify multiple strings, the condition is satisfied if one of the strings matches the host name.
         * </p>
         * 
         * @param values
         *        The host names. The maximum length of each string is 128 characters. The comparison is case
         *        insensitive. The following wildcard characters are supported: * (matches 0 or more characters) and ?
         *        (matches exactly 1 character). You must include at least one "." character. You can include only
         *        alphabetical characters after the final "." character.</p>
         *        <p>
         *        If you specify multiple strings, the condition is satisfied if one of the strings matches the host
         *        name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The host names. The maximum length of each string is 128 characters. The comparison is case insensitive. The
         * following wildcard characters are supported: * (matches 0 or more characters) and ? (matches exactly 1
         * character). You must include at least one "." character. You can include only alphabetical characters after
         * the final "." character.
         * </p>
         * <p>
         * If you specify multiple strings, the condition is satisfied if one of the strings matches the host name.
         * </p>
         * 
         * @param values
         *        The host names. The maximum length of each string is 128 characters. The comparison is case
         *        insensitive. The following wildcard characters are supported: * (matches 0 or more characters) and ?
         *        (matches exactly 1 character). You must include at least one "." character. You can include only
         *        alphabetical characters after the final "." character.</p>
         *        <p>
         *        If you specify multiple strings, the condition is satisfied if one of the strings matches the host
         *        name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);

        /**
         * <p>
         * The regular expressions to compare against the host header. The maximum length of each string is 128
         * characters.
         * </p>
         * 
         * @param regexValues
         *        The regular expressions to compare against the host header. The maximum length of each string is 128
         *        characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexValues(Collection<String> regexValues);

        /**
         * <p>
         * The regular expressions to compare against the host header. The maximum length of each string is 128
         * characters.
         * </p>
         * 
         * @param regexValues
         *        The regular expressions to compare against the host header. The maximum length of each string is 128
         *        characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexValues(String... regexValues);
    }

    static final class BuilderImpl implements Builder {
        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private List<String> regexValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HostHeaderConditionConfig model) {
            values(model.values);
            regexValues(model.regexValues);
        }

        public final Collection<String> getValues() {
            if (values instanceof SdkAutoConstructList) {
                return null;
            }
            return values;
        }

        public final void setValues(Collection<String> values) {
            this.values = ListOfStringCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ListOfStringCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final Collection<String> getRegexValues() {
            if (regexValues instanceof SdkAutoConstructList) {
                return null;
            }
            return regexValues;
        }

        public final void setRegexValues(Collection<String> regexValues) {
            this.regexValues = ListOfStringCopier.copy(regexValues);
        }

        @Override
        public final Builder regexValues(Collection<String> regexValues) {
            this.regexValues = ListOfStringCopier.copy(regexValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regexValues(String... regexValues) {
            regexValues(Arrays.asList(regexValues));
            return this;
        }

        @Override
        public HostHeaderConditionConfig build() {
            return new HostHeaderConditionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
