/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Response;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Limit;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LimitsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAccountLimitsResponse
extends ElasticLoadBalancingV2Response
implements ToCopyableBuilder<Builder, DescribeAccountLimitsResponse> {
    private static final SdkField<List<Limit>> LIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Limits").getter(DescribeAccountLimitsResponse.getter(DescribeAccountLimitsResponse::limits)).setter(DescribeAccountLimitsResponse.setter(Builder::limits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Limit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(DescribeAccountLimitsResponse.getter(DescribeAccountLimitsResponse::nextMarker)).setter(DescribeAccountLimitsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMITS_FIELD, NEXT_MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAccountLimitsResponse.memberNameToFieldInitializer();
    private final List<Limit> limits;
    private final String nextMarker;

    private DescribeAccountLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.limits = builder.limits;
        this.nextMarker = builder.nextMarker;
    }

    public final boolean hasLimits() {
        return this.limits != null && !(this.limits instanceof SdkAutoConstructList);
    }

    public final List<Limit> limits() {
        return this.limits;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLimits() ? this.limits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountLimitsResponse)) {
            return false;
        }
        DescribeAccountLimitsResponse other = (DescribeAccountLimitsResponse)((Object)obj);
        return this.hasLimits() == other.hasLimits() && Objects.equals(this.limits(), other.limits()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAccountLimitsResponse").add("Limits", this.hasLimits() ? this.limits() : null).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Limits": {
                return Optional.ofNullable(clazz.cast(this.limits()));
            }
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Limits", LIMITS_FIELD);
        map.put("NextMarker", NEXT_MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountLimitsResponse, T> g) {
        return obj -> g.apply((DescribeAccountLimitsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Response.BuilderImpl
    implements Builder {
        private List<Limit> limits = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountLimitsResponse model) {
            super(model);
            this.limits(model.limits);
            this.nextMarker(model.nextMarker);
        }

        public final List<Limit.Builder> getLimits() {
            List<Limit.Builder> result = LimitsCopier.copyToBuilder(this.limits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLimits(Collection<Limit.BuilderImpl> limits) {
            this.limits = LimitsCopier.copyFromBuilder(limits);
        }

        @Override
        public final Builder limits(Collection<Limit> limits) {
            this.limits = LimitsCopier.copy(limits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder limits(Limit ... limits) {
            this.limits(Arrays.asList(limits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder limits(Consumer<Limit.Builder> ... limits) {
            this.limits(Stream.of(limits).map(c -> (Limit)((Limit.Builder)Limit.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public DescribeAccountLimitsResponse build() {
            return new DescribeAccountLimitsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ElasticLoadBalancingV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAccountLimitsResponse> {
        public Builder limits(Collection<Limit> var1);

        public Builder limits(Limit ... var1);

        public Builder limits(Consumer<Limit.Builder> ... var1);

        public Builder nextMarker(String var1);
    }
}

