/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.HostHeaderRewriteConfig;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TransformTypeEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.UrlRewriteConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleTransform
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleTransform> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(RuleTransform.getter(RuleTransform::typeAsString)).setter(RuleTransform.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<HostHeaderRewriteConfig> HOST_HEADER_REWRITE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HostHeaderRewriteConfig").getter(RuleTransform.getter(RuleTransform::hostHeaderRewriteConfig)).setter(RuleTransform.setter(Builder::hostHeaderRewriteConfig)).constructor(HostHeaderRewriteConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostHeaderRewriteConfig").build()}).build();
    private static final SdkField<UrlRewriteConfig> URL_REWRITE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UrlRewriteConfig").getter(RuleTransform.getter(RuleTransform::urlRewriteConfig)).setter(RuleTransform.setter(Builder::urlRewriteConfig)).constructor(UrlRewriteConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UrlRewriteConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, HOST_HEADER_REWRITE_CONFIG_FIELD, URL_REWRITE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RuleTransform.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final HostHeaderRewriteConfig hostHeaderRewriteConfig;
    private final UrlRewriteConfig urlRewriteConfig;

    private RuleTransform(BuilderImpl builder) {
        this.type = builder.type;
        this.hostHeaderRewriteConfig = builder.hostHeaderRewriteConfig;
        this.urlRewriteConfig = builder.urlRewriteConfig;
    }

    public final TransformTypeEnum type() {
        return TransformTypeEnum.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final HostHeaderRewriteConfig hostHeaderRewriteConfig() {
        return this.hostHeaderRewriteConfig;
    }

    public final UrlRewriteConfig urlRewriteConfig() {
        return this.urlRewriteConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostHeaderRewriteConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.urlRewriteConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleTransform)) {
            return false;
        }
        RuleTransform other = (RuleTransform)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.hostHeaderRewriteConfig(), other.hostHeaderRewriteConfig()) && Objects.equals(this.urlRewriteConfig(), other.urlRewriteConfig());
    }

    public final String toString() {
        return ToString.builder((String)"RuleTransform").add("Type", (Object)this.typeAsString()).add("HostHeaderRewriteConfig", (Object)this.hostHeaderRewriteConfig()).add("UrlRewriteConfig", (Object)this.urlRewriteConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "HostHeaderRewriteConfig": {
                return Optional.ofNullable(clazz.cast(this.hostHeaderRewriteConfig()));
            }
            case "UrlRewriteConfig": {
                return Optional.ofNullable(clazz.cast(this.urlRewriteConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Type", TYPE_FIELD);
        map.put("HostHeaderRewriteConfig", HOST_HEADER_REWRITE_CONFIG_FIELD);
        map.put("UrlRewriteConfig", URL_REWRITE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleTransform, T> g) {
        return obj -> g.apply((RuleTransform)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private HostHeaderRewriteConfig hostHeaderRewriteConfig;
        private UrlRewriteConfig urlRewriteConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleTransform model) {
            this.type(model.type);
            this.hostHeaderRewriteConfig(model.hostHeaderRewriteConfig);
            this.urlRewriteConfig(model.urlRewriteConfig);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TransformTypeEnum type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final HostHeaderRewriteConfig.Builder getHostHeaderRewriteConfig() {
            return this.hostHeaderRewriteConfig != null ? this.hostHeaderRewriteConfig.toBuilder() : null;
        }

        public final void setHostHeaderRewriteConfig(HostHeaderRewriteConfig.BuilderImpl hostHeaderRewriteConfig) {
            this.hostHeaderRewriteConfig = hostHeaderRewriteConfig != null ? hostHeaderRewriteConfig.build() : null;
        }

        @Override
        public final Builder hostHeaderRewriteConfig(HostHeaderRewriteConfig hostHeaderRewriteConfig) {
            this.hostHeaderRewriteConfig = hostHeaderRewriteConfig;
            return this;
        }

        public final UrlRewriteConfig.Builder getUrlRewriteConfig() {
            return this.urlRewriteConfig != null ? this.urlRewriteConfig.toBuilder() : null;
        }

        public final void setUrlRewriteConfig(UrlRewriteConfig.BuilderImpl urlRewriteConfig) {
            this.urlRewriteConfig = urlRewriteConfig != null ? urlRewriteConfig.build() : null;
        }

        @Override
        public final Builder urlRewriteConfig(UrlRewriteConfig urlRewriteConfig) {
            this.urlRewriteConfig = urlRewriteConfig;
            return this;
        }

        public RuleTransform build() {
            return new RuleTransform(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleTransform> {
        public Builder type(String var1);

        public Builder type(TransformTypeEnum var1);

        public Builder hostHeaderRewriteConfig(HostHeaderRewriteConfig var1);

        default public Builder hostHeaderRewriteConfig(Consumer<HostHeaderRewriteConfig.Builder> hostHeaderRewriteConfig) {
            return this.hostHeaderRewriteConfig((HostHeaderRewriteConfig)((HostHeaderRewriteConfig.Builder)HostHeaderRewriteConfig.builder().applyMutation(hostHeaderRewriteConfig)).build());
        }

        public Builder urlRewriteConfig(UrlRewriteConfig var1);

        default public Builder urlRewriteConfig(Consumer<UrlRewriteConfig.Builder> urlRewriteConfig) {
            return this.urlRewriteConfig((UrlRewriteConfig)((UrlRewriteConfig.Builder)UrlRewriteConfig.builder().applyMutation(urlRewriteConfig)).build());
        }
    }
}

