/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetSecurityGroupsResponse extends ElasticLoadBalancingV2Response implements
        ToCopyableBuilder<SetSecurityGroupsResponse.Builder, SetSecurityGroupsResponse> {
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(SetSecurityGroupsResponse::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ENFORCE_SECURITY_GROUP_INBOUND_RULES_ON_PRIVATE_LINK_TRAFFIC_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic")
            .getter(getter(SetSecurityGroupsResponse::enforceSecurityGroupInboundRulesOnPrivateLinkTrafficAsString))
            .setter(setter(Builder::enforceSecurityGroupInboundRulesOnPrivateLinkTraffic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_GROUP_IDS_FIELD,
            ENFORCE_SECURITY_GROUP_INBOUND_RULES_ON_PRIVATE_LINK_TRAFFIC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> securityGroupIds;

    private final String enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;

    private SetSecurityGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.securityGroupIds = builder.securityGroupIds;
        this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic = builder.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the security groups associated with the load balancer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return The IDs of the security groups associated with the load balancer.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * Indicates whether to evaluate inbound security group rules for traffic sent to a Network Load Balancer through
     * Amazon Web Services PrivateLink.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enforceSecurityGroupInboundRulesOnPrivateLinkTraffic} will return
     * {@link EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #enforceSecurityGroupInboundRulesOnPrivateLinkTrafficAsString}.
     * </p>
     * 
     * @return Indicates whether to evaluate inbound security group rules for traffic sent to a Network Load Balancer
     *         through Amazon Web Services PrivateLink.
     * @see EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum
     */
    public final EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum enforceSecurityGroupInboundRulesOnPrivateLinkTraffic() {
        return EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum
                .fromValue(enforceSecurityGroupInboundRulesOnPrivateLinkTraffic);
    }

    /**
     * <p>
     * Indicates whether to evaluate inbound security group rules for traffic sent to a Network Load Balancer through
     * Amazon Web Services PrivateLink.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enforceSecurityGroupInboundRulesOnPrivateLinkTraffic} will return
     * {@link EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #enforceSecurityGroupInboundRulesOnPrivateLinkTrafficAsString}.
     * </p>
     * 
     * @return Indicates whether to evaluate inbound security group rules for traffic sent to a Network Load Balancer
     *         through Amazon Web Services PrivateLink.
     * @see EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum
     */
    public final String enforceSecurityGroupInboundRulesOnPrivateLinkTrafficAsString() {
        return enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enforceSecurityGroupInboundRulesOnPrivateLinkTrafficAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetSecurityGroupsResponse)) {
            return false;
        }
        SetSecurityGroupsResponse other = (SetSecurityGroupsResponse) obj;
        return hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(enforceSecurityGroupInboundRulesOnPrivateLinkTrafficAsString(),
                        other.enforceSecurityGroupInboundRulesOnPrivateLinkTrafficAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("SetSecurityGroupsResponse")
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic",
                        enforceSecurityGroupInboundRulesOnPrivateLinkTrafficAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic":
            return Optional.ofNullable(clazz.cast(enforceSecurityGroupInboundRulesOnPrivateLinkTrafficAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SecurityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic",
                ENFORCE_SECURITY_GROUP_INBOUND_RULES_ON_PRIVATE_LINK_TRAFFIC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetSecurityGroupsResponse, T> g) {
        return obj -> g.apply((SetSecurityGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElasticLoadBalancingV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, SetSecurityGroupsResponse> {
        /**
         * <p>
         * The IDs of the security groups associated with the load balancer.
         * </p>
         * 
         * @param securityGroupIds
         *        The IDs of the security groups associated with the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * The IDs of the security groups associated with the load balancer.
         * </p>
         * 
         * @param securityGroupIds
         *        The IDs of the security groups associated with the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * Indicates whether to evaluate inbound security group rules for traffic sent to a Network Load Balancer
         * through Amazon Web Services PrivateLink.
         * </p>
         * 
         * @param enforceSecurityGroupInboundRulesOnPrivateLinkTraffic
         *        Indicates whether to evaluate inbound security group rules for traffic sent to a Network Load Balancer
         *        through Amazon Web Services PrivateLink.
         * @see EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum
         */
        Builder enforceSecurityGroupInboundRulesOnPrivateLinkTraffic(String enforceSecurityGroupInboundRulesOnPrivateLinkTraffic);

        /**
         * <p>
         * Indicates whether to evaluate inbound security group rules for traffic sent to a Network Load Balancer
         * through Amazon Web Services PrivateLink.
         * </p>
         * 
         * @param enforceSecurityGroupInboundRulesOnPrivateLinkTraffic
         *        Indicates whether to evaluate inbound security group rules for traffic sent to a Network Load Balancer
         *        through Amazon Web Services PrivateLink.
         * @see EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum
         */
        Builder enforceSecurityGroupInboundRulesOnPrivateLinkTraffic(
                EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum enforceSecurityGroupInboundRulesOnPrivateLinkTraffic);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Response.BuilderImpl implements Builder {
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;

        private BuilderImpl() {
        }

        private BuilderImpl(SetSecurityGroupsResponse model) {
            super(model);
            securityGroupIds(model.securityGroupIds);
            enforceSecurityGroupInboundRulesOnPrivateLinkTraffic(model.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic);
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupsCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getEnforceSecurityGroupInboundRulesOnPrivateLinkTraffic() {
            return enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;
        }

        public final void setEnforceSecurityGroupInboundRulesOnPrivateLinkTraffic(
                String enforceSecurityGroupInboundRulesOnPrivateLinkTraffic) {
            this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic = enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;
        }

        @Override
        public final Builder enforceSecurityGroupInboundRulesOnPrivateLinkTraffic(
                String enforceSecurityGroupInboundRulesOnPrivateLinkTraffic) {
            this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic = enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;
            return this;
        }

        @Override
        public final Builder enforceSecurityGroupInboundRulesOnPrivateLinkTraffic(
                EnforceSecurityGroupInboundRulesOnPrivateLinkTrafficEnum enforceSecurityGroupInboundRulesOnPrivateLinkTraffic) {
            this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic(enforceSecurityGroupInboundRulesOnPrivateLinkTraffic == null ? null
                    : enforceSecurityGroupInboundRulesOnPrivateLinkTraffic.toString());
            return this;
        }

        @Override
        public SetSecurityGroupsResponse build() {
            return new SetSecurityGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
