/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.EnablePrefixForIpv6SourceNatEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.IpAddressType;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.IpamPools;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerSchemeEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerTypeEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SecurityGroupsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SubnetMapping;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SubnetMappingsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SubnetsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Tag;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLoadBalancerRequest
extends ElasticLoadBalancingV2Request
implements ToCopyableBuilder<Builder, CreateLoadBalancerRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateLoadBalancerRequest.getter(CreateLoadBalancerRequest::name)).setter(CreateLoadBalancerRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subnets").getter(CreateLoadBalancerRequest.getter(CreateLoadBalancerRequest::subnets)).setter(CreateLoadBalancerRequest.setter(Builder::subnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SubnetMapping>> SUBNET_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetMappings").getter(CreateLoadBalancerRequest.getter(CreateLoadBalancerRequest::subnetMappings)).setter(CreateLoadBalancerRequest.setter(Builder::subnetMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SubnetMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(CreateLoadBalancerRequest.getter(CreateLoadBalancerRequest::securityGroups)).setter(CreateLoadBalancerRequest.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SCHEME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scheme").getter(CreateLoadBalancerRequest.getter(CreateLoadBalancerRequest::schemeAsString)).setter(CreateLoadBalancerRequest.setter(Builder::scheme)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scheme").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateLoadBalancerRequest.getter(CreateLoadBalancerRequest::tags)).setter(CreateLoadBalancerRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CreateLoadBalancerRequest.getter(CreateLoadBalancerRequest::typeAsString)).setter(CreateLoadBalancerRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddressType").getter(CreateLoadBalancerRequest.getter(CreateLoadBalancerRequest::ipAddressTypeAsString)).setter(CreateLoadBalancerRequest.setter(Builder::ipAddressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType").build()}).build();
    private static final SdkField<String> CUSTOMER_OWNED_IPV4_POOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerOwnedIpv4Pool").getter(CreateLoadBalancerRequest.getter(CreateLoadBalancerRequest::customerOwnedIpv4Pool)).setter(CreateLoadBalancerRequest.setter(Builder::customerOwnedIpv4Pool)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerOwnedIpv4Pool").build()}).build();
    private static final SdkField<String> ENABLE_PREFIX_FOR_IPV6_SOURCE_NAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnablePrefixForIpv6SourceNat").getter(CreateLoadBalancerRequest.getter(CreateLoadBalancerRequest::enablePrefixForIpv6SourceNatAsString)).setter(CreateLoadBalancerRequest.setter(Builder::enablePrefixForIpv6SourceNat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePrefixForIpv6SourceNat").build()}).build();
    private static final SdkField<IpamPools> IPAM_POOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IpamPools").getter(CreateLoadBalancerRequest.getter(CreateLoadBalancerRequest::ipamPools)).setter(CreateLoadBalancerRequest.setter(Builder::ipamPools)).constructor(IpamPools::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPools").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SUBNETS_FIELD, SUBNET_MAPPINGS_FIELD, SECURITY_GROUPS_FIELD, SCHEME_FIELD, TAGS_FIELD, TYPE_FIELD, IP_ADDRESS_TYPE_FIELD, CUSTOMER_OWNED_IPV4_POOL_FIELD, ENABLE_PREFIX_FOR_IPV6_SOURCE_NAT_FIELD, IPAM_POOLS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateLoadBalancerRequest.memberNameToFieldInitializer();
    private final String name;
    private final List<String> subnets;
    private final List<SubnetMapping> subnetMappings;
    private final List<String> securityGroups;
    private final String scheme;
    private final List<Tag> tags;
    private final String type;
    private final String ipAddressType;
    private final String customerOwnedIpv4Pool;
    private final String enablePrefixForIpv6SourceNat;
    private final IpamPools ipamPools;

    private CreateLoadBalancerRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.subnets = builder.subnets;
        this.subnetMappings = builder.subnetMappings;
        this.securityGroups = builder.securityGroups;
        this.scheme = builder.scheme;
        this.tags = builder.tags;
        this.type = builder.type;
        this.ipAddressType = builder.ipAddressType;
        this.customerOwnedIpv4Pool = builder.customerOwnedIpv4Pool;
        this.enablePrefixForIpv6SourceNat = builder.enablePrefixForIpv6SourceNat;
        this.ipamPools = builder.ipamPools;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasSubnets() {
        return this.subnets != null && !(this.subnets instanceof SdkAutoConstructList);
    }

    public final List<String> subnets() {
        return this.subnets;
    }

    public final boolean hasSubnetMappings() {
        return this.subnetMappings != null && !(this.subnetMappings instanceof SdkAutoConstructList);
    }

    public final List<SubnetMapping> subnetMappings() {
        return this.subnetMappings;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroups() {
        return this.securityGroups;
    }

    public final LoadBalancerSchemeEnum scheme() {
        return LoadBalancerSchemeEnum.fromValue(this.scheme);
    }

    public final String schemeAsString() {
        return this.scheme;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final LoadBalancerTypeEnum type() {
        return LoadBalancerTypeEnum.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(this.ipAddressType);
    }

    public final String ipAddressTypeAsString() {
        return this.ipAddressType;
    }

    public final String customerOwnedIpv4Pool() {
        return this.customerOwnedIpv4Pool;
    }

    public final EnablePrefixForIpv6SourceNatEnum enablePrefixForIpv6SourceNat() {
        return EnablePrefixForIpv6SourceNatEnum.fromValue(this.enablePrefixForIpv6SourceNat);
    }

    public final String enablePrefixForIpv6SourceNatAsString() {
        return this.enablePrefixForIpv6SourceNat;
    }

    public final IpamPools ipamPools() {
        return this.ipamPools;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnets() ? this.subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetMappings() ? this.subnetMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.schemeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerOwnedIpv4Pool());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePrefixForIpv6SourceNatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPools());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoadBalancerRequest)) {
            return false;
        }
        CreateLoadBalancerRequest other = (CreateLoadBalancerRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && this.hasSubnets() == other.hasSubnets() && Objects.equals(this.subnets(), other.subnets()) && this.hasSubnetMappings() == other.hasSubnetMappings() && Objects.equals(this.subnetMappings(), other.subnetMappings()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.schemeAsString(), other.schemeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.ipAddressTypeAsString(), other.ipAddressTypeAsString()) && Objects.equals(this.customerOwnedIpv4Pool(), other.customerOwnedIpv4Pool()) && Objects.equals(this.enablePrefixForIpv6SourceNatAsString(), other.enablePrefixForIpv6SourceNatAsString()) && Objects.equals(this.ipamPools(), other.ipamPools());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLoadBalancerRequest").add("Name", (Object)this.name()).add("Subnets", this.hasSubnets() ? this.subnets() : null).add("SubnetMappings", this.hasSubnetMappings() ? this.subnetMappings() : null).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("Scheme", (Object)this.schemeAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("Type", (Object)this.typeAsString()).add("IpAddressType", (Object)this.ipAddressTypeAsString()).add("CustomerOwnedIpv4Pool", (Object)this.customerOwnedIpv4Pool()).add("EnablePrefixForIpv6SourceNat", (Object)this.enablePrefixForIpv6SourceNatAsString()).add("IpamPools", (Object)this.ipamPools()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
            case "SubnetMappings": {
                return Optional.ofNullable(clazz.cast(this.subnetMappings()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "Scheme": {
                return Optional.ofNullable(clazz.cast(this.schemeAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "IpAddressType": {
                return Optional.ofNullable(clazz.cast(this.ipAddressTypeAsString()));
            }
            case "CustomerOwnedIpv4Pool": {
                return Optional.ofNullable(clazz.cast(this.customerOwnedIpv4Pool()));
            }
            case "EnablePrefixForIpv6SourceNat": {
                return Optional.ofNullable(clazz.cast(this.enablePrefixForIpv6SourceNatAsString()));
            }
            case "IpamPools": {
                return Optional.ofNullable(clazz.cast(this.ipamPools()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Subnets", SUBNETS_FIELD);
        map.put("SubnetMappings", SUBNET_MAPPINGS_FIELD);
        map.put("SecurityGroups", SECURITY_GROUPS_FIELD);
        map.put("Scheme", SCHEME_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("IpAddressType", IP_ADDRESS_TYPE_FIELD);
        map.put("CustomerOwnedIpv4Pool", CUSTOMER_OWNED_IPV4_POOL_FIELD);
        map.put("EnablePrefixForIpv6SourceNat", ENABLE_PREFIX_FOR_IPV6_SOURCE_NAT_FIELD);
        map.put("IpamPools", IPAM_POOLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLoadBalancerRequest, T> g) {
        return obj -> g.apply((CreateLoadBalancerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Request.BuilderImpl
    implements Builder {
        private String name;
        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();
        private List<SubnetMapping> subnetMappings = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private String scheme;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String type;
        private String ipAddressType;
        private String customerOwnedIpv4Pool;
        private String enablePrefixForIpv6SourceNat;
        private IpamPools ipamPools;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLoadBalancerRequest model) {
            super(model);
            this.name(model.name);
            this.subnets(model.subnets);
            this.subnetMappings(model.subnetMappings);
            this.securityGroups(model.securityGroups);
            this.scheme(model.scheme);
            this.tags(model.tags);
            this.type(model.type);
            this.ipAddressType(model.ipAddressType);
            this.customerOwnedIpv4Pool(model.customerOwnedIpv4Pool);
            this.enablePrefixForIpv6SourceNat(model.enablePrefixForIpv6SourceNat);
            this.ipamPools(model.ipamPools);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getSubnets() {
            if (this.subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnets;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final List<SubnetMapping.Builder> getSubnetMappings() {
            List<SubnetMapping.Builder> result = SubnetMappingsCopier.copyToBuilder(this.subnetMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubnetMappings(Collection<SubnetMapping.BuilderImpl> subnetMappings) {
            this.subnetMappings = SubnetMappingsCopier.copyFromBuilder(subnetMappings);
        }

        @Override
        public final Builder subnetMappings(Collection<SubnetMapping> subnetMappings) {
            this.subnetMappings = SubnetMappingsCopier.copy(subnetMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetMappings(SubnetMapping ... subnetMappings) {
            this.subnetMappings(Arrays.asList(subnetMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetMappings(Consumer<SubnetMapping.Builder> ... subnetMappings) {
            this.subnetMappings(Stream.of(subnetMappings).map(c -> (SubnetMapping)((SubnetMapping.Builder)SubnetMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (this.securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final String getScheme() {
            return this.scheme;
        }

        public final void setScheme(String scheme) {
            this.scheme = scheme;
        }

        @Override
        public final Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        @Override
        public final Builder scheme(LoadBalancerSchemeEnum scheme) {
            this.scheme(scheme == null ? null : scheme.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LoadBalancerTypeEnum type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final String getCustomerOwnedIpv4Pool() {
            return this.customerOwnedIpv4Pool;
        }

        public final void setCustomerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
        }

        @Override
        public final Builder customerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
            return this;
        }

        public final String getEnablePrefixForIpv6SourceNat() {
            return this.enablePrefixForIpv6SourceNat;
        }

        public final void setEnablePrefixForIpv6SourceNat(String enablePrefixForIpv6SourceNat) {
            this.enablePrefixForIpv6SourceNat = enablePrefixForIpv6SourceNat;
        }

        @Override
        public final Builder enablePrefixForIpv6SourceNat(String enablePrefixForIpv6SourceNat) {
            this.enablePrefixForIpv6SourceNat = enablePrefixForIpv6SourceNat;
            return this;
        }

        @Override
        public final Builder enablePrefixForIpv6SourceNat(EnablePrefixForIpv6SourceNatEnum enablePrefixForIpv6SourceNat) {
            this.enablePrefixForIpv6SourceNat(enablePrefixForIpv6SourceNat == null ? null : enablePrefixForIpv6SourceNat.toString());
            return this;
        }

        public final IpamPools.Builder getIpamPools() {
            return this.ipamPools != null ? this.ipamPools.toBuilder() : null;
        }

        public final void setIpamPools(IpamPools.BuilderImpl ipamPools) {
            this.ipamPools = ipamPools != null ? ipamPools.build() : null;
        }

        @Override
        public final Builder ipamPools(IpamPools ipamPools) {
            this.ipamPools = ipamPools;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLoadBalancerRequest build() {
            return new CreateLoadBalancerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ElasticLoadBalancingV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLoadBalancerRequest> {
        public Builder name(String var1);

        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);

        public Builder subnetMappings(Collection<SubnetMapping> var1);

        public Builder subnetMappings(SubnetMapping ... var1);

        public Builder subnetMappings(Consumer<SubnetMapping.Builder> ... var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder scheme(String var1);

        public Builder scheme(LoadBalancerSchemeEnum var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder type(String var1);

        public Builder type(LoadBalancerTypeEnum var1);

        public Builder ipAddressType(String var1);

        public Builder ipAddressType(IpAddressType var1);

        public Builder customerOwnedIpv4Pool(String var1);

        public Builder enablePrefixForIpv6SourceNat(String var1);

        public Builder enablePrefixForIpv6SourceNat(EnablePrefixForIpv6SourceNatEnum var1);

        public Builder ipamPools(IpamPools var1);

        default public Builder ipamPools(Consumer<IpamPools.Builder> ipamPools) {
            return this.ipamPools((IpamPools)((IpamPools.Builder)IpamPools.builder().applyMutation(ipamPools)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

