/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a rewrite transform. This transform matches a pattern and replaces it with the specified string.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RewriteConfig implements SdkPojo, Serializable, ToCopyableBuilder<RewriteConfig.Builder, RewriteConfig> {
    private static final SdkField<String> REGEX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Regex")
            .getter(getter(RewriteConfig::regex)).setter(setter(Builder::regex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Regex").build()).build();

    private static final SdkField<String> REPLACE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Replace")
            .getter(getter(RewriteConfig::replace)).setter(setter(Builder::replace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Replace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGEX_FIELD, REPLACE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String regex;

    private final String replace;

    private RewriteConfig(BuilderImpl builder) {
        this.regex = builder.regex;
        this.replace = builder.replace;
    }

    /**
     * <p>
     * The regular expression to match in the input string. The maximum length of the string is 1,024 characters.
     * </p>
     * 
     * @return The regular expression to match in the input string. The maximum length of the string is 1,024
     *         characters.
     */
    public final String regex() {
        return regex;
    }

    /**
     * <p>
     * The replacement string to use when rewriting the matched input. The maximum length of the string is 1,024
     * characters. You can specify capture groups in the regular expression (for example, $1 and $2).
     * </p>
     * 
     * @return The replacement string to use when rewriting the matched input. The maximum length of the string is 1,024
     *         characters. You can specify capture groups in the regular expression (for example, $1 and $2).
     */
    public final String replace() {
        return replace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(regex());
        hashCode = 31 * hashCode + Objects.hashCode(replace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RewriteConfig)) {
            return false;
        }
        RewriteConfig other = (RewriteConfig) obj;
        return Objects.equals(regex(), other.regex()) && Objects.equals(replace(), other.replace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RewriteConfig").add("Regex", regex()).add("Replace", replace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Regex":
            return Optional.ofNullable(clazz.cast(regex()));
        case "Replace":
            return Optional.ofNullable(clazz.cast(replace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Regex", REGEX_FIELD);
        map.put("Replace", REPLACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RewriteConfig, T> g) {
        return obj -> g.apply((RewriteConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RewriteConfig> {
        /**
         * <p>
         * The regular expression to match in the input string. The maximum length of the string is 1,024 characters.
         * </p>
         * 
         * @param regex
         *        The regular expression to match in the input string. The maximum length of the string is 1,024
         *        characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regex(String regex);

        /**
         * <p>
         * The replacement string to use when rewriting the matched input. The maximum length of the string is 1,024
         * characters. You can specify capture groups in the regular expression (for example, $1 and $2).
         * </p>
         * 
         * @param replace
         *        The replacement string to use when rewriting the matched input. The maximum length of the string is
         *        1,024 characters. You can specify capture groups in the regular expression (for example, $1 and $2).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replace(String replace);
    }

    static final class BuilderImpl implements Builder {
        private String regex;

        private String replace;

        private BuilderImpl() {
        }

        private BuilderImpl(RewriteConfig model) {
            regex(model.regex);
            replace(model.replace);
        }

        public final String getRegex() {
            return regex;
        }

        public final void setRegex(String regex) {
            this.regex = regex;
        }

        @Override
        public final Builder regex(String regex) {
            this.regex = regex;
            return this;
        }

        public final String getReplace() {
            return replace;
        }

        public final void setReplace(String replace) {
            this.replace = replace;
        }

        @Override
        public final Builder replace(String replace) {
            this.replace = replace;
            return this;
        }

        @Override
        public RewriteConfig build() {
            return new RewriteConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
