/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyIpPoolsRequest extends ElasticLoadBalancingV2Request implements
        ToCopyableBuilder<ModifyIpPoolsRequest.Builder, ModifyIpPoolsRequest> {
    private static final SdkField<String> LOAD_BALANCER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LoadBalancerArn").getter(getter(ModifyIpPoolsRequest::loadBalancerArn))
            .setter(setter(Builder::loadBalancerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerArn").build()).build();

    private static final SdkField<IpamPools> IPAM_POOLS_FIELD = SdkField.<IpamPools> builder(MarshallingType.SDK_POJO)
            .memberName("IpamPools").getter(getter(ModifyIpPoolsRequest::ipamPools)).setter(setter(Builder::ipamPools))
            .constructor(IpamPools::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPools").build()).build();

    private static final SdkField<List<String>> REMOVE_IPAM_POOLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemoveIpamPools")
            .getter(getter(ModifyIpPoolsRequest::removeIpamPoolsAsStrings))
            .setter(setter(Builder::removeIpamPoolsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveIpamPools").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_ARN_FIELD,
            IPAM_POOLS_FIELD, REMOVE_IPAM_POOLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String loadBalancerArn;

    private final IpamPools ipamPools;

    private final List<String> removeIpamPools;

    private ModifyIpPoolsRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerArn = builder.loadBalancerArn;
        this.ipamPools = builder.ipamPools;
        this.removeIpamPools = builder.removeIpamPools;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the load balancer.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the load balancer.
     */
    public final String loadBalancerArn() {
        return loadBalancerArn;
    }

    /**
     * <p>
     * The IPAM pools to be modified.
     * </p>
     * 
     * @return The IPAM pools to be modified.
     */
    public final IpamPools ipamPools() {
        return ipamPools;
    }

    /**
     * <p>
     * Remove the IP pools in use by the load balancer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveIpamPools} method.
     * </p>
     * 
     * @return Remove the IP pools in use by the load balancer.
     */
    public final List<RemoveIpamPoolEnum> removeIpamPools() {
        return RemoveIpamPoolsCopier.copyStringToEnum(removeIpamPools);
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveIpamPools property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemoveIpamPools() {
        return removeIpamPools != null && !(removeIpamPools instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Remove the IP pools in use by the load balancer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveIpamPools} method.
     * </p>
     * 
     * @return Remove the IP pools in use by the load balancer.
     */
    public final List<String> removeIpamPoolsAsStrings() {
        return removeIpamPools;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(ipamPools());
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveIpamPools() ? removeIpamPoolsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIpPoolsRequest)) {
            return false;
        }
        ModifyIpPoolsRequest other = (ModifyIpPoolsRequest) obj;
        return Objects.equals(loadBalancerArn(), other.loadBalancerArn()) && Objects.equals(ipamPools(), other.ipamPools())
                && hasRemoveIpamPools() == other.hasRemoveIpamPools()
                && Objects.equals(removeIpamPoolsAsStrings(), other.removeIpamPoolsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyIpPoolsRequest").add("LoadBalancerArn", loadBalancerArn()).add("IpamPools", ipamPools())
                .add("RemoveIpamPools", hasRemoveIpamPools() ? removeIpamPoolsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBalancerArn":
            return Optional.ofNullable(clazz.cast(loadBalancerArn()));
        case "IpamPools":
            return Optional.ofNullable(clazz.cast(ipamPools()));
        case "RemoveIpamPools":
            return Optional.ofNullable(clazz.cast(removeIpamPoolsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LoadBalancerArn", LOAD_BALANCER_ARN_FIELD);
        map.put("IpamPools", IPAM_POOLS_FIELD);
        map.put("RemoveIpamPools", REMOVE_IPAM_POOLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyIpPoolsRequest, T> g) {
        return obj -> g.apply((ModifyIpPoolsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElasticLoadBalancingV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyIpPoolsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the load balancer.
         * </p>
         * 
         * @param loadBalancerArn
         *        The Amazon Resource Name (ARN) of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerArn(String loadBalancerArn);

        /**
         * <p>
         * The IPAM pools to be modified.
         * </p>
         * 
         * @param ipamPools
         *        The IPAM pools to be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPools(IpamPools ipamPools);

        /**
         * <p>
         * The IPAM pools to be modified.
         * </p>
         * This is a convenience method that creates an instance of the {@link IpamPools.Builder} avoiding the need to
         * create one manually via {@link IpamPools#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IpamPools.Builder#build()} is called immediately and its result
         * is passed to {@link #ipamPools(IpamPools)}.
         * 
         * @param ipamPools
         *        a consumer that will call methods on {@link IpamPools.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipamPools(IpamPools)
         */
        default Builder ipamPools(Consumer<IpamPools.Builder> ipamPools) {
            return ipamPools(IpamPools.builder().applyMutation(ipamPools).build());
        }

        /**
         * <p>
         * Remove the IP pools in use by the load balancer.
         * </p>
         * 
         * @param removeIpamPools
         *        Remove the IP pools in use by the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeIpamPoolsWithStrings(Collection<String> removeIpamPools);

        /**
         * <p>
         * Remove the IP pools in use by the load balancer.
         * </p>
         * 
         * @param removeIpamPools
         *        Remove the IP pools in use by the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeIpamPoolsWithStrings(String... removeIpamPools);

        /**
         * <p>
         * Remove the IP pools in use by the load balancer.
         * </p>
         * 
         * @param removeIpamPools
         *        Remove the IP pools in use by the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeIpamPools(Collection<RemoveIpamPoolEnum> removeIpamPools);

        /**
         * <p>
         * Remove the IP pools in use by the load balancer.
         * </p>
         * 
         * @param removeIpamPools
         *        Remove the IP pools in use by the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeIpamPools(RemoveIpamPoolEnum... removeIpamPools);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Request.BuilderImpl implements Builder {
        private String loadBalancerArn;

        private IpamPools ipamPools;

        private List<String> removeIpamPools = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIpPoolsRequest model) {
            super(model);
            loadBalancerArn(model.loadBalancerArn);
            ipamPools(model.ipamPools);
            removeIpamPoolsWithStrings(model.removeIpamPools);
        }

        public final String getLoadBalancerArn() {
            return loadBalancerArn;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final IpamPools.Builder getIpamPools() {
            return ipamPools != null ? ipamPools.toBuilder() : null;
        }

        public final void setIpamPools(IpamPools.BuilderImpl ipamPools) {
            this.ipamPools = ipamPools != null ? ipamPools.build() : null;
        }

        @Override
        public final Builder ipamPools(IpamPools ipamPools) {
            this.ipamPools = ipamPools;
            return this;
        }

        public final Collection<String> getRemoveIpamPools() {
            if (removeIpamPools instanceof SdkAutoConstructList) {
                return null;
            }
            return removeIpamPools;
        }

        public final void setRemoveIpamPools(Collection<String> removeIpamPools) {
            this.removeIpamPools = RemoveIpamPoolsCopier.copy(removeIpamPools);
        }

        @Override
        public final Builder removeIpamPoolsWithStrings(Collection<String> removeIpamPools) {
            this.removeIpamPools = RemoveIpamPoolsCopier.copy(removeIpamPools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeIpamPoolsWithStrings(String... removeIpamPools) {
            removeIpamPoolsWithStrings(Arrays.asList(removeIpamPools));
            return this;
        }

        @Override
        public final Builder removeIpamPools(Collection<RemoveIpamPoolEnum> removeIpamPools) {
            this.removeIpamPools = RemoveIpamPoolsCopier.copyEnumToString(removeIpamPools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeIpamPools(RemoveIpamPoolEnum... removeIpamPools) {
            removeIpamPools(Arrays.asList(removeIpamPools));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyIpPoolsRequest build() {
            return new ModifyIpPoolsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
