/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a load balancer attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoadBalancerAttribute implements SdkPojo, Serializable,
        ToCopyableBuilder<LoadBalancerAttribute.Builder, LoadBalancerAttribute> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(LoadBalancerAttribute::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(LoadBalancerAttribute::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String value;

    private LoadBalancerAttribute(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of the attribute.
     * </p>
     * <p>
     * The following attributes are supported by all load balancers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>deletion_protection.enabled</code> - Indicates whether deletion protection is enabled. The value is
     * <code>true</code> or <code>false</code>. The default is <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>load_balancing.cross_zone.enabled</code> - Indicates whether cross-zone load balancing is enabled. The
     * possible values are <code>true</code> and <code>false</code>. The default for Network Load Balancers and Gateway
     * Load Balancers is <code>false</code>. The default for Application Load Balancers is <code>true</code>, and can't
     * be changed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attributes are supported by both Application Load Balancers and Network Load Balancers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>access_logs.s3.enabled</code> - Indicates whether access logs are enabled. The value is <code>true</code>
     * or <code>false</code>. The default is <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>access_logs.s3.bucket</code> - The name of the S3 bucket for the access logs. This attribute is required if
     * access logs are enabled. The bucket must exist in the same region as the load balancer and have a bucket policy
     * that grants Elastic Load Balancing permissions to write to the bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>access_logs.s3.prefix</code> - The prefix for the location in the S3 bucket for the access logs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ipv6.deny_all_igw_traffic</code> - Blocks internet gateway (IGW) access to the load balancer. It is set to
     * <code>false</code> for internet-facing load balancers and <code>true</code> for internal load balancers,
     * preventing unintended access to your internal load balancer through an internet gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zonal_shift.config.enabled</code> - Indicates whether zonal shift is enabled. The possible values are
     * <code>true</code> and <code>false</code>. The default is <code>false</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attributes are supported by only Application Load Balancers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>idle_timeout.timeout_seconds</code> - The idle timeout value, in seconds. The valid range is 1-4000
     * seconds. The default is 60 seconds.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>client_keep_alive.seconds</code> - The client keep alive value, in seconds. The valid range is 60-604800
     * seconds. The default is 3600 seconds.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>connection_logs.s3.enabled</code> - Indicates whether connection logs are enabled. The value is
     * <code>true</code> or <code>false</code>. The default is <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>connection_logs.s3.bucket</code> - The name of the S3 bucket for the connection logs. This attribute is
     * required if connection logs are enabled. The bucket must exist in the same region as the load balancer and have a
     * bucket policy that grants Elastic Load Balancing permissions to write to the bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>connection_logs.s3.prefix</code> - The prefix for the location in the S3 bucket for the connection logs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>routing.http.desync_mitigation_mode</code> - Determines how the load balancer handles requests that might
     * pose a security risk to your application. The possible values are <code>monitor</code>, <code>defensive</code>,
     * and <code>strictest</code>. The default is <code>defensive</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>routing.http.drop_invalid_header_fields.enabled</code> - Indicates whether HTTP headers with invalid header
     * fields are removed by the load balancer (<code>true</code>) or routed to targets (<code>false</code>). The
     * default is <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>routing.http.preserve_host_header.enabled</code> - Indicates whether the Application Load Balancer should
     * preserve the <code>Host</code> header in the HTTP request and send it to the target without any change. The
     * possible values are <code>true</code> and <code>false</code>. The default is <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>routing.http.x_amzn_tls_version_and_cipher_suite.enabled</code> - Indicates whether the two headers (
     * <code>x-amzn-tls-version</code> and <code>x-amzn-tls-cipher-suite</code>), which contain information about the
     * negotiated TLS version and cipher suite, are added to the client request before sending it to the target. The
     * <code>x-amzn-tls-version</code> header has information about the TLS protocol version negotiated with the client,
     * and the <code>x-amzn-tls-cipher-suite</code> header has information about the cipher suite negotiated with the
     * client. Both headers are in OpenSSL format. The possible values for the attribute are <code>true</code> and
     * <code>false</code>. The default is <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>routing.http.xff_client_port.enabled</code> - Indicates whether the <code>X-Forwarded-For</code> header
     * should preserve the source port that the client used to connect to the load balancer. The possible values are
     * <code>true</code> and <code>false</code>. The default is <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>routing.http.xff_header_processing.mode</code> - Enables you to modify, preserve, or remove the
     * <code>X-Forwarded-For</code> header in the HTTP request before the Application Load Balancer sends the request to
     * the target. The possible values are <code>append</code>, <code>preserve</code>, and <code>remove</code>. The
     * default is <code>append</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the value is <code>append</code>, the Application Load Balancer adds the client IP address (of the last hop)
     * to the <code>X-Forwarded-For</code> header in the HTTP request before it sends it to targets.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the value is <code>preserve</code> the Application Load Balancer preserves the <code>X-Forwarded-For</code>
     * header in the HTTP request, and sends it to targets without any change.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the value is <code>remove</code>, the Application Load Balancer removes the <code>X-Forwarded-For</code>
     * header in the HTTP request before it sends it to targets.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>routing.http2.enabled</code> - Indicates whether clients can connect to the load balancer using HTTP/2. If
     * <code>true</code>, clients can connect using HTTP/2 or HTTP/1.1. However, all client requests are subject to the
     * stricter HTTP/2 header validation rules. For example, message header names must contain only alphanumeric
     * characters and hyphens. If <code>false</code>, clients must connect using HTTP/1.1. The default is
     * <code>true</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>waf.fail_open.enabled</code> - Indicates whether to allow a WAF-enabled load balancer to route requests to
     * targets if it is unable to forward the request to Amazon Web Services WAF. The possible values are
     * <code>true</code> and <code>false</code>. The default is <code>false</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following attributes are supported by only Network Load Balancers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>dns_record.client_routing_policy</code> - Indicates how traffic is distributed among the load balancer
     * Availability Zones. The possible values are <code>availability_zone_affinity</code> with 100 percent zonal
     * affinity, <code>partial_availability_zone_affinity</code> with 85 percent zonal affinity, and
     * <code>any_availability_zone</code> with 0 percent zonal affinity.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>secondary_ips.auto_assigned.per_subnet</code> - The number of secondary IP addresses to configure for your
     * load balancer nodes. Use to address port allocation errors if you can't add targets. The valid range is 0 to 7.
     * The default is 0. After you set this value, you can't decrease it.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the attribute.</p>
     *         <p>
     *         The following attributes are supported by all load balancers:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>deletion_protection.enabled</code> - Indicates whether deletion protection is enabled. The value is
     *         <code>true</code> or <code>false</code>. The default is <code>false</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>load_balancing.cross_zone.enabled</code> - Indicates whether cross-zone load balancing is enabled.
     *         The possible values are <code>true</code> and <code>false</code>. The default for Network Load Balancers
     *         and Gateway Load Balancers is <code>false</code>. The default for Application Load Balancers is
     *         <code>true</code>, and can't be changed.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following attributes are supported by both Application Load Balancers and Network Load Balancers:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>access_logs.s3.enabled</code> - Indicates whether access logs are enabled. The value is
     *         <code>true</code> or <code>false</code>. The default is <code>false</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>access_logs.s3.bucket</code> - The name of the S3 bucket for the access logs. This attribute is
     *         required if access logs are enabled. The bucket must exist in the same region as the load balancer and
     *         have a bucket policy that grants Elastic Load Balancing permissions to write to the bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>access_logs.s3.prefix</code> - The prefix for the location in the S3 bucket for the access logs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ipv6.deny_all_igw_traffic</code> - Blocks internet gateway (IGW) access to the load balancer. It is
     *         set to <code>false</code> for internet-facing load balancers and <code>true</code> for internal load
     *         balancers, preventing unintended access to your internal load balancer through an internet gateway.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zonal_shift.config.enabled</code> - Indicates whether zonal shift is enabled. The possible values
     *         are <code>true</code> and <code>false</code>. The default is <code>false</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following attributes are supported by only Application Load Balancers:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>idle_timeout.timeout_seconds</code> - The idle timeout value, in seconds. The valid range is 1-4000
     *         seconds. The default is 60 seconds.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>client_keep_alive.seconds</code> - The client keep alive value, in seconds. The valid range is
     *         60-604800 seconds. The default is 3600 seconds.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>connection_logs.s3.enabled</code> - Indicates whether connection logs are enabled. The value is
     *         <code>true</code> or <code>false</code>. The default is <code>false</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>connection_logs.s3.bucket</code> - The name of the S3 bucket for the connection logs. This
     *         attribute is required if connection logs are enabled. The bucket must exist in the same region as the
     *         load balancer and have a bucket policy that grants Elastic Load Balancing permissions to write to the
     *         bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>connection_logs.s3.prefix</code> - The prefix for the location in the S3 bucket for the connection
     *         logs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>routing.http.desync_mitigation_mode</code> - Determines how the load balancer handles requests that
     *         might pose a security risk to your application. The possible values are <code>monitor</code>,
     *         <code>defensive</code>, and <code>strictest</code>. The default is <code>defensive</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>routing.http.drop_invalid_header_fields.enabled</code> - Indicates whether HTTP headers with
     *         invalid header fields are removed by the load balancer (<code>true</code>) or routed to targets (
     *         <code>false</code>). The default is <code>false</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>routing.http.preserve_host_header.enabled</code> - Indicates whether the Application Load Balancer
     *         should preserve the <code>Host</code> header in the HTTP request and send it to the target without any
     *         change. The possible values are <code>true</code> and <code>false</code>. The default is
     *         <code>false</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>routing.http.x_amzn_tls_version_and_cipher_suite.enabled</code> - Indicates whether the two headers
     *         (<code>x-amzn-tls-version</code> and <code>x-amzn-tls-cipher-suite</code>), which contain information
     *         about the negotiated TLS version and cipher suite, are added to the client request before sending it to
     *         the target. The <code>x-amzn-tls-version</code> header has information about the TLS protocol version
     *         negotiated with the client, and the <code>x-amzn-tls-cipher-suite</code> header has information about the
     *         cipher suite negotiated with the client. Both headers are in OpenSSL format. The possible values for the
     *         attribute are <code>true</code> and <code>false</code>. The default is <code>false</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>routing.http.xff_client_port.enabled</code> - Indicates whether the <code>X-Forwarded-For</code>
     *         header should preserve the source port that the client used to connect to the load balancer. The possible
     *         values are <code>true</code> and <code>false</code>. The default is <code>false</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>routing.http.xff_header_processing.mode</code> - Enables you to modify, preserve, or remove the
     *         <code>X-Forwarded-For</code> header in the HTTP request before the Application Load Balancer sends the
     *         request to the target. The possible values are <code>append</code>, <code>preserve</code>, and
     *         <code>remove</code>. The default is <code>append</code>.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the value is <code>append</code>, the Application Load Balancer adds the client IP address (of the
     *         last hop) to the <code>X-Forwarded-For</code> header in the HTTP request before it sends it to targets.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the value is <code>preserve</code> the Application Load Balancer preserves the
     *         <code>X-Forwarded-For</code> header in the HTTP request, and sends it to targets without any change.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the value is <code>remove</code>, the Application Load Balancer removes the
     *         <code>X-Forwarded-For</code> header in the HTTP request before it sends it to targets.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>routing.http2.enabled</code> - Indicates whether clients can connect to the load balancer using
     *         HTTP/2. If <code>true</code>, clients can connect using HTTP/2 or HTTP/1.1. However, all client requests
     *         are subject to the stricter HTTP/2 header validation rules. For example, message header names must
     *         contain only alphanumeric characters and hyphens. If <code>false</code>, clients must connect using
     *         HTTP/1.1. The default is <code>true</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>waf.fail_open.enabled</code> - Indicates whether to allow a WAF-enabled load balancer to route
     *         requests to targets if it is unable to forward the request to Amazon Web Services WAF. The possible
     *         values are <code>true</code> and <code>false</code>. The default is <code>false</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The following attributes are supported by only Network Load Balancers:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>dns_record.client_routing_policy</code> - Indicates how traffic is distributed among the load
     *         balancer Availability Zones. The possible values are <code>availability_zone_affinity</code> with 100
     *         percent zonal affinity, <code>partial_availability_zone_affinity</code> with 85 percent zonal affinity,
     *         and <code>any_availability_zone</code> with 0 percent zonal affinity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>secondary_ips.auto_assigned.per_subnet</code> - The number of secondary IP addresses to configure
     *         for your load balancer nodes. Use to address port allocation errors if you can't add targets. The valid
     *         range is 0 to 7. The default is 0. After you set this value, you can't decrease it.
     *         </p>
     *         </li>
     */
    public final String key() {
        return key;
    }

    /**
     * <p>
     * The value of the attribute.
     * </p>
     * 
     * @return The value of the attribute.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerAttribute)) {
            return false;
        }
        LoadBalancerAttribute other = (LoadBalancerAttribute) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoadBalancerAttribute").add("Key", key()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Key", KEY_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoadBalancerAttribute, T> g) {
        return obj -> g.apply((LoadBalancerAttribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoadBalancerAttribute> {
        /**
         * <p>
         * The name of the attribute.
         * </p>
         * <p>
         * The following attributes are supported by all load balancers:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>deletion_protection.enabled</code> - Indicates whether deletion protection is enabled. The value is
         * <code>true</code> or <code>false</code>. The default is <code>false</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>load_balancing.cross_zone.enabled</code> - Indicates whether cross-zone load balancing is enabled. The
         * possible values are <code>true</code> and <code>false</code>. The default for Network Load Balancers and
         * Gateway Load Balancers is <code>false</code>. The default for Application Load Balancers is <code>true</code>
         * , and can't be changed.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attributes are supported by both Application Load Balancers and Network Load Balancers:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>access_logs.s3.enabled</code> - Indicates whether access logs are enabled. The value is
         * <code>true</code> or <code>false</code>. The default is <code>false</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>access_logs.s3.bucket</code> - The name of the S3 bucket for the access logs. This attribute is
         * required if access logs are enabled. The bucket must exist in the same region as the load balancer and have a
         * bucket policy that grants Elastic Load Balancing permissions to write to the bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>access_logs.s3.prefix</code> - The prefix for the location in the S3 bucket for the access logs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ipv6.deny_all_igw_traffic</code> - Blocks internet gateway (IGW) access to the load balancer. It is set
         * to <code>false</code> for internet-facing load balancers and <code>true</code> for internal load balancers,
         * preventing unintended access to your internal load balancer through an internet gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zonal_shift.config.enabled</code> - Indicates whether zonal shift is enabled. The possible values are
         * <code>true</code> and <code>false</code>. The default is <code>false</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attributes are supported by only Application Load Balancers:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>idle_timeout.timeout_seconds</code> - The idle timeout value, in seconds. The valid range is 1-4000
         * seconds. The default is 60 seconds.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>client_keep_alive.seconds</code> - The client keep alive value, in seconds. The valid range is
         * 60-604800 seconds. The default is 3600 seconds.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>connection_logs.s3.enabled</code> - Indicates whether connection logs are enabled. The value is
         * <code>true</code> or <code>false</code>. The default is <code>false</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>connection_logs.s3.bucket</code> - The name of the S3 bucket for the connection logs. This attribute is
         * required if connection logs are enabled. The bucket must exist in the same region as the load balancer and
         * have a bucket policy that grants Elastic Load Balancing permissions to write to the bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>connection_logs.s3.prefix</code> - The prefix for the location in the S3 bucket for the connection
         * logs.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>routing.http.desync_mitigation_mode</code> - Determines how the load balancer handles requests that
         * might pose a security risk to your application. The possible values are <code>monitor</code>,
         * <code>defensive</code>, and <code>strictest</code>. The default is <code>defensive</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>routing.http.drop_invalid_header_fields.enabled</code> - Indicates whether HTTP headers with invalid
         * header fields are removed by the load balancer (<code>true</code>) or routed to targets (<code>false</code>).
         * The default is <code>false</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>routing.http.preserve_host_header.enabled</code> - Indicates whether the Application Load Balancer
         * should preserve the <code>Host</code> header in the HTTP request and send it to the target without any
         * change. The possible values are <code>true</code> and <code>false</code>. The default is <code>false</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>routing.http.x_amzn_tls_version_and_cipher_suite.enabled</code> - Indicates whether the two headers (
         * <code>x-amzn-tls-version</code> and <code>x-amzn-tls-cipher-suite</code>), which contain information about
         * the negotiated TLS version and cipher suite, are added to the client request before sending it to the target.
         * The <code>x-amzn-tls-version</code> header has information about the TLS protocol version negotiated with the
         * client, and the <code>x-amzn-tls-cipher-suite</code> header has information about the cipher suite negotiated
         * with the client. Both headers are in OpenSSL format. The possible values for the attribute are
         * <code>true</code> and <code>false</code>. The default is <code>false</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>routing.http.xff_client_port.enabled</code> - Indicates whether the <code>X-Forwarded-For</code> header
         * should preserve the source port that the client used to connect to the load balancer. The possible values are
         * <code>true</code> and <code>false</code>. The default is <code>false</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>routing.http.xff_header_processing.mode</code> - Enables you to modify, preserve, or remove the
         * <code>X-Forwarded-For</code> header in the HTTP request before the Application Load Balancer sends the
         * request to the target. The possible values are <code>append</code>, <code>preserve</code>, and
         * <code>remove</code>. The default is <code>append</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the value is <code>append</code>, the Application Load Balancer adds the client IP address (of the last
         * hop) to the <code>X-Forwarded-For</code> header in the HTTP request before it sends it to targets.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the value is <code>preserve</code> the Application Load Balancer preserves the
         * <code>X-Forwarded-For</code> header in the HTTP request, and sends it to targets without any change.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the value is <code>remove</code>, the Application Load Balancer removes the <code>X-Forwarded-For</code>
         * header in the HTTP request before it sends it to targets.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>routing.http2.enabled</code> - Indicates whether clients can connect to the load balancer using HTTP/2.
         * If <code>true</code>, clients can connect using HTTP/2 or HTTP/1.1. However, all client requests are subject
         * to the stricter HTTP/2 header validation rules. For example, message header names must contain only
         * alphanumeric characters and hyphens. If <code>false</code>, clients must connect using HTTP/1.1. The default
         * is <code>true</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>waf.fail_open.enabled</code> - Indicates whether to allow a WAF-enabled load balancer to route requests
         * to targets if it is unable to forward the request to Amazon Web Services WAF. The possible values are
         * <code>true</code> and <code>false</code>. The default is <code>false</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The following attributes are supported by only Network Load Balancers:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>dns_record.client_routing_policy</code> - Indicates how traffic is distributed among the load balancer
         * Availability Zones. The possible values are <code>availability_zone_affinity</code> with 100 percent zonal
         * affinity, <code>partial_availability_zone_affinity</code> with 85 percent zonal affinity, and
         * <code>any_availability_zone</code> with 0 percent zonal affinity.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>secondary_ips.auto_assigned.per_subnet</code> - The number of secondary IP addresses to configure for
         * your load balancer nodes. Use to address port allocation errors if you can't add targets. The valid range is
         * 0 to 7. The default is 0. After you set this value, you can't decrease it.
         * </p>
         * </li>
         * </ul>
         * 
         * @param key
         *        The name of the attribute.</p>
         *        <p>
         *        The following attributes are supported by all load balancers:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>deletion_protection.enabled</code> - Indicates whether deletion protection is enabled. The value
         *        is <code>true</code> or <code>false</code>. The default is <code>false</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>load_balancing.cross_zone.enabled</code> - Indicates whether cross-zone load balancing is
         *        enabled. The possible values are <code>true</code> and <code>false</code>. The default for Network
         *        Load Balancers and Gateway Load Balancers is <code>false</code>. The default for Application Load
         *        Balancers is <code>true</code>, and can't be changed.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attributes are supported by both Application Load Balancers and Network Load Balancers:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>access_logs.s3.enabled</code> - Indicates whether access logs are enabled. The value is
         *        <code>true</code> or <code>false</code>. The default is <code>false</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>access_logs.s3.bucket</code> - The name of the S3 bucket for the access logs. This attribute is
         *        required if access logs are enabled. The bucket must exist in the same region as the load balancer and
         *        have a bucket policy that grants Elastic Load Balancing permissions to write to the bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>access_logs.s3.prefix</code> - The prefix for the location in the S3 bucket for the access logs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ipv6.deny_all_igw_traffic</code> - Blocks internet gateway (IGW) access to the load balancer. It
         *        is set to <code>false</code> for internet-facing load balancers and <code>true</code> for internal
         *        load balancers, preventing unintended access to your internal load balancer through an internet
         *        gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zonal_shift.config.enabled</code> - Indicates whether zonal shift is enabled. The possible
         *        values are <code>true</code> and <code>false</code>. The default is <code>false</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attributes are supported by only Application Load Balancers:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>idle_timeout.timeout_seconds</code> - The idle timeout value, in seconds. The valid range is
         *        1-4000 seconds. The default is 60 seconds.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>client_keep_alive.seconds</code> - The client keep alive value, in seconds. The valid range is
         *        60-604800 seconds. The default is 3600 seconds.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>connection_logs.s3.enabled</code> - Indicates whether connection logs are enabled. The value is
         *        <code>true</code> or <code>false</code>. The default is <code>false</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>connection_logs.s3.bucket</code> - The name of the S3 bucket for the connection logs. This
         *        attribute is required if connection logs are enabled. The bucket must exist in the same region as the
         *        load balancer and have a bucket policy that grants Elastic Load Balancing permissions to write to the
         *        bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>connection_logs.s3.prefix</code> - The prefix for the location in the S3 bucket for the
         *        connection logs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>routing.http.desync_mitigation_mode</code> - Determines how the load balancer handles requests
         *        that might pose a security risk to your application. The possible values are <code>monitor</code>,
         *        <code>defensive</code>, and <code>strictest</code>. The default is <code>defensive</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>routing.http.drop_invalid_header_fields.enabled</code> - Indicates whether HTTP headers with
         *        invalid header fields are removed by the load balancer (<code>true</code>) or routed to targets (
         *        <code>false</code>). The default is <code>false</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>routing.http.preserve_host_header.enabled</code> - Indicates whether the Application Load
         *        Balancer should preserve the <code>Host</code> header in the HTTP request and send it to the target
         *        without any change. The possible values are <code>true</code> and <code>false</code>. The default is
         *        <code>false</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>routing.http.x_amzn_tls_version_and_cipher_suite.enabled</code> - Indicates whether the two
         *        headers (<code>x-amzn-tls-version</code> and <code>x-amzn-tls-cipher-suite</code>), which contain
         *        information about the negotiated TLS version and cipher suite, are added to the client request before
         *        sending it to the target. The <code>x-amzn-tls-version</code> header has information about the TLS
         *        protocol version negotiated with the client, and the <code>x-amzn-tls-cipher-suite</code> header has
         *        information about the cipher suite negotiated with the client. Both headers are in OpenSSL format. The
         *        possible values for the attribute are <code>true</code> and <code>false</code>. The default is
         *        <code>false</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>routing.http.xff_client_port.enabled</code> - Indicates whether the <code>X-Forwarded-For</code>
         *        header should preserve the source port that the client used to connect to the load balancer. The
         *        possible values are <code>true</code> and <code>false</code>. The default is <code>false</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>routing.http.xff_header_processing.mode</code> - Enables you to modify, preserve, or remove the
         *        <code>X-Forwarded-For</code> header in the HTTP request before the Application Load Balancer sends the
         *        request to the target. The possible values are <code>append</code>, <code>preserve</code>, and
         *        <code>remove</code>. The default is <code>append</code>.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the value is <code>append</code>, the Application Load Balancer adds the client IP address (of the
         *        last hop) to the <code>X-Forwarded-For</code> header in the HTTP request before it sends it to
         *        targets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the value is <code>preserve</code> the Application Load Balancer preserves the
         *        <code>X-Forwarded-For</code> header in the HTTP request, and sends it to targets without any change.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the value is <code>remove</code>, the Application Load Balancer removes the
         *        <code>X-Forwarded-For</code> header in the HTTP request before it sends it to targets.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>routing.http2.enabled</code> - Indicates whether clients can connect to the load balancer using
         *        HTTP/2. If <code>true</code>, clients can connect using HTTP/2 or HTTP/1.1. However, all client
         *        requests are subject to the stricter HTTP/2 header validation rules. For example, message header names
         *        must contain only alphanumeric characters and hyphens. If <code>false</code>, clients must connect
         *        using HTTP/1.1. The default is <code>true</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>waf.fail_open.enabled</code> - Indicates whether to allow a WAF-enabled load balancer to route
         *        requests to targets if it is unable to forward the request to Amazon Web Services WAF. The possible
         *        values are <code>true</code> and <code>false</code>. The default is <code>false</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The following attributes are supported by only Network Load Balancers:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>dns_record.client_routing_policy</code> - Indicates how traffic is distributed among the load
         *        balancer Availability Zones. The possible values are <code>availability_zone_affinity</code> with 100
         *        percent zonal affinity, <code>partial_availability_zone_affinity</code> with 85 percent zonal
         *        affinity, and <code>any_availability_zone</code> with 0 percent zonal affinity.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>secondary_ips.auto_assigned.per_subnet</code> - The number of secondary IP addresses to
         *        configure for your load balancer nodes. Use to address port allocation errors if you can't add
         *        targets. The valid range is 0 to 7. The default is 0. After you set this value, you can't decrease it.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The value of the attribute.
         * </p>
         * 
         * @param value
         *        The value of the attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerAttribute model) {
            key(model.key);
            value(model.value);
        }

        public final String getKey() {
            return key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public LoadBalancerAttribute build() {
            return new LoadBalancerAttribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
