/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTrustStoreAssociationsResponse extends ElasticLoadBalancingV2Response implements
        ToCopyableBuilder<DescribeTrustStoreAssociationsResponse.Builder, DescribeTrustStoreAssociationsResponse> {
    private static final SdkField<List<TrustStoreAssociation>> TRUST_STORE_ASSOCIATIONS_FIELD = SdkField
            .<List<TrustStoreAssociation>> builder(MarshallingType.LIST)
            .memberName("TrustStoreAssociations")
            .getter(getter(DescribeTrustStoreAssociationsResponse::trustStoreAssociations))
            .setter(setter(Builder::trustStoreAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStoreAssociations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TrustStoreAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrustStoreAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(DescribeTrustStoreAssociationsResponse::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRUST_STORE_ASSOCIATIONS_FIELD, NEXT_MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<TrustStoreAssociation> trustStoreAssociations;

    private final String nextMarker;

    private DescribeTrustStoreAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.trustStoreAssociations = builder.trustStoreAssociations;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrustStoreAssociations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTrustStoreAssociations() {
        return trustStoreAssociations != null && !(trustStoreAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the resources the trust store is associated to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrustStoreAssociations} method.
     * </p>
     * 
     * @return Information about the resources the trust store is associated to.
     */
    public final List<TrustStoreAssociation> trustStoreAssociations() {
        return trustStoreAssociations;
    }

    /**
     * <p>
     * If there are additional results, this is the marker for the next set of results. Otherwise, this is null.
     * </p>
     * 
     * @return If there are additional results, this is the marker for the next set of results. Otherwise, this is null.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTrustStoreAssociations() ? trustStoreAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrustStoreAssociationsResponse)) {
            return false;
        }
        DescribeTrustStoreAssociationsResponse other = (DescribeTrustStoreAssociationsResponse) obj;
        return hasTrustStoreAssociations() == other.hasTrustStoreAssociations()
                && Objects.equals(trustStoreAssociations(), other.trustStoreAssociations())
                && Objects.equals(nextMarker(), other.nextMarker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTrustStoreAssociationsResponse")
                .add("TrustStoreAssociations", hasTrustStoreAssociations() ? trustStoreAssociations() : null)
                .add("NextMarker", nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrustStoreAssociations":
            return Optional.ofNullable(clazz.cast(trustStoreAssociations()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrustStoreAssociations", TRUST_STORE_ASSOCIATIONS_FIELD);
        map.put("NextMarker", NEXT_MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrustStoreAssociationsResponse, T> g) {
        return obj -> g.apply((DescribeTrustStoreAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ElasticLoadBalancingV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTrustStoreAssociationsResponse> {
        /**
         * <p>
         * Information about the resources the trust store is associated to.
         * </p>
         * 
         * @param trustStoreAssociations
         *        Information about the resources the trust store is associated to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustStoreAssociations(Collection<TrustStoreAssociation> trustStoreAssociations);

        /**
         * <p>
         * Information about the resources the trust store is associated to.
         * </p>
         * 
         * @param trustStoreAssociations
         *        Information about the resources the trust store is associated to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustStoreAssociations(TrustStoreAssociation... trustStoreAssociations);

        /**
         * <p>
         * Information about the resources the trust store is associated to.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.TrustStoreAssociation.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.TrustStoreAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.TrustStoreAssociation.Builder#build()} is
         * called immediately and its result is passed to {@link #trustStoreAssociations(List<TrustStoreAssociation>)}.
         * 
         * @param trustStoreAssociations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.TrustStoreAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trustStoreAssociations(java.util.Collection<TrustStoreAssociation>)
         */
        Builder trustStoreAssociations(Consumer<TrustStoreAssociation.Builder>... trustStoreAssociations);

        /**
         * <p>
         * If there are additional results, this is the marker for the next set of results. Otherwise, this is null.
         * </p>
         * 
         * @param nextMarker
         *        If there are additional results, this is the marker for the next set of results. Otherwise, this is
         *        null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Response.BuilderImpl implements Builder {
        private List<TrustStoreAssociation> trustStoreAssociations = DefaultSdkAutoConstructList.getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrustStoreAssociationsResponse model) {
            super(model);
            trustStoreAssociations(model.trustStoreAssociations);
            nextMarker(model.nextMarker);
        }

        public final List<TrustStoreAssociation.Builder> getTrustStoreAssociations() {
            List<TrustStoreAssociation.Builder> result = TrustStoreAssociationsCopier.copyToBuilder(this.trustStoreAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrustStoreAssociations(Collection<TrustStoreAssociation.BuilderImpl> trustStoreAssociations) {
            this.trustStoreAssociations = TrustStoreAssociationsCopier.copyFromBuilder(trustStoreAssociations);
        }

        @Override
        public final Builder trustStoreAssociations(Collection<TrustStoreAssociation> trustStoreAssociations) {
            this.trustStoreAssociations = TrustStoreAssociationsCopier.copy(trustStoreAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trustStoreAssociations(TrustStoreAssociation... trustStoreAssociations) {
            trustStoreAssociations(Arrays.asList(trustStoreAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trustStoreAssociations(Consumer<TrustStoreAssociation.Builder>... trustStoreAssociations) {
            trustStoreAssociations(Stream.of(trustStoreAssociations)
                    .map(c -> TrustStoreAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public DescribeTrustStoreAssociationsResponse build() {
            return new DescribeTrustStoreAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
