/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.EnablePrefixForIpv6SourceNatEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.IpAddressType;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SubnetMapping;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SubnetMappingsCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SubnetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetSubnetsRequest
extends ElasticLoadBalancingV2Request
implements ToCopyableBuilder<Builder, SetSubnetsRequest> {
    private static final SdkField<String> LOAD_BALANCER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoadBalancerArn").getter(SetSubnetsRequest.getter(SetSubnetsRequest::loadBalancerArn)).setter(SetSubnetsRequest.setter(Builder::loadBalancerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerArn").build()}).build();
    private static final SdkField<List<String>> SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subnets").getter(SetSubnetsRequest.getter(SetSubnetsRequest::subnets)).setter(SetSubnetsRequest.setter(Builder::subnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SubnetMapping>> SUBNET_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetMappings").getter(SetSubnetsRequest.getter(SetSubnetsRequest::subnetMappings)).setter(SetSubnetsRequest.setter(Builder::subnetMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SubnetMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddressType").getter(SetSubnetsRequest.getter(SetSubnetsRequest::ipAddressTypeAsString)).setter(SetSubnetsRequest.setter(Builder::ipAddressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType").build()}).build();
    private static final SdkField<String> ENABLE_PREFIX_FOR_IPV6_SOURCE_NAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnablePrefixForIpv6SourceNat").getter(SetSubnetsRequest.getter(SetSubnetsRequest::enablePrefixForIpv6SourceNatAsString)).setter(SetSubnetsRequest.setter(Builder::enablePrefixForIpv6SourceNat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePrefixForIpv6SourceNat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_ARN_FIELD, SUBNETS_FIELD, SUBNET_MAPPINGS_FIELD, IP_ADDRESS_TYPE_FIELD, ENABLE_PREFIX_FOR_IPV6_SOURCE_NAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SetSubnetsRequest.memberNameToFieldInitializer();
    private final String loadBalancerArn;
    private final List<String> subnets;
    private final List<SubnetMapping> subnetMappings;
    private final String ipAddressType;
    private final String enablePrefixForIpv6SourceNat;

    private SetSubnetsRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerArn = builder.loadBalancerArn;
        this.subnets = builder.subnets;
        this.subnetMappings = builder.subnetMappings;
        this.ipAddressType = builder.ipAddressType;
        this.enablePrefixForIpv6SourceNat = builder.enablePrefixForIpv6SourceNat;
    }

    public final String loadBalancerArn() {
        return this.loadBalancerArn;
    }

    public final boolean hasSubnets() {
        return this.subnets != null && !(this.subnets instanceof SdkAutoConstructList);
    }

    public final List<String> subnets() {
        return this.subnets;
    }

    public final boolean hasSubnetMappings() {
        return this.subnetMappings != null && !(this.subnetMappings instanceof SdkAutoConstructList);
    }

    public final List<SubnetMapping> subnetMappings() {
        return this.subnetMappings;
    }

    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(this.ipAddressType);
    }

    public final String ipAddressTypeAsString() {
        return this.ipAddressType;
    }

    public final EnablePrefixForIpv6SourceNatEnum enablePrefixForIpv6SourceNat() {
        return EnablePrefixForIpv6SourceNatEnum.fromValue(this.enablePrefixForIpv6SourceNat);
    }

    public final String enablePrefixForIpv6SourceNatAsString() {
        return this.enablePrefixForIpv6SourceNat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnets() ? this.subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetMappings() ? this.subnetMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePrefixForIpv6SourceNatAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetSubnetsRequest)) {
            return false;
        }
        SetSubnetsRequest other = (SetSubnetsRequest)((Object)obj);
        return Objects.equals(this.loadBalancerArn(), other.loadBalancerArn()) && this.hasSubnets() == other.hasSubnets() && Objects.equals(this.subnets(), other.subnets()) && this.hasSubnetMappings() == other.hasSubnetMappings() && Objects.equals(this.subnetMappings(), other.subnetMappings()) && Objects.equals(this.ipAddressTypeAsString(), other.ipAddressTypeAsString()) && Objects.equals(this.enablePrefixForIpv6SourceNatAsString(), other.enablePrefixForIpv6SourceNatAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SetSubnetsRequest").add("LoadBalancerArn", (Object)this.loadBalancerArn()).add("Subnets", this.hasSubnets() ? this.subnets() : null).add("SubnetMappings", this.hasSubnetMappings() ? this.subnetMappings() : null).add("IpAddressType", (Object)this.ipAddressTypeAsString()).add("EnablePrefixForIpv6SourceNat", (Object)this.enablePrefixForIpv6SourceNatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerArn": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerArn()));
            }
            case "Subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
            case "SubnetMappings": {
                return Optional.ofNullable(clazz.cast(this.subnetMappings()));
            }
            case "IpAddressType": {
                return Optional.ofNullable(clazz.cast(this.ipAddressTypeAsString()));
            }
            case "EnablePrefixForIpv6SourceNat": {
                return Optional.ofNullable(clazz.cast(this.enablePrefixForIpv6SourceNatAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LoadBalancerArn", LOAD_BALANCER_ARN_FIELD);
        map.put("Subnets", SUBNETS_FIELD);
        map.put("SubnetMappings", SUBNET_MAPPINGS_FIELD);
        map.put("IpAddressType", IP_ADDRESS_TYPE_FIELD);
        map.put("EnablePrefixForIpv6SourceNat", ENABLE_PREFIX_FOR_IPV6_SOURCE_NAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetSubnetsRequest, T> g) {
        return obj -> g.apply((SetSubnetsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Request.BuilderImpl
    implements Builder {
        private String loadBalancerArn;
        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();
        private List<SubnetMapping> subnetMappings = DefaultSdkAutoConstructList.getInstance();
        private String ipAddressType;
        private String enablePrefixForIpv6SourceNat;

        private BuilderImpl() {
        }

        private BuilderImpl(SetSubnetsRequest model) {
            super(model);
            this.loadBalancerArn(model.loadBalancerArn);
            this.subnets(model.subnets);
            this.subnetMappings(model.subnetMappings);
            this.ipAddressType(model.ipAddressType);
            this.enablePrefixForIpv6SourceNat(model.enablePrefixForIpv6SourceNat);
        }

        public final String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final Collection<String> getSubnets() {
            if (this.subnets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnets;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = SubnetsCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final List<SubnetMapping.Builder> getSubnetMappings() {
            List<SubnetMapping.Builder> result = SubnetMappingsCopier.copyToBuilder(this.subnetMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubnetMappings(Collection<SubnetMapping.BuilderImpl> subnetMappings) {
            this.subnetMappings = SubnetMappingsCopier.copyFromBuilder(subnetMappings);
        }

        @Override
        public final Builder subnetMappings(Collection<SubnetMapping> subnetMappings) {
            this.subnetMappings = SubnetMappingsCopier.copy(subnetMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetMappings(SubnetMapping ... subnetMappings) {
            this.subnetMappings(Arrays.asList(subnetMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetMappings(Consumer<SubnetMapping.Builder> ... subnetMappings) {
            this.subnetMappings(Stream.of(subnetMappings).map(c -> (SubnetMapping)((SubnetMapping.Builder)SubnetMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final String getEnablePrefixForIpv6SourceNat() {
            return this.enablePrefixForIpv6SourceNat;
        }

        public final void setEnablePrefixForIpv6SourceNat(String enablePrefixForIpv6SourceNat) {
            this.enablePrefixForIpv6SourceNat = enablePrefixForIpv6SourceNat;
        }

        @Override
        public final Builder enablePrefixForIpv6SourceNat(String enablePrefixForIpv6SourceNat) {
            this.enablePrefixForIpv6SourceNat = enablePrefixForIpv6SourceNat;
            return this;
        }

        @Override
        public final Builder enablePrefixForIpv6SourceNat(EnablePrefixForIpv6SourceNatEnum enablePrefixForIpv6SourceNat) {
            this.enablePrefixForIpv6SourceNat(enablePrefixForIpv6SourceNat == null ? null : enablePrefixForIpv6SourceNat.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetSubnetsRequest build() {
            return new SetSubnetsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ElasticLoadBalancingV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SetSubnetsRequest> {
        public Builder loadBalancerArn(String var1);

        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);

        public Builder subnetMappings(Collection<SubnetMapping> var1);

        public Builder subnetMappings(SubnetMapping ... var1);

        public Builder subnetMappings(Consumer<SubnetMapping.Builder> ... var1);

        public Builder ipAddressType(String var1);

        public Builder ipAddressType(IpAddressType var1);

        public Builder enablePrefixForIpv6SourceNat(String var1);

        public Builder enablePrefixForIpv6SourceNat(EnablePrefixForIpv6SourceNatEnum var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

