/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RulePriorityListCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RulePriorityPair;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetRulePrioritiesRequest
extends ElasticLoadBalancingV2Request
implements ToCopyableBuilder<Builder, SetRulePrioritiesRequest> {
    private static final SdkField<List<RulePriorityPair>> RULE_PRIORITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RulePriorities").getter(SetRulePrioritiesRequest.getter(SetRulePrioritiesRequest::rulePriorities)).setter(SetRulePrioritiesRequest.setter(Builder::rulePriorities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RulePriorities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RulePriorityPair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_PRIORITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SetRulePrioritiesRequest.memberNameToFieldInitializer();
    private final List<RulePriorityPair> rulePriorities;

    private SetRulePrioritiesRequest(BuilderImpl builder) {
        super(builder);
        this.rulePriorities = builder.rulePriorities;
    }

    public final boolean hasRulePriorities() {
        return this.rulePriorities != null && !(this.rulePriorities instanceof SdkAutoConstructList);
    }

    public final List<RulePriorityPair> rulePriorities() {
        return this.rulePriorities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRulePriorities() ? this.rulePriorities() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetRulePrioritiesRequest)) {
            return false;
        }
        SetRulePrioritiesRequest other = (SetRulePrioritiesRequest)((Object)obj);
        return this.hasRulePriorities() == other.hasRulePriorities() && Objects.equals(this.rulePriorities(), other.rulePriorities());
    }

    public final String toString() {
        return ToString.builder((String)"SetRulePrioritiesRequest").add("RulePriorities", this.hasRulePriorities() ? this.rulePriorities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RulePriorities": {
                return Optional.ofNullable(clazz.cast(this.rulePriorities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<RulePriorityPair>>> map = new HashMap<String, SdkField<List<RulePriorityPair>>>();
        map.put("RulePriorities", RULE_PRIORITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetRulePrioritiesRequest, T> g) {
        return obj -> g.apply((SetRulePrioritiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Request.BuilderImpl
    implements Builder {
        private List<RulePriorityPair> rulePriorities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SetRulePrioritiesRequest model) {
            super(model);
            this.rulePriorities(model.rulePriorities);
        }

        public final List<RulePriorityPair.Builder> getRulePriorities() {
            List<RulePriorityPair.Builder> result = RulePriorityListCopier.copyToBuilder(this.rulePriorities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRulePriorities(Collection<RulePriorityPair.BuilderImpl> rulePriorities) {
            this.rulePriorities = RulePriorityListCopier.copyFromBuilder(rulePriorities);
        }

        @Override
        public final Builder rulePriorities(Collection<RulePriorityPair> rulePriorities) {
            this.rulePriorities = RulePriorityListCopier.copy(rulePriorities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulePriorities(RulePriorityPair ... rulePriorities) {
            this.rulePriorities(Arrays.asList(rulePriorities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rulePriorities(Consumer<RulePriorityPair.Builder> ... rulePriorities) {
            this.rulePriorities(Stream.of(rulePriorities).map(c -> (RulePriorityPair)((RulePriorityPair.Builder)RulePriorityPair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetRulePrioritiesRequest build() {
            return new SetRulePrioritiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SetRulePrioritiesRequest> {
        public Builder rulePriorities(Collection<RulePriorityPair> var1);

        public Builder rulePriorities(RulePriorityPair ... var1);

        public Builder rulePriorities(Consumer<RulePriorityPair.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

