/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2Client;
import software.amazon.awssdk.services.elasticloadbalancingv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreRevocationsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreRevocationsResponse;

public class DescribeTrustStoreRevocationsIterable
implements SdkIterable<DescribeTrustStoreRevocationsResponse> {
    private final ElasticLoadBalancingV2Client client;
    private final DescribeTrustStoreRevocationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTrustStoreRevocationsIterable(ElasticLoadBalancingV2Client client, DescribeTrustStoreRevocationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeTrustStoreRevocationsResponseFetcher();
    }

    public Iterator<DescribeTrustStoreRevocationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class DescribeTrustStoreRevocationsResponseFetcher
    implements SyncPageFetcher<DescribeTrustStoreRevocationsResponse> {
        private DescribeTrustStoreRevocationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTrustStoreRevocationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public DescribeTrustStoreRevocationsResponse nextPage(DescribeTrustStoreRevocationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTrustStoreRevocationsIterable.this.client.describeTrustStoreRevocations(DescribeTrustStoreRevocationsIterable.this.firstRequest);
            }
            return DescribeTrustStoreRevocationsIterable.this.client.describeTrustStoreRevocations((DescribeTrustStoreRevocationsRequest)((Object)DescribeTrustStoreRevocationsIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

