/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ProtocolEnum {
    HTTP("HTTP"),
    HTTPS("HTTPS"),
    TCP("TCP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ProtocolEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProtocolEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ProtocolEnum.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProtocolEnum> knownValues() {
        return Stream.of(ProtocolEnum.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

