/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.MinimumLoadBalancerCapacity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyCapacityReservationRequest
extends ElasticLoadBalancingV2Request
implements ToCopyableBuilder<Builder, ModifyCapacityReservationRequest> {
    private static final SdkField<String> LOAD_BALANCER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoadBalancerArn").getter(ModifyCapacityReservationRequest.getter(ModifyCapacityReservationRequest::loadBalancerArn)).setter(ModifyCapacityReservationRequest.setter(Builder::loadBalancerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerArn").build()}).build();
    private static final SdkField<MinimumLoadBalancerCapacity> MINIMUM_LOAD_BALANCER_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MinimumLoadBalancerCapacity").getter(ModifyCapacityReservationRequest.getter(ModifyCapacityReservationRequest::minimumLoadBalancerCapacity)).setter(ModifyCapacityReservationRequest.setter(Builder::minimumLoadBalancerCapacity)).constructor(MinimumLoadBalancerCapacity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumLoadBalancerCapacity").build()}).build();
    private static final SdkField<Boolean> RESET_CAPACITY_RESERVATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ResetCapacityReservation").getter(ModifyCapacityReservationRequest.getter(ModifyCapacityReservationRequest::resetCapacityReservation)).setter(ModifyCapacityReservationRequest.setter(Builder::resetCapacityReservation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResetCapacityReservation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_ARN_FIELD, MINIMUM_LOAD_BALANCER_CAPACITY_FIELD, RESET_CAPACITY_RESERVATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyCapacityReservationRequest.memberNameToFieldInitializer();
    private final String loadBalancerArn;
    private final MinimumLoadBalancerCapacity minimumLoadBalancerCapacity;
    private final Boolean resetCapacityReservation;

    private ModifyCapacityReservationRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerArn = builder.loadBalancerArn;
        this.minimumLoadBalancerCapacity = builder.minimumLoadBalancerCapacity;
        this.resetCapacityReservation = builder.resetCapacityReservation;
    }

    public final String loadBalancerArn() {
        return this.loadBalancerArn;
    }

    public final MinimumLoadBalancerCapacity minimumLoadBalancerCapacity() {
        return this.minimumLoadBalancerCapacity;
    }

    public final Boolean resetCapacityReservation() {
        return this.resetCapacityReservation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumLoadBalancerCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.resetCapacityReservation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCapacityReservationRequest)) {
            return false;
        }
        ModifyCapacityReservationRequest other = (ModifyCapacityReservationRequest)((Object)obj);
        return Objects.equals(this.loadBalancerArn(), other.loadBalancerArn()) && Objects.equals(this.minimumLoadBalancerCapacity(), other.minimumLoadBalancerCapacity()) && Objects.equals(this.resetCapacityReservation(), other.resetCapacityReservation());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyCapacityReservationRequest").add("LoadBalancerArn", (Object)this.loadBalancerArn()).add("MinimumLoadBalancerCapacity", (Object)this.minimumLoadBalancerCapacity()).add("ResetCapacityReservation", (Object)this.resetCapacityReservation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerArn": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerArn()));
            }
            case "MinimumLoadBalancerCapacity": {
                return Optional.ofNullable(clazz.cast(this.minimumLoadBalancerCapacity()));
            }
            case "ResetCapacityReservation": {
                return Optional.ofNullable(clazz.cast(this.resetCapacityReservation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LoadBalancerArn", LOAD_BALANCER_ARN_FIELD);
        map.put("MinimumLoadBalancerCapacity", MINIMUM_LOAD_BALANCER_CAPACITY_FIELD);
        map.put("ResetCapacityReservation", RESET_CAPACITY_RESERVATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyCapacityReservationRequest, T> g) {
        return obj -> g.apply((ModifyCapacityReservationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Request.BuilderImpl
    implements Builder {
        private String loadBalancerArn;
        private MinimumLoadBalancerCapacity minimumLoadBalancerCapacity;
        private Boolean resetCapacityReservation;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCapacityReservationRequest model) {
            super(model);
            this.loadBalancerArn(model.loadBalancerArn);
            this.minimumLoadBalancerCapacity(model.minimumLoadBalancerCapacity);
            this.resetCapacityReservation(model.resetCapacityReservation);
        }

        public final String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final MinimumLoadBalancerCapacity.Builder getMinimumLoadBalancerCapacity() {
            return this.minimumLoadBalancerCapacity != null ? this.minimumLoadBalancerCapacity.toBuilder() : null;
        }

        public final void setMinimumLoadBalancerCapacity(MinimumLoadBalancerCapacity.BuilderImpl minimumLoadBalancerCapacity) {
            this.minimumLoadBalancerCapacity = minimumLoadBalancerCapacity != null ? minimumLoadBalancerCapacity.build() : null;
        }

        @Override
        public final Builder minimumLoadBalancerCapacity(MinimumLoadBalancerCapacity minimumLoadBalancerCapacity) {
            this.minimumLoadBalancerCapacity = minimumLoadBalancerCapacity;
            return this;
        }

        public final Boolean getResetCapacityReservation() {
            return this.resetCapacityReservation;
        }

        public final void setResetCapacityReservation(Boolean resetCapacityReservation) {
            this.resetCapacityReservation = resetCapacityReservation;
        }

        @Override
        public final Builder resetCapacityReservation(Boolean resetCapacityReservation) {
            this.resetCapacityReservation = resetCapacityReservation;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyCapacityReservationRequest build() {
            return new ModifyCapacityReservationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyCapacityReservationRequest> {
        public Builder loadBalancerArn(String var1);

        public Builder minimumLoadBalancerCapacity(MinimumLoadBalancerCapacity var1);

        default public Builder minimumLoadBalancerCapacity(Consumer<MinimumLoadBalancerCapacity.Builder> minimumLoadBalancerCapacity) {
            return this.minimumLoadBalancerCapacity((MinimumLoadBalancerCapacity)((MinimumLoadBalancerCapacity.Builder)MinimumLoadBalancerCapacity.builder().applyMutation(minimumLoadBalancerCapacity)).build());
        }

        public Builder resetCapacityReservation(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

