/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RevocationIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoveTrustStoreRevocationsRequest
extends ElasticLoadBalancingV2Request
implements ToCopyableBuilder<Builder, RemoveTrustStoreRevocationsRequest> {
    private static final SdkField<String> TRUST_STORE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrustStoreArn").getter(RemoveTrustStoreRevocationsRequest.getter(RemoveTrustStoreRevocationsRequest::trustStoreArn)).setter(RemoveTrustStoreRevocationsRequest.setter(Builder::trustStoreArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStoreArn").build()}).build();
    private static final SdkField<List<Long>> REVOCATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RevocationIds").getter(RemoveTrustStoreRevocationsRequest.getter(RemoveTrustStoreRevocationsRequest::revocationIds)).setter(RemoveTrustStoreRevocationsRequest.setter(Builder::revocationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevocationIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_STORE_ARN_FIELD, REVOCATION_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TrustStoreArn", TRUST_STORE_ARN_FIELD);
            this.put("RevocationIds", REVOCATION_IDS_FIELD);
        }
    });
    private final String trustStoreArn;
    private final List<Long> revocationIds;

    private RemoveTrustStoreRevocationsRequest(BuilderImpl builder) {
        super(builder);
        this.trustStoreArn = builder.trustStoreArn;
        this.revocationIds = builder.revocationIds;
    }

    public final String trustStoreArn() {
        return this.trustStoreArn;
    }

    public final boolean hasRevocationIds() {
        return this.revocationIds != null && !(this.revocationIds instanceof SdkAutoConstructList);
    }

    public final List<Long> revocationIds() {
        return this.revocationIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trustStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRevocationIds() ? this.revocationIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveTrustStoreRevocationsRequest)) {
            return false;
        }
        RemoveTrustStoreRevocationsRequest other = (RemoveTrustStoreRevocationsRequest)((Object)obj);
        return Objects.equals(this.trustStoreArn(), other.trustStoreArn()) && this.hasRevocationIds() == other.hasRevocationIds() && Objects.equals(this.revocationIds(), other.revocationIds());
    }

    public final String toString() {
        return ToString.builder((String)"RemoveTrustStoreRevocationsRequest").add("TrustStoreArn", (Object)this.trustStoreArn()).add("RevocationIds", this.hasRevocationIds() ? this.revocationIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrustStoreArn": {
                return Optional.ofNullable(clazz.cast(this.trustStoreArn()));
            }
            case "RevocationIds": {
                return Optional.ofNullable(clazz.cast(this.revocationIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RemoveTrustStoreRevocationsRequest, T> g) {
        return obj -> g.apply((RemoveTrustStoreRevocationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Request.BuilderImpl
    implements Builder {
        private String trustStoreArn;
        private List<Long> revocationIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveTrustStoreRevocationsRequest model) {
            super(model);
            this.trustStoreArn(model.trustStoreArn);
            this.revocationIds(model.revocationIds);
        }

        public final String getTrustStoreArn() {
            return this.trustStoreArn;
        }

        public final void setTrustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
        }

        @Override
        public final Builder trustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
            return this;
        }

        public final Collection<Long> getRevocationIds() {
            if (this.revocationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.revocationIds;
        }

        public final void setRevocationIds(Collection<Long> revocationIds) {
            this.revocationIds = RevocationIdsCopier.copy(revocationIds);
        }

        @Override
        public final Builder revocationIds(Collection<Long> revocationIds) {
            this.revocationIds = RevocationIdsCopier.copy(revocationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revocationIds(Long ... revocationIds) {
            this.revocationIds(Arrays.asList(revocationIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveTrustStoreRevocationsRequest build() {
            return new RemoveTrustStoreRevocationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RemoveTrustStoreRevocationsRequest> {
        public Builder trustStoreArn(String var1);

        public Builder revocationIds(Collection<Long> var1);

        public Builder revocationIds(Long ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

